/* bishopMobility.t.cc
 */
#include "osl/mobility/bishopMobility.h"
#include "osl/record/csaString.h"
#include <iostream>

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

class BishopMobilityTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(BishopMobilityTest);
  CPPUNIT_TEST(testCount);
  CPPUNIT_TEST(testCountDir);
  CPPUNIT_TEST_SUITE_END();
public:
  void testCount();
  void testCountDir();
};

CPPUNIT_TEST_SUITE_REGISTRATION(BishopMobilityTest);

using namespace osl;
using namespace osl::mobility;

void BishopMobilityTest::testCount()
{
  {
    SimpleState sState=
      CsaString(
		"P1+NY+TO *  *  *  * -OU-KE-KY\n"
		"P2 *  *  *  *  * -GI-KI *  *\n"
		"P3 * +RY *  * +UM * -KI-FU-FU\n"
		"P4 *  * +FU-FU *  *  *  *  *\n"
		"P5 *  * -KE * +FU *  * +FU *\n"
		"P6+KE *  * +FU+GI-FU *  * +FU\n"
		"P7 *  * -UM *  *  *  *  *  *\n"
		"P8 *  *  *  *  *  *  *  *  * \n"
		"P9 * +OU * -GI *  *  *  * -NG\n"
		"P+00HI00KI00KE00KY00FU00FU00FU00FU00FU00FU\n"
		"P-00KI00KY00FU00FU\n"
		"P-00AL\n"
		"+\n"
		).getInitialState();
    NumEffectState state(sState);
    {
      // 53 馬
      Piece p=state.getPieceAt(Position(5,3));
      CPPUNIT_ASSERT_EQUAL(8,BishopMobility::countAll(BLACK,state,p));
      CPPUNIT_ASSERT_EQUAL(6,BishopMobility::countSafe(BLACK,state,p));
      int countAll=0,countSafe=0;
      BishopMobility::countBoth(BLACK,state,p,countAll,countSafe);
      CPPUNIT_ASSERT_EQUAL(8,countAll);
      CPPUNIT_ASSERT_EQUAL(6,countSafe);
    }
    {
      // 77 馬
      Piece p=state.getPieceAt(Position(7,7));
      CPPUNIT_ASSERT_EQUAL(7,BishopMobility::countAll(WHITE,state,p));
      CPPUNIT_ASSERT_EQUAL(4,BishopMobility::countSafe(WHITE,state,p));
      int countAll=0,countSafe=0;
      BishopMobility::countBoth(WHITE,state,p,countAll,countSafe);
      CPPUNIT_ASSERT_EQUAL(7,countAll);
      CPPUNIT_ASSERT_EQUAL(4,countSafe);
    }
  }
}

void BishopMobilityTest::testCountDir()
{
  {
    SimpleState sState=
      CsaString(
		"P1+NY+TO *  *  *  * -OU-KE-KY\n"
		"P2 *  *  *  *  * -GI-KI *  *\n"
		"P3 * +RY *  * +UM * -KI-FU-FU\n"
		"P4 *  * +FU-FU *  *  *  *  *\n"
		"P5 *  * -KE * +FU *  * +FU *\n"
		"P6+KE *  * +FU+GI-FU *  * +FU\n"
		"P7 *  * -UM *  *  *  *  *  *\n"
		"P8 *  *  *  *  *  *  *  *  * \n"
		"P9 * +OU * -GI *  *  *  * -NG\n"
		"P+00HI00KI00KE00KY00FU00FU00FU00FU00FU00FU\n"
		"P-00KI00KY00FU00FU\n"
		"P-00AL\n"
		"+\n"
		).getInitialState();
    NumEffectState state(sState);
    {
      // 53 馬
      Piece p=state.getPieceAt(Position(5,3));
      CPPUNIT_ASSERT_EQUAL(2, (BishopMobility::countAllDir<BLACK,UL>(state,p)));
      CPPUNIT_ASSERT_EQUAL(1, (BishopMobility::countAllDir<BLACK,UR>(state,p)));
      CPPUNIT_ASSERT_EQUAL(1, (BishopMobility::countAllDir<BLACK,DL>(state,p)));
      CPPUNIT_ASSERT_EQUAL(4, (BishopMobility::countAllDir<BLACK,DR>(state,p)));
    }
    {
      // 77 馬
      Piece p=state.getPieceAt(Position(7,7));
      CPPUNIT_ASSERT_EQUAL(2, (BishopMobility::countAllDir<WHITE,UL>(state,p)));
      CPPUNIT_ASSERT_EQUAL(2, (BishopMobility::countAllDir<WHITE,UR>(state,p)));
      CPPUNIT_ASSERT_EQUAL(1, (BishopMobility::countAllDir<WHITE,DL>(state,p)));
      CPPUNIT_ASSERT_EQUAL(2, (BishopMobility::countAllDir<WHITE,DR>(state,p)));
    }
  }
}


/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
