#include "osl/misc/base64.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

using namespace osl;
extern bool isShortTest;

class Base64Test : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE( Base64Test );
  CPPUNIT_TEST( testEncodeA );
  CPPUNIT_TEST( testEncodea );
  CPPUNIT_TEST( testEncode0 );
  CPPUNIT_TEST( testEncode62 );
  CPPUNIT_TEST( testEncode63 );
  CPPUNIT_TEST( testEncodeQUJDREVGRw );
  CPPUNIT_TEST( testEncodeleasure );
  CPPUNIT_TEST_SUITE_END();
public:
  void testEncodeA();
  void testEncodea();
  void testEncode0();
  void testEncode62();
  void testEncode63();
  void testEncodeQUJDREVGRw();
  void testEncodeleasure();
};

CPPUNIT_TEST_SUITE_REGISTRATION(Base64Test);

void Base64Test::testEncodeA() {
  boost::dynamic_bitset<> orig(8); // A
  orig[0] = 1;
  orig[1] = 0;
  orig[2] = 0;
  orig[3] = 0;
  orig[4] = 0;
  orig[5] = 0;
  orig[6] = 1;
  orig[7] = 0;
  const std::string base64 = "QQ==";

  CPPUNIT_ASSERT_EQUAL(base64, osl::misc::base64Encode(orig));
  CPPUNIT_ASSERT_EQUAL(orig,   osl::misc::base64Decode(base64));
}

void Base64Test::testEncodea() {
  boost::dynamic_bitset<> orig(8); // a
  orig[0] = 1;
  orig[1] = 1;
  orig[2] = 1;
  orig[3] = 0;
  orig[4] = 1;
  orig[5] = 0;
  orig[6] = 0;
  orig[7] = 1;
  const std::string base64 = "lw==";

  CPPUNIT_ASSERT_EQUAL(base64, osl::misc::base64Encode(orig));
  CPPUNIT_ASSERT_EQUAL(orig,   osl::misc::base64Decode(base64));
}

void Base64Test::testEncode0() {
  boost::dynamic_bitset<> orig(8); // 0
  orig[0] = 0;
  orig[1] = 0;
  orig[2] = 1;
  orig[3] = 0;
  orig[4] = 0;
  orig[5] = 0;
  orig[6] = 0;
  orig[7] = 1;
  const std::string base64 = "hA==";

  CPPUNIT_ASSERT_EQUAL(base64, osl::misc::base64Encode(orig));
  CPPUNIT_ASSERT_EQUAL(orig,   osl::misc::base64Decode(base64));
}

void Base64Test::testEncode62() {
  boost::dynamic_bitset<> orig(8); // -
  orig[0] = 1;
  orig[1] = 0;
  orig[2] = 1;
  orig[3] = 0;
  orig[4] = 0;
  orig[5] = 0;
  orig[6] = 1;
  orig[7] = 0;
  const std::string base64 = "RQ==";

  CPPUNIT_ASSERT_EQUAL(base64, osl::misc::base64Encode(orig));
  CPPUNIT_ASSERT_EQUAL(orig,   osl::misc::base64Decode(base64));
}

void Base64Test::testEncode63() {
  boost::dynamic_bitset<> orig(8); // _
  orig[0] = 1;
  orig[1] = 0;
  orig[2] = 1;
  orig[3] = 0;
  orig[4] = 1;
  orig[5] = 0;
  orig[6] = 0;
  orig[7] = 1;
  const std::string base64 = "lQ==";

  CPPUNIT_ASSERT_EQUAL(base64, osl::misc::base64Encode(orig));
  CPPUNIT_ASSERT_EQUAL(orig,   osl::misc::base64Decode(base64));
}

void Base64Test::testEncodeQUJDREVGRw() {
  boost::dynamic_bitset<> bits(7*8); // ABCDEFG
  bits = boost::dynamic_bitset<>(7*8, 0x41ul) << 6*8 |
         boost::dynamic_bitset<>(7*8, 0x42ul) << 5*8 |
         boost::dynamic_bitset<>(7*8, 0x43ul) << 4*8 |
         boost::dynamic_bitset<>(7*8, 0x44ul) << 3*8 |
         boost::dynamic_bitset<>(7*8, 0x45ul) << 2*8 |
         boost::dynamic_bitset<>(7*8, 0x46ul) << 1*8 |
         boost::dynamic_bitset<>(7*8, 0x47ul);

  const std::string ret = osl::misc::base64Encode(bits);
  CPPUNIT_ASSERT_EQUAL(std::string("QUJDREVGRw=="), ret);
}

void Base64Test::testEncodeleasure() {
  std::string src = "bGVhc3VyZS4=";
  const boost::dynamic_bitset<> ret = osl::misc::base64Decode(src);
  const std::string src2 = osl::misc::base64Encode(ret);
  CPPUNIT_ASSERT_EQUAL(src, src2);
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
