#include "osl/effect_util/shadowEffect.h"
#include "osl/effect_util/additionalOrShadow.h"
#include "osl/effect_util/effectUtil.h"

template <int count_max>
int osl::effect_util::
ShadowEffect::count(const NumEffectState& state, Position target, 
		    Player attack)
{
  PieceVector direct_pieces;
  EffectUtil::findEffect(alt(attack), state, target, direct_pieces);
  return AdditionalOrShadow::count<count_max>
    (direct_pieces, state, target, attack);
}

bool osl::effect_util::
ShadowEffect::hasEffect(const NumEffectState& state, Position target, 
			Player attack)
{
  return count<1>(state, target, attack);
}

int osl::effect_util::
ShadowEffect::count2(const NumEffectState& state, Position target, 
		     Player attack)
{
  return count<2>(state, target, attack);
}


// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
