/* kajiMove.h
 */
#ifndef _KANJIMOVE_H
#define _KANJIMOVE_H

#include "osl/ptype.h"
#include "osl/position.h"
#include "osl/move.h"
#include "osl/stl/hash_map.h"
#include "osl/state/numEffectState.h"
#include <string>
#include <list>
#include <boost/functional/hash.hpp>

namespace osl
{
  namespace state
  {
    class SimpleState;
  }
  namespace record
  {
    /**
     * Parse kanji records such as "７六歩", the style of which is 
     * generally used to write Shogi records in Japanese.
     */
    class KanjiMove
    {
    public:
      KanjiMove();
      ~KanjiMove();

      /**
       * Convert a Japanese string (one token) to a move object
       */
      const Move strToMove(const std::string&, 
                                const NumEffectState& state, 
                                const Move& last_move) const;
      void setVerbose(bool verbose) {this->verbose = verbose;}

      Position toPosition(const std::string&) const;
      Ptype toPtype(const std::string&) const;
    private:
      typedef std::list<Move> found_moves_t;
      void selectCandidates(found_moves_t& found, 
                            std::string& str, 
                            const Position& to_pos,
                            const Player& player) const;
      typedef hash_map<std::string, Position, boost::hash<std::string> >
      str2position_t;
      str2position_t str2position;
      typedef hash_map<std::string, Ptype, boost::hash<std::string> > str2piece_t;
      str2piece_t str2piece;
      bool verbose;
    };

  } // record
} // osl

#endif /* _KANJIMOVE_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
