#include "osl/game_playing/csaClient.h"
#include "osl/game_playing/recordTracer.h"
#include "osl/game_playing/bookPlayer.h"
#include "osl/game_playing/gameState.h"
#include "osl/game_playing/csaLogger.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>
#include <sstream>

using namespace osl;
using namespace osl::game_playing;

class CsaClientTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(CsaClientTest);
  CPPUNIT_TEST(testUndo);
  CPPUNIT_TEST_SUITE_END();
public:
  void testUndo() 
  {
    vector<Move> moves;
    const Move m76fu(Position(7,7),Position(7,6),PAWN,PTYPE_EMPTY,false,BLACK);
    const Move m34fu(Position(3,3),Position(3,4),PAWN,PTYPE_EMPTY,false,WHITE);
    moves.push_back(m76fu);
    moves.push_back(m34fu);
    
    BookPlayer white(new RecordTracer(moves), new ResignPlayer());
    std::ostringstream log;
    CsaLogger *logger = new CsaLogger(log);
    std::istringstream is("+7776FU\n%TORYO\n");
    std::ostringstream os;

    CsaClient client(0, &white, logger, is, os);
    client.setSilent(true);
    client.run();
    CPPUNIT_ASSERT_EQUAL(std::string("-3334FU\n"), os.str());
  }
};

CPPUNIT_TEST_SUITE_REGISTRATION(CsaClientTest);

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
