/* nonBlockDelete.cc
 */
#include "osl/misc/nonBlockDelete.h"
#include "osl/misc/pointerQueue.h"
#include <boost/thread.hpp>
#include <iostream>

static volatile bool finish = false;

class osl::misc::NonBlockDelete::Queue : public PointerQueue<void>
{
public:
  Queue() : thread(0)
  {
  }
  boost::thread *thread;
};

struct osl::misc::NonBlockDelete::Runner
{
  boost::shared_ptr<Queue> queue;
  Runner(const boost::shared_ptr<Queue>& q) : queue(q)
  {
  }
  void operator()()
  {
    while (! finish)
    {
      boost::shared_ptr<void> ptr;
      ptr = queue->pop_front();
      const int count = ptr.use_count();
      if (count > 1)
	std::cerr << "NonBlockDelete " << count << " > 1 " 
		  << ptr.get() << std::endl;
      // release ptr
    }
  }
};


osl::misc::NonBlockDelete& osl::misc::
NonBlockDelete::instance()
{
  static NonBlockDelete the_instance;
  return the_instance;
}

osl::misc::
NonBlockDelete::NonBlockDelete()
  : queue(new Queue())
{
  queue->thread = new boost::thread(Runner(queue));
}

osl::misc::
NonBlockDelete::~NonBlockDelete()
{
  finish = true;
  queue->quit(1);
  queue->thread->join();
  delete queue->thread;
}

int osl::misc::
NonBlockDelete::waiting()
{
  NonBlockDelete& the_instance = instance();
  return the_instance.queue->size();
}

void osl::misc::NonBlockDelete::resetAny(boost::shared_ptr<void>& ptr)
{
  if (finish) {
    ptr.reset();
    return;
  }
  instance().push_back(ptr);
}

void osl::misc::NonBlockDelete::push_back(boost::shared_ptr<void>& ptr)
{
  if (finish) {
    ptr.reset();
    return;
  }
  queue->push_back(ptr);
}

void osl::misc::
NonBlockDelete::deleteAll()
{
  NonBlockDelete& the_instance = instance();
  while (the_instance.queue->size())
  {
    boost::shared_ptr<void> ptr
      = the_instance.queue->pop_front_non_block();
  }
  boost::thread::yield();
}

bool osl::misc::
NonBlockDelete::deleteOne()
{
  NonBlockDelete& the_instance = instance();
  if (the_instance.queue->size() == 0)
    return false;
  boost::shared_ptr<void> ptr
    = the_instance.queue->pop_front_non_block();
  return true;
}


/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
