/* vector.h
 */
#ifndef VECTOR_H
#define VECTOR_H

#include <vector>
#include "osl/stl/pool_allocator.h"

namespace osl
{
  namespace stl
  {
    // 2008-04-23 vector は scalable_allocatorで動かないようにみえる
    // gpl_pool_allocatorを使う意味もほとんどないので、標準のallocatorを使う
    template <class T>
    struct vector : public std::vector<T>
    {
      typedef std::vector<T> base_t;
      vector() {}
      explicit vector(size_t s);
      vector(size_t s, const T& val) : base_t(s,val)
      {
      }
      vector(const typename base_t::const_iterator it1, const typename base_t::const_iterator it2)
        : base_t(it1, it2)
      {}
      ~vector();
    };
    template <class T>
    vector<T>::~vector()
    {
    }
    template <class T>
    vector<T>::vector(size_t s) : base_t(s)
    {
    }
  } // namespace stl
  using stl::vector;
} // namespace stl

#endif /* VECTOR_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
