#ifndef _SIMPLE_ALWAYS_MOVE_ACTION_H
#define _SIMPLE_ALWAYS_MOVE_ACTION_H
#include "osl/piece.h"
#include "osl/position.h"
#include "osl/move_action/concept.h"

namespace osl
{
  namespace effect_action
  {
    /**
     * 駒を取らないことが前提
     */
    template <class Action>
    class SimpleMove
    {
      BOOST_CLASS_REQUIRE(Action,osl::move_action,Concept);
    private:
      Action & ac;
    public:
      SimpleMove(Action & a) :ac(a){}
      template<Player P,Ptype Type>
      void doActionPtype(Piece p1,Position to){
	Position from=p1.position(); 
	if(canPromote(Type) &&
	   !p1.isPromotedNotKingGold() &&
	   (to.canPromote<P>() || from.canPromote<P>())){
	  ac.simpleMove(from,to,promote(Type),true,P);
	}
	if(!canPromote(Type) ||
	   PtypePlayerTraits<Type,P>::canDropTo(to) ||
	   p1.isPromotedNotKingGold()){
	  ac.simpleMove(from,to,p1.ptype(),false,P);
	}
      }
      template<Player P>
      void doAction(Piece p1,Position to){
	Position from=p1.position(); 
	Ptype ptype=p1.ptype();
	if(canPromote(ptype)){
	  if (to.canPromote<P>()){
	    ac.simpleMove(from,to,promote(ptype),true,P);
	    if(Ptype_Table.canDropTo(P, ptype,to)){
	      ac.simpleMove(from,to,ptype,false,P);
	    }
	  }
	  else if (from.canPromote<P>()){
	    ac.simpleMove(from,to,promote(ptype),true,P);
	    ac.simpleMove(from,to,ptype,false,P);
	  }
	  else{
	    ac.simpleMove(from,to,ptype,false,P);
	  }
	}
	else{
	  ac.simpleMove(from,to,ptype,false,P);
	}
      }
      bool done() const{ return false;}
    };
  } // namespace effect_action
} // namespace osl
#endif
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
