package Locales::DB::Language::it;

# Auto generated from CLDR

$Locales::DB::Language::it::VERSION = '0.08';

$Locales::DB::Language::it::cldr_version = '2.0';

%Locales::DB::Language::it::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => "\.",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\ \{1\}"
        },
        'language' => "Lingua\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ e\ \{1\}",
            'end'    => "\{0\}\,\ e\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Regione\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '”',
        'alternate_quotation_start' => '“',
        'quotation_end'             => '’',
        'quotation_start'           => '‘'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'other'
        ],
        'category_rules'          => { 'one' => "n\ is\ 1" },
        'category_rules_compiled' => { 'one' => "sub\ \{\ return\ \'one\'\ if\ \(\ \(\(\ \$_\[0\]\ \=\=\ 1\)\)\)\;\ return\;\}\;" }
    },
    'posix' => {
        'nostr'  => "no\:n",
        'yesstr' => "sì\:si\:s"
    },
);

%Locales::DB::Language::it::code_to_name = (
    'aa'    => 'afar',
    'ab'    => 'abkhazian',
    'ace'   => 'accinese',
    'ach'   => 'acioli',
    'ada'   => 'adangme',
    'ady'   => 'adyghe',
    'ae'    => 'avestan',
    'af'    => 'afrikaans',
    'afa'   => "lingua\ afroasiatica",
    'afh'   => 'afrihili',
    'agq'   => 'Aghem',
    'ain'   => 'ainu',
    'ak'    => 'akan',
    'akk'   => 'accado',
    'ale'   => 'aleuto',
    'alg'   => "lingue\ algonchine",
    'alt'   => "altai\ meridionale",
    'am'    => 'amarico',
    'an'    => 'aragonese',
    'ang'   => "inglese\ antico",
    'anp'   => 'angika',
    'apa'   => "lingue\ apache",
    'ar'    => 'arabo',
    'arc'   => 'aramaico',
    'arn'   => 'araucano',
    'arp'   => 'arapaho',
    'art'   => "lingua\ artificiale",
    'arw'   => 'aruaco',
    'as'    => 'assamese',
    'asa'   => 'Asu',
    'ast'   => 'asturiano',
    'ath'   => "lingue\ athabaska",
    'aus'   => "lingue\ australiane",
    'av'    => 'avaro',
    'awa'   => 'awadhi',
    'ay'    => 'aymara',
    'az'    => 'azero',
    'ba'    => 'baschiro',
    'bad'   => 'banda',
    'bai'   => "lingue\ bamileke",
    'bal'   => 'beluci',
    'ban'   => 'balinese',
    'bas'   => 'basa',
    'bat'   => "lingua\ baltica",
    'be'    => 'bielorusso',
    'bej'   => 'begia',
    'bem'   => 'wemba',
    'ber'   => 'berbero',
    'bez'   => 'Bena',
    'bg'    => 'bulgaro',
    'bh'    => 'bihari',
    'bho'   => 'bhojpuri',
    'bi'    => 'bislama',
    'bik'   => 'bicol',
    'bin'   => 'bini',
    'bla'   => 'siksika',
    'bm'    => 'bambara',
    'bn'    => 'bengalese',
    'bnt'   => 'bantu',
    'bo'    => 'tibetano',
    'br'    => 'bretone',
    'bra'   => 'braj',
    'brx'   => 'Bodo',
    'bs'    => 'bosniaco',
    'btk'   => 'batak',
    'bua'   => 'buriat',
    'bug'   => 'bugi',
    'byn'   => 'blin',
    'ca'    => 'catalano',
    'cad'   => 'caddo',
    'cai'   => "lingua\ indiana\ dell\'America\ Centrale",
    'car'   => 'caribico',
    'cau'   => "lingua\ caucasica",
    'cay'   => 'Cayuga',
    'cch'   => 'atsam',
    'ce'    => 'ceceno',
    'ceb'   => 'cebuano',
    'cel'   => "celtica\ altra\ lingua",
    'cgg'   => 'Chiga',
    'ch'    => 'chamorro',
    'chb'   => 'chibcha',
    'chg'   => 'ciagataico',
    'chk'   => 'chuukese',
    'chm'   => 'mari',
    'chn'   => "gergo\ chinook",
    'cho'   => 'choctaw',
    'chp'   => 'chipewyan',
    'chr'   => 'cherokee',
    'chy'   => 'cheyenne',
    'cmc'   => "lingue\ chamic",
    'co'    => 'corso',
    'cop'   => 'copto',
    'cpe'   => "creolo\ o\ pidgin\ basati\ sull\'inglese",
    'cpf'   => "creolo\ o\ pidgin\ basati\ sul\ francese",
    'cpp'   => "creolo\ o\ pidgin\ basati\ sul\ portoghese",
    'cr'    => 'cree',
    'crh'   => "turco\ crimeo",
    'crp'   => "creolo\ o\ pidgin",
    'cs'    => 'ceco',
    'csb'   => 'kashubian',
    'cu'    => "slavo\ della\ Chiesa",
    'cus'   => "lingua\ cuscitica",
    'cv'    => 'chuvash',
    'cy'    => 'gallese',
    'da'    => 'danese',
    'dak'   => 'dakota',
    'dar'   => 'dargwa',
    'dav'   => 'Taita',
    'day'   => 'dayak',
    'de'    => 'tedesco',
    'de_at' => "tedesco\ austriaco",
    'de_ch' => "alto\ tedesco\ svizzero",
    'del'   => 'delaware',
    'den'   => 'slave',
    'dgr'   => 'dogrib',
    'din'   => 'dinca',
    'dje'   => 'Zarma',
    'doi'   => 'dogri',
    'dra'   => "lingua\ dravidica",
    'dsb'   => "basso\ sorabo",
    'dua'   => 'duala',
    'dum'   => "olandese\ medio",
    'dv'    => 'divehi',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => 'diula',
    'dz'    => 'dzongkha',
    'ebu'   => 'Embu',
    'ee'    => 'ewe',
    'efi'   => 'efik',
    'egy'   => "egiziano\ antico",
    'eka'   => 'ekajuka',
    'el'    => 'greco',
    'elx'   => 'elamitico',
    'en'    => 'inglese',
    'en_au' => "inglese\ australiano",
    'en_ca' => "inglese\ canadese",
    'en_gb' => "inglese\ britannico",
    'en_us' => "inglese\ americano",
    'enm'   => "inglese\ medio",
    'eo'    => 'esperanto',
    'es'    => 'spagnolo',
    'es_es' => "spagnolo\ della\ Spagna",
    'et'    => 'estone',
    'eu'    => 'basco',
    'ewo'   => 'ewondo',
    'fa'    => 'persiano',
    'fan'   => 'fang',
    'fat'   => 'fanti',
    'ff'    => 'fulah',
    'fi'    => 'finlandese',
    'fil'   => 'filippino',
    'fiu'   => "lingua\ ungrofinnica",
    'fj'    => 'figiano',
    'fo'    => 'faroese',
    'fon'   => 'Fon',
    'fr'    => 'francese',
    'fr_ca' => "francese\ canadese",
    'fr_ch' => "francese\ svizzero",
    'frm'   => "francese\ medio",
    'fro'   => "francese\ antico",
    'frr'   => "frisone\ settentrionale",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'friulano',
    'fy'    => 'frisone',
    'ga'    => 'irlandese',
    'gaa'   => 'ga',
    'gay'   => 'gayo',
    'gba'   => 'gbaya',
    'gd'    => "gaelico\ scozzese",
    'gem'   => "lingua\ germanica",
    'gez'   => 'geez',
    'gil'   => 'gilbertese',
    'gl'    => 'galiziano',
    'gmh'   => "tedesco\ medio\ alto",
    'gn'    => 'guarana',
    'goh'   => "tedesco\ antico\ alto",
    'gon'   => 'gondi',
    'gor'   => 'gorontalo',
    'got'   => 'gotico',
    'grb'   => 'gerbo',
    'grc'   => "greco\ antico",
    'gsw'   => "tedesco\ svizzero",
    'gu'    => 'gujarati',
    'guz'   => 'Gusii',
    'gv'    => 'manx',
    'gwi'   => 'gwichʼin',
    'ha'    => 'haussa',
    'hai'   => 'haida',
    'haw'   => 'hawaiano',
    'he'    => 'ebraico',
    'hi'    => 'hindi',
    'hil'   => 'hiligayna',
    'him'   => 'himachali',
    'hit'   => 'hittite',
    'hmn'   => 'hmong',
    'ho'    => "hiri\ motu",
    'hr'    => 'croato',
    'hsb'   => "alto\ sorabo",
    'ht'    => 'haitiano',
    'hu'    => 'ungherese',
    'hup'   => 'hupa',
    'hy'    => 'armeno',
    'hz'    => 'herero',
    'ia'    => 'interlingua',
    'iba'   => 'iban',
    'id'    => 'indonesiano',
    'ie'    => 'interlingue',
    'ig'    => 'igbo',
    'ii'    => "sichuan\ yi",
    'ijo'   => 'Ijo',
    'ik'    => 'inupiak',
    'ilo'   => 'ilocano',
    'inc'   => "lingua\ indiana",
    'ine'   => "lingua\ indoeuropea",
    'inh'   => 'ingush',
    'io'    => 'ido',
    'ira'   => 'iraniana',
    'iro'   => "lingue\ irochesi",
    'is'    => 'islandese',
    'it'    => 'italiano',
    'iu'    => 'inuktitut',
    'ja'    => 'giapponese',
    'jbo'   => 'lojban',
    'jmc'   => 'Machame',
    'jpr'   => "giudeo\ persiano",
    'jrb'   => "giudeo\ arabo",
    'jv'    => 'giavanese',
    'ka'    => 'georgiano',
    'kaa'   => "kara\-kalpak",
    'kab'   => 'kabyle',
    'kac'   => 'kachin',
    'kaj'   => 'kai',
    'kam'   => 'kamba',
    'kar'   => 'karen',
    'kaw'   => 'kawi',
    'kbd'   => 'kabardia',
    'kcg'   => 'tyap',
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => 'kfo',
    'kg'    => 'kongo',
    'kha'   => 'khasi',
    'khi'   => "lingua\ khoisan",
    'kho'   => 'khotanese',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'kikuyu',
    'kj'    => 'kuanyama',
    'kk'    => 'kazako',
    'kl'    => 'kalaallisut',
    'kln'   => 'Kalenjin',
    'km'    => 'khmer',
    'kmb'   => 'kimbundu',
    'kn'    => 'kannada',
    'ko'    => 'coreano',
    'kok'   => 'konkani',
    'kos'   => 'kosraean',
    'kpe'   => 'kpelle',
    'kr'    => 'kanuri',
    'krc'   => "karachay\-Balkar",
    'krl'   => 'careliano',
    'kro'   => 'kru',
    'kru'   => 'kurukh',
    'ks'    => 'kashmiri',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'curdo',
    'kum'   => 'kumyk',
    'kut'   => 'kutenai',
    'kv'    => 'komi',
    'kw'    => 'cornico',
    'ky'    => 'kirghiso',
    'la'    => 'latino',
    'lad'   => 'ladino',
    'lag'   => 'Langi',
    'lah'   => 'lahnda',
    'lam'   => 'lamba',
    'lb'    => 'lussemburghese',
    'lez'   => 'lezghian',
    'lg'    => 'ganda',
    'li'    => 'limburgese',
    'ln'    => 'lingala',
    'lo'    => 'lao',
    'lol'   => "lolo\ bantu",
    'loz'   => 'lozi',
    'lt'    => 'lituano',
    'lu'    => "luba\-katanga",
    'lua'   => "luba\-lulua",
    'lui'   => 'luiseno',
    'lun'   => 'lunda',
    'luo'   => 'luo',
    'lus'   => 'lushai',
    'luy'   => 'Luyia',
    'lv'    => 'lettone',
    'mad'   => 'madurese',
    'mag'   => 'magahi',
    'mai'   => 'maithili',
    'mak'   => 'makasar',
    'man'   => 'mandingo',
    'map'   => 'austronesiano',
    'mas'   => 'masai',
    'mdf'   => 'moksha',
    'mdr'   => 'mandar',
    'men'   => 'mende',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'malgascio',
    'mga'   => "irlandese\ medio",
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => 'marshallese',
    'mi'    => 'maori',
    'mic'   => 'micmac',
    'min'   => 'menangkabau',
    'mis'   => "lingue\ diverse",
    'mk'    => 'macedone',
    'mkh'   => "lingua\ mon\-khmer",
    'ml'    => 'malayalam',
    'mn'    => 'mongolo',
    'mnc'   => 'manchu',
    'mni'   => 'manipuri',
    'mno'   => 'manobo',
    'mo'    => 'moldavo',
    'moh'   => 'mohawk',
    'mos'   => 'mossi',
    'mr'    => 'marathi',
    'ms'    => 'malese',
    'mt'    => 'maltese',
    'mua'   => 'Mundang',
    'mul'   => 'multilingua',
    'mun'   => "lingua\ munda",
    'mus'   => 'creek',
    'mwl'   => 'mirandese',
    'mwr'   => 'marwari',
    'my'    => 'birmano',
    'myn'   => "lingue\ maya",
    'myv'   => 'erzya',
    'na'    => 'nauru',
    'nah'   => 'nahuatl',
    'nai'   => "lingua\ indiana\ del\ Nord\ America",
    'nap'   => 'napoletano',
    'naq'   => 'Nama',
    'nb'    => "norvegese\ bokmal",
    'nd'    => "ndebele\ del\ nord",
    'nds'   => "basso\ tedesco",
    'ne'    => 'nepalese',
    'new'   => 'newari',
    'ng'    => 'ndonga',
    'nia'   => 'nias',
    'nic'   => "lingua\ niger\-cordofan",
    'niu'   => 'niue',
    'nl'    => 'olandese',
    'nl_be' => "fiammingo\ belga",
    'nmg'   => 'Kwasio',
    'nn'    => "norvegese\ nynorsk",
    'no'    => 'norvegese',
    'nog'   => 'nogai',
    'non'   => "norse\ antico",
    'nqo'   => "n\'ko",
    'nr'    => "ndebele\ del\ sud",
    'nso'   => "sotho\ del\ nord",
    'nub'   => 'nubiano',
    'nus'   => 'Nuer',
    'nv'    => 'navajo',
    'nwc'   => "newari\ classico",
    'ny'    => 'nyanja',
    'nym'   => 'nyamwezi',
    'nyn'   => 'nyankole',
    'nyo'   => 'nyoro',
    'nzi'   => 'nzima',
    'oc'    => 'occitano',
    'oj'    => 'ojibwa',
    'om'    => 'oromo',
    'or'    => 'oriya',
    'os'    => 'ossetico',
    'osa'   => 'osage',
    'ota'   => "turco\ ottomano",
    'oto'   => "lingue\ otomi",
    'pa'    => 'punjabi',
    'paa'   => "lingua\ papuana",
    'pag'   => 'pangasinan',
    'pal'   => 'pahlavi',
    'pam'   => 'pampanga',
    'pap'   => 'papiamento',
    'pau'   => 'palau',
    'peo'   => "persiano\ antico",
    'phi'   => "lingua\ filippina",
    'phn'   => 'fenicio',
    'pi'    => 'pali',
    'pl'    => 'polacco',
    'pon'   => 'ponape',
    'pra'   => 'pracrito',
    'pro'   => "provenzale\ antico",
    'ps'    => 'pashto',
    'pt'    => 'portoghese',
    'pt_br' => "portoghese\ brasiliano",
    'pt_pt' => "portoghese\ del\ Portogallo",
    'qu'    => 'quechua',
    'raj'   => 'rajasthani',
    'rap'   => 'rapanui',
    'rar'   => 'rarotonga',
    'rm'    => "lingua\ rhaeto\-romance",
    'rn'    => 'rundi',
    'ro'    => 'rumeno',
    'roa'   => "lingua\ romanza",
    'rof'   => 'Rombo',
    'rom'   => 'romani',
    'ru'    => 'russo',
    'rup'   => 'arumeno',
    'rw'    => 'kinyarwanda',
    'rwk'   => 'Rwa',
    'sa'    => 'sanscrito',
    'sad'   => 'sandawe',
    'sah'   => 'yakut',
    'sai'   => "lingua\ indiana\ del\ Sud\ America",
    'sal'   => "lingue\ salish",
    'sam'   => "aramaico\ samaritano",
    'saq'   => 'Samburu',
    'sas'   => 'sasak',
    'sat'   => 'santali',
    'sbp'   => 'Sangu',
    'sc'    => 'sardo',
    'scn'   => 'siciliano',
    'sco'   => 'scozzese',
    'sd'    => 'sindhi',
    'se'    => "sami\ del\ nord",
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'selkup',
    'sem'   => "lingua\ semitica",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'sango',
    'sga'   => "irlandese\ antico",
    'sgn'   => "lingue\ sign",
    'sh'    => "serbo\-croato",
    'shi'   => 'Tachelhit',
    'shn'   => 'shan',
    'si'    => 'singalese',
    'sid'   => 'sidamo',
    'sio'   => "lingue\ sioux",
    'sit'   => "lingua\ sino\-tibetana",
    'sk'    => 'slovacco',
    'sl'    => 'sloveno',
    'sla'   => "lingua\ slava",
    'sm'    => 'samoano',
    'sma'   => "sami\ del\ sud",
    'smi'   => "lingua\ sami",
    'smj'   => "sami\ lule",
    'smn'   => "sami\ inari",
    'sms'   => "sami\ skolt",
    'sn'    => 'shona',
    'snk'   => 'soninke',
    'so'    => 'somalo',
    'sog'   => 'sogdiano',
    'son'   => 'songhai',
    'sq'    => 'albanese',
    'sr'    => 'serbo',
    'srn'   => "sranan\ tongo",
    'srr'   => 'serer',
    'ss'    => 'swati',
    'ssa'   => "lingua\ nilo\-sahariana",
    'ssy'   => 'Saho',
    'st'    => "sotho\ del\ sud",
    'su'    => 'sundanese',
    'suk'   => 'sukuma',
    'sus'   => 'susu',
    'sux'   => 'sumero',
    'sv'    => 'svedese',
    'sw'    => 'swahili',
    'swb'   => 'comoriano',
    'swc'   => "Congo\ Swahili",
    'syc'   => "Classical\ Syriac",
    'syr'   => 'siriaco',
    'ta'    => 'tamil',
    'tai'   => "lingua\ tailandese",
    'te'    => 'telugu',
    'tem'   => 'temne',
    'teo'   => 'Teso',
    'ter'   => 'tereno',
    'tet'   => 'tetum',
    'tg'    => 'tagicco',
    'th'    => 'thai',
    'ti'    => 'tigrinya',
    'tig'   => 'tigre',
    'tiv'   => 'tiv',
    'tk'    => 'turcomanno',
    'tkl'   => 'tokelau',
    'tl'    => 'tagalog',
    'tlh'   => 'klingon',
    'tli'   => 'tlingit',
    'tmh'   => 'tamashek',
    'tn'    => 'tswana',
    'to'    => 'tonga',
    'tog'   => "nyasa\ del\ Tonga",
    'tpi'   => "tok\ pisin",
    'tr'    => 'turco',
    'trv'   => 'Taroko',
    'ts'    => 'tsonga',
    'tsi'   => 'tsimshian',
    'tt'    => 'tatarico',
    'tum'   => 'tumbuka',
    'tup'   => "lingue\ tupi",
    'tut'   => "lingua\ altaica",
    'tvl'   => 'tuvalu',
    'tw'    => 'ci',
    'twq'   => 'Tasawaq',
    'ty'    => 'taitiano',
    'tyv'   => 'tuvinian',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'udmurt',
    'ug'    => 'uiguro',
    'uga'   => 'ugaritico',
    'uk'    => 'ucraino',
    'umb'   => 'mbundu',
    'und'   => "lingua\ imprecisata",
    'ur'    => 'urdu',
    'uz'    => 'usbeco',
    'vai'   => 'vai',
    've'    => 'venda',
    'vi'    => 'vietnamita',
    'vo'    => 'volapük',
    'vot'   => 'voto',
    'vun'   => 'Vunjo',
    'wa'    => 'vallone',
    'wae'   => 'Walser',
    'wak'   => "lingue\ wakash",
    'wal'   => 'walamo',
    'war'   => 'waray',
    'was'   => 'washo',
    'wen'   => 'sorabo',
    'wo'    => 'volof',
    'xal'   => 'kalmyk',
    'xh'    => 'xosa',
    'xog'   => 'Soga',
    'yao'   => "yao\ \(bantu\)",
    'yap'   => 'yapese',
    'yav'   => 'Yangben',
    'yi'    => 'yiddish',
    'yo'    => 'yoruba',
    'ypk'   => "lingue\ yupik",
    'yue'   => 'cantonese',
    'za'    => 'zhuang',
    'zap'   => 'zapotec',
    'zbl'   => 'Blissymbols',
    'zen'   => 'zenaga',
    'zh'    => 'cinese',
    'znd'   => 'zande',
    'zu'    => 'zulu',
    'zun'   => 'zuni',
    'zxx'   => "nessun\ contenuto\ linguistico",
    'zza'   => 'zaza',
);

%Locales::DB::Language::it::name_to_code = (
    'abkhazian'                        => 'ab',
    'accado'                           => 'akk',
    'accinese'                         => 'ace',
    'acioli'                           => 'ach',
    'adangme'                          => 'ada',
    'adyghe'                           => 'ady',
    'afar'                             => 'aa',
    'afrihili'                         => 'afh',
    'afrikaans'                        => 'af',
    'aghem'                            => 'agq',
    'ainu'                             => 'ain',
    'akan'                             => 'ak',
    'albanese'                         => 'sq',
    'aleuto'                           => 'ale',
    'altaimeridionale'                 => 'alt',
    'altosorabo'                       => 'hsb',
    'altotedescosvizzero'              => 'de_ch',
    'amarico'                          => 'am',
    'angika'                           => 'anp',
    'arabo'                            => 'ar',
    'aragonese'                        => 'an',
    'aramaico'                         => 'arc',
    'aramaicosamaritano'               => 'sam',
    'arapaho'                          => 'arp',
    'araucano'                         => 'arn',
    'armeno'                           => 'hy',
    'aruaco'                           => 'arw',
    'arumeno'                          => 'rup',
    'assamese'                         => 'as',
    'asturiano'                        => 'ast',
    'asu'                              => 'asa',
    'atsam'                            => 'cch',
    'austronesiano'                    => 'map',
    'avaro'                            => 'av',
    'avestan'                          => 'ae',
    'awadhi'                           => 'awa',
    'aymara'                           => 'ay',
    'azero'                            => 'az',
    'bafia'                            => 'ksf',
    'balinese'                         => 'ban',
    'bambara'                          => 'bm',
    'banda'                            => 'bad',
    'bantu'                            => 'bnt',
    'basa'                             => 'bas',
    'baschiro'                         => 'ba',
    'basco'                            => 'eu',
    'bassosorabo'                      => 'dsb',
    'bassotedesco'                     => 'nds',
    'batak'                            => 'btk',
    'begia'                            => 'bej',
    'beluci'                           => 'bal',
    'bena'                             => 'bez',
    'bengalese'                        => 'bn',
    'berbero'                          => 'ber',
    'bhojpuri'                         => 'bho',
    'bicol'                            => 'bik',
    'bielorusso'                       => 'be',
    'bihari'                           => 'bh',
    'bini'                             => 'bin',
    'birmano'                          => 'my',
    'bislama'                          => 'bi',
    'blin'                             => 'byn',
    'blissymbols'                      => 'zbl',
    'bodo'                             => 'brx',
    'bosniaco'                         => 'bs',
    'braj'                             => 'bra',
    'bretone'                          => 'br',
    'bugi'                             => 'bug',
    'bulgaro'                          => 'bg',
    'buriat'                           => 'bua',
    'caddo'                            => 'cad',
    'cantonese'                        => 'yue',
    'careliano'                        => 'krl',
    'caribico'                         => 'car',
    'catalano'                         => 'ca',
    'cayuga'                           => 'cay',
    'cebuano'                          => 'ceb',
    'ceceno'                           => 'ce',
    'ceco'                             => 'cs',
    'celticaaltralingua'               => 'cel',
    'centralmoroccotamazight'          => 'tzm',
    'chamorro'                         => 'ch',
    'cherokee'                         => 'chr',
    'cheyenne'                         => 'chy',
    'chibcha'                          => 'chb',
    'chiga'                            => 'cgg',
    'chipewyan'                        => 'chp',
    'choctaw'                          => 'cho',
    'chuukese'                         => 'chk',
    'chuvash'                          => 'cv',
    'ci'                               => 'tw',
    'ciagataico'                       => 'chg',
    'cinese'                           => 'zh',
    'classicalsyriac'                  => 'syc',
    'colognian'                        => 'ksh',
    'comoriano'                        => 'swb',
    'congoswahili'                     => 'swc',
    'copto'                            => 'cop',
    'coreano'                          => 'ko',
    'cornico'                          => 'kw',
    'corso'                            => 'co',
    'cree'                             => 'cr',
    'creek'                            => 'mus',
    'creoloopidgin'                    => 'crp',
    'creoloopidginbasatisulfrancese'   => 'cpf',
    'creoloopidginbasatisullinglese'   => 'cpe',
    'creoloopidginbasatisulportoghese' => 'cpp',
    'croato'                           => 'hr',
    'curdo'                            => 'ku',
    'dakota'                           => 'dak',
    'danese'                           => 'da',
    'dargwa'                           => 'dar',
    'dayak'                            => 'day',
    'delaware'                         => 'del',
    'dinca'                            => 'din',
    'diula'                            => 'dyu',
    'divehi'                           => 'dv',
    'dogri'                            => 'doi',
    'dogrib'                           => 'dgr',
    'duala'                            => 'dua',
    'dzongkha'                         => 'dz',
    'easternfrisian'                   => 'frs',
    'ebraico'                          => 'he',
    'efik'                             => 'efi',
    'egizianoantico'                   => 'egy',
    'ekajuka'                          => 'eka',
    'elamitico'                        => 'elx',
    'embu'                             => 'ebu',
    'erzya'                            => 'myv',
    'esperanto'                        => 'eo',
    'estone'                           => 'et',
    'ewe'                              => 'ee',
    'ewondo'                           => 'ewo',
    'fang'                             => 'fan',
    'fanti'                            => 'fat',
    'faroese'                          => 'fo',
    'fenicio'                          => 'phn',
    'fiammingobelga'                   => 'nl_be',
    'figiano'                          => 'fj',
    'filippino'                        => 'fil',
    'finlandese'                       => 'fi',
    'fon'                              => 'fon',
    'francese'                         => 'fr',
    'franceseantico'                   => 'fro',
    'francesecanadese'                 => 'fr_ca',
    'francesemedio'                    => 'frm',
    'francesesvizzero'                 => 'fr_ch',
    'frisone'                          => 'fy',
    'frisonesettentrionale'            => 'frr',
    'friulano'                         => 'fur',
    'fulah'                            => 'ff',
    'ga'                               => 'gaa',
    'gaelicoscozzese'                  => 'gd',
    'galiziano'                        => 'gl',
    'gallese'                          => 'cy',
    'ganda'                            => 'lg',
    'gayo'                             => 'gay',
    'gbaya'                            => 'gba',
    'geez'                             => 'gez',
    'georgiano'                        => 'ka',
    'gerbo'                            => 'grb',
    'gergochinook'                     => 'chn',
    'giapponese'                       => 'ja',
    'giavanese'                        => 'jv',
    'gilbertese'                       => 'gil',
    'giudeoarabo'                      => 'jrb',
    'giudeopersiano'                   => 'jpr',
    'gondi'                            => 'gon',
    'gorontalo'                        => 'gor',
    'gotico'                           => 'got',
    'greco'                            => 'el',
    'grecoantico'                      => 'grc',
    'guarana'                          => 'gn',
    'gujarati'                         => 'gu',
    'gusii'                            => 'guz',
    'gwichʼin'                        => 'gwi',
    'haida'                            => 'hai',
    'haitiano'                         => 'ht',
    'haussa'                           => 'ha',
    'hawaiano'                         => 'haw',
    'herero'                           => 'hz',
    'hiligayna'                        => 'hil',
    'himachali'                        => 'him',
    'hindi'                            => 'hi',
    'hirimotu'                         => 'ho',
    'hittite'                          => 'hit',
    'hmong'                            => 'hmn',
    'hupa'                             => 'hup',
    'iban'                             => 'iba',
    'ido'                              => 'io',
    'igbo'                             => 'ig',
    'ijo'                              => 'ijo',
    'ilocano'                          => 'ilo',
    'indonesiano'                      => 'id',
    'inglese'                          => 'en',
    'ingleseamericano'                 => 'en_us',
    'ingleseantico'                    => 'ang',
    'ingleseaustraliano'               => 'en_au',
    'inglesebritannico'                => 'en_gb',
    'inglesecanadese'                  => 'en_ca',
    'inglesemedio'                     => 'enm',
    'ingush'                           => 'inh',
    'interlingua'                      => 'ia',
    'interlingue'                      => 'ie',
    'inuktitut'                        => 'iu',
    'inupiak'                          => 'ik',
    'iraniana'                         => 'ira',
    'irlandese'                        => 'ga',
    'irlandeseantico'                  => 'sga',
    'irlandesemedio'                   => 'mga',
    'islandese'                        => 'is',
    'italiano'                         => 'it',
    'jolafonyi'                        => 'dyo',
    'kabardia'                         => 'kbd',
    'kabuverdianu'                     => 'kea',
    'kabyle'                           => 'kab',
    'kachin'                           => 'kac',
    'kai'                              => 'kaj',
    'kalaallisut'                      => 'kl',
    'kalenjin'                         => 'kln',
    'kalmyk'                           => 'xal',
    'kamba'                            => 'kam',
    'kannada'                          => 'kn',
    'kanuri'                           => 'kr',
    'karachaybalkar'                   => 'krc',
    'karakalpak'                       => 'kaa',
    'karen'                            => 'kar',
    'kashmiri'                         => 'ks',
    'kashubian'                        => 'csb',
    'kawi'                             => 'kaw',
    'kazako'                           => 'kk',
    'kfo'                              => 'kfo',
    'khasi'                            => 'kha',
    'khmer'                            => 'km',
    'khotanese'                        => 'kho',
    'kikuyu'                           => 'ki',
    'kimbundu'                         => 'kmb',
    'kinyarwanda'                      => 'rw',
    'kirghiso'                         => 'ky',
    'klingon'                          => 'tlh',
    'komi'                             => 'kv',
    'kongo'                            => 'kg',
    'konkani'                          => 'kok',
    'kosraean'                         => 'kos',
    'koyraborosenni'                   => 'ses',
    'koyrachiini'                      => 'khq',
    'kpelle'                           => 'kpe',
    'kru'                              => 'kro',
    'kuanyama'                         => 'kj',
    'kumyk'                            => 'kum',
    'kurukh'                           => 'kru',
    'kutenai'                          => 'kut',
    'kwasio'                           => 'nmg',
    'ladino'                           => 'lad',
    'lahnda'                           => 'lah',
    'lamba'                            => 'lam',
    'langi'                            => 'lag',
    'lao'                              => 'lo',
    'latino'                           => 'la',
    'lettone'                          => 'lv',
    'lezghian'                         => 'lez',
    'limburgese'                       => 'li',
    'lingala'                          => 'ln',
    'linguaafroasiatica'               => 'afa',
    'linguaaltaica'                    => 'tut',
    'linguaartificiale'                => 'art',
    'linguabaltica'                    => 'bat',
    'linguacaucasica'                  => 'cau',
    'linguacuscitica'                  => 'cus',
    'linguadravidica'                  => 'dra',
    'linguafilippina'                  => 'phi',
    'linguagermanica'                  => 'gem',
    'linguaimprecisata'                => 'und',
    'linguaindiana'                    => 'inc',
    'linguaindianadellamericacentrale' => 'cai',
    'linguaindianadelnordamerica'      => 'nai',
    'linguaindianadelsudamerica'       => 'sai',
    'linguaindoeuropea'                => 'ine',
    'linguakhoisan'                    => 'khi',
    'linguamonkhmer'                   => 'mkh',
    'linguamunda'                      => 'mun',
    'linguanigercordofan'              => 'nic',
    'linguanilosahariana'              => 'ssa',
    'linguapapuana'                    => 'paa',
    'linguarhaetoromance'              => 'rm',
    'linguaromanza'                    => 'roa',
    'linguasami'                       => 'smi',
    'linguasemitica'                   => 'sem',
    'linguasinotibetana'               => 'sit',
    'linguaslava'                      => 'sla',
    'linguatailandese'                 => 'tai',
    'linguaungrofinnica'               => 'fiu',
    'linguealgonchine'                 => 'alg',
    'lingueapache'                     => 'apa',
    'lingueathabaska'                  => 'ath',
    'lingueaustraliane'                => 'aus',
    'linguebamileke'                   => 'bai',
    'linguechamic'                     => 'cmc',
    'linguediverse'                    => 'mis',
    'lingueirochesi'                   => 'iro',
    'linguemaya'                       => 'myn',
    'lingueotomi'                      => 'oto',
    'linguesalish'                     => 'sal',
    'linguesign'                       => 'sgn',
    'linguesioux'                      => 'sio',
    'linguetupi'                       => 'tup',
    'linguewakash'                     => 'wak',
    'lingueyupik'                      => 'ypk',
    'lituano'                          => 'lt',
    'lojban'                           => 'jbo',
    'lolobantu'                        => 'lol',
    'lozi'                             => 'loz',
    'lubakatanga'                      => 'lu',
    'lubalulua'                        => 'lua',
    'luiseno'                          => 'lui',
    'lunda'                            => 'lun',
    'luo'                              => 'luo',
    'lushai'                           => 'lus',
    'lussemburghese'                   => 'lb',
    'luyia'                            => 'luy',
    'macedone'                         => 'mk',
    'machame'                          => 'jmc',
    'madurese'                         => 'mad',
    'magahi'                           => 'mag',
    'maithili'                         => 'mai',
    'makasar'                          => 'mak',
    'makhuwameetto'                    => 'mgh',
    'makonde'                          => 'kde',
    'malayalam'                        => 'ml',
    'malese'                           => 'ms',
    'malgascio'                        => 'mg',
    'maltese'                          => 'mt',
    'manchu'                           => 'mnc',
    'mandar'                           => 'mdr',
    'mandingo'                         => 'man',
    'manipuri'                         => 'mni',
    'manobo'                           => 'mno',
    'manx'                             => 'gv',
    'maori'                            => 'mi',
    'marathi'                          => 'mr',
    'mari'                             => 'chm',
    'marshallese'                      => 'mh',
    'marwari'                          => 'mwr',
    'masai'                            => 'mas',
    'mbundu'                           => 'umb',
    'menangkabau'                      => 'min',
    'mende'                            => 'men',
    'meru'                             => 'mer',
    'micmac'                           => 'mic',
    'mirandese'                        => 'mwl',
    'mohawk'                           => 'moh',
    'moksha'                           => 'mdf',
    'moldavo'                          => 'mo',
    'mongolo'                          => 'mn',
    'morisyen'                         => 'mfe',
    'mossi'                            => 'mos',
    'multilingua'                      => 'mul',
    'mundang'                          => 'mua',
    'nahuatl'                          => 'nah',
    'nama'                             => 'naq',
    'napoletano'                       => 'nap',
    'nauru'                            => 'na',
    'navajo'                           => 'nv',
    'ndebeledelnord'                   => 'nd',
    'ndebeledelsud'                    => 'nr',
    'ndonga'                           => 'ng',
    'nepalese'                         => 'ne',
    'nessuncontenutolinguistico'       => 'zxx',
    'newari'                           => 'new',
    'newariclassico'                   => 'nwc',
    'nias'                             => 'nia',
    'niue'                             => 'niu',
    'nko'                              => 'nqo',
    'nogai'                            => 'nog',
    'norseantico'                      => 'non',
    'norvegese'                        => 'no',
    'norvegesebokmal'                  => 'nb',
    'norvegesenynorsk'                 => 'nn',
    'nubiano'                          => 'nub',
    'nuer'                             => 'nus',
    'nyamwezi'                         => 'nym',
    'nyanja'                           => 'ny',
    'nyankole'                         => 'nyn',
    'nyasadeltonga'                    => 'tog',
    'nyoro'                            => 'nyo',
    'nzima'                            => 'nzi',
    'occitano'                         => 'oc',
    'ojibwa'                           => 'oj',
    'olandese'                         => 'nl',
    'olandesemedio'                    => 'dum',
    'oriya'                            => 'or',
    'oromo'                            => 'om',
    'osage'                            => 'osa',
    'ossetico'                         => 'os',
    'pahlavi'                          => 'pal',
    'palau'                            => 'pau',
    'pali'                             => 'pi',
    'pampanga'                         => 'pam',
    'pangasinan'                       => 'pag',
    'papiamento'                       => 'pap',
    'pashto'                           => 'ps',
    'persiano'                         => 'fa',
    'persianoantico'                   => 'peo',
    'polacco'                          => 'pl',
    'ponape'                           => 'pon',
    'portoghese'                       => 'pt',
    'portoghesebrasiliano'             => 'pt_br',
    'portoghesedelportogallo'          => 'pt_pt',
    'pracrito'                         => 'pra',
    'provenzaleantico'                 => 'pro',
    'punjabi'                          => 'pa',
    'quechua'                          => 'qu',
    'rajasthani'                       => 'raj',
    'rapanui'                          => 'rap',
    'rarotonga'                        => 'rar',
    'romani'                           => 'rom',
    'rombo'                            => 'rof',
    'rumeno'                           => 'ro',
    'rundi'                            => 'rn',
    'russo'                            => 'ru',
    'rwa'                              => 'rwk',
    'saho'                             => 'ssy',
    'samburu'                          => 'saq',
    'samidelnord'                      => 'se',
    'samidelsud'                       => 'sma',
    'samiinari'                        => 'smn',
    'samilule'                         => 'smj',
    'samiskolt'                        => 'sms',
    'samoano'                          => 'sm',
    'sandawe'                          => 'sad',
    'sango'                            => 'sg',
    'sangu'                            => 'sbp',
    'sanscrito'                        => 'sa',
    'santali'                          => 'sat',
    'sardo'                            => 'sc',
    'sasak'                            => 'sas',
    'scozzese'                         => 'sco',
    'selkup'                           => 'sel',
    'sena'                             => 'seh',
    'seneca'                           => 'see',
    'serbo'                            => 'sr',
    'serbocroato'                      => 'sh',
    'serer'                            => 'srr',
    'shambala'                         => 'ksb',
    'shan'                             => 'shn',
    'shona'                            => 'sn',
    'sichuanyi'                        => 'ii',
    'siciliano'                        => 'scn',
    'sidamo'                           => 'sid',
    'siksika'                          => 'bla',
    'sindhi'                           => 'sd',
    'singalese'                        => 'si',
    'siriaco'                          => 'syr',
    'slave'                            => 'den',
    'slavodellachiesa'                 => 'cu',
    'slovacco'                         => 'sk',
    'sloveno'                          => 'sl',
    'soga'                             => 'xog',
    'sogdiano'                         => 'sog',
    'somalo'                           => 'so',
    'songhai'                          => 'son',
    'soninke'                          => 'snk',
    'sorabo'                           => 'wen',
    'sothodelnord'                     => 'nso',
    'sothodelsud'                      => 'st',
    'spagnolo'                         => 'es',
    'spagnolodellaspagna'              => 'es_es',
    'sranantongo'                      => 'srn',
    'sukuma'                           => 'suk',
    'sumero'                           => 'sux',
    'sundanese'                        => 'su',
    'susu'                             => 'sus',
    'svedese'                          => 'sv',
    'swahili'                          => 'sw',
    'swati'                            => 'ss',
    'tachelhit'                        => 'shi',
    'tagalog'                          => 'tl',
    'tagicco'                          => 'tg',
    'taita'                            => 'dav',
    'taitiano'                         => 'ty',
    'tamashek'                         => 'tmh',
    'tamil'                            => 'ta',
    'taroko'                           => 'trv',
    'tasawaq'                          => 'twq',
    'tatarico'                         => 'tt',
    'tedesco'                          => 'de',
    'tedescoanticoalto'                => 'goh',
    'tedescoaustriaco'                 => 'de_at',
    'tedescomedioalto'                 => 'gmh',
    'tedescosvizzero'                  => 'gsw',
    'telugu'                           => 'te',
    'temne'                            => 'tem',
    'tereno'                           => 'ter',
    'teso'                             => 'teo',
    'tetum'                            => 'tet',
    'thai'                             => 'th',
    'tibetano'                         => 'bo',
    'tigre'                            => 'tig',
    'tigrinya'                         => 'ti',
    'tiv'                              => 'tiv',
    'tlingit'                          => 'tli',
    'tokelau'                          => 'tkl',
    'tokpisin'                         => 'tpi',
    'tonga'                            => 'to',
    'tsimshian'                        => 'tsi',
    'tsonga'                           => 'ts',
    'tswana'                           => 'tn',
    'tumbuka'                          => 'tum',
    'turco'                            => 'tr',
    'turcocrimeo'                      => 'crh',
    'turcomanno'                       => 'tk',
    'turcoottomano'                    => 'ota',
    'tuvalu'                           => 'tvl',
    'tuvinian'                         => 'tyv',
    'tyap'                             => 'kcg',
    'ucraino'                          => 'uk',
    'udmurt'                           => 'udm',
    'ugaritico'                        => 'uga',
    'uiguro'                           => 'ug',
    'ungherese'                        => 'hu',
    'urdu'                             => 'ur',
    'usbeco'                           => 'uz',
    'vai'                              => 'vai',
    'vallone'                          => 'wa',
    'venda'                            => 've',
    'vietnamita'                       => 'vi',
    'volapük'                         => 'vo',
    'volof'                            => 'wo',
    'voto'                             => 'vot',
    'vunjo'                            => 'vun',
    'walamo'                           => 'wal',
    'walser'                           => 'wae',
    'waray'                            => 'war',
    'washo'                            => 'was',
    'wemba'                            => 'bem',
    'xosa'                             => 'xh',
    'yakut'                            => 'sah',
    'yangben'                          => 'yav',
    'yaobantu'                         => 'yao',
    'yapese'                           => 'yap',
    'yiddish'                          => 'yi',
    'yoruba'                           => 'yo',
    'zande'                            => 'znd',
    'zapotec'                          => 'zap',
    'zarma'                            => 'dje',
    'zaza'                             => 'zza',
    'zenaga'                           => 'zen',
    'zhuang'                           => 'za',
    'zulu'                             => 'zu',
    'zuni'                             => 'zun',
);

1;
