package Locales::DB::Language::af;

# Auto generated from CLDR

$Locales::DB::Language::af::VERSION = '0.08';

$Locales::DB::Language::af::cldr_version = '2.0';

%Locales::DB::Language::af::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => ' ',
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Taal\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ en\ \{1\}",
            'end'    => "\{0\}\ en\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Omgewing\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '”',
        'alternate_quotation_start' => '‘',
        'quotation_end'             => '”',
        'quotation_start'           => '“'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'other'
        ],
        'category_rules'          => { 'one' => "n\ is\ 1" },
        'category_rules_compiled' => { 'one' => "sub\ \{\ return\ \'one\'\ if\ \(\ \(\(\ \$_\[0\]\ \=\=\ 1\)\)\)\;\ return\;\}\;" }
    },
    'posix' => {
        'nostr'  => "nee\:n",
        'yesstr' => "ja\:j"
    },
);

%Locales::DB::Language::af::code_to_name = (
    'aa'    => 'Afar',
    'ab'    => 'Abkasies',
    'ace'   => 'Achinese',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'Adyghe',
    'ae'    => 'Avestan',
    'af'    => 'Afrikaans',
    'afa'   => "Ander\ Afro\-Asiaties",
    'afh'   => 'Afrihili',
    'agq'   => 'Aghem',
    'ain'   => 'Ainu',
    'ak'    => 'Akan',
    'akk'   => 'Akkadian',
    'ale'   => 'Aleut',
    'alg'   => "Algonquian\ Language",
    'alt'   => "Southern\ Altai",
    'am'    => 'Amharies',
    'an'    => 'Aragonese',
    'ang'   => "Old\ English",
    'anp'   => 'Angika',
    'apa'   => "Apache\ Language",
    'ar'    => 'Arabies',
    'arc'   => 'Aramees',
    'arn'   => 'Araucanian',
    'arp'   => 'Arapaho',
    'art'   => "Kunsmatige\ taal",
    'arw'   => 'Arawak',
    'as'    => 'Assamees',
    'asa'   => 'Asu',
    'ast'   => 'Asturian',
    'ath'   => "Athapascan\ Language",
    'aus'   => "Australian\ Language",
    'av'    => 'Avaric',
    'awa'   => 'Awadhi',
    'ay'    => 'Aymara',
    'az'    => 'Azeri',
    'ba'    => 'Bashkir',
    'bad'   => 'Banda',
    'bai'   => "Bamileke\ Language",
    'bal'   => 'Baluchi',
    'ban'   => 'Balinese',
    'bas'   => 'Basaa',
    'bat'   => "Baltiese\ taal",
    'be'    => "Wit\-Russies",
    'bej'   => 'Beja',
    'bem'   => 'Bemba',
    'ber'   => 'Berbers',
    'bez'   => 'Bena',
    'bg'    => 'Bulgaars',
    'bh'    => "Biharise\ taal",
    'bho'   => 'Bhojpuri',
    'bi'    => 'Bislama',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => 'Bengaals',
    'bnt'   => 'Bantoe',
    'bo'    => 'Tibettaans',
    'br'    => 'Bretons',
    'bra'   => 'Braj',
    'brx'   => 'Bodo',
    'bs'    => 'Bosnies',
    'btk'   => 'Batak',
    'bua'   => 'Buriat',
    'bug'   => 'Buginese',
    'byn'   => 'Blin',
    'ca'    => 'Katalaans',
    'cad'   => 'Caddo',
    'cai'   => "Central\ American\ Indian\ Language",
    'car'   => 'Carib',
    'cau'   => "Caucasian\ Language",
    'cay'   => 'Cayuga',
    'cch'   => 'Atsam',
    'ce'    => 'Chechen',
    'ceb'   => 'Cebuano',
    'cel'   => "Keltiese\ taal",
    'cgg'   => 'Chiga',
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => 'Chagatai',
    'chk'   => 'Chuukese',
    'chm'   => 'Mari',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokees',
    'chy'   => 'Cheyenne',
    'cmc'   => "Chamic\ Language",
    'co'    => 'Corsican',
    'cop'   => 'Kopties',
    'cpe'   => "English\-based\ Creole\ or\ Pidgin",
    'cpf'   => "French\-based\ Creole\ or\ Pidgin",
    'cpp'   => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'    => 'Cree',
    'crh'   => "Crimean\ Turkish",
    'crp'   => "Creole\ or\ Pidgin",
    'cs'    => 'Tsjeggies',
    'csb'   => 'Kashubian',
    'cu'    => 'Kerkslawies',
    'cus'   => "Cushitic\ Language",
    'cv'    => 'Chuvash',
    'cy'    => 'Wallies',
    'da'    => 'Deens',
    'dak'   => 'Dakota',
    'dar'   => 'Dargwa',
    'dav'   => 'Taita',
    'day'   => 'Dayak',
    'de'    => 'Duits',
    'de_at' => "Oostenrykse\ Duits",
    'de_ch' => "Switserse\ hoog\-Duits",
    'del'   => 'Delaware',
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'dje'   => 'Zarma',
    'doi'   => 'Dogri',
    'dra'   => "Dravidian\ Language",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'Duala',
    'dum'   => "Middle\ Dutch",
    'dv'    => 'Divehi',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => 'Dyula',
    'dz'    => 'Dzongkha',
    'ebu'   => 'Embu',
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => "Antieke\ Egipties",
    'eka'   => 'Ekajuk',
    'el'    => 'Grieks',
    'elx'   => 'Elamite',
    'en'    => 'Engels',
    'en_au' => "Australiese\ Engels",
    'en_ca' => "Kanadese\ Engels",
    'en_gb' => "Britse\ Engels",
    'en_us' => "Amerikaanse\ Engels",
    'enm'   => "Middle\ English",
    'eo'    => 'Esperanto',
    'es'    => 'Spaans',
    'es_es' => "Iberiese\ Spaans",
    'et'    => 'Estnies',
    'eu'    => 'Baskies',
    'ewo'   => 'Ewondo',
    'fa'    => 'Persies',
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => 'Fins',
    'fil'   => 'Filippyns',
    'fiu'   => "Finno\-Ugrian\ Language",
    'fj'    => 'Fidjiaans',
    'fo'    => 'Faroees',
    'fon'   => 'Fon',
    'fr'    => 'Frans',
    'fr_ca' => "Kanadese\ Frans",
    'fr_ch' => "Switserse\ Frans",
    'frm'   => "Middle\ French",
    'fro'   => "Old\ French",
    'frr'   => "Northern\ Frisian",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'Friulian',
    'fy'    => "Wes\-Fries",
    'ga'    => 'Iers',
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "Skotse\ Gallies",
    'gem'   => "Germaanse\ taal",
    'gez'   => 'Geez',
    'gil'   => 'Gilbertese',
    'gl'    => 'Galisies',
    'gmh'   => "Middle\ High\ German",
    'gn'    => 'Guarani',
    'goh'   => "Old\ High\ German",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Goties',
    'grb'   => 'Grebo',
    'grc'   => "Antieke\ Grieks",
    'gsw'   => "Switserse\ Duits",
    'gu'    => 'Gudjarati',
    'guz'   => 'Gusii',
    'gv'    => 'Manx',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => 'Hausa',
    'hai'   => 'Haida',
    'haw'   => 'Hawaies',
    'he'    => 'Hebreeus',
    'hi'    => 'Hindi',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hetities',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => 'Kroaties',
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'Haïtiaans',
    'hu'    => 'Hongaars',
    'hup'   => 'Hupa',
    'hy'    => 'Armeens',
    'hz'    => 'Herero',
    'ia'    => 'Interlingua',
    'iba'   => 'Iban',
    'id'    => 'Indonesies',
    'ie'    => 'Interlingue',
    'ig'    => 'Igbo',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'Inupiaq',
    'ilo'   => 'Iloko',
    'inc'   => "Indic\ Language",
    'ine'   => "Indo\-Europese\ taal",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => "Iranian\ Language",
    'iro'   => "Iroquoian\ Language",
    'is'    => 'Yslands',
    'it'    => 'Italiaans',
    'iu'    => 'Inuktitut',
    'ja'    => 'Japannees',
    'jbo'   => 'Lojban',
    'jmc'   => 'Machame',
    'jpr'   => "Judeo\-Persian",
    'jrb'   => "Judeo\-Arabic",
    'jv'    => 'Javaans',
    'ka'    => 'Georgies',
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabyle',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Khoi\-San\ taal",
    'kho'   => 'Khotanese',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'Kazak',
    'kl'    => 'Kalaallisut',
    'kln'   => 'Kalenjin',
    'km'    => 'Khmer',
    'kmb'   => 'Kimbundu',
    'kn'    => 'Kannada',
    'ko'    => 'Koreaans',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'Kasjmirs',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'Koerdies',
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Kornies',
    'ky'    => 'Kirgisies',
    'la'    => 'Latyn',
    'lad'   => 'Ladino',
    'lag'   => 'Langi',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'Luxemburgs',
    'lez'   => 'Lezghian',
    'lg'    => 'Ganda',
    'li'    => 'Limburgs',
    'ln'    => 'Lingaals',
    'lo'    => 'Lao',
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => 'Litaus',
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'luy'   => 'Luyia',
    'lv'    => 'Letties',
    'mad'   => 'Madurese',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => "Austronesian\ Language",
    'mas'   => 'Masai',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'Malgassies',
    'mga'   => "Middle\ Irish",
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => 'Marshallese',
    'mi'    => 'Maori',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "Miscellaneous\ Language",
    'mk'    => 'Masedonies',
    'mkh'   => "Mon\-Khmer\ Language",
    'ml'    => 'Malabaars',
    'mn'    => 'Mongools',
    'mnc'   => 'Manchu',
    'mni'   => 'Manipuri',
    'mno'   => "Manobo\ Language",
    'mo'    => 'Moldavian',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => 'Marathi',
    'ms'    => 'Maleisies',
    'mt'    => 'Maltees',
    'mua'   => 'Mundang',
    'mul'   => "Veelvuldige\ tale",
    'mun'   => "Munda\ Language",
    'mus'   => 'Creek',
    'mwl'   => 'Mirandese',
    'mwr'   => 'Marwari',
    'my'    => 'Birmaans',
    'myn'   => "Mayan\ Language",
    'myv'   => 'Erzya',
    'na'    => 'Nauru',
    'nah'   => 'Nahuatl',
    'nai'   => "North\ American\ Indian\ Language",
    'nap'   => 'Neapolitan',
    'naq'   => 'Nama',
    'nb'    => "Noorse\ Bokmål",
    'nd'    => "Noord\-Ndebele",
    'nds'   => "Low\ German",
    'ne'    => 'Nepalees',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => 'Niuean',
    'nl'    => 'Nederlands',
    'nl_be' => 'Vlaams',
    'nmg'   => 'Kwasio',
    'nn'    => "Noorweegse\ Nynorsk",
    'no'    => 'Noors',
    'nog'   => 'Nogai',
    'non'   => "Old\ Norse",
    'nqo'   => "N\â\\Ko",
    'nr'    => "Suid\-Ndebele",
    'nso'   => "Noord\-Sotho",
    'nub'   => "Nubian\ Language",
    'nus'   => 'Nuer',
    'nv'    => 'Navajo',
    'nwc'   => "Classical\ Newari",
    'ny'    => 'Nyanja',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'Occitaans',
    'oj'    => 'Ojibwa',
    'om'    => 'Oromo',
    'or'    => 'Oriya',
    'os'    => 'Osseties',
    'osa'   => 'Osage',
    'ota'   => "Ottoman\ Turkish",
    'oto'   => "Otomian\ Language",
    'pa'    => 'Pandjabi',
    'paa'   => "Papuan\ Language",
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palauan',
    'peo'   => "Old\ Persian",
    'phi'   => "Philippine\ Language",
    'phn'   => 'Fenisies',
    'pi'    => 'Pali',
    'pl'    => 'Pools',
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Language",
    'pro'   => "Old\ Proven\Ã\§al",
    'ps'    => 'Pushto',
    'pt'    => 'Portugees',
    'pt_br' => "Brasiliaanse\ Portugees",
    'pt_pt' => "Iberiese\ Portugees",
    'qu'    => 'Quechua',
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => "Reto\-Romaans",
    'rn'    => 'Rundi',
    'ro'    => 'Roemeens',
    'roa'   => "Romance\ Language",
    'rof'   => 'Rombo',
    'rom'   => 'Romany',
    'ru'    => 'Russies',
    'rup'   => 'Aromanian',
    'rw'    => 'Rwandees',
    'rwk'   => 'Rwa',
    'sa'    => 'Sanskrit',
    'sad'   => 'Sandawe',
    'sah'   => 'Sakha',
    'sai'   => "South\ American\ Indian\ Language",
    'sal'   => "Salishan\ Language",
    'sam'   => "Samaritan\ Aramaic",
    'saq'   => 'Samburu',
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sbp'   => 'Sangu',
    'sc'    => 'Sardinian',
    'scn'   => 'Sicilian',
    'sco'   => 'Skots',
    'sd'    => 'Sindhi',
    'se'    => "Noordelike\ Sami",
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'Selkup',
    'sem'   => "Semitiese\ taal",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'Sango',
    'sga'   => "Old\ Irish",
    'sgn'   => 'Gebaretaal',
    'sh'    => "Serwo\-Kroaties",
    'shi'   => 'Tachelhit',
    'shn'   => 'Shan',
    'si'    => 'Sinhala',
    'sid'   => 'Sidamo',
    'sio'   => "Siouan\ Language",
    'sit'   => "Sino\-Tibetan\ Language",
    'sk'    => 'Slowaaks',
    'sl'    => 'Sloweens',
    'sla'   => "Slawiese\ taal",
    'sm'    => 'Samoaans',
    'sma'   => "Southern\ Sami",
    'smi'   => "Sami\ Language",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'Shona',
    'snk'   => 'Soninke',
    'so'    => 'Somalies',
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => 'Albanees',
    'sr'    => 'Serwies',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'Swazi',
    'ssa'   => "Nilo\-Saharan\ Language",
    'ssy'   => 'Saho',
    'st'    => "Suid\-Sotho",
    'su'    => 'Sundanees',
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sumerian',
    'sv'    => 'Sweeds',
    'sw'    => 'Swahili',
    'swb'   => 'Shimaorees',
    'swc'   => "Congo\ Swahili",
    'syc'   => "Classical\ Syriac",
    'syr'   => 'Syriac',
    'ta'    => 'Tamil',
    'tai'   => "Tai\ Language",
    'te'    => 'Telugu',
    'tem'   => 'Timne',
    'teo'   => 'Teso',
    'ter'   => 'Tereno',
    'tet'   => 'Tetum',
    'tg'    => 'Tadjik',
    'th'    => 'Thais',
    'ti'    => 'Tigrinya',
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'Turkmeens',
    'tkl'   => 'Tokelau',
    'tl'    => 'Tagalog',
    'tlh'   => 'Klingon',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => 'Tswana',
    'to'    => 'Tonga',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "Tok\ Pisin",
    'tr'    => 'Turks',
    'trv'   => 'Taroko',
    'ts'    => 'Tsonga',
    'tsi'   => 'Tsimshian',
    'tt'    => 'Tataars',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ Language",
    'tut'   => "Altaic\ Language",
    'tvl'   => 'Tuvalu',
    'tw'    => 'Twi',
    'twq'   => 'Tasawaq',
    'ty'    => 'Tahities',
    'tyv'   => 'Tuvinian',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'Udmurt',
    'ug'    => 'Uyghur',
    'uga'   => 'Ugaritic',
    'uk'    => 'Oekraïens',
    'umb'   => 'Umbundu',
    'und'   => "Onbekende\ of\ ongeldige\ taal",
    'ur'    => 'Oerdoe',
    'uz'    => 'Oezbeeks',
    'vai'   => 'Vai',
    've'    => 'Venda',
    'vi'    => 'Viëtnamees',
    'vo'    => "Volap\Ã\¼k",
    'vot'   => 'Votic',
    'vun'   => 'Vunjo',
    'wa'    => 'Walloon',
    'wae'   => 'Walser',
    'wak'   => "Wakashan\ Language",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "Sorbian\ Language",
    'wo'    => 'Wolof',
    'xal'   => 'Kalmyk',
    'xh'    => 'Xhosa',
    'xog'   => 'Soga',
    'yao'   => 'Yao',
    'yap'   => 'Yapese',
    'yav'   => 'Yangben',
    'yi'    => 'Jiddisj',
    'yo'    => 'Yoruba',
    'ypk'   => "Yupik\ Language",
    'yue'   => 'Kantonees',
    'za'    => 'Zhuang',
    'zap'   => 'Zapotec',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Zenaga',
    'zh'    => 'Sjinees',
    'znd'   => 'Zande',
    'zu'    => 'Zoeloe',
    'zun'   => 'Zuni',
    'zxx'   => "Geen\ linguistiese\ inhoud",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::af::name_to_code = (
    'abkasies'                      => 'ab',
    'achinese'                      => 'ace',
    'acoli'                         => 'ach',
    'adangme'                       => 'ada',
    'adyghe'                        => 'ady',
    'afar'                          => 'aa',
    'afrihili'                      => 'afh',
    'afrikaans'                     => 'af',
    'aghem'                         => 'agq',
    'ainu'                          => 'ain',
    'akan'                          => 'ak',
    'akkadian'                      => 'akk',
    'albanees'                      => 'sq',
    'aleut'                         => 'ale',
    'algonquianlanguage'            => 'alg',
    'altaiclanguage'                => 'tut',
    'amerikaanseengels'             => 'en_us',
    'amharies'                      => 'am',
    'anderafroasiaties'             => 'afa',
    'angika'                        => 'anp',
    'antiekeegipties'               => 'egy',
    'antiekegrieks'                 => 'grc',
    'apachelanguage'                => 'apa',
    'arabies'                       => 'ar',
    'aragonese'                     => 'an',
    'aramees'                       => 'arc',
    'arapaho'                       => 'arp',
    'araucanian'                    => 'arn',
    'arawak'                        => 'arw',
    'armeens'                       => 'hy',
    'aromanian'                     => 'rup',
    'assamees'                      => 'as',
    'asturian'                      => 'ast',
    'asu'                           => 'asa',
    'athapascanlanguage'            => 'ath',
    'atsam'                         => 'cch',
    'australianlanguage'            => 'aus',
    'australieseengels'             => 'en_au',
    'austronesianlanguage'          => 'map',
    'avaric'                        => 'av',
    'avestan'                       => 'ae',
    'awadhi'                        => 'awa',
    'aymara'                        => 'ay',
    'azeri'                         => 'az',
    'bafia'                         => 'ksf',
    'balinese'                      => 'ban',
    'baltiesetaal'                  => 'bat',
    'baluchi'                       => 'bal',
    'bambara'                       => 'bm',
    'bamilekelanguage'              => 'bai',
    'banda'                         => 'bad',
    'bantoe'                        => 'bnt',
    'basaa'                         => 'bas',
    'bashkir'                       => 'ba',
    'baskies'                       => 'eu',
    'batak'                         => 'btk',
    'beja'                          => 'bej',
    'bemba'                         => 'bem',
    'bena'                          => 'bez',
    'bengaals'                      => 'bn',
    'berbers'                       => 'ber',
    'bhojpuri'                      => 'bho',
    'biharisetaal'                  => 'bh',
    'bikol'                         => 'bik',
    'bini'                          => 'bin',
    'birmaans'                      => 'my',
    'bislama'                       => 'bi',
    'blin'                          => 'byn',
    'blissymbols'                   => 'zbl',
    'bodo'                          => 'brx',
    'bosnies'                       => 'bs',
    'braj'                          => 'bra',
    'brasiliaanseportugees'         => 'pt_br',
    'bretons'                       => 'br',
    'britseengels'                  => 'en_gb',
    'buginese'                      => 'bug',
    'bulgaars'                      => 'bg',
    'buriat'                        => 'bua',
    'caddo'                         => 'cad',
    'carib'                         => 'car',
    'caucasianlanguage'             => 'cau',
    'cayuga'                        => 'cay',
    'cebuano'                       => 'ceb',
    'centralamericanindianlanguage' => 'cai',
    'centralmoroccotamazight'       => 'tzm',
    'chagatai'                      => 'chg',
    'chamiclanguage'                => 'cmc',
    'chamorro'                      => 'ch',
    'chechen'                       => 'ce',
    'cherokees'                     => 'chr',
    'cheyenne'                      => 'chy',
    'chibcha'                       => 'chb',
    'chiga'                         => 'cgg',
    'chinookjargon'                 => 'chn',
    'chipewyan'                     => 'chp',
    'choctaw'                       => 'cho',
    'chuukese'                      => 'chk',
    'chuvash'                       => 'cv',
    'classicalnewari'               => 'nwc',
    'classicalsyriac'               => 'syc',
    'colognian'                     => 'ksh',
    'congoswahili'                  => 'swc',
    'corsican'                      => 'co',
    'cree'                          => 'cr',
    'creek'                         => 'mus',
    'creoleorpidgin'                => 'crp',
    'crimeanturkish'                => 'crh',
    'cushiticlanguage'              => 'cus',
    'dakota'                        => 'dak',
    'dargwa'                        => 'dar',
    'dayak'                         => 'day',
    'deens'                         => 'da',
    'delaware'                      => 'del',
    'dinka'                         => 'din',
    'divehi'                        => 'dv',
    'dogri'                         => 'doi',
    'dogrib'                        => 'dgr',
    'dravidianlanguage'             => 'dra',
    'duala'                         => 'dua',
    'duits'                         => 'de',
    'dyula'                         => 'dyu',
    'dzongkha'                      => 'dz',
    'easternfrisian'                => 'frs',
    'efik'                          => 'efi',
    'ekajuk'                        => 'eka',
    'elamite'                       => 'elx',
    'embu'                          => 'ebu',
    'engels'                        => 'en',
    'englishbasedcreoleorpidgin'    => 'cpe',
    'erzya'                         => 'myv',
    'esperanto'                     => 'eo',
    'estnies'                       => 'et',
    'ewe'                           => 'ee',
    'ewondo'                        => 'ewo',
    'fang'                          => 'fan',
    'fanti'                         => 'fat',
    'faroees'                       => 'fo',
    'fenisies'                      => 'phn',
    'fidjiaans'                     => 'fj',
    'filippyns'                     => 'fil',
    'finnougrianlanguage'           => 'fiu',
    'fins'                          => 'fi',
    'fon'                           => 'fon',
    'frans'                         => 'fr',
    'frenchbasedcreoleorpidgin'     => 'cpf',
    'friulian'                      => 'fur',
    'fulah'                         => 'ff',
    'ga'                            => 'gaa',
    'galisies'                      => 'gl',
    'ganda'                         => 'lg',
    'gayo'                          => 'gay',
    'gbaya'                         => 'gba',
    'gebaretaal'                    => 'sgn',
    'geenlinguistieseinhoud'        => 'zxx',
    'geez'                          => 'gez',
    'georgies'                      => 'ka',
    'germaansetaal'                 => 'gem',
    'gilbertese'                    => 'gil',
    'gondi'                         => 'gon',
    'gorontalo'                     => 'gor',
    'goties'                        => 'got',
    'grebo'                         => 'grb',
    'grieks'                        => 'el',
    'guarani'                       => 'gn',
    'gudjarati'                     => 'gu',
    'gusii'                         => 'guz',
    "gwich\Ê\¼in"                 => 'gwi',
    'haida'                         => 'hai',
    'hausa'                         => 'ha',
    'hawaies'                       => 'haw',
    'haïtiaans'                    => 'ht',
    'hebreeus'                      => 'he',
    'herero'                        => 'hz',
    'hetities'                      => 'hit',
    'hiligaynon'                    => 'hil',
    'himachali'                     => 'him',
    'hindi'                         => 'hi',
    'hirimotu'                      => 'ho',
    'hmong'                         => 'hmn',
    'hongaars'                      => 'hu',
    'hupa'                          => 'hup',
    'iban'                          => 'iba',
    'iberieseportugees'             => 'pt_pt',
    'iberiesespaans'                => 'es_es',
    'ido'                           => 'io',
    'iers'                          => 'ga',
    'igbo'                          => 'ig',
    'ijo'                           => 'ijo',
    'iloko'                         => 'ilo',
    'inarisami'                     => 'smn',
    'indiclanguage'                 => 'inc',
    'indoeuropesetaal'              => 'ine',
    'indonesies'                    => 'id',
    'ingush'                        => 'inh',
    'interlingua'                   => 'ia',
    'interlingue'                   => 'ie',
    'inuktitut'                     => 'iu',
    'inupiaq'                       => 'ik',
    'iranianlanguage'               => 'ira',
    'iroquoianlanguage'             => 'iro',
    'italiaans'                     => 'it',
    'japannees'                     => 'ja',
    'javaans'                       => 'jv',
    'jiddisj'                       => 'yi',
    'jju'                           => 'kaj',
    'jolafonyi'                     => 'dyo',
    'judeoarabic'                   => 'jrb',
    'judeopersian'                  => 'jpr',
    'kabardian'                     => 'kbd',
    'kabuverdianu'                  => 'kea',
    'kabyle'                        => 'kab',
    'kachin'                        => 'kac',
    'kalaallisut'                   => 'kl',
    'kalenjin'                      => 'kln',
    'kalmyk'                        => 'xal',
    'kamba'                         => 'kam',
    'kanadeseengels'                => 'en_ca',
    'kanadesefrans'                 => 'fr_ca',
    'kannada'                       => 'kn',
    'kantonees'                     => 'yue',
    'kanuri'                        => 'kr',
    'karachaybalkar'                => 'krc',
    'karakalpak'                    => 'kaa',
    'karelian'                      => 'krl',
    'karen'                         => 'kar',
    'kashubian'                     => 'csb',
    'kasjmirs'                      => 'ks',
    'katalaans'                     => 'ca',
    'kawi'                          => 'kaw',
    'kazak'                         => 'kk',
    'keltiesetaal'                  => 'cel',
    'kerkslawies'                   => 'cu',
    'khasi'                         => 'kha',
    'khmer'                         => 'km',
    'khoisantaal'                   => 'khi',
    'khotanese'                     => 'kho',
    'kikuyu'                        => 'ki',
    'kimbundu'                      => 'kmb',
    'kirgisies'                     => 'ky',
    'klingon'                       => 'tlh',
    'koerdies'                      => 'ku',
    'komi'                          => 'kv',
    'kongo'                         => 'kg',
    'konkani'                       => 'kok',
    'kopties'                       => 'cop',
    'koreaans'                      => 'ko',
    'kornies'                       => 'kw',
    'koro'                          => 'kfo',
    'kosraean'                      => 'kos',
    'koyraborosenni'                => 'ses',
    'koyrachiini'                   => 'khq',
    'kpelle'                        => 'kpe',
    'kroaties'                      => 'hr',
    'kru'                           => 'kro',
    'kuanyama'                      => 'kj',
    'kumyk'                         => 'kum',
    'kunsmatigetaal'                => 'art',
    'kurukh'                        => 'kru',
    'kutenai'                       => 'kut',
    'kwasio'                        => 'nmg',
    'ladino'                        => 'lad',
    'lahnda'                        => 'lah',
    'lamba'                         => 'lam',
    'langi'                         => 'lag',
    'lao'                           => 'lo',
    'latyn'                         => 'la',
    'letties'                       => 'lv',
    'lezghian'                      => 'lez',
    'limburgs'                      => 'li',
    'lingaals'                      => 'ln',
    'litaus'                        => 'lt',
    'lojban'                        => 'jbo',
    'lowersorbian'                  => 'dsb',
    'lowgerman'                     => 'nds',
    'lozi'                          => 'loz',
    'lubakatanga'                   => 'lu',
    'lubalulua'                     => 'lua',
    'luiseno'                       => 'lui',
    'lulesami'                      => 'smj',
    'lunda'                         => 'lun',
    'luo'                           => 'luo',
    'lushai'                        => 'lus',
    'luxemburgs'                    => 'lb',
    'luyia'                         => 'luy',
    'machame'                       => 'jmc',
    'madurese'                      => 'mad',
    'magahi'                        => 'mag',
    'maithili'                      => 'mai',
    'makasar'                       => 'mak',
    'makhuwameetto'                 => 'mgh',
    'makonde'                       => 'kde',
    'malabaars'                     => 'ml',
    'maleisies'                     => 'ms',
    'malgassies'                    => 'mg',
    'maltees'                       => 'mt',
    'manchu'                        => 'mnc',
    'mandar'                        => 'mdr',
    'mandingo'                      => 'man',
    'manipuri'                      => 'mni',
    'manobolanguage'                => 'mno',
    'manx'                          => 'gv',
    'maori'                         => 'mi',
    'marathi'                       => 'mr',
    'mari'                          => 'chm',
    'marshallese'                   => 'mh',
    'marwari'                       => 'mwr',
    'masai'                         => 'mas',
    'masedonies'                    => 'mk',
    'mayanlanguage'                 => 'myn',
    'mende'                         => 'men',
    'meru'                          => 'mer',
    'micmac'                        => 'mic',
    'middledutch'                   => 'dum',
    'middleenglish'                 => 'enm',
    'middlefrench'                  => 'frm',
    'middlehighgerman'              => 'gmh',
    'middleirish'                   => 'mga',
    'minangkabau'                   => 'min',
    'mirandese'                     => 'mwl',
    'miscellaneouslanguage'         => 'mis',
    'mohawk'                        => 'moh',
    'moksha'                        => 'mdf',
    'moldavian'                     => 'mo',
    'mongo'                         => 'lol',
    'mongools'                      => 'mn',
    'monkhmerlanguage'              => 'mkh',
    'morisyen'                      => 'mfe',
    'mossi'                         => 'mos',
    'mundalanguage'                 => 'mun',
    'mundang'                       => 'mua',
    'nahuatl'                       => 'nah',
    'nama'                          => 'naq',
    'nauru'                         => 'na',
    'navajo'                        => 'nv',
    'ndonga'                        => 'ng',
    'neapolitan'                    => 'nap',
    'nederlands'                    => 'nl',
    'nepalees'                      => 'ne',
    'newari'                        => 'new',
    'nias'                          => 'nia',
    'nigerkordofanianlanguage'      => 'nic',
    'nilosaharanlanguage'           => 'ssa',
    'niuean'                        => 'niu',
    'nogai'                         => 'nog',
    'noordelikesami'                => 'se',
    'noordndebele'                  => 'nd',
    'noordsotho'                    => 'nso',
    'noors'                         => 'no',
    'noorsebokmål'                 => 'nb',
    'noorweegsenynorsk'             => 'nn',
    'northamericanindianlanguage'   => 'nai',
    'northernfrisian'               => 'frr',
    'nubianlanguage'                => 'nub',
    'nuer'                          => 'nus',
    'nyamwezi'                      => 'nym',
    'nyanja'                        => 'ny',
    'nyankole'                      => 'nyn',
    'nyasatonga'                    => 'tog',
    'nyoro'                         => 'nyo',
    'nzima'                         => 'nzi',
    "n\â\\ko"                  => 'nqo',
    'occitaans'                     => 'oc',
    'oekraïens'                    => 'uk',
    'oerdoe'                        => 'ur',
    'oezbeeks'                      => 'uz',
    'ojibwa'                        => 'oj',
    'oldenglish'                    => 'ang',
    'oldfrench'                     => 'fro',
    'oldhighgerman'                 => 'goh',
    'oldirish'                      => 'sga',
    'oldnorse'                      => 'non',
    'oldpersian'                    => 'peo',
    "oldproven\Ã\§al"             => 'pro',
    'onbekendeofongeldigetaal'      => 'und',
    'oostenrykseduits'              => 'de_at',
    'oriya'                         => 'or',
    'oromo'                         => 'om',
    'osage'                         => 'osa',
    'osseties'                      => 'os',
    'otomianlanguage'               => 'oto',
    'ottomanturkish'                => 'ota',
    'pahlavi'                       => 'pal',
    'palauan'                       => 'pau',
    'pali'                          => 'pi',
    'pampanga'                      => 'pam',
    'pandjabi'                      => 'pa',
    'pangasinan'                    => 'pag',
    'papiamento'                    => 'pap',
    'papuanlanguage'                => 'paa',
    'persies'                       => 'fa',
    'philippinelanguage'            => 'phi',
    'pohnpeian'                     => 'pon',
    'pools'                         => 'pl',
    'portugees'                     => 'pt',
    'portuguesebasedcreoleorpidgin' => 'cpp',
    'prakritlanguage'               => 'pra',
    'pushto'                        => 'ps',
    'quechua'                       => 'qu',
    'rajasthani'                    => 'raj',
    'rapanui'                       => 'rap',
    'rarotongan'                    => 'rar',
    'retoromaans'                   => 'rm',
    'roemeens'                      => 'ro',
    'romancelanguage'               => 'roa',
    'romany'                        => 'rom',
    'rombo'                         => 'rof',
    'rundi'                         => 'rn',
    'russies'                       => 'ru',
    'rwa'                           => 'rwk',
    'rwandees'                      => 'rw',
    'saho'                          => 'ssy',
    'sakha'                         => 'sah',
    'salishanlanguage'              => 'sal',
    'samaritanaramaic'              => 'sam',
    'samburu'                       => 'saq',
    'samilanguage'                  => 'smi',
    'samoaans'                      => 'sm',
    'sandawe'                       => 'sad',
    'sango'                         => 'sg',
    'sangu'                         => 'sbp',
    'sanskrit'                      => 'sa',
    'santali'                       => 'sat',
    'sardinian'                     => 'sc',
    'sasak'                         => 'sas',
    'selkup'                        => 'sel',
    'semitiesetaal'                 => 'sem',
    'sena'                          => 'seh',
    'seneca'                        => 'see',
    'serer'                         => 'srr',
    'serwies'                       => 'sr',
    'serwokroaties'                 => 'sh',
    'shambala'                      => 'ksb',
    'shan'                          => 'shn',
    'shimaorees'                    => 'swb',
    'shona'                         => 'sn',
    'sichuanyi'                     => 'ii',
    'sicilian'                      => 'scn',
    'sidamo'                        => 'sid',
    'siksika'                       => 'bla',
    'sindhi'                        => 'sd',
    'sinhala'                       => 'si',
    'sinotibetanlanguage'           => 'sit',
    'siouanlanguage'                => 'sio',
    'sjinees'                       => 'zh',
    'skoltsami'                     => 'sms',
    'skots'                         => 'sco',
    'skotsegallies'                 => 'gd',
    'slave'                         => 'den',
    'slawiesetaal'                  => 'sla',
    'slowaaks'                      => 'sk',
    'sloweens'                      => 'sl',
    'soga'                          => 'xog',
    'sogdien'                       => 'sog',
    'somalies'                      => 'so',
    'songhai'                       => 'son',
    'soninke'                       => 'snk',
    'sorbianlanguage'               => 'wen',
    'southamericanindianlanguage'   => 'sai',
    'southernaltai'                 => 'alt',
    'southernsami'                  => 'sma',
    'spaans'                        => 'es',
    'sranantongo'                   => 'srn',
    'suidndebele'                   => 'nr',
    'suidsotho'                     => 'st',
    'sukuma'                        => 'suk',
    'sumerian'                      => 'sux',
    'sundanees'                     => 'su',
    'susu'                          => 'sus',
    'swahili'                       => 'sw',
    'swazi'                         => 'ss',
    'sweeds'                        => 'sv',
    'switserseduits'                => 'gsw',
    'switsersefrans'                => 'fr_ch',
    'switsersehoogduits'            => 'de_ch',
    'syriac'                        => 'syr',
    'tachelhit'                     => 'shi',
    'tadjik'                        => 'tg',
    'tagalog'                       => 'tl',
    'tahities'                      => 'ty',
    'tailanguage'                   => 'tai',
    'taita'                         => 'dav',
    'tamashek'                      => 'tmh',
    'tamil'                         => 'ta',
    'taroko'                        => 'trv',
    'tasawaq'                       => 'twq',
    'tataars'                       => 'tt',
    'telugu'                        => 'te',
    'tereno'                        => 'ter',
    'teso'                          => 'teo',
    'tetum'                         => 'tet',
    'thais'                         => 'th',
    'tibettaans'                    => 'bo',
    'tigre'                         => 'tig',
    'tigrinya'                      => 'ti',
    'timne'                         => 'tem',
    'tiv'                           => 'tiv',
    'tlingit'                       => 'tli',
    'tokelau'                       => 'tkl',
    'tokpisin'                      => 'tpi',
    'tonga'                         => 'to',
    'tsimshian'                     => 'tsi',
    'tsjeggies'                     => 'cs',
    'tsonga'                        => 'ts',
    'tswana'                        => 'tn',
    'tumbuka'                       => 'tum',
    'tupilanguage'                  => 'tup',
    'turkmeens'                     => 'tk',
    'turks'                         => 'tr',
    'tuvalu'                        => 'tvl',
    'tuvinian'                      => 'tyv',
    'twi'                           => 'tw',
    'tyap'                          => 'kcg',
    'udmurt'                        => 'udm',
    'ugaritic'                      => 'uga',
    'umbundu'                       => 'umb',
    'uppersorbian'                  => 'hsb',
    'uyghur'                        => 'ug',
    'vai'                           => 'vai',
    'veelvuldigetale'               => 'mul',
    'venda'                         => 've',
    'viëtnamees'                   => 'vi',
    'vlaams'                        => 'nl_be',
    "volap\Ã\¼k"                  => 'vo',
    'votic'                         => 'vot',
    'vunjo'                         => 'vun',
    'wakashanlanguage'              => 'wak',
    'walamo'                        => 'wal',
    'wallies'                       => 'cy',
    'walloon'                       => 'wa',
    'walser'                        => 'wae',
    'waray'                         => 'war',
    'washo'                         => 'was',
    'wesfries'                      => 'fy',
    'witrussies'                    => 'be',
    'wolof'                         => 'wo',
    'xhosa'                         => 'xh',
    'yangben'                       => 'yav',
    'yao'                           => 'yao',
    'yapese'                        => 'yap',
    'yoruba'                        => 'yo',
    'yslands'                       => 'is',
    'yupiklanguage'                 => 'ypk',
    'zande'                         => 'znd',
    'zapotec'                       => 'zap',
    'zarma'                         => 'dje',
    'zaza'                          => 'zza',
    'zenaga'                        => 'zen',
    'zhuang'                        => 'za',
    'zoeloe'                        => 'zu',
    'zuni'                          => 'zun',
);

1;
