/*
 * Copyright (c) 2003 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * - Redistribution of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * 
 * - Redistribution in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the distribution.
 * 
 * Neither the name of Sun Microsystems, Inc. or the names of
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * 
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES,
 * INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN
 * MICROSYSTEMS, INC. ("SUN") AND ITS LICENSORS SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR
 * ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR
 * DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE
 * DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY,
 * ARISING OUT OF THE USE OF OR INABILITY TO USE THIS SOFTWARE, EVEN IF
 * SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 * 
 * You acknowledge that this software is not designed or intended for use
 * in the design, construction, operation or maintenance of any nuclear
 * facility.
 * 
 * Sun gratefully acknowledges that this software was originally authored
 * and developed by Kenneth Bradley Russell and Christopher John Kline.
 */

package com.jogamp.opengl.util.gl2;

class GLUTStrokeMonoRoman {

/* GENERATED FILE -- DO NOT MODIFY */

/* char: 33 '!' */

static final CoordRec char33_stroke0[] = {
    new CoordRec((float) 52.381, (float) 100 ),
    new CoordRec((float) 52.381, (float) 33.3333 ),
};

static final CoordRec char33_stroke1[] = {
    new CoordRec((float) 52.381, (float) 9.5238 ),
    new CoordRec((float) 47.6191, (float) 4.7619 ),
    new CoordRec((float) 52.381, (float) 0 ),
    new CoordRec((float) 57.1429, (float) 4.7619 ),
    new CoordRec((float) 52.381, (float) 9.5238 ),
};

static final StrokeRec char33[] = {
   new StrokeRec( 2, char33_stroke0 ),
   new StrokeRec( 5, char33_stroke1 ),
};

/* char: 34 '"' */

static final CoordRec char34_stroke0[] = {
    new CoordRec((float) 33.3334, (float) 100 ),
    new CoordRec((float) 33.3334, (float) 66.6667 ),
};

static final CoordRec char34_stroke1[] = {
    new CoordRec((float) 71.4286, (float) 100 ),
    new CoordRec((float) 71.4286, (float) 66.6667 ),
};

static final StrokeRec char34[] = {
   new StrokeRec( 2, char34_stroke0 ),
   new StrokeRec( 2, char34_stroke1 ),
};

/* char: 35 '#' */

static final CoordRec char35_stroke0[] = {
    new CoordRec((float) 54.7619, (float) 119.048 ),
    new CoordRec((float) 21.4286, (float) -33.3333 ),
};

static final CoordRec char35_stroke1[] = {
    new CoordRec((float) 83.3334, (float) 119.048 ),
    new CoordRec((float) 50, (float) -33.3333 ),
};

static final CoordRec char35_stroke2[] = {
    new CoordRec((float) 21.4286, (float) 57.1429 ),
    new CoordRec((float) 88.0952, (float) 57.1429 ),
};

static final CoordRec char35_stroke3[] = {
    new CoordRec((float) 16.6667, (float) 28.5714 ),
    new CoordRec((float) 83.3334, (float) 28.5714 ),
};

static final StrokeRec char35[] = {
   new StrokeRec( 2, char35_stroke0 ),
   new StrokeRec( 2, char35_stroke1 ),
   new StrokeRec( 2, char35_stroke2 ),
   new StrokeRec( 2, char35_stroke3 ),
};

/* char: 36 '$' */

static final CoordRec char36_stroke0[] = {
    new CoordRec((float) 42.8571, (float) 119.048 ),
    new CoordRec((float) 42.8571, (float) -19.0476 ),
};

static final CoordRec char36_stroke1[] = {
    new CoordRec((float) 61.9047, (float) 119.048 ),
    new CoordRec((float) 61.9047, (float) -19.0476 ),
};

static final CoordRec char36_stroke2[] = {
    new CoordRec((float) 85.7143, (float) 85.7143 ),
    new CoordRec((float) 76.1905, (float) 95.2381 ),
    new CoordRec((float) 61.9047, (float) 100 ),
    new CoordRec((float) 42.8571, (float) 100 ),
    new CoordRec((float) 28.5714, (float) 95.2381 ),
    new CoordRec((float) 19.0476, (float) 85.7143 ),
    new CoordRec((float) 19.0476, (float) 76.1905 ),
    new CoordRec((float) 23.8095, (float) 66.6667 ),
    new CoordRec((float) 28.5714, (float) 61.9048 ),
    new CoordRec((float) 38.0952, (float) 57.1429 ),
    new CoordRec((float) 66.6666, (float) 47.619 ),
    new CoordRec((float) 76.1905, (float) 42.8571 ),
    new CoordRec((float) 80.9524, (float) 38.0952 ),
    new CoordRec((float) 85.7143, (float) 28.5714 ),
    new CoordRec((float) 85.7143, (float) 14.2857 ),
    new CoordRec((float) 76.1905, (float) 4.7619 ),
    new CoordRec((float) 61.9047, (float) 0 ),
    new CoordRec((float) 42.8571, (float) 0 ),
    new CoordRec((float) 28.5714, (float) 4.7619 ),
    new CoordRec((float) 19.0476, (float) 14.2857 ),
};

static final StrokeRec char36[] = {
   new StrokeRec( 2, char36_stroke0 ),
   new StrokeRec( 2, char36_stroke1 ),
   new StrokeRec( 20, char36_stroke2 ),
};

/* char: 37 '%' */

static final CoordRec char37_stroke0[] = {
    new CoordRec((float) 95.2381, (float) 100 ),
    new CoordRec((float) 9.5238, (float) 0 ),
};

static final CoordRec char37_stroke1[] = {
    new CoordRec((float) 33.3333, (float) 100 ),
    new CoordRec((float) 42.8571, (float) 90.4762 ),
    new CoordRec((float) 42.8571, (float) 80.9524 ),
    new CoordRec((float) 38.0952, (float) 71.4286 ),
    new CoordRec((float) 28.5714, (float) 66.6667 ),
    new CoordRec((float) 19.0476, (float) 66.6667 ),
    new CoordRec((float) 9.5238, (float) 76.1905 ),
    new CoordRec((float) 9.5238, (float) 85.7143 ),
    new CoordRec((float) 14.2857, (float) 95.2381 ),
    new CoordRec((float) 23.8095, (float) 100 ),
    new CoordRec((float) 33.3333, (float) 100 ),
    new CoordRec((float) 42.8571, (float) 95.2381 ),
    new CoordRec((float) 57.1428, (float) 90.4762 ),
    new CoordRec((float) 71.4286, (float) 90.4762 ),
    new CoordRec((float) 85.7143, (float) 95.2381 ),
    new CoordRec((float) 95.2381, (float) 100 ),
};

static final CoordRec char37_stroke2[] = {
    new CoordRec((float) 76.1905, (float) 33.3333 ),
    new CoordRec((float) 66.6667, (float) 28.5714 ),
    new CoordRec((float) 61.9048, (float) 19.0476 ),
    new CoordRec((float) 61.9048, (float) 9.5238 ),
    new CoordRec((float) 71.4286, (float) 0 ),
    new CoordRec((float) 80.9524, (float) 0 ),
    new CoordRec((float) 90.4762, (float) 4.7619 ),
    new CoordRec((float) 95.2381, (float) 14.2857 ),
    new CoordRec((float) 95.2381, (float) 23.8095 ),
    new CoordRec((float) 85.7143, (float) 33.3333 ),
    new CoordRec((float) 76.1905, (float) 33.3333 ),
};

static final StrokeRec char37[] = {
   new StrokeRec( 2, char37_stroke0 ),
   new StrokeRec( 16, char37_stroke1 ),
   new StrokeRec( 11, char37_stroke2 ),
};

/* char: 38 '&' */

static final CoordRec char38_stroke0[] = {
    new CoordRec((float) 100, (float) 57.1429 ),
    new CoordRec((float) 100, (float) 61.9048 ),
    new CoordRec((float) 95.2381, (float) 66.6667 ),
    new CoordRec((float) 90.4762, (float) 66.6667 ),
    new CoordRec((float) 85.7143, (float) 61.9048 ),
    new CoordRec((float) 80.9524, (float) 52.381 ),
    new CoordRec((float) 71.4286, (float) 28.5714 ),
    new CoordRec((float) 61.9048, (float) 14.2857 ),
    new CoordRec((float) 52.3809, (float) 4.7619 ),
    new CoordRec((float) 42.8571, (float) 0 ),
    new CoordRec((float) 23.8095, (float) 0 ),
    new CoordRec((float) 14.2857, (float) 4.7619 ),
    new CoordRec((float) 9.5238, (float) 9.5238 ),
    new CoordRec((float) 4.7619, (float) 19.0476 ),
    new CoordRec((float) 4.7619, (float) 28.5714 ),
    new CoordRec((float) 9.5238, (float) 38.0952 ),
    new CoordRec((float) 14.2857, (float) 42.8571 ),
    new CoordRec((float) 47.619, (float) 61.9048 ),
    new CoordRec((float) 52.3809, (float) 66.6667 ),
    new CoordRec((float) 57.1429, (float) 76.1905 ),
    new CoordRec((float) 57.1429, (float) 85.7143 ),
    new CoordRec((float) 52.3809, (float) 95.2381 ),
    new CoordRec((float) 42.8571, (float) 100 ),
    new CoordRec((float) 33.3333, (float) 95.2381 ),
    new CoordRec((float) 28.5714, (float) 85.7143 ),
    new CoordRec((float) 28.5714, (float) 76.1905 ),
    new CoordRec((float) 33.3333, (float) 61.9048 ),
    new CoordRec((float) 42.8571, (float) 47.619 ),
    new CoordRec((float) 66.6667, (float) 14.2857 ),
    new CoordRec((float) 76.1905, (float) 4.7619 ),
    new CoordRec((float) 85.7143, (float) 0 ),
    new CoordRec((float) 95.2381, (float) 0 ),
    new CoordRec((float) 100, (float) 4.7619 ),
    new CoordRec((float) 100, (float) 9.5238 ),
};

static final StrokeRec char38[] = {
   new StrokeRec( 34, char38_stroke0 ),
};

/* char: 39 ''' */

static final CoordRec char39_stroke0[] = {
    new CoordRec((float) 52.381, (float) 100 ),
    new CoordRec((float) 52.381, (float) 66.6667 ),
};

static final StrokeRec char39[] = {
   new StrokeRec( 2, char39_stroke0 ),
};

/* char: 40 '(' */

static final CoordRec char40_stroke0[] = {
    new CoordRec((float) 69.0476, (float) 119.048 ),
    new CoordRec((float) 59.5238, (float) 109.524 ),
    new CoordRec((float) 50, (float) 95.2381 ),
    new CoordRec((float) 40.4762, (float) 76.1905 ),
    new CoordRec((float) 35.7143, (float) 52.381 ),
    new CoordRec((float) 35.7143, (float) 33.3333 ),
    new CoordRec((float) 40.4762, (float) 9.5238 ),
    new CoordRec((float) 50, (float) -9.5238 ),
    new CoordRec((float) 59.5238, (float) -23.8095 ),
    new CoordRec((float) 69.0476, (float) -33.3333 ),
};

static final StrokeRec char40[] = {
   new StrokeRec( 10, char40_stroke0 ),
};

/* char: 41 ')' */

static final CoordRec char41_stroke0[] = {
    new CoordRec((float) 35.7143, (float) 119.048 ),
    new CoordRec((float) 45.2381, (float) 109.524 ),
    new CoordRec((float) 54.7619, (float) 95.2381 ),
    new CoordRec((float) 64.2857, (float) 76.1905 ),
    new CoordRec((float) 69.0476, (float) 52.381 ),
    new CoordRec((float) 69.0476, (float) 33.3333 ),
    new CoordRec((float) 64.2857, (float) 9.5238 ),
    new CoordRec((float) 54.7619, (float) -9.5238 ),
    new CoordRec((float) 45.2381, (float) -23.8095 ),
    new CoordRec((float) 35.7143, (float) -33.3333 ),
};

static final StrokeRec char41[] = {
   new StrokeRec( 10, char41_stroke0 ),
};

/* char: 42 '*' */

static final CoordRec char42_stroke0[] = {
    new CoordRec((float) 52.381, (float) 71.4286 ),
    new CoordRec((float) 52.381, (float) 14.2857 ),
};

static final CoordRec char42_stroke1[] = {
    new CoordRec((float) 28.5715, (float) 57.1429 ),
    new CoordRec((float) 76.1905, (float) 28.5714 ),
};

static final CoordRec char42_stroke2[] = {
    new CoordRec((float) 76.1905, (float) 57.1429 ),
    new CoordRec((float) 28.5715, (float) 28.5714 ),
};

static final StrokeRec char42[] = {
   new StrokeRec( 2, char42_stroke0 ),
   new StrokeRec( 2, char42_stroke1 ),
   new StrokeRec( 2, char42_stroke2 ),
};

/* char: 43 '+' */

static final CoordRec char43_stroke0[] = {
    new CoordRec((float) 52.3809, (float) 85.7143 ),
    new CoordRec((float) 52.3809, (float) 0 ),
};

static final CoordRec char43_stroke1[] = {
    new CoordRec((float) 9.5238, (float) 42.8571 ),
    new CoordRec((float) 95.2381, (float) 42.8571 ),
};

static final StrokeRec char43[] = {
   new StrokeRec( 2, char43_stroke0 ),
   new StrokeRec( 2, char43_stroke1 ),
};

/* char: 44 ',' */

static final CoordRec char44_stroke0[] = {
    new CoordRec((float) 57.1429, (float) 4.7619 ),
    new CoordRec((float) 52.381, (float) 0 ),
    new CoordRec((float) 47.6191, (float) 4.7619 ),
    new CoordRec((float) 52.381, (float) 9.5238 ),
    new CoordRec((float) 57.1429, (float) 4.7619 ),
    new CoordRec((float) 57.1429, (float) -4.7619 ),
    new CoordRec((float) 52.381, (float) -14.2857 ),
    new CoordRec((float) 47.6191, (float) -19.0476 ),
};

static final StrokeRec char44[] = {
   new StrokeRec( 8, char44_stroke0 ),
};

/* char: 45 '-' */

static final CoordRec char45_stroke0[] = {
    new CoordRec((float) 9.5238, (float) 42.8571 ),
    new CoordRec((float) 95.2381, (float) 42.8571 ),
};

static final StrokeRec char45[] = {
   new StrokeRec( 2, char45_stroke0 ),
};

/* char: 46 '.' */

static final CoordRec char46_stroke0[] = {
    new CoordRec((float) 52.381, (float) 9.5238 ),
    new CoordRec((float) 47.6191, (float) 4.7619 ),
    new CoordRec((float) 52.381, (float) 0 ),
    new CoordRec((float) 57.1429, (float) 4.7619 ),
    new CoordRec((float) 52.381, (float) 9.5238 ),
};

static final StrokeRec char46[] = {
   new StrokeRec( 5, char46_stroke0 ),
};

/* char: 47 '/' */

static final CoordRec char47_stroke0[] = {
    new CoordRec((float) 19.0476, (float) -14.2857 ),
    new CoordRec((float) 85.7143, (float) 100 ),
};

static final StrokeRec char47[] = {
   new StrokeRec( 2, char47_stroke0 ),
};

/* char: 48 '0' */

static final CoordRec char48_stroke0[] = {
    new CoordRec((float) 47.619, (float) 100 ),
    new CoordRec((float) 33.3333, (float) 95.2381 ),
    new CoordRec((float) 23.8095, (float) 80.9524 ),
    new CoordRec((float) 19.0476, (float) 57.1429 ),
    new CoordRec((float) 19.0476, (float) 42.8571 ),
    new CoordRec((float) 23.8095, (float) 19.0476 ),
    new CoordRec((float) 33.3333, (float) 4.7619 ),
    new CoordRec((float) 47.619, (float) 0 ),
    new CoordRec((float) 57.1428, (float) 0 ),
    new CoordRec((float) 71.4286, (float) 4.7619 ),
    new CoordRec((float) 80.9524, (float) 19.0476 ),
    new CoordRec((float) 85.7143, (float) 42.8571 ),
    new CoordRec((float) 85.7143, (float) 57.1429 ),
    new CoordRec((float) 80.9524, (float) 80.9524 ),
    new CoordRec((float) 71.4286, (float) 95.2381 ),
    new CoordRec((float) 57.1428, (float) 100 ),
    new CoordRec((float) 47.619, (float) 100 ),
};

static final StrokeRec char48[] = {
   new StrokeRec( 17, char48_stroke0 ),
};

/* char: 49 '1' */

static final CoordRec char49_stroke0[] = {
    new CoordRec((float) 40.4762, (float) 80.9524 ),
    new CoordRec((float) 50, (float) 85.7143 ),
    new CoordRec((float) 64.2857, (float) 100 ),
    new CoordRec((float) 64.2857, (float) 0 ),
};

static final StrokeRec char49[] = {
   new StrokeRec( 4, char49_stroke0 ),
};

/* char: 50 '2' */

static final CoordRec char50_stroke0[] = {
    new CoordRec((float) 23.8095, (float) 76.1905 ),
    new CoordRec((float) 23.8095, (float) 80.9524 ),
    new CoordRec((float) 28.5714, (float) 90.4762 ),
    new CoordRec((float) 33.3333, (float) 95.2381 ),
    new CoordRec((float) 42.8571, (float) 100 ),
    new CoordRec((float) 61.9047, (float) 100 ),
    new CoordRec((float) 71.4286, (float) 95.2381 ),
    new CoordRec((float) 76.1905, (float) 90.4762 ),
    new CoordRec((float) 80.9524, (float) 80.9524 ),
    new CoordRec((float) 80.9524, (float) 71.4286 ),
    new CoordRec((float) 76.1905, (float) 61.9048 ),
    new CoordRec((float) 66.6666, (float) 47.619 ),
    new CoordRec((float) 19.0476, (float) 0 ),
    new CoordRec((float) 85.7143, (float) 0 ),
};

static final StrokeRec char50[] = {
   new StrokeRec( 14, char50_stroke0 ),
};

/* char: 51 '3' */

static final CoordRec char51_stroke0[] = {
    new CoordRec((float) 28.5714, (float) 100 ),
    new CoordRec((float) 80.9524, (float) 100 ),
    new CoordRec((float) 52.3809, (float) 61.9048 ),
    new CoordRec((float) 66.6666, (float) 61.9048 ),
    new CoordRec((float) 76.1905, (float) 57.1429 ),
    new CoordRec((float) 80.9524, (float) 52.381 ),
    new CoordRec((float) 85.7143, (float) 38.0952 ),
    new CoordRec((float) 85.7143, (float) 28.5714 ),
    new CoordRec((float) 80.9524, (float) 14.2857 ),
    new CoordRec((float) 71.4286, (float) 4.7619 ),
    new CoordRec((float) 57.1428, (float) 0 ),
    new CoordRec((float) 42.8571, (float) 0 ),
    new CoordRec((float) 28.5714, (float) 4.7619 ),
    new CoordRec((float) 23.8095, (float) 9.5238 ),
    new CoordRec((float) 19.0476, (float) 19.0476 ),
};

static final StrokeRec char51[] = {
   new StrokeRec( 15, char51_stroke0 ),
};

/* char: 52 '4' */

static final CoordRec char52_stroke0[] = {
    new CoordRec((float) 64.2857, (float) 100 ),
    new CoordRec((float) 16.6667, (float) 33.3333 ),
    new CoordRec((float) 88.0952, (float) 33.3333 ),
};

static final CoordRec char52_stroke1[] = {
    new CoordRec((float) 64.2857, (float) 100 ),
    new CoordRec((float) 64.2857, (float) 0 ),
};

static final StrokeRec char52[] = {
   new StrokeRec( 3, char52_stroke0 ),
   new StrokeRec( 2, char52_stroke1 ),
};

/* char: 53 '5' */

static final CoordRec char53_stroke0[] = {
    new CoordRec((float) 76.1905, (float) 100 ),
    new CoordRec((float) 28.5714, (float) 100 ),
    new CoordRec((float) 23.8095, (float) 57.1429 ),
    new CoordRec((float) 28.5714, (float) 61.9048 ),
    new CoordRec((float) 42.8571, (float) 66.6667 ),
    new CoordRec((float) 57.1428, (float) 66.6667 ),
    new CoordRec((float) 71.4286, (float) 61.9048 ),
    new CoordRec((float) 80.9524, (float) 52.381 ),
    new CoordRec((float) 85.7143, (float) 38.0952 ),
    new CoordRec((float) 85.7143, (float) 28.5714 ),
    new CoordRec((float) 80.9524, (float) 14.2857 ),
    new CoordRec((float) 71.4286, (float) 4.7619 ),
    new CoordRec((float) 57.1428, (float) 0 ),
    new CoordRec((float) 42.8571, (float) 0 ),
    new CoordRec((float) 28.5714, (float) 4.7619 ),
    new CoordRec((float) 23.8095, (float) 9.5238 ),
    new CoordRec((float) 19.0476, (float) 19.0476 ),
};

static final StrokeRec char53[] = {
   new StrokeRec( 17, char53_stroke0 ),
};

/* char: 54 '6' */

static final CoordRec char54_stroke0[] = {
    new CoordRec((float) 78.5714, (float) 85.7143 ),
    new CoordRec((float) 73.8096, (float) 95.2381 ),
    new CoordRec((float) 59.5238, (float) 100 ),
    new CoordRec((float) 50, (float) 100 ),
    new CoordRec((float) 35.7143, (float) 95.2381 ),
    new CoordRec((float) 26.1905, (float) 80.9524 ),
    new CoordRec((float) 21.4286, (float) 57.1429 ),
    new CoordRec((float) 21.4286, (float) 33.3333 ),
    new CoordRec((float) 26.1905, (float) 14.2857 ),
    new CoordRec((float) 35.7143, (float) 4.7619 ),
    new CoordRec((float) 50, (float) 0 ),
    new CoordRec((float) 54.7619, (float) 0 ),
    new CoordRec((float) 69.0476, (float) 4.7619 ),
    new CoordRec((float) 78.5714, (float) 14.2857 ),
    new CoordRec((float) 83.3334, (float) 28.5714 ),
    new CoordRec((float) 83.3334, (float) 33.3333 ),
    new CoordRec((float) 78.5714, (float) 47.619 ),
    new CoordRec((float) 69.0476, (float) 57.1429 ),
    new CoordRec((float) 54.7619, (float) 61.9048 ),
    new CoordRec((float) 50, (float) 61.9048 ),
    new CoordRec((float) 35.7143, (float) 57.1429 ),
    new CoordRec((float) 26.1905, (float) 47.619 ),
    new CoordRec((float) 21.4286, (float) 33.3333 ),
};

static final StrokeRec char54[] = {
   new StrokeRec( 23, char54_stroke0 ),
};

/* char: 55 '7' */

static final CoordRec char55_stroke0[] = {
    new CoordRec((float) 85.7143, (float) 100 ),
    new CoordRec((float) 38.0952, (float) 0 ),
};

static final CoordRec char55_stroke1[] = {
    new CoordRec((float) 19.0476, (float) 100 ),
    new CoordRec((float) 85.7143, (float) 100 ),
};

static final StrokeRec char55[] = {
   new StrokeRec( 2, char55_stroke0 ),
   new StrokeRec( 2, char55_stroke1 ),
};

/* char: 56 '8' */

static final CoordRec char56_stroke0[] = {
    new CoordRec((float) 42.8571, (float) 100 ),
    new CoordRec((float) 28.5714, (float) 95.2381 ),
    new CoordRec((float) 23.8095, (float) 85.7143 ),
    new CoordRec((float) 23.8095, (float) 76.1905 ),
    new CoordRec((float) 28.5714, (float) 66.6667 ),
    new CoordRec((float) 38.0952, (float) 61.9048 ),
    new CoordRec((float) 57.1428, (float) 57.1429 ),
    new CoordRec((float) 71.4286, (float) 52.381 ),
    new CoordRec((float) 80.9524, (float) 42.8571 ),
    new CoordRec((float) 85.7143, (float) 33.3333 ),
    new CoordRec((float) 85.7143, (float) 19.0476 ),
    new CoordRec((float) 80.9524, (float) 9.5238 ),
    new CoordRec((float) 76.1905, (float) 4.7619 ),
    new CoordRec((float) 61.9047, (float) 0 ),
    new CoordRec((float) 42.8571, (float) 0 ),
    new CoordRec((float) 28.5714, (float) 4.7619 ),
    new CoordRec((float) 23.8095, (float) 9.5238 ),
    new CoordRec((float) 19.0476, (float) 19.0476 ),
    new CoordRec((float) 19.0476, (float) 33.3333 ),
    new CoordRec((float) 23.8095, (float) 42.8571 ),
    new CoordRec((float) 33.3333, (float) 52.381 ),
    new CoordRec((float) 47.619, (float) 57.1429 ),
    new CoordRec((float) 66.6666, (float) 61.9048 ),
    new CoordRec((float) 76.1905, (float) 66.6667 ),
    new CoordRec((float) 80.9524, (float) 76.1905 ),
    new CoordRec((float) 80.9524, (float) 85.7143 ),
    new CoordRec((float) 76.1905, (float) 95.2381 ),
    new CoordRec((float) 61.9047, (float) 100 ),
    new CoordRec((float) 42.8571, (float) 100 ),
};

static final StrokeRec char56[] = {
   new StrokeRec( 29, char56_stroke0 ),
};

/* char: 57 '9' */

static final CoordRec char57_stroke0[] = {
    new CoordRec((float) 83.3334, (float) 66.6667 ),
    new CoordRec((float) 78.5714, (float) 52.381 ),
    new CoordRec((float) 69.0476, (float) 42.8571 ),
    new CoordRec((float) 54.7619, (float) 38.0952 ),
    new CoordRec((float) 50, (float) 38.0952 ),
    new CoordRec((float) 35.7143, (float) 42.8571 ),
    new CoordRec((float) 26.1905, (float) 52.381 ),
    new CoordRec((float) 21.4286, (float) 66.6667 ),
    new CoordRec((float) 21.4286, (float) 71.4286 ),
    new CoordRec((float) 26.1905, (float) 85.7143 ),
    new CoordRec((float) 35.7143, (float) 95.2381 ),
    new CoordRec((float) 50, (float) 100 ),
    new CoordRec((float) 54.7619, (float) 100 ),
    new CoordRec((float) 69.0476, (float) 95.2381 ),
    new CoordRec((float) 78.5714, (float) 85.7143 ),
    new CoordRec((float) 83.3334, (float) 66.6667 ),
    new CoordRec((float) 83.3334, (float) 42.8571 ),
    new CoordRec((float) 78.5714, (float) 19.0476 ),
    new CoordRec((float) 69.0476, (float) 4.7619 ),
    new CoordRec((float) 54.7619, (float) 0 ),
    new CoordRec((float) 45.2381, (float) 0 ),
    new CoordRec((float) 30.9524, (float) 4.7619 ),
    new CoordRec((float) 26.1905, (float) 14.2857 ),
};

static final StrokeRec char57[] = {
   new StrokeRec( 23, char57_stroke0 ),
};

/* char: 58 ':' */

static final CoordRec char58_stroke0[] = {
    new CoordRec((float) 52.381, (float) 66.6667 ),
    new CoordRec((float) 47.6191, (float) 61.9048 ),
    new CoordRec((float) 52.381, (float) 57.1429 ),
    new CoordRec((float) 57.1429, (float) 61.9048 ),
    new CoordRec((float) 52.381, (float) 66.6667 ),
};

static final CoordRec char58_stroke1[] = {
    new CoordRec((float) 52.381, (float) 9.5238 ),
    new CoordRec((float) 47.6191, (float) 4.7619 ),
    new CoordRec((float) 52.381, (float) 0 ),
    new CoordRec((float) 57.1429, (float) 4.7619 ),
    new CoordRec((float) 52.381, (float) 9.5238 ),
};

static final StrokeRec char58[] = {
   new StrokeRec( 5, char58_stroke0 ),
   new StrokeRec( 5, char58_stroke1 ),
};

/* char: 59 ';' */

static final CoordRec char59_stroke0[] = {
    new CoordRec((float) 52.381, (float) 66.6667 ),
    new CoordRec((float) 47.6191, (float) 61.9048 ),
    new CoordRec((float) 52.381, (float) 57.1429 ),
    new CoordRec((float) 57.1429, (float) 61.9048 ),
    new CoordRec((float) 52.381, (float) 66.6667 ),
};

static final CoordRec char59_stroke1[] = {
    new CoordRec((float) 57.1429, (float) 4.7619 ),
    new CoordRec((float) 52.381, (float) 0 ),
    new CoordRec((float) 47.6191, (float) 4.7619 ),
    new CoordRec((float) 52.381, (float) 9.5238 ),
    new CoordRec((float) 57.1429, (float) 4.7619 ),
    new CoordRec((float) 57.1429, (float) -4.7619 ),
    new CoordRec((float) 52.381, (float) -14.2857 ),
    new CoordRec((float) 47.6191, (float) -19.0476 ),
};

static final StrokeRec char59[] = {
   new StrokeRec( 5, char59_stroke0 ),
   new StrokeRec( 8, char59_stroke1 ),
};

/* char: 60 '<' */

static final CoordRec char60_stroke0[] = {
    new CoordRec((float) 90.4762, (float) 85.7143 ),
    new CoordRec((float) 14.2857, (float) 42.8571 ),
    new CoordRec((float) 90.4762, (float) 0 ),
};

static final StrokeRec char60[] = {
   new StrokeRec( 3, char60_stroke0 ),
};

/* char: 61 '=' */

static final CoordRec char61_stroke0[] = {
    new CoordRec((float) 9.5238, (float) 57.1429 ),
    new CoordRec((float) 95.2381, (float) 57.1429 ),
};

static final CoordRec char61_stroke1[] = {
    new CoordRec((float) 9.5238, (float) 28.5714 ),
    new CoordRec((float) 95.2381, (float) 28.5714 ),
};

static final StrokeRec char61[] = {
   new StrokeRec( 2, char61_stroke0 ),
   new StrokeRec( 2, char61_stroke1 ),
};

/* char: 62 '>' */

static final CoordRec char62_stroke0[] = {
    new CoordRec((float) 14.2857, (float) 85.7143 ),
    new CoordRec((float) 90.4762, (float) 42.8571 ),
    new CoordRec((float) 14.2857, (float) 0 ),
};

static final StrokeRec char62[] = {
   new StrokeRec( 3, char62_stroke0 ),
};

/* char: 63 '?' */

static final CoordRec char63_stroke0[] = {
    new CoordRec((float) 23.8095, (float) 76.1905 ),
    new CoordRec((float) 23.8095, (float) 80.9524 ),
    new CoordRec((float) 28.5714, (float) 90.4762 ),
    new CoordRec((float) 33.3333, (float) 95.2381 ),
    new CoordRec((float) 42.8571, (float) 100 ),
    new CoordRec((float) 61.9047, (float) 100 ),
    new CoordRec((float) 71.4285, (float) 95.2381 ),
    new CoordRec((float) 76.1905, (float) 90.4762 ),
    new CoordRec((float) 80.9524, (float) 80.9524 ),
    new CoordRec((float) 80.9524, (float) 71.4286 ),
    new CoordRec((float) 76.1905, (float) 61.9048 ),
    new CoordRec((float) 71.4285, (float) 57.1429 ),
    new CoordRec((float) 52.3809, (float) 47.619 ),
    new CoordRec((float) 52.3809, (float) 33.3333 ),
};

static final CoordRec char63_stroke1[] = {
    new CoordRec((float) 52.3809, (float) 9.5238 ),
    new CoordRec((float) 47.619, (float) 4.7619 ),
    new CoordRec((float) 52.3809, (float) 0 ),
    new CoordRec((float) 57.1428, (float) 4.7619 ),
    new CoordRec((float) 52.3809, (float) 9.5238 ),
};

static final StrokeRec char63[] = {
   new StrokeRec( 14, char63_stroke0 ),
   new StrokeRec( 5, char63_stroke1 ),
};

/* char: 64 '@' */

static final CoordRec char64_stroke0[] = {
    new CoordRec((float) 64.2857, (float) 52.381 ),
    new CoordRec((float) 54.7619, (float) 57.1429 ),
    new CoordRec((float) 45.2381, (float) 57.1429 ),
    new CoordRec((float) 40.4762, (float) 47.619 ),
    new CoordRec((float) 40.4762, (float) 42.8571 ),
    new CoordRec((float) 45.2381, (float) 33.3333 ),
    new CoordRec((float) 54.7619, (float) 33.3333 ),
    new CoordRec((float) 64.2857, (float) 38.0952 ),
};

static final CoordRec char64_stroke1[] = {
    new CoordRec((float) 64.2857, (float) 57.1429 ),
    new CoordRec((float) 64.2857, (float) 38.0952 ),
    new CoordRec((float) 69.0476, (float) 33.3333 ),
    new CoordRec((float) 78.5714, (float) 33.3333 ),
    new CoordRec((float) 83.3334, (float) 42.8571 ),
    new CoordRec((float) 83.3334, (float) 47.619 ),
    new CoordRec((float) 78.5714, (float) 61.9048 ),
    new CoordRec((float) 69.0476, (float) 71.4286 ),
    new CoordRec((float) 54.7619, (float) 76.1905 ),
    new CoordRec((float) 50, (float) 76.1905 ),
    new CoordRec((float) 35.7143, (float) 71.4286 ),
    new CoordRec((float) 26.1905, (float) 61.9048 ),
    new CoordRec((float) 21.4286, (float) 47.619 ),
    new CoordRec((float) 21.4286, (float) 42.8571 ),
    new CoordRec((float) 26.1905, (float) 28.5714 ),
    new CoordRec((float) 35.7143, (float) 19.0476 ),
    new CoordRec((float) 50, (float) 14.2857 ),
    new CoordRec((float) 54.7619, (float) 14.2857 ),
    new CoordRec((float) 69.0476, (float) 19.0476 ),
};

static final StrokeRec char64[] = {
   new StrokeRec( 8, char64_stroke0 ),
   new StrokeRec( 19, char64_stroke1 ),
};

/* char: 65 'A' */

static final CoordRec char65_stroke0[] = {
    new CoordRec((float) 52.3809, (float) 100 ),
    new CoordRec((float) 14.2857, (float) 0 ),
};

static final CoordRec char65_stroke1[] = {
    new CoordRec((float) 52.3809, (float) 100 ),
    new CoordRec((float) 90.4762, (float) 0 ),
};

static final CoordRec char65_stroke2[] = {
    new CoordRec((float) 28.5714, (float) 33.3333 ),
    new CoordRec((float) 76.1905, (float) 33.3333 ),
};

static final StrokeRec char65[] = {
   new StrokeRec( 2, char65_stroke0 ),
   new StrokeRec( 2, char65_stroke1 ),
   new StrokeRec( 2, char65_stroke2 ),
};

/* char: 66 'B' */

static final CoordRec char66_stroke0[] = {
    new CoordRec((float) 19.0476, (float) 100 ),
    new CoordRec((float) 19.0476, (float) 0 ),
};

static final CoordRec char66_stroke1[] = {
    new CoordRec((float) 19.0476, (float) 100 ),
    new CoordRec((float) 61.9047, (float) 100 ),
    new CoordRec((float) 76.1905, (float) 95.2381 ),
    new CoordRec((float) 80.9524, (float) 90.4762 ),
    new CoordRec((float) 85.7143, (float) 80.9524 ),
    new CoordRec((float) 85.7143, (float) 71.4286 ),
    new CoordRec((float) 80.9524, (float) 61.9048 ),
    new CoordRec((float) 76.1905, (float) 57.1429 ),
    new CoordRec((float) 61.9047, (float) 52.381 ),
};

static final CoordRec char66_stroke2[] = {
    new CoordRec((float) 19.0476, (float) 52.381 ),
    new CoordRec((float) 61.9047, (float) 52.381 ),
    new CoordRec((float) 76.1905, (float) 47.619 ),
    new CoordRec((float) 80.9524, (float) 42.8571 ),
    new CoordRec((float) 85.7143, (float) 33.3333 ),
    new CoordRec((float) 85.7143, (float) 19.0476 ),
    new CoordRec((float) 80.9524, (float) 9.5238 ),
    new CoordRec((float) 76.1905, (float) 4.7619 ),
    new CoordRec((float) 61.9047, (float) 0 ),
    new CoordRec((float) 19.0476, (float) 0 ),
};

static final StrokeRec char66[] = {
   new StrokeRec( 2, char66_stroke0 ),
   new StrokeRec( 9, char66_stroke1 ),
   new StrokeRec( 10, char66_stroke2 ),
};

/* char: 67 'C' */

static final CoordRec char67_stroke0[] = {
    new CoordRec((float) 88.0952, (float) 76.1905 ),
    new CoordRec((float) 83.3334, (float) 85.7143 ),
    new CoordRec((float) 73.8096, (float) 95.2381 ),
    new CoordRec((float) 64.2857, (float) 100 ),
    new CoordRec((float) 45.2381, (float) 100 ),
    new CoordRec((float) 35.7143, (float) 95.2381 ),
    new CoordRec((float) 26.1905, (float) 85.7143 ),
    new CoordRec((float) 21.4286, (float) 76.1905 ),
    new CoordRec((float) 16.6667, (float) 61.9048 ),
    new CoordRec((float) 16.6667, (float) 38.0952 ),
    new CoordRec((float) 21.4286, (float) 23.8095 ),
    new CoordRec((float) 26.1905, (float) 14.2857 ),
    new CoordRec((float) 35.7143, (float) 4.7619 ),
    new CoordRec((float) 45.2381, (float) 0 ),
    new CoordRec((float) 64.2857, (float) 0 ),
    new CoordRec((float) 73.8096, (float) 4.7619 ),
    new CoordRec((float) 83.3334, (float) 14.2857 ),
    new CoordRec((float) 88.0952, (float) 23.8095 ),
};

static final StrokeRec char67[] = {
   new StrokeRec( 18, char67_stroke0 ),
};

/* char: 68 'D' */

static final CoordRec char68_stroke0[] = {
    new CoordRec((float) 19.0476, (float) 100 ),
    new CoordRec((float) 19.0476, (float) 0 ),
};

static final CoordRec char68_stroke1[] = {
    new CoordRec((float) 19.0476, (float) 100 ),
    new CoordRec((float) 52.3809, (float) 100 ),
    new CoordRec((float) 66.6666, (float) 95.2381 ),
    new CoordRec((float) 76.1905, (float) 85.7143 ),
    new CoordRec((float) 80.9524, (float) 76.1905 ),
    new CoordRec((float) 85.7143, (float) 61.9048 ),
    new CoordRec((float) 85.7143, (float) 38.0952 ),
    new CoordRec((float) 80.9524, (float) 23.8095 ),
    new CoordRec((float) 76.1905, (float) 14.2857 ),
    new CoordRec((float) 66.6666, (float) 4.7619 ),
    new CoordRec((float) 52.3809, (float) 0 ),
    new CoordRec((float) 19.0476, (float) 0 ),
};

static final StrokeRec char68[] = {
   new StrokeRec( 2, char68_stroke0 ),
   new StrokeRec( 12, char68_stroke1 ),
};

/* char: 69 'E' */

static final CoordRec char69_stroke0[] = {
    new CoordRec((float) 21.4286, (float) 100 ),
    new CoordRec((float) 21.4286, (float) 0 ),
};

static final CoordRec char69_stroke1[] = {
    new CoordRec((float) 21.4286, (float) 100 ),
    new CoordRec((float) 83.3334, (float) 100 ),
};

static final CoordRec char69_stroke2[] = {
    new CoordRec((float) 21.4286, (float) 52.381 ),
    new CoordRec((float) 59.5238, (float) 52.381 ),
};

static final CoordRec char69_stroke3[] = {
    new CoordRec((float) 21.4286, (float) 0 ),
    new CoordRec((float) 83.3334, (float) 0 ),
};

static final StrokeRec char69[] = {
   new StrokeRec( 2, char69_stroke0 ),
   new StrokeRec( 2, char69_stroke1 ),
   new StrokeRec( 2, char69_stroke2 ),
   new StrokeRec( 2, char69_stroke3 ),
};

/* char: 70 'F' */

static final CoordRec char70_stroke0[] = {
    new CoordRec((float) 21.4286, (float) 100 ),
    new CoordRec((float) 21.4286, (float) 0 ),
};

static final CoordRec char70_stroke1[] = {
    new CoordRec((float) 21.4286, (float) 100 ),
    new CoordRec((float) 83.3334, (float) 100 ),
};

static final CoordRec char70_stroke2[] = {
    new CoordRec((float) 21.4286, (float) 52.381 ),
    new CoordRec((float) 59.5238, (float) 52.381 ),
};

static final StrokeRec char70[] = {
   new StrokeRec( 2, char70_stroke0 ),
   new StrokeRec( 2, char70_stroke1 ),
   new StrokeRec( 2, char70_stroke2 ),
};

/* char: 71 'G' */

static final CoordRec char71_stroke0[] = {
    new CoordRec((float) 88.0952, (float) 76.1905 ),
    new CoordRec((float) 83.3334, (float) 85.7143 ),
    new CoordRec((float) 73.8096, (float) 95.2381 ),
    new CoordRec((float) 64.2857, (float) 100 ),
    new CoordRec((float) 45.2381, (float) 100 ),
    new CoordRec((float) 35.7143, (float) 95.2381 ),
    new CoordRec((float) 26.1905, (float) 85.7143 ),
    new CoordRec((float) 21.4286, (float) 76.1905 ),
    new CoordRec((float) 16.6667, (float) 61.9048 ),
    new CoordRec((float) 16.6667, (float) 38.0952 ),
    new CoordRec((float) 21.4286, (float) 23.8095 ),
    new CoordRec((float) 26.1905, (float) 14.2857 ),
    new CoordRec((float) 35.7143, (float) 4.7619 ),
    new CoordRec((float) 45.2381, (float) 0 ),
    new CoordRec((float) 64.2857, (float) 0 ),
    new CoordRec((float) 73.8096, (float) 4.7619 ),
    new CoordRec((float) 83.3334, (float) 14.2857 ),
    new CoordRec((float) 88.0952, (float) 23.8095 ),
    new CoordRec((float) 88.0952, (float) 38.0952 ),
};

static final CoordRec char71_stroke1[] = {
    new CoordRec((float) 64.2857, (float) 38.0952 ),
    new CoordRec((float) 88.0952, (float) 38.0952 ),
};

static final StrokeRec char71[] = {
   new StrokeRec( 19, char71_stroke0 ),
   new StrokeRec( 2, char71_stroke1 ),
};

/* char: 72 'H' */

static final CoordRec char72_stroke0[] = {
    new CoordRec((float) 19.0476, (float) 100 ),
    new CoordRec((float) 19.0476, (float) 0 ),
};

static final CoordRec char72_stroke1[] = {
    new CoordRec((float) 85.7143, (float) 100 ),
    new CoordRec((float) 85.7143, (float) 0 ),
};

static final CoordRec char72_stroke2[] = {
    new CoordRec((float) 19.0476, (float) 52.381 ),
    new CoordRec((float) 85.7143, (float) 52.381 ),
};

static final StrokeRec char72[] = {
   new StrokeRec( 2, char72_stroke0 ),
   new StrokeRec( 2, char72_stroke1 ),
   new StrokeRec( 2, char72_stroke2 ),
};

/* char: 73 'I' */

static final CoordRec char73_stroke0[] = {
    new CoordRec((float) 52.381, (float) 100 ),
    new CoordRec((float) 52.381, (float) 0 ),
};

static final StrokeRec char73[] = {
   new StrokeRec( 2, char73_stroke0 ),
};

/* char: 74 'J' */

static final CoordRec char74_stroke0[] = {
    new CoordRec((float) 76.1905, (float) 100 ),
    new CoordRec((float) 76.1905, (float) 23.8095 ),
    new CoordRec((float) 71.4286, (float) 9.5238 ),
    new CoordRec((float) 66.6667, (float) 4.7619 ),
    new CoordRec((float) 57.1429, (float) 0 ),
    new CoordRec((float) 47.6191, (float) 0 ),
    new CoordRec((float) 38.0953, (float) 4.7619 ),
    new CoordRec((float) 33.3334, (float) 9.5238 ),
    new CoordRec((float) 28.5715, (float) 23.8095 ),
    new CoordRec((float) 28.5715, (float) 33.3333 ),
};

static final StrokeRec char74[] = {
   new StrokeRec( 10, char74_stroke0 ),
};

/* char: 75 'K' */

static final CoordRec char75_stroke0[] = {
    new CoordRec((float) 19.0476, (float) 100 ),
    new CoordRec((float) 19.0476, (float) 0 ),
};

static final CoordRec char75_stroke1[] = {
    new CoordRec((float) 85.7143, (float) 100 ),
    new CoordRec((float) 19.0476, (float) 33.3333 ),
};

static final CoordRec char75_stroke2[] = {
    new CoordRec((float) 42.8571, (float) 57.1429 ),
    new CoordRec((float) 85.7143, (float) 0 ),
};

static final StrokeRec char75[] = {
   new StrokeRec( 2, char75_stroke0 ),
   new StrokeRec( 2, char75_stroke1 ),
   new StrokeRec( 2, char75_stroke2 ),
};

/* char: 76 'L' */

static final CoordRec char76_stroke0[] = {
    new CoordRec((float) 23.8095, (float) 100 ),
    new CoordRec((float) 23.8095, (float) 0 ),
};

static final CoordRec char76_stroke1[] = {
    new CoordRec((float) 23.8095, (float) 0 ),
    new CoordRec((float) 80.9524, (float) 0 ),
};

static final StrokeRec char76[] = {
   new StrokeRec( 2, char76_stroke0 ),
   new StrokeRec( 2, char76_stroke1 ),
};

/* char: 77 'M' */

static final CoordRec char77_stroke0[] = {
    new CoordRec((float) 14.2857, (float) 100 ),
    new CoordRec((float) 14.2857, (float) 0 ),
};

static final CoordRec char77_stroke1[] = {
    new CoordRec((float) 14.2857, (float) 100 ),
    new CoordRec((float) 52.3809, (float) 0 ),
};

static final CoordRec char77_stroke2[] = {
    new CoordRec((float) 90.4762, (float) 100 ),
    new CoordRec((float) 52.3809, (float) 0 ),
};

static final CoordRec char77_stroke3[] = {
    new CoordRec((float) 90.4762, (float) 100 ),
    new CoordRec((float) 90.4762, (float) 0 ),
};

static final StrokeRec char77[] = {
   new StrokeRec( 2, char77_stroke0 ),
   new StrokeRec( 2, char77_stroke1 ),
   new StrokeRec( 2, char77_stroke2 ),
   new StrokeRec( 2, char77_stroke3 ),
};

/* char: 78 'N' */

static final CoordRec char78_stroke0[] = {
    new CoordRec((float) 19.0476, (float) 100 ),
    new CoordRec((float) 19.0476, (float) 0 ),
};

static final CoordRec char78_stroke1[] = {
    new CoordRec((float) 19.0476, (float) 100 ),
    new CoordRec((float) 85.7143, (float) 0 ),
};

static final CoordRec char78_stroke2[] = {
    new CoordRec((float) 85.7143, (float) 100 ),
    new CoordRec((float) 85.7143, (float) 0 ),
};

static final StrokeRec char78[] = {
   new StrokeRec( 2, char78_stroke0 ),
   new StrokeRec( 2, char78_stroke1 ),
   new StrokeRec( 2, char78_stroke2 ),
};

/* char: 79 'O' */

static final CoordRec char79_stroke0[] = {
    new CoordRec((float) 42.8571, (float) 100 ),
    new CoordRec((float) 33.3333, (float) 95.2381 ),
    new CoordRec((float) 23.8095, (float) 85.7143 ),
    new CoordRec((float) 19.0476, (float) 76.1905 ),
    new CoordRec((float) 14.2857, (float) 61.9048 ),
    new CoordRec((float) 14.2857, (float) 38.0952 ),
    new CoordRec((float) 19.0476, (float) 23.8095 ),
    new CoordRec((float) 23.8095, (float) 14.2857 ),
    new CoordRec((float) 33.3333, (float) 4.7619 ),
    new CoordRec((float) 42.8571, (float) 0 ),
    new CoordRec((float) 61.9047, (float) 0 ),
    new CoordRec((float) 71.4286, (float) 4.7619 ),
    new CoordRec((float) 80.9524, (float) 14.2857 ),
    new CoordRec((float) 85.7143, (float) 23.8095 ),
    new CoordRec((float) 90.4762, (float) 38.0952 ),
    new CoordRec((float) 90.4762, (float) 61.9048 ),
    new CoordRec((float) 85.7143, (float) 76.1905 ),
    new CoordRec((float) 80.9524, (float) 85.7143 ),
    new CoordRec((float) 71.4286, (float) 95.2381 ),
    new CoordRec((float) 61.9047, (float) 100 ),
    new CoordRec((float) 42.8571, (float) 100 ),
};

static final StrokeRec char79[] = {
   new StrokeRec( 21, char79_stroke0 ),
};

/* char: 80 'P' */

static final CoordRec char80_stroke0[] = {
    new CoordRec((float) 19.0476, (float) 100 ),
    new CoordRec((float) 19.0476, (float) 0 ),
};

static final CoordRec char80_stroke1[] = {
    new CoordRec((float) 19.0476, (float) 100 ),
    new CoordRec((float) 61.9047, (float) 100 ),
    new CoordRec((float) 76.1905, (float) 95.2381 ),
    new CoordRec((float) 80.9524, (float) 90.4762 ),
    new CoordRec((float) 85.7143, (float) 80.9524 ),
    new CoordRec((float) 85.7143, (float) 66.6667 ),
    new CoordRec((float) 80.9524, (float) 57.1429 ),
    new CoordRec((float) 76.1905, (float) 52.381 ),
    new CoordRec((float) 61.9047, (float) 47.619 ),
    new CoordRec((float) 19.0476, (float) 47.619 ),
};

static final StrokeRec char80[] = {
   new StrokeRec( 2, char80_stroke0 ),
   new StrokeRec( 10, char80_stroke1 ),
};

/* char: 81 'Q' */

static final CoordRec char81_stroke0[] = {
    new CoordRec((float) 42.8571, (float) 100 ),
    new CoordRec((float) 33.3333, (float) 95.2381 ),
    new CoordRec((float) 23.8095, (float) 85.7143 ),
    new CoordRec((float) 19.0476, (float) 76.1905 ),
    new CoordRec((float) 14.2857, (float) 61.9048 ),
    new CoordRec((float) 14.2857, (float) 38.0952 ),
    new CoordRec((float) 19.0476, (float) 23.8095 ),
    new CoordRec((float) 23.8095, (float) 14.2857 ),
    new CoordRec((float) 33.3333, (float) 4.7619 ),
    new CoordRec((float) 42.8571, (float) 0 ),
    new CoordRec((float) 61.9047, (float) 0 ),
    new CoordRec((float) 71.4286, (float) 4.7619 ),
    new CoordRec((float) 80.9524, (float) 14.2857 ),
    new CoordRec((float) 85.7143, (float) 23.8095 ),
    new CoordRec((float) 90.4762, (float) 38.0952 ),
    new CoordRec((float) 90.4762, (float) 61.9048 ),
    new CoordRec((float) 85.7143, (float) 76.1905 ),
    new CoordRec((float) 80.9524, (float) 85.7143 ),
    new CoordRec((float) 71.4286, (float) 95.2381 ),
    new CoordRec((float) 61.9047, (float) 100 ),
    new CoordRec((float) 42.8571, (float) 100 ),
};

static final CoordRec char81_stroke1[] = {
    new CoordRec((float) 57.1428, (float) 19.0476 ),
    new CoordRec((float) 85.7143, (float) -9.5238 ),
};

static final StrokeRec char81[] = {
   new StrokeRec( 21, char81_stroke0 ),
   new StrokeRec( 2, char81_stroke1 ),
};

/* char: 82 'R' */

static final CoordRec char82_stroke0[] = {
    new CoordRec((float) 19.0476, (float) 100 ),
    new CoordRec((float) 19.0476, (float) 0 ),
};

static final CoordRec char82_stroke1[] = {
    new CoordRec((float) 19.0476, (float) 100 ),
    new CoordRec((float) 61.9047, (float) 100 ),
    new CoordRec((float) 76.1905, (float) 95.2381 ),
    new CoordRec((float) 80.9524, (float) 90.4762 ),
    new CoordRec((float) 85.7143, (float) 80.9524 ),
    new CoordRec((float) 85.7143, (float) 71.4286 ),
    new CoordRec((float) 80.9524, (float) 61.9048 ),
    new CoordRec((float) 76.1905, (float) 57.1429 ),
    new CoordRec((float) 61.9047, (float) 52.381 ),
    new CoordRec((float) 19.0476, (float) 52.381 ),
};

static final CoordRec char82_stroke2[] = {
    new CoordRec((float) 52.3809, (float) 52.381 ),
    new CoordRec((float) 85.7143, (float) 0 ),
};

static final StrokeRec char82[] = {
   new StrokeRec( 2, char82_stroke0 ),
   new StrokeRec( 10, char82_stroke1 ),
   new StrokeRec( 2, char82_stroke2 ),
};

/* char: 83 'S' */

static final CoordRec char83_stroke0[] = {
    new CoordRec((float) 85.7143, (float) 85.7143 ),
    new CoordRec((float) 76.1905, (float) 95.2381 ),
    new CoordRec((float) 61.9047, (float) 100 ),
    new CoordRec((float) 42.8571, (float) 100 ),
    new CoordRec((float) 28.5714, (float) 95.2381 ),
    new CoordRec((float) 19.0476, (float) 85.7143 ),
    new CoordRec((float) 19.0476, (float) 76.1905 ),
    new CoordRec((float) 23.8095, (float) 66.6667 ),
    new CoordRec((float) 28.5714, (float) 61.9048 ),
    new CoordRec((float) 38.0952, (float) 57.1429 ),
    new CoordRec((float) 66.6666, (float) 47.619 ),
    new CoordRec((float) 76.1905, (float) 42.8571 ),
    new CoordRec((float) 80.9524, (float) 38.0952 ),
    new CoordRec((float) 85.7143, (float) 28.5714 ),
    new CoordRec((float) 85.7143, (float) 14.2857 ),
    new CoordRec((float) 76.1905, (float) 4.7619 ),
    new CoordRec((float) 61.9047, (float) 0 ),
    new CoordRec((float) 42.8571, (float) 0 ),
    new CoordRec((float) 28.5714, (float) 4.7619 ),
    new CoordRec((float) 19.0476, (float) 14.2857 ),
};

static final StrokeRec char83[] = {
   new StrokeRec( 20, char83_stroke0 ),
};

/* char: 84 'T' */

static final CoordRec char84_stroke0[] = {
    new CoordRec((float) 52.3809, (float) 100 ),
    new CoordRec((float) 52.3809, (float) 0 ),
};

static final CoordRec char84_stroke1[] = {
    new CoordRec((float) 19.0476, (float) 100 ),
    new CoordRec((float) 85.7143, (float) 100 ),
};

static final StrokeRec char84[] = {
   new StrokeRec( 2, char84_stroke0 ),
   new StrokeRec( 2, char84_stroke1 ),
};

/* char: 85 'U' */

static final CoordRec char85_stroke0[] = {
    new CoordRec((float) 19.0476, (float) 100 ),
    new CoordRec((float) 19.0476, (float) 28.5714 ),
    new CoordRec((float) 23.8095, (float) 14.2857 ),
    new CoordRec((float) 33.3333, (float) 4.7619 ),
    new CoordRec((float) 47.619, (float) 0 ),
    new CoordRec((float) 57.1428, (float) 0 ),
    new CoordRec((float) 71.4286, (float) 4.7619 ),
    new CoordRec((float) 80.9524, (float) 14.2857 ),
    new CoordRec((float) 85.7143, (float) 28.5714 ),
    new CoordRec((float) 85.7143, (float) 100 ),
};

static final StrokeRec char85[] = {
   new StrokeRec( 10, char85_stroke0 ),
};

/* char: 86 'V' */

static final CoordRec char86_stroke0[] = {
    new CoordRec((float) 14.2857, (float) 100 ),
    new CoordRec((float) 52.3809, (float) 0 ),
};

static final CoordRec char86_stroke1[] = {
    new CoordRec((float) 90.4762, (float) 100 ),
    new CoordRec((float) 52.3809, (float) 0 ),
};

static final StrokeRec char86[] = {
   new StrokeRec( 2, char86_stroke0 ),
   new StrokeRec( 2, char86_stroke1 ),
};

/* char: 87 'W' */

static final CoordRec char87_stroke0[] = {
    new CoordRec((float) 4.7619, (float) 100 ),
    new CoordRec((float) 28.5714, (float) 0 ),
};

static final CoordRec char87_stroke1[] = {
    new CoordRec((float) 52.3809, (float) 100 ),
    new CoordRec((float) 28.5714, (float) 0 ),
};

static final CoordRec char87_stroke2[] = {
    new CoordRec((float) 52.3809, (float) 100 ),
    new CoordRec((float) 76.1905, (float) 0 ),
};

static final CoordRec char87_stroke3[] = {
    new CoordRec((float) 100, (float) 100 ),
    new CoordRec((float) 76.1905, (float) 0 ),
};

static final StrokeRec char87[] = {
   new StrokeRec( 2, char87_stroke0 ),
   new StrokeRec( 2, char87_stroke1 ),
   new StrokeRec( 2, char87_stroke2 ),
   new StrokeRec( 2, char87_stroke3 ),
};

/* char: 88 'X' */

static final CoordRec char88_stroke0[] = {
    new CoordRec((float) 19.0476, (float) 100 ),
    new CoordRec((float) 85.7143, (float) 0 ),
};

static final CoordRec char88_stroke1[] = {
    new CoordRec((float) 85.7143, (float) 100 ),
    new CoordRec((float) 19.0476, (float) 0 ),
};

static final StrokeRec char88[] = {
   new StrokeRec( 2, char88_stroke0 ),
   new StrokeRec( 2, char88_stroke1 ),
};

/* char: 89 'Y' */

static final CoordRec char89_stroke0[] = {
    new CoordRec((float) 14.2857, (float) 100 ),
    new CoordRec((float) 52.3809, (float) 52.381 ),
    new CoordRec((float) 52.3809, (float) 0 ),
};

static final CoordRec char89_stroke1[] = {
    new CoordRec((float) 90.4762, (float) 100 ),
    new CoordRec((float) 52.3809, (float) 52.381 ),
};

static final StrokeRec char89[] = {
   new StrokeRec( 3, char89_stroke0 ),
   new StrokeRec( 2, char89_stroke1 ),
};

/* char: 90 'Z' */

static final CoordRec char90_stroke0[] = {
    new CoordRec((float) 85.7143, (float) 100 ),
    new CoordRec((float) 19.0476, (float) 0 ),
};

static final CoordRec char90_stroke1[] = {
    new CoordRec((float) 19.0476, (float) 100 ),
    new CoordRec((float) 85.7143, (float) 100 ),
};

static final CoordRec char90_stroke2[] = {
    new CoordRec((float) 19.0476, (float) 0 ),
    new CoordRec((float) 85.7143, (float) 0 ),
};

static final StrokeRec char90[] = {
   new StrokeRec( 2, char90_stroke0 ),
   new StrokeRec( 2, char90_stroke1 ),
   new StrokeRec( 2, char90_stroke2 ),
};

/* char: 91 '[' */

static final CoordRec char91_stroke0[] = {
    new CoordRec((float) 35.7143, (float) 119.048 ),
    new CoordRec((float) 35.7143, (float) -33.3333 ),
};

static final CoordRec char91_stroke1[] = {
    new CoordRec((float) 40.4762, (float) 119.048 ),
    new CoordRec((float) 40.4762, (float) -33.3333 ),
};

static final CoordRec char91_stroke2[] = {
    new CoordRec((float) 35.7143, (float) 119.048 ),
    new CoordRec((float) 69.0476, (float) 119.048 ),
};

static final CoordRec char91_stroke3[] = {
    new CoordRec((float) 35.7143, (float) -33.3333 ),
    new CoordRec((float) 69.0476, (float) -33.3333 ),
};

static final StrokeRec char91[] = {
   new StrokeRec( 2, char91_stroke0 ),
   new StrokeRec( 2, char91_stroke1 ),
   new StrokeRec( 2, char91_stroke2 ),
   new StrokeRec( 2, char91_stroke3 ),
};

/* char: 92 '\' */

static final CoordRec char92_stroke0[] = {
    new CoordRec((float) 19.0476, (float) 100 ),
    new CoordRec((float) 85.7143, (float) -14.2857 ),
};

static final StrokeRec char92[] = {
   new StrokeRec( 2, char92_stroke0 ),
};

/* char: 93 ']' */

static final CoordRec char93_stroke0[] = {
    new CoordRec((float) 64.2857, (float) 119.048 ),
    new CoordRec((float) 64.2857, (float) -33.3333 ),
};

static final CoordRec char93_stroke1[] = {
    new CoordRec((float) 69.0476, (float) 119.048 ),
    new CoordRec((float) 69.0476, (float) -33.3333 ),
};

static final CoordRec char93_stroke2[] = {
    new CoordRec((float) 35.7143, (float) 119.048 ),
    new CoordRec((float) 69.0476, (float) 119.048 ),
};

static final CoordRec char93_stroke3[] = {
    new CoordRec((float) 35.7143, (float) -33.3333 ),
    new CoordRec((float) 69.0476, (float) -33.3333 ),
};

static final StrokeRec char93[] = {
   new StrokeRec( 2, char93_stroke0 ),
   new StrokeRec( 2, char93_stroke1 ),
   new StrokeRec( 2, char93_stroke2 ),
   new StrokeRec( 2, char93_stroke3 ),
};

/* char: 94 '^' */

static final CoordRec char94_stroke0[] = {
    new CoordRec((float) 52.3809, (float) 109.524 ),
    new CoordRec((float) 14.2857, (float) 42.8571 ),
};

static final CoordRec char94_stroke1[] = {
    new CoordRec((float) 52.3809, (float) 109.524 ),
    new CoordRec((float) 90.4762, (float) 42.8571 ),
};

static final StrokeRec char94[] = {
   new StrokeRec( 2, char94_stroke0 ),
   new StrokeRec( 2, char94_stroke1 ),
};

/* char: 95 '_' */

static final CoordRec char95_stroke0[] = {
    new CoordRec((float) 0, (float) -33.3333 ),
    new CoordRec((float) 104.762, (float) -33.3333 ),
    new CoordRec((float) 104.762, (float) -28.5714 ),
    new CoordRec((float) 0, (float) -28.5714 ),
    new CoordRec((float) 0, (float) -33.3333 ),
};

static final StrokeRec char95[] = {
   new StrokeRec( 5, char95_stroke0 ),
};

/* char: 96 '`' */

static final CoordRec char96_stroke0[] = {
    new CoordRec((float) 42.8572, (float) 100 ),
    new CoordRec((float) 66.6667, (float) 71.4286 ),
};

static final CoordRec char96_stroke1[] = {
    new CoordRec((float) 42.8572, (float) 100 ),
    new CoordRec((float) 38.0953, (float) 95.2381 ),
    new CoordRec((float) 66.6667, (float) 71.4286 ),
};

static final StrokeRec char96[] = {
   new StrokeRec( 2, char96_stroke0 ),
   new StrokeRec( 3, char96_stroke1 ),
};

/* char: 97 'a' */

static final CoordRec char97_stroke0[] = {
    new CoordRec((float) 80.9524, (float) 66.6667 ),
    new CoordRec((float) 80.9524, (float) 0 ),
};

static final CoordRec char97_stroke1[] = {
    new CoordRec((float) 80.9524, (float) 52.381 ),
    new CoordRec((float) 71.4285, (float) 61.9048 ),
    new CoordRec((float) 61.9047, (float) 66.6667 ),
    new CoordRec((float) 47.619, (float) 66.6667 ),
    new CoordRec((float) 38.0952, (float) 61.9048 ),
    new CoordRec((float) 28.5714, (float) 52.381 ),
    new CoordRec((float) 23.8095, (float) 38.0952 ),
    new CoordRec((float) 23.8095, (float) 28.5714 ),
    new CoordRec((float) 28.5714, (float) 14.2857 ),
    new CoordRec((float) 38.0952, (float) 4.7619 ),
    new CoordRec((float) 47.619, (float) 0 ),
    new CoordRec((float) 61.9047, (float) 0 ),
    new CoordRec((float) 71.4285, (float) 4.7619 ),
    new CoordRec((float) 80.9524, (float) 14.2857 ),
};

static final StrokeRec char97[] = {
   new StrokeRec( 2, char97_stroke0 ),
   new StrokeRec( 14, char97_stroke1 ),
};

/* char: 98 'b' */

static final CoordRec char98_stroke0[] = {
    new CoordRec((float) 23.8095, (float) 100 ),
    new CoordRec((float) 23.8095, (float) 0 ),
};

static final CoordRec char98_stroke1[] = {
    new CoordRec((float) 23.8095, (float) 52.381 ),
    new CoordRec((float) 33.3333, (float) 61.9048 ),
    new CoordRec((float) 42.8571, (float) 66.6667 ),
    new CoordRec((float) 57.1428, (float) 66.6667 ),
    new CoordRec((float) 66.6666, (float) 61.9048 ),
    new CoordRec((float) 76.1905, (float) 52.381 ),
    new CoordRec((float) 80.9524, (float) 38.0952 ),
    new CoordRec((float) 80.9524, (float) 28.5714 ),
    new CoordRec((float) 76.1905, (float) 14.2857 ),
    new CoordRec((float) 66.6666, (float) 4.7619 ),
    new CoordRec((float) 57.1428, (float) 0 ),
    new CoordRec((float) 42.8571, (float) 0 ),
    new CoordRec((float) 33.3333, (float) 4.7619 ),
    new CoordRec((float) 23.8095, (float) 14.2857 ),
};

static final StrokeRec char98[] = {
   new StrokeRec( 2, char98_stroke0 ),
   new StrokeRec( 14, char98_stroke1 ),
};

/* char: 99 'c' */

static final CoordRec char99_stroke0[] = {
    new CoordRec((float) 80.9524, (float) 52.381 ),
    new CoordRec((float) 71.4285, (float) 61.9048 ),
    new CoordRec((float) 61.9047, (float) 66.6667 ),
    new CoordRec((float) 47.619, (float) 66.6667 ),
    new CoordRec((float) 38.0952, (float) 61.9048 ),
    new CoordRec((float) 28.5714, (float) 52.381 ),
    new CoordRec((float) 23.8095, (float) 38.0952 ),
    new CoordRec((float) 23.8095, (float) 28.5714 ),
    new CoordRec((float) 28.5714, (float) 14.2857 ),
    new CoordRec((float) 38.0952, (float) 4.7619 ),
    new CoordRec((float) 47.619, (float) 0 ),
    new CoordRec((float) 61.9047, (float) 0 ),
    new CoordRec((float) 71.4285, (float) 4.7619 ),
    new CoordRec((float) 80.9524, (float) 14.2857 ),
};

static final StrokeRec char99[] = {
   new StrokeRec( 14, char99_stroke0 ),
};

/* char: 100 'd' */

static final CoordRec char100_stroke0[] = {
    new CoordRec((float) 80.9524, (float) 100 ),
    new CoordRec((float) 80.9524, (float) 0 ),
};

static final CoordRec char100_stroke1[] = {
    new CoordRec((float) 80.9524, (float) 52.381 ),
    new CoordRec((float) 71.4285, (float) 61.9048 ),
    new CoordRec((float) 61.9047, (float) 66.6667 ),
    new CoordRec((float) 47.619, (float) 66.6667 ),
    new CoordRec((float) 38.0952, (float) 61.9048 ),
    new CoordRec((float) 28.5714, (float) 52.381 ),
    new CoordRec((float) 23.8095, (float) 38.0952 ),
    new CoordRec((float) 23.8095, (float) 28.5714 ),
    new CoordRec((float) 28.5714, (float) 14.2857 ),
    new CoordRec((float) 38.0952, (float) 4.7619 ),
    new CoordRec((float) 47.619, (float) 0 ),
    new CoordRec((float) 61.9047, (float) 0 ),
    new CoordRec((float) 71.4285, (float) 4.7619 ),
    new CoordRec((float) 80.9524, (float) 14.2857 ),
};

static final StrokeRec char100[] = {
   new StrokeRec( 2, char100_stroke0 ),
   new StrokeRec( 14, char100_stroke1 ),
};

/* char: 101 'e' */

static final CoordRec char101_stroke0[] = {
    new CoordRec((float) 23.8095, (float) 38.0952 ),
    new CoordRec((float) 80.9524, (float) 38.0952 ),
    new CoordRec((float) 80.9524, (float) 47.619 ),
    new CoordRec((float) 76.1905, (float) 57.1429 ),
    new CoordRec((float) 71.4285, (float) 61.9048 ),
    new CoordRec((float) 61.9047, (float) 66.6667 ),
    new CoordRec((float) 47.619, (float) 66.6667 ),
    new CoordRec((float) 38.0952, (float) 61.9048 ),
    new CoordRec((float) 28.5714, (float) 52.381 ),
    new CoordRec((float) 23.8095, (float) 38.0952 ),
    new CoordRec((float) 23.8095, (float) 28.5714 ),
    new CoordRec((float) 28.5714, (float) 14.2857 ),
    new CoordRec((float) 38.0952, (float) 4.7619 ),
    new CoordRec((float) 47.619, (float) 0 ),
    new CoordRec((float) 61.9047, (float) 0 ),
    new CoordRec((float) 71.4285, (float) 4.7619 ),
    new CoordRec((float) 80.9524, (float) 14.2857 ),
};

static final StrokeRec char101[] = {
   new StrokeRec( 17, char101_stroke0 ),
};

/* char: 102 'f' */

static final CoordRec char102_stroke0[] = {
    new CoordRec((float) 71.4286, (float) 100 ),
    new CoordRec((float) 61.9048, (float) 100 ),
    new CoordRec((float) 52.381, (float) 95.2381 ),
    new CoordRec((float) 47.6191, (float) 80.9524 ),
    new CoordRec((float) 47.6191, (float) 0 ),
};

static final CoordRec char102_stroke1[] = {
    new CoordRec((float) 33.3334, (float) 66.6667 ),
    new CoordRec((float) 66.6667, (float) 66.6667 ),
};

static final StrokeRec char102[] = {
   new StrokeRec( 5, char102_stroke0 ),
   new StrokeRec( 2, char102_stroke1 ),
};

/* char: 103 'g' */

static final CoordRec char103_stroke0[] = {
    new CoordRec((float) 80.9524, (float) 66.6667 ),
    new CoordRec((float) 80.9524, (float) -9.5238 ),
    new CoordRec((float) 76.1905, (float) -23.8095 ),
    new CoordRec((float) 71.4285, (float) -28.5714 ),
    new CoordRec((float) 61.9047, (float) -33.3333 ),
    new CoordRec((float) 47.619, (float) -33.3333 ),
    new CoordRec((float) 38.0952, (float) -28.5714 ),
};

static final CoordRec char103_stroke1[] = {
    new CoordRec((float) 80.9524, (float) 52.381 ),
    new CoordRec((float) 71.4285, (float) 61.9048 ),
    new CoordRec((float) 61.9047, (float) 66.6667 ),
    new CoordRec((float) 47.619, (float) 66.6667 ),
    new CoordRec((float) 38.0952, (float) 61.9048 ),
    new CoordRec((float) 28.5714, (float) 52.381 ),
    new CoordRec((float) 23.8095, (float) 38.0952 ),
    new CoordRec((float) 23.8095, (float) 28.5714 ),
    new CoordRec((float) 28.5714, (float) 14.2857 ),
    new CoordRec((float) 38.0952, (float) 4.7619 ),
    new CoordRec((float) 47.619, (float) 0 ),
    new CoordRec((float) 61.9047, (float) 0 ),
    new CoordRec((float) 71.4285, (float) 4.7619 ),
    new CoordRec((float) 80.9524, (float) 14.2857 ),
};

static final StrokeRec char103[] = {
   new StrokeRec( 7, char103_stroke0 ),
   new StrokeRec( 14, char103_stroke1 ),
};

/* char: 104 'h' */

static final CoordRec char104_stroke0[] = {
    new CoordRec((float) 26.1905, (float) 100 ),
    new CoordRec((float) 26.1905, (float) 0 ),
};

static final CoordRec char104_stroke1[] = {
    new CoordRec((float) 26.1905, (float) 47.619 ),
    new CoordRec((float) 40.4762, (float) 61.9048 ),
    new CoordRec((float) 50, (float) 66.6667 ),
    new CoordRec((float) 64.2857, (float) 66.6667 ),
    new CoordRec((float) 73.8095, (float) 61.9048 ),
    new CoordRec((float) 78.5715, (float) 47.619 ),
    new CoordRec((float) 78.5715, (float) 0 ),
};

static final StrokeRec char104[] = {
   new StrokeRec( 2, char104_stroke0 ),
   new StrokeRec( 7, char104_stroke1 ),
};

/* char: 105 'i' */

static final CoordRec char105_stroke0[] = {
    new CoordRec((float) 47.6191, (float) 100 ),
    new CoordRec((float) 52.381, (float) 95.2381 ),
    new CoordRec((float) 57.1429, (float) 100 ),
    new CoordRec((float) 52.381, (float) 104.762 ),
    new CoordRec((float) 47.6191, (float) 100 ),
};

static final CoordRec char105_stroke1[] = {
    new CoordRec((float) 52.381, (float) 66.6667 ),
    new CoordRec((float) 52.381, (float) 0 ),
};

static final StrokeRec char105[] = {
   new StrokeRec( 5, char105_stroke0 ),
   new StrokeRec( 2, char105_stroke1 ),
};

/* char: 106 'j' */

static final CoordRec char106_stroke0[] = {
    new CoordRec((float) 57.1429, (float) 100 ),
    new CoordRec((float) 61.9048, (float) 95.2381 ),
    new CoordRec((float) 66.6667, (float) 100 ),
    new CoordRec((float) 61.9048, (float) 104.762 ),
    new CoordRec((float) 57.1429, (float) 100 ),
};

static final CoordRec char106_stroke1[] = {
    new CoordRec((float) 61.9048, (float) 66.6667 ),
    new CoordRec((float) 61.9048, (float) -14.2857 ),
    new CoordRec((float) 57.1429, (float) -28.5714 ),
    new CoordRec((float) 47.6191, (float) -33.3333 ),
    new CoordRec((float) 38.0953, (float) -33.3333 ),
};

static final StrokeRec char106[] = {
   new StrokeRec( 5, char106_stroke0 ),
   new StrokeRec( 5, char106_stroke1 ),
};

/* char: 107 'k' */

static final CoordRec char107_stroke0[] = {
    new CoordRec((float) 26.1905, (float) 100 ),
    new CoordRec((float) 26.1905, (float) 0 ),
};

static final CoordRec char107_stroke1[] = {
    new CoordRec((float) 73.8095, (float) 66.6667 ),
    new CoordRec((float) 26.1905, (float) 19.0476 ),
};

static final CoordRec char107_stroke2[] = {
    new CoordRec((float) 45.2381, (float) 38.0952 ),
    new CoordRec((float) 78.5715, (float) 0 ),
};

static final StrokeRec char107[] = {
   new StrokeRec( 2, char107_stroke0 ),
   new StrokeRec( 2, char107_stroke1 ),
   new StrokeRec( 2, char107_stroke2 ),
};

/* char: 108 'l' */

static final CoordRec char108_stroke0[] = {
    new CoordRec((float) 52.381, (float) 100 ),
    new CoordRec((float) 52.381, (float) 0 ),
};

static final StrokeRec char108[] = {
   new StrokeRec( 2, char108_stroke0 ),
};

/* char: 109 'm' */

static final CoordRec char109_stroke0[] = {
    new CoordRec((float) 0, (float) 66.6667 ),
    new CoordRec((float) 0, (float) 0 ),
};

static final CoordRec char109_stroke1[] = {
    new CoordRec((float) 0, (float) 47.619 ),
    new CoordRec((float) 14.2857, (float) 61.9048 ),
    new CoordRec((float) 23.8095, (float) 66.6667 ),
    new CoordRec((float) 38.0952, (float) 66.6667 ),
    new CoordRec((float) 47.619, (float) 61.9048 ),
    new CoordRec((float) 52.381, (float) 47.619 ),
    new CoordRec((float) 52.381, (float) 0 ),
};

static final CoordRec char109_stroke2[] = {
    new CoordRec((float) 52.381, (float) 47.619 ),
    new CoordRec((float) 66.6667, (float) 61.9048 ),
    new CoordRec((float) 76.1905, (float) 66.6667 ),
    new CoordRec((float) 90.4762, (float) 66.6667 ),
    new CoordRec((float) 100, (float) 61.9048 ),
    new CoordRec((float) 104.762, (float) 47.619 ),
    new CoordRec((float) 104.762, (float) 0 ),
};

static final StrokeRec char109[] = {
   new StrokeRec( 2, char109_stroke0 ),
   new StrokeRec( 7, char109_stroke1 ),
   new StrokeRec( 7, char109_stroke2 ),
};

/* char: 110 'n' */

static final CoordRec char110_stroke0[] = {
    new CoordRec((float) 26.1905, (float) 66.6667 ),
    new CoordRec((float) 26.1905, (float) 0 ),
};

static final CoordRec char110_stroke1[] = {
    new CoordRec((float) 26.1905, (float) 47.619 ),
    new CoordRec((float) 40.4762, (float) 61.9048 ),
    new CoordRec((float) 50, (float) 66.6667 ),
    new CoordRec((float) 64.2857, (float) 66.6667 ),
    new CoordRec((float) 73.8095, (float) 61.9048 ),
    new CoordRec((float) 78.5715, (float) 47.619 ),
    new CoordRec((float) 78.5715, (float) 0 ),
};

static final StrokeRec char110[] = {
   new StrokeRec( 2, char110_stroke0 ),
   new StrokeRec( 7, char110_stroke1 ),
};

/* char: 111 'o' */

static final CoordRec char111_stroke0[] = {
    new CoordRec((float) 45.2381, (float) 66.6667 ),
    new CoordRec((float) 35.7143, (float) 61.9048 ),
    new CoordRec((float) 26.1905, (float) 52.381 ),
    new CoordRec((float) 21.4286, (float) 38.0952 ),
    new CoordRec((float) 21.4286, (float) 28.5714 ),
    new CoordRec((float) 26.1905, (float) 14.2857 ),
    new CoordRec((float) 35.7143, (float) 4.7619 ),
    new CoordRec((float) 45.2381, (float) 0 ),
    new CoordRec((float) 59.5238, (float) 0 ),
    new CoordRec((float) 69.0476, (float) 4.7619 ),
    new CoordRec((float) 78.5714, (float) 14.2857 ),
    new CoordRec((float) 83.3334, (float) 28.5714 ),
    new CoordRec((float) 83.3334, (float) 38.0952 ),
    new CoordRec((float) 78.5714, (float) 52.381 ),
    new CoordRec((float) 69.0476, (float) 61.9048 ),
    new CoordRec((float) 59.5238, (float) 66.6667 ),
    new CoordRec((float) 45.2381, (float) 66.6667 ),
};

static final StrokeRec char111[] = {
   new StrokeRec( 17, char111_stroke0 ),
};

/* char: 112 'p' */

static final CoordRec char112_stroke0[] = {
    new CoordRec((float) 23.8095, (float) 66.6667 ),
    new CoordRec((float) 23.8095, (float) -33.3333 ),
};

static final CoordRec char112_stroke1[] = {
    new CoordRec((float) 23.8095, (float) 52.381 ),
    new CoordRec((float) 33.3333, (float) 61.9048 ),
    new CoordRec((float) 42.8571, (float) 66.6667 ),
    new CoordRec((float) 57.1428, (float) 66.6667 ),
    new CoordRec((float) 66.6666, (float) 61.9048 ),
    new CoordRec((float) 76.1905, (float) 52.381 ),
    new CoordRec((float) 80.9524, (float) 38.0952 ),
    new CoordRec((float) 80.9524, (float) 28.5714 ),
    new CoordRec((float) 76.1905, (float) 14.2857 ),
    new CoordRec((float) 66.6666, (float) 4.7619 ),
    new CoordRec((float) 57.1428, (float) 0 ),
    new CoordRec((float) 42.8571, (float) 0 ),
    new CoordRec((float) 33.3333, (float) 4.7619 ),
    new CoordRec((float) 23.8095, (float) 14.2857 ),
};

static final StrokeRec char112[] = {
   new StrokeRec( 2, char112_stroke0 ),
   new StrokeRec( 14, char112_stroke1 ),
};

/* char: 113 'q' */

static final CoordRec char113_stroke0[] = {
    new CoordRec((float) 80.9524, (float) 66.6667 ),
    new CoordRec((float) 80.9524, (float) -33.3333 ),
};

static final CoordRec char113_stroke1[] = {
    new CoordRec((float) 80.9524, (float) 52.381 ),
    new CoordRec((float) 71.4285, (float) 61.9048 ),
    new CoordRec((float) 61.9047, (float) 66.6667 ),
    new CoordRec((float) 47.619, (float) 66.6667 ),
    new CoordRec((float) 38.0952, (float) 61.9048 ),
    new CoordRec((float) 28.5714, (float) 52.381 ),
    new CoordRec((float) 23.8095, (float) 38.0952 ),
    new CoordRec((float) 23.8095, (float) 28.5714 ),
    new CoordRec((float) 28.5714, (float) 14.2857 ),
    new CoordRec((float) 38.0952, (float) 4.7619 ),
    new CoordRec((float) 47.619, (float) 0 ),
    new CoordRec((float) 61.9047, (float) 0 ),
    new CoordRec((float) 71.4285, (float) 4.7619 ),
    new CoordRec((float) 80.9524, (float) 14.2857 ),
};

static final StrokeRec char113[] = {
   new StrokeRec( 2, char113_stroke0 ),
   new StrokeRec( 14, char113_stroke1 ),
};

/* char: 114 'r' */

static final CoordRec char114_stroke0[] = {
    new CoordRec((float) 33.3334, (float) 66.6667 ),
    new CoordRec((float) 33.3334, (float) 0 ),
};

static final CoordRec char114_stroke1[] = {
    new CoordRec((float) 33.3334, (float) 38.0952 ),
    new CoordRec((float) 38.0953, (float) 52.381 ),
    new CoordRec((float) 47.6191, (float) 61.9048 ),
    new CoordRec((float) 57.1429, (float) 66.6667 ),
    new CoordRec((float) 71.4286, (float) 66.6667 ),
};

static final StrokeRec char114[] = {
   new StrokeRec( 2, char114_stroke0 ),
   new StrokeRec( 5, char114_stroke1 ),
};

/* char: 115 's' */

static final CoordRec char115_stroke0[] = {
    new CoordRec((float) 78.5715, (float) 52.381 ),
    new CoordRec((float) 73.8095, (float) 61.9048 ),
    new CoordRec((float) 59.5238, (float) 66.6667 ),
    new CoordRec((float) 45.2381, (float) 66.6667 ),
    new CoordRec((float) 30.9524, (float) 61.9048 ),
    new CoordRec((float) 26.1905, (float) 52.381 ),
    new CoordRec((float) 30.9524, (float) 42.8571 ),
    new CoordRec((float) 40.4762, (float) 38.0952 ),
    new CoordRec((float) 64.2857, (float) 33.3333 ),
    new CoordRec((float) 73.8095, (float) 28.5714 ),
    new CoordRec((float) 78.5715, (float) 19.0476 ),
    new CoordRec((float) 78.5715, (float) 14.2857 ),
    new CoordRec((float) 73.8095, (float) 4.7619 ),
    new CoordRec((float) 59.5238, (float) 0 ),
    new CoordRec((float) 45.2381, (float) 0 ),
    new CoordRec((float) 30.9524, (float) 4.7619 ),
    new CoordRec((float) 26.1905, (float) 14.2857 ),
};

static final StrokeRec char115[] = {
   new StrokeRec( 17, char115_stroke0 ),
};

/* char: 116 't' */

static final CoordRec char116_stroke0[] = {
    new CoordRec((float) 47.6191, (float) 100 ),
    new CoordRec((float) 47.6191, (float) 19.0476 ),
    new CoordRec((float) 52.381, (float) 4.7619 ),
    new CoordRec((float) 61.9048, (float) 0 ),
    new CoordRec((float) 71.4286, (float) 0 ),
};

static final CoordRec char116_stroke1[] = {
    new CoordRec((float) 33.3334, (float) 66.6667 ),
    new CoordRec((float) 66.6667, (float) 66.6667 ),
};

static final StrokeRec char116[] = {
   new StrokeRec( 5, char116_stroke0 ),
   new StrokeRec( 2, char116_stroke1 ),
};

/* char: 117 'u' */

static final CoordRec char117_stroke0[] = {
    new CoordRec((float) 26.1905, (float) 66.6667 ),
    new CoordRec((float) 26.1905, (float) 19.0476 ),
    new CoordRec((float) 30.9524, (float) 4.7619 ),
    new CoordRec((float) 40.4762, (float) 0 ),
    new CoordRec((float) 54.7619, (float) 0 ),
    new CoordRec((float) 64.2857, (float) 4.7619 ),
    new CoordRec((float) 78.5715, (float) 19.0476 ),
};

static final CoordRec char117_stroke1[] = {
    new CoordRec((float) 78.5715, (float) 66.6667 ),
    new CoordRec((float) 78.5715, (float) 0 ),
};

static final StrokeRec char117[] = {
   new StrokeRec( 7, char117_stroke0 ),
   new StrokeRec( 2, char117_stroke1 ),
};

/* char: 118 'v' */

static final CoordRec char118_stroke0[] = {
    new CoordRec((float) 23.8095, (float) 66.6667 ),
    new CoordRec((float) 52.3809, (float) 0 ),
};

static final CoordRec char118_stroke1[] = {
    new CoordRec((float) 80.9524, (float) 66.6667 ),
    new CoordRec((float) 52.3809, (float) 0 ),
};

static final StrokeRec char118[] = {
   new StrokeRec( 2, char118_stroke0 ),
   new StrokeRec( 2, char118_stroke1 ),
};

/* char: 119 'w' */

static final CoordRec char119_stroke0[] = {
    new CoordRec((float) 14.2857, (float) 66.6667 ),
    new CoordRec((float) 33.3333, (float) 0 ),
};

static final CoordRec char119_stroke1[] = {
    new CoordRec((float) 52.3809, (float) 66.6667 ),
    new CoordRec((float) 33.3333, (float) 0 ),
};

static final CoordRec char119_stroke2[] = {
    new CoordRec((float) 52.3809, (float) 66.6667 ),
    new CoordRec((float) 71.4286, (float) 0 ),
};

static final CoordRec char119_stroke3[] = {
    new CoordRec((float) 90.4762, (float) 66.6667 ),
    new CoordRec((float) 71.4286, (float) 0 ),
};

static final StrokeRec char119[] = {
   new StrokeRec( 2, char119_stroke0 ),
   new StrokeRec( 2, char119_stroke1 ),
   new StrokeRec( 2, char119_stroke2 ),
   new StrokeRec( 2, char119_stroke3 ),
};

/* char: 120 'x' */

static final CoordRec char120_stroke0[] = {
    new CoordRec((float) 26.1905, (float) 66.6667 ),
    new CoordRec((float) 78.5715, (float) 0 ),
};

static final CoordRec char120_stroke1[] = {
    new CoordRec((float) 78.5715, (float) 66.6667 ),
    new CoordRec((float) 26.1905, (float) 0 ),
};

static final StrokeRec char120[] = {
   new StrokeRec( 2, char120_stroke0 ),
   new StrokeRec( 2, char120_stroke1 ),
};

/* char: 121 'y' */

static final CoordRec char121_stroke0[] = {
    new CoordRec((float) 26.1905, (float) 66.6667 ),
    new CoordRec((float) 54.7619, (float) 0 ),
};

static final CoordRec char121_stroke1[] = {
    new CoordRec((float) 83.3334, (float) 66.6667 ),
    new CoordRec((float) 54.7619, (float) 0 ),
    new CoordRec((float) 45.2381, (float) -19.0476 ),
    new CoordRec((float) 35.7143, (float) -28.5714 ),
    new CoordRec((float) 26.1905, (float) -33.3333 ),
    new CoordRec((float) 21.4286, (float) -33.3333 ),
};

static final StrokeRec char121[] = {
   new StrokeRec( 2, char121_stroke0 ),
   new StrokeRec( 6, char121_stroke1 ),
};

/* char: 122 'z' */

static final CoordRec char122_stroke0[] = {
    new CoordRec((float) 78.5715, (float) 66.6667 ),
    new CoordRec((float) 26.1905, (float) 0 ),
};

static final CoordRec char122_stroke1[] = {
    new CoordRec((float) 26.1905, (float) 66.6667 ),
    new CoordRec((float) 78.5715, (float) 66.6667 ),
};

static final CoordRec char122_stroke2[] = {
    new CoordRec((float) 26.1905, (float) 0 ),
    new CoordRec((float) 78.5715, (float) 0 ),
};

static final StrokeRec char122[] = {
   new StrokeRec( 2, char122_stroke0 ),
   new StrokeRec( 2, char122_stroke1 ),
   new StrokeRec( 2, char122_stroke2 ),
};

/* char: 123 '{' */

static final CoordRec char123_stroke0[] = {
    new CoordRec((float) 64.2857, (float) 119.048 ),
    new CoordRec((float) 54.7619, (float) 114.286 ),
    new CoordRec((float) 50, (float) 109.524 ),
    new CoordRec((float) 45.2381, (float) 100 ),
    new CoordRec((float) 45.2381, (float) 90.4762 ),
    new CoordRec((float) 50, (float) 80.9524 ),
    new CoordRec((float) 54.7619, (float) 76.1905 ),
    new CoordRec((float) 59.5238, (float) 66.6667 ),
    new CoordRec((float) 59.5238, (float) 57.1429 ),
    new CoordRec((float) 50, (float) 47.619 ),
};

static final CoordRec char123_stroke1[] = {
    new CoordRec((float) 54.7619, (float) 114.286 ),
    new CoordRec((float) 50, (float) 104.762 ),
    new CoordRec((float) 50, (float) 95.2381 ),
    new CoordRec((float) 54.7619, (float) 85.7143 ),
    new CoordRec((float) 59.5238, (float) 80.9524 ),
    new CoordRec((float) 64.2857, (float) 71.4286 ),
    new CoordRec((float) 64.2857, (float) 61.9048 ),
    new CoordRec((float) 59.5238, (float) 52.381 ),
    new CoordRec((float) 40.4762, (float) 42.8571 ),
    new CoordRec((float) 59.5238, (float) 33.3333 ),
    new CoordRec((float) 64.2857, (float) 23.8095 ),
    new CoordRec((float) 64.2857, (float) 14.2857 ),
    new CoordRec((float) 59.5238, (float) 4.7619 ),
    new CoordRec((float) 54.7619, (float) 0 ),
    new CoordRec((float) 50, (float) -9.5238 ),
    new CoordRec((float) 50, (float) -19.0476 ),
    new CoordRec((float) 54.7619, (float) -28.5714 ),
};

static final CoordRec char123_stroke2[] = {
    new CoordRec((float) 50, (float) 38.0952 ),
    new CoordRec((float) 59.5238, (float) 28.5714 ),
    new CoordRec((float) 59.5238, (float) 19.0476 ),
    new CoordRec((float) 54.7619, (float) 9.5238 ),
    new CoordRec((float) 50, (float) 4.7619 ),
    new CoordRec((float) 45.2381, (float) -4.7619 ),
    new CoordRec((float) 45.2381, (float) -14.2857 ),
    new CoordRec((float) 50, (float) -23.8095 ),
    new CoordRec((float) 54.7619, (float) -28.5714 ),
    new CoordRec((float) 64.2857, (float) -33.3333 ),
};

static final StrokeRec char123[] = {
   new StrokeRec( 10, char123_stroke0 ),
   new StrokeRec( 17, char123_stroke1 ),
   new StrokeRec( 10, char123_stroke2 ),
};

/* char: 124 '|' */

static final CoordRec char124_stroke0[] = {
    new CoordRec((float) 52.381, (float) 119.048 ),
    new CoordRec((float) 52.381, (float) -33.3333 ),
};

static final StrokeRec char124[] = {
   new StrokeRec( 2, char124_stroke0 ),
};

/* char: 125 '}' */

static final CoordRec char125_stroke0[] = {
    new CoordRec((float) 40.4762, (float) 119.048 ),
    new CoordRec((float) 50, (float) 114.286 ),
    new CoordRec((float) 54.7619, (float) 109.524 ),
    new CoordRec((float) 59.5238, (float) 100 ),
    new CoordRec((float) 59.5238, (float) 90.4762 ),
    new CoordRec((float) 54.7619, (float) 80.9524 ),
    new CoordRec((float) 50, (float) 76.1905 ),
    new CoordRec((float) 45.2381, (float) 66.6667 ),
    new CoordRec((float) 45.2381, (float) 57.1429 ),
    new CoordRec((float) 54.7619, (float) 47.619 ),
};

static final CoordRec char125_stroke1[] = {
    new CoordRec((float) 50, (float) 114.286 ),
    new CoordRec((float) 54.7619, (float) 104.762 ),
    new CoordRec((float) 54.7619, (float) 95.2381 ),
    new CoordRec((float) 50, (float) 85.7143 ),
    new CoordRec((float) 45.2381, (float) 80.9524 ),
    new CoordRec((float) 40.4762, (float) 71.4286 ),
    new CoordRec((float) 40.4762, (float) 61.9048 ),
    new CoordRec((float) 45.2381, (float) 52.381 ),
    new CoordRec((float) 64.2857, (float) 42.8571 ),
    new CoordRec((float) 45.2381, (float) 33.3333 ),
    new CoordRec((float) 40.4762, (float) 23.8095 ),
    new CoordRec((float) 40.4762, (float) 14.2857 ),
    new CoordRec((float) 45.2381, (float) 4.7619 ),
    new CoordRec((float) 50, (float) 0 ),
    new CoordRec((float) 54.7619, (float) -9.5238 ),
    new CoordRec((float) 54.7619, (float) -19.0476 ),
    new CoordRec((float) 50, (float) -28.5714 ),
};

static final CoordRec char125_stroke2[] = {
    new CoordRec((float) 54.7619, (float) 38.0952 ),
    new CoordRec((float) 45.2381, (float) 28.5714 ),
    new CoordRec((float) 45.2381, (float) 19.0476 ),
    new CoordRec((float) 50, (float) 9.5238 ),
    new CoordRec((float) 54.7619, (float) 4.7619 ),
    new CoordRec((float) 59.5238, (float) -4.7619 ),
    new CoordRec((float) 59.5238, (float) -14.2857 ),
    new CoordRec((float) 54.7619, (float) -23.8095 ),
    new CoordRec((float) 50, (float) -28.5714 ),
    new CoordRec((float) 40.4762, (float) -33.3333 ),
};

static final StrokeRec char125[] = {
   new StrokeRec( 10, char125_stroke0 ),
   new StrokeRec( 17, char125_stroke1 ),
   new StrokeRec( 10, char125_stroke2 ),
};

/* char: 126 '~' */

static final CoordRec char126_stroke0[] = {
    new CoordRec((float) 9.5238, (float) 28.5714 ),
    new CoordRec((float) 9.5238, (float) 38.0952 ),
    new CoordRec((float) 14.2857, (float) 52.381 ),
    new CoordRec((float) 23.8095, (float) 57.1429 ),
    new CoordRec((float) 33.3333, (float) 57.1429 ),
    new CoordRec((float) 42.8571, (float) 52.381 ),
    new CoordRec((float) 61.9048, (float) 38.0952 ),
    new CoordRec((float) 71.4286, (float) 33.3333 ),
    new CoordRec((float) 80.9524, (float) 33.3333 ),
    new CoordRec((float) 90.4762, (float) 38.0952 ),
    new CoordRec((float) 95.2381, (float) 47.619 ),
};

static final CoordRec char126_stroke1[] = {
    new CoordRec((float) 9.5238, (float) 38.0952 ),
    new CoordRec((float) 14.2857, (float) 47.619 ),
    new CoordRec((float) 23.8095, (float) 52.381 ),
    new CoordRec((float) 33.3333, (float) 52.381 ),
    new CoordRec((float) 42.8571, (float) 47.619 ),
    new CoordRec((float) 61.9048, (float) 33.3333 ),
    new CoordRec((float) 71.4286, (float) 28.5714 ),
    new CoordRec((float) 80.9524, (float) 28.5714 ),
    new CoordRec((float) 90.4762, (float) 33.3333 ),
    new CoordRec((float) 95.2381, (float) 47.619 ),
    new CoordRec((float) 95.2381, (float) 57.1429 ),
};

static final StrokeRec char126[] = {
   new StrokeRec( 11, char126_stroke0 ),
   new StrokeRec( 11, char126_stroke1 ),
};

/* char: 127 */

static final CoordRec char127_stroke0[] = {
    new CoordRec((float) 71.4286, (float) 100 ),
    new CoordRec((float) 33.3333, (float) -33.3333 ),
};

static final CoordRec char127_stroke1[] = {
    new CoordRec((float) 47.619, (float) 66.6667 ),
    new CoordRec((float) 33.3333, (float) 61.9048 ),
    new CoordRec((float) 23.8095, (float) 52.381 ),
    new CoordRec((float) 19.0476, (float) 38.0952 ),
    new CoordRec((float) 19.0476, (float) 23.8095 ),
    new CoordRec((float) 23.8095, (float) 14.2857 ),
    new CoordRec((float) 33.3333, (float) 4.7619 ),
    new CoordRec((float) 47.619, (float) 0 ),
    new CoordRec((float) 57.1428, (float) 0 ),
    new CoordRec((float) 71.4286, (float) 4.7619 ),
    new CoordRec((float) 80.9524, (float) 14.2857 ),
    new CoordRec((float) 85.7143, (float) 28.5714 ),
    new CoordRec((float) 85.7143, (float) 42.8571 ),
    new CoordRec((float) 80.9524, (float) 52.381 ),
    new CoordRec((float) 71.4286, (float) 61.9048 ),
    new CoordRec((float) 57.1428, (float) 66.6667 ),
    new CoordRec((float) 47.619, (float) 66.6667 ),
};

static final StrokeRec char127[] = {
   new StrokeRec( 2, char127_stroke0 ),
   new StrokeRec( 17, char127_stroke1 ),
};

static final StrokeCharRec chars[] = {
    new StrokeCharRec(0, /* char0 */ null, (float) 0, (float) 0 ),
    new StrokeCharRec(0, /* char1 */ null, (float) 0, (float) 0 ),
    new StrokeCharRec(0, /* char2 */ null, (float) 0, (float) 0 ),
    new StrokeCharRec(0, /* char3 */ null, (float) 0, (float) 0 ),
    new StrokeCharRec(0, /* char4 */ null, (float) 0, (float) 0 ),
    new StrokeCharRec(0, /* char5 */ null, (float) 0, (float) 0 ),
    new StrokeCharRec(0, /* char6 */ null, (float) 0, (float) 0 ),
    new StrokeCharRec(0, /* char7 */ null, (float) 0, (float) 0 ),
    new StrokeCharRec(0, /* char8 */ null, (float) 0, (float) 0 ),
    new StrokeCharRec(0, /* char9 */ null, (float) 0, (float) 0 ),
    new StrokeCharRec(0, /* char10 */ null, (float) 0, (float) 0 ),
    new StrokeCharRec(0, /* char11 */ null, (float) 0, (float) 0 ),
    new StrokeCharRec(0, /* char12 */ null, (float) 0, (float) 0 ),
    new StrokeCharRec(0, /* char13 */ null, (float) 0, (float) 0 ),
    new StrokeCharRec(0, /* char14 */ null, (float) 0, (float) 0 ),
    new StrokeCharRec(0, /* char15 */ null, (float) 0, (float) 0 ),
    new StrokeCharRec(0, /* char16 */ null, (float) 0, (float) 0 ),
    new StrokeCharRec(0, /* char17 */ null, (float) 0, (float) 0 ),
    new StrokeCharRec(0, /* char18 */ null, (float) 0, (float) 0 ),
    new StrokeCharRec(0, /* char19 */ null, (float) 0, (float) 0 ),
    new StrokeCharRec(0, /* char20 */ null, (float) 0, (float) 0 ),
    new StrokeCharRec(0, /* char21 */ null, (float) 0, (float) 0 ),
    new StrokeCharRec(0, /* char22 */ null, (float) 0, (float) 0 ),
    new StrokeCharRec(0, /* char23 */ null, (float) 0, (float) 0 ),
    new StrokeCharRec(0, /* char24 */ null, (float) 0, (float) 0 ),
    new StrokeCharRec(0, /* char25 */ null, (float) 0, (float) 0 ),
    new StrokeCharRec(0, /* char26 */ null, (float) 0, (float) 0 ),
    new StrokeCharRec(0, /* char27 */ null, (float) 0, (float) 0 ),
    new StrokeCharRec(0, /* char28 */ null, (float) 0, (float) 0 ),
    new StrokeCharRec(0, /* char29 */ null, (float) 0, (float) 0 ),
    new StrokeCharRec(0, /* char30 */ null, (float) 0, (float) 0 ),
    new StrokeCharRec(0, /* char31 */ null, (float) 0, (float) 0 ),
    new StrokeCharRec(0, /* char32 */ null, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(2, char33, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(2, char34, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(4, char35, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(3, char36, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(3, char37, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(1, char38, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(1, char39, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(1, char40, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(1, char41, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(3, char42, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(2, char43, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(1, char44, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(1, char45, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(1, char46, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(1, char47, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(1, char48, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(1, char49, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(1, char50, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(1, char51, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(2, char52, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(1, char53, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(1, char54, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(2, char55, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(1, char56, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(1, char57, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(2, char58, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(2, char59, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(1, char60, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(2, char61, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(1, char62, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(2, char63, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(2, char64, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(3, char65, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(3, char66, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(1, char67, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(2, char68, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(4, char69, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(3, char70, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(2, char71, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(3, char72, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(1, char73, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(1, char74, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(3, char75, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(2, char76, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(4, char77, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(3, char78, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(1, char79, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(2, char80, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(2, char81, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(3, char82, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(1, char83, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(2, char84, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(1, char85, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(2, char86, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(4, char87, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(2, char88, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(2, char89, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(3, char90, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(4, char91, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(1, char92, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(4, char93, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(2, char94, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(1, char95, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(2, char96, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(2, char97, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(2, char98, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(1, char99, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(2, char100, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(1, char101, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(2, char102, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(2, char103, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(2, char104, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(2, char105, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(2, char106, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(3, char107, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(1, char108, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(3, char109, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(2, char110, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(1, char111, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(2, char112, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(2, char113, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(2, char114, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(1, char115, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(2, char116, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(2, char117, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(2, char118, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(4, char119, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(2, char120, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(2, char121, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(3, char122, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(3, char123, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(1, char124, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(3, char125, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(2, char126, (float) 52.381, (float) 104.762 ),
    new StrokeCharRec(2, char127, (float) 52.381, (float) 104.762 ),
};

public static final StrokeFontRec glutStrokeMonoRoman = new StrokeFontRec( "Roman", 128, chars, (float) 119.048, (float) -33.3333 );
}
