/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.managed.factory.support.beans;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlValue;

import org.jboss.logging.Logger;
import org.jboss.reflect.spi.TypeInfo;

/**
 * @author Scott.Stark@jboss.org
 * @version $Revision:$
 */
public class StringValueMetaData
   implements IValueMetaData
{
   private static final long serialVersionUID = 2L;

   /** The log */
   private static final Logger log = Logger.getLogger(StringValueMetaData.class);
   /**
    * The value
    */
   private Object value;
   /**
    * The type
    */
   protected String type;

   /**
    * The property name
    */
   protected String propertyName;

   /**
    * The bean name
    */
   protected String beanName;
   /**
    * Do we replace String with System property,
    * by default it is true.
    */
   private boolean replace = true;

   /**
    * Do we trim string value before usage,
    * by default is true.
    */
   private boolean trim = true;

   /**
    * Create a new string value
    */
   public StringValueMetaData()
   {
   }

   /**
    * Create a new string value
    * 
    * @param value the value
    */
   public StringValueMetaData(String value)
   {
      this.value = value;
   }

   public String getValue()
   {
      return value.toString();
   }

   /**
    * Set the value
    * 
    * @param value the value
    */
   @XmlValue
   public void setValue(String value)
   {
      this.value = value;
   }

   public void setValue(Object value)
   {
      if (value != null && value instanceof String == false)
         throw new ClassCastException("value is not a String: " + value);
      this.value = (String) value;
   }

   protected Object getDefaultInstance()
   {
      return null;
   }

   public boolean isReplace()
   {
      return replace;
   }

   @XmlAttribute(name="replace")
   public void setReplace(boolean replace)
   {
      this.replace = replace;
   }

   public boolean isTrim()
   {
      return trim;
   }

   public void setTrim(boolean trim)
   {
      this.trim = trim;
   }

   public Object getUnderlyingValue()
   {
      return value;
   }

   public Object getValue(TypeInfo info, ClassLoader cl) throws Throwable
   {
      // TODO Auto-generated method stub
      return null;
   }

   public StringValueMetaData clone()
      throws CloneNotSupportedException
   {
      return (StringValueMetaData)super.clone();
   }

   public void setType(String type)
   {
      this.type = type;
   }
}
