/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#ifndef _GUESTFS_PROTOCOL_H_RPCGEN
#define _GUESTFS_PROTOCOL_H_RPCGEN

#include <rpc/rpc.h>


#ifdef __cplusplus
extern "C" {
#endif


typedef char *guestfs_str;

struct guestfs_int_int_bool {
	int i;
	int b;
};
typedef struct guestfs_int_int_bool guestfs_int_int_bool;

typedef struct {
	u_int guestfs_int_int_bool_list_len;
	guestfs_int_int_bool *guestfs_int_int_bool_list_val;
} guestfs_int_int_bool_list;

struct guestfs_int_lvm_pv {
	char *pv_name;
	char pv_uuid[32];
	char *pv_fmt;
	quad_t pv_size;
	quad_t dev_size;
	quad_t pv_free;
	quad_t pv_used;
	char *pv_attr;
	quad_t pv_pe_count;
	quad_t pv_pe_alloc_count;
	char *pv_tags;
	quad_t pe_start;
	quad_t pv_mda_count;
	quad_t pv_mda_free;
};
typedef struct guestfs_int_lvm_pv guestfs_int_lvm_pv;

typedef struct {
	u_int guestfs_int_lvm_pv_list_len;
	guestfs_int_lvm_pv *guestfs_int_lvm_pv_list_val;
} guestfs_int_lvm_pv_list;

struct guestfs_int_lvm_vg {
	char *vg_name;
	char vg_uuid[32];
	char *vg_fmt;
	char *vg_attr;
	quad_t vg_size;
	quad_t vg_free;
	char *vg_sysid;
	quad_t vg_extent_size;
	quad_t vg_extent_count;
	quad_t vg_free_count;
	quad_t max_lv;
	quad_t max_pv;
	quad_t pv_count;
	quad_t lv_count;
	quad_t snap_count;
	quad_t vg_seqno;
	char *vg_tags;
	quad_t vg_mda_count;
	quad_t vg_mda_free;
};
typedef struct guestfs_int_lvm_vg guestfs_int_lvm_vg;

typedef struct {
	u_int guestfs_int_lvm_vg_list_len;
	guestfs_int_lvm_vg *guestfs_int_lvm_vg_list_val;
} guestfs_int_lvm_vg_list;

struct guestfs_int_lvm_lv {
	char *lv_name;
	char lv_uuid[32];
	char *lv_attr;
	quad_t lv_major;
	quad_t lv_minor;
	quad_t lv_kernel_major;
	quad_t lv_kernel_minor;
	quad_t lv_size;
	quad_t seg_count;
	char *origin;
	float snap_percent;
	float copy_percent;
	char *move_pv;
	char *lv_tags;
	char *mirror_log;
	char *modules;
};
typedef struct guestfs_int_lvm_lv guestfs_int_lvm_lv;

typedef struct {
	u_int guestfs_int_lvm_lv_list_len;
	guestfs_int_lvm_lv *guestfs_int_lvm_lv_list_val;
} guestfs_int_lvm_lv_list;

struct guestfs_int_stat {
	quad_t dev;
	quad_t ino;
	quad_t mode;
	quad_t nlink;
	quad_t uid;
	quad_t gid;
	quad_t rdev;
	quad_t size;
	quad_t blksize;
	quad_t blocks;
	quad_t atime;
	quad_t mtime;
	quad_t ctime;
};
typedef struct guestfs_int_stat guestfs_int_stat;

typedef struct {
	u_int guestfs_int_stat_list_len;
	guestfs_int_stat *guestfs_int_stat_list_val;
} guestfs_int_stat_list;

struct guestfs_int_statvfs {
	quad_t bsize;
	quad_t frsize;
	quad_t blocks;
	quad_t bfree;
	quad_t bavail;
	quad_t files;
	quad_t ffree;
	quad_t favail;
	quad_t fsid;
	quad_t flag;
	quad_t namemax;
};
typedef struct guestfs_int_statvfs guestfs_int_statvfs;

typedef struct {
	u_int guestfs_int_statvfs_list_len;
	guestfs_int_statvfs *guestfs_int_statvfs_list_val;
} guestfs_int_statvfs_list;

struct guestfs_int_dirent {
	quad_t ino;
	char ftyp;
	char *name;
};
typedef struct guestfs_int_dirent guestfs_int_dirent;

typedef struct {
	u_int guestfs_int_dirent_list_len;
	guestfs_int_dirent *guestfs_int_dirent_list_val;
} guestfs_int_dirent_list;

struct guestfs_int_version {
	quad_t major;
	quad_t minor;
	quad_t release;
	char *extra;
};
typedef struct guestfs_int_version guestfs_int_version;

typedef struct {
	u_int guestfs_int_version_list_len;
	guestfs_int_version *guestfs_int_version_list_val;
} guestfs_int_version_list;

struct guestfs_int_xattr {
	char *attrname;
	struct {
		u_int attrval_len;
		char *attrval_val;
	} attrval;
};
typedef struct guestfs_int_xattr guestfs_int_xattr;

typedef struct {
	u_int guestfs_int_xattr_list_len;
	guestfs_int_xattr *guestfs_int_xattr_list_val;
} guestfs_int_xattr_list;

struct guestfs_int_inotify_event {
	quad_t in_wd;
	int in_mask;
	int in_cookie;
	char *in_name;
};
typedef struct guestfs_int_inotify_event guestfs_int_inotify_event;

typedef struct {
	u_int guestfs_int_inotify_event_list_len;
	guestfs_int_inotify_event *guestfs_int_inotify_event_list_val;
} guestfs_int_inotify_event_list;

struct guestfs_int_partition {
	int part_num;
	quad_t part_start;
	quad_t part_end;
	quad_t part_size;
};
typedef struct guestfs_int_partition guestfs_int_partition;

typedef struct {
	u_int guestfs_int_partition_list_len;
	guestfs_int_partition *guestfs_int_partition_list_val;
} guestfs_int_partition_list;

struct guestfs_int_application {
	char *app_name;
	char *app_display_name;
	int app_epoch;
	char *app_version;
	char *app_release;
	char *app_install_path;
	char *app_trans_path;
	char *app_publisher;
	char *app_url;
	char *app_source_package;
	char *app_summary;
	char *app_description;
};
typedef struct guestfs_int_application guestfs_int_application;

typedef struct {
	u_int guestfs_int_application_list_len;
	guestfs_int_application *guestfs_int_application_list_val;
} guestfs_int_application_list;

struct guestfs_mount_args {
	char *device;
	char *mountpoint;
};
typedef struct guestfs_mount_args guestfs_mount_args;

struct guestfs_touch_args {
	char *path;
};
typedef struct guestfs_touch_args guestfs_touch_args;

struct guestfs_cat_args {
	char *path;
};
typedef struct guestfs_cat_args guestfs_cat_args;

struct guestfs_cat_ret {
	char *content;
};
typedef struct guestfs_cat_ret guestfs_cat_ret;

struct guestfs_ll_args {
	char *directory;
};
typedef struct guestfs_ll_args guestfs_ll_args;

struct guestfs_ll_ret {
	char *listing;
};
typedef struct guestfs_ll_ret guestfs_ll_ret;

struct guestfs_ls_args {
	char *directory;
};
typedef struct guestfs_ls_args guestfs_ls_args;

struct guestfs_ls_ret {
	struct {
		u_int listing_len;
		guestfs_str *listing_val;
	} listing;
};
typedef struct guestfs_ls_ret guestfs_ls_ret;

struct guestfs_list_devices_ret {
	struct {
		u_int devices_len;
		guestfs_str *devices_val;
	} devices;
};
typedef struct guestfs_list_devices_ret guestfs_list_devices_ret;

struct guestfs_list_partitions_ret {
	struct {
		u_int partitions_len;
		guestfs_str *partitions_val;
	} partitions;
};
typedef struct guestfs_list_partitions_ret guestfs_list_partitions_ret;

struct guestfs_pvs_ret {
	struct {
		u_int physvols_len;
		guestfs_str *physvols_val;
	} physvols;
};
typedef struct guestfs_pvs_ret guestfs_pvs_ret;

struct guestfs_vgs_ret {
	struct {
		u_int volgroups_len;
		guestfs_str *volgroups_val;
	} volgroups;
};
typedef struct guestfs_vgs_ret guestfs_vgs_ret;

struct guestfs_lvs_ret {
	struct {
		u_int logvols_len;
		guestfs_str *logvols_val;
	} logvols;
};
typedef struct guestfs_lvs_ret guestfs_lvs_ret;

struct guestfs_pvs_full_ret {
	guestfs_int_lvm_pv_list physvols;
};
typedef struct guestfs_pvs_full_ret guestfs_pvs_full_ret;

struct guestfs_vgs_full_ret {
	guestfs_int_lvm_vg_list volgroups;
};
typedef struct guestfs_vgs_full_ret guestfs_vgs_full_ret;

struct guestfs_lvs_full_ret {
	guestfs_int_lvm_lv_list logvols;
};
typedef struct guestfs_lvs_full_ret guestfs_lvs_full_ret;

struct guestfs_read_lines_args {
	char *path;
};
typedef struct guestfs_read_lines_args guestfs_read_lines_args;

struct guestfs_read_lines_ret {
	struct {
		u_int lines_len;
		guestfs_str *lines_val;
	} lines;
};
typedef struct guestfs_read_lines_ret guestfs_read_lines_ret;

struct guestfs_aug_init_args {
	char *root;
	int flags;
};
typedef struct guestfs_aug_init_args guestfs_aug_init_args;

struct guestfs_aug_defvar_args {
	char *name;
	guestfs_str *expr;
};
typedef struct guestfs_aug_defvar_args guestfs_aug_defvar_args;

struct guestfs_aug_defvar_ret {
	int nrnodes;
};
typedef struct guestfs_aug_defvar_ret guestfs_aug_defvar_ret;

struct guestfs_aug_defnode_args {
	char *name;
	char *expr;
	char *val;
};
typedef struct guestfs_aug_defnode_args guestfs_aug_defnode_args;

struct guestfs_aug_defnode_ret {
	guestfs_int_int_bool nrnodescreated;
};
typedef struct guestfs_aug_defnode_ret guestfs_aug_defnode_ret;

struct guestfs_aug_get_args {
	char *augpath;
};
typedef struct guestfs_aug_get_args guestfs_aug_get_args;

struct guestfs_aug_get_ret {
	char *val;
};
typedef struct guestfs_aug_get_ret guestfs_aug_get_ret;

struct guestfs_aug_set_args {
	char *augpath;
	char *val;
};
typedef struct guestfs_aug_set_args guestfs_aug_set_args;

struct guestfs_aug_insert_args {
	char *augpath;
	char *label;
	bool_t before;
};
typedef struct guestfs_aug_insert_args guestfs_aug_insert_args;

struct guestfs_aug_rm_args {
	char *augpath;
};
typedef struct guestfs_aug_rm_args guestfs_aug_rm_args;

struct guestfs_aug_rm_ret {
	int nrnodes;
};
typedef struct guestfs_aug_rm_ret guestfs_aug_rm_ret;

struct guestfs_aug_mv_args {
	char *src;
	char *dest;
};
typedef struct guestfs_aug_mv_args guestfs_aug_mv_args;

struct guestfs_aug_match_args {
	char *augpath;
};
typedef struct guestfs_aug_match_args guestfs_aug_match_args;

struct guestfs_aug_match_ret {
	struct {
		u_int matches_len;
		guestfs_str *matches_val;
	} matches;
};
typedef struct guestfs_aug_match_ret guestfs_aug_match_ret;

struct guestfs_aug_ls_args {
	char *augpath;
};
typedef struct guestfs_aug_ls_args guestfs_aug_ls_args;

struct guestfs_aug_ls_ret {
	struct {
		u_int matches_len;
		guestfs_str *matches_val;
	} matches;
};
typedef struct guestfs_aug_ls_ret guestfs_aug_ls_ret;

struct guestfs_rm_args {
	char *path;
};
typedef struct guestfs_rm_args guestfs_rm_args;

struct guestfs_rmdir_args {
	char *path;
};
typedef struct guestfs_rmdir_args guestfs_rmdir_args;

struct guestfs_rm_rf_args {
	char *path;
};
typedef struct guestfs_rm_rf_args guestfs_rm_rf_args;

struct guestfs_mkdir_args {
	char *path;
};
typedef struct guestfs_mkdir_args guestfs_mkdir_args;

struct guestfs_mkdir_p_args {
	char *path;
};
typedef struct guestfs_mkdir_p_args guestfs_mkdir_p_args;

struct guestfs_chmod_args {
	int mode;
	char *path;
};
typedef struct guestfs_chmod_args guestfs_chmod_args;

struct guestfs_chown_args {
	int owner;
	int group;
	char *path;
};
typedef struct guestfs_chown_args guestfs_chown_args;

struct guestfs_exists_args {
	char *path;
};
typedef struct guestfs_exists_args guestfs_exists_args;

struct guestfs_exists_ret {
	bool_t existsflag;
};
typedef struct guestfs_exists_ret guestfs_exists_ret;

struct guestfs_is_file_args {
	char *path;
};
typedef struct guestfs_is_file_args guestfs_is_file_args;

struct guestfs_is_file_ret {
	bool_t fileflag;
};
typedef struct guestfs_is_file_ret guestfs_is_file_ret;

struct guestfs_is_dir_args {
	char *path;
};
typedef struct guestfs_is_dir_args guestfs_is_dir_args;

struct guestfs_is_dir_ret {
	bool_t dirflag;
};
typedef struct guestfs_is_dir_ret guestfs_is_dir_ret;

struct guestfs_pvcreate_args {
	char *device;
};
typedef struct guestfs_pvcreate_args guestfs_pvcreate_args;

struct guestfs_vgcreate_args {
	char *volgroup;
	struct {
		u_int physvols_len;
		guestfs_str *physvols_val;
	} physvols;
};
typedef struct guestfs_vgcreate_args guestfs_vgcreate_args;

struct guestfs_lvcreate_args {
	char *logvol;
	char *volgroup;
	int mbytes;
};
typedef struct guestfs_lvcreate_args guestfs_lvcreate_args;

struct guestfs_mkfs_args {
	char *fstype;
	char *device;
};
typedef struct guestfs_mkfs_args guestfs_mkfs_args;

struct guestfs_sfdisk_args {
	char *device;
	int cyls;
	int heads;
	int sectors;
	struct {
		u_int lines_len;
		guestfs_str *lines_val;
	} lines;
};
typedef struct guestfs_sfdisk_args guestfs_sfdisk_args;

struct guestfs_write_file_args {
	char *path;
	char *content;
	int size;
};
typedef struct guestfs_write_file_args guestfs_write_file_args;

struct guestfs_umount_args {
	char *pathordevice;
};
typedef struct guestfs_umount_args guestfs_umount_args;

struct guestfs_mounts_ret {
	struct {
		u_int devices_len;
		guestfs_str *devices_val;
	} devices;
};
typedef struct guestfs_mounts_ret guestfs_mounts_ret;

struct guestfs_file_args {
	char *path;
};
typedef struct guestfs_file_args guestfs_file_args;

struct guestfs_file_ret {
	char *description;
};
typedef struct guestfs_file_ret guestfs_file_ret;

struct guestfs_command_args {
	struct {
		u_int arguments_len;
		guestfs_str *arguments_val;
	} arguments;
};
typedef struct guestfs_command_args guestfs_command_args;

struct guestfs_command_ret {
	char *output;
};
typedef struct guestfs_command_ret guestfs_command_ret;

struct guestfs_command_lines_args {
	struct {
		u_int arguments_len;
		guestfs_str *arguments_val;
	} arguments;
};
typedef struct guestfs_command_lines_args guestfs_command_lines_args;

struct guestfs_command_lines_ret {
	struct {
		u_int lines_len;
		guestfs_str *lines_val;
	} lines;
};
typedef struct guestfs_command_lines_ret guestfs_command_lines_ret;

struct guestfs_stat_args {
	char *path;
};
typedef struct guestfs_stat_args guestfs_stat_args;

struct guestfs_stat_ret {
	guestfs_int_stat statbuf;
};
typedef struct guestfs_stat_ret guestfs_stat_ret;

struct guestfs_lstat_args {
	char *path;
};
typedef struct guestfs_lstat_args guestfs_lstat_args;

struct guestfs_lstat_ret {
	guestfs_int_stat statbuf;
};
typedef struct guestfs_lstat_ret guestfs_lstat_ret;

struct guestfs_statvfs_args {
	char *path;
};
typedef struct guestfs_statvfs_args guestfs_statvfs_args;

struct guestfs_statvfs_ret {
	guestfs_int_statvfs statbuf;
};
typedef struct guestfs_statvfs_ret guestfs_statvfs_ret;

struct guestfs_tune2fs_l_args {
	char *device;
};
typedef struct guestfs_tune2fs_l_args guestfs_tune2fs_l_args;

struct guestfs_tune2fs_l_ret {
	struct {
		u_int superblock_len;
		guestfs_str *superblock_val;
	} superblock;
};
typedef struct guestfs_tune2fs_l_ret guestfs_tune2fs_l_ret;

struct guestfs_blockdev_setro_args {
	char *device;
};
typedef struct guestfs_blockdev_setro_args guestfs_blockdev_setro_args;

struct guestfs_blockdev_setrw_args {
	char *device;
};
typedef struct guestfs_blockdev_setrw_args guestfs_blockdev_setrw_args;

struct guestfs_blockdev_getro_args {
	char *device;
};
typedef struct guestfs_blockdev_getro_args guestfs_blockdev_getro_args;

struct guestfs_blockdev_getro_ret {
	bool_t ro;
};
typedef struct guestfs_blockdev_getro_ret guestfs_blockdev_getro_ret;

struct guestfs_blockdev_getss_args {
	char *device;
};
typedef struct guestfs_blockdev_getss_args guestfs_blockdev_getss_args;

struct guestfs_blockdev_getss_ret {
	int sectorsize;
};
typedef struct guestfs_blockdev_getss_ret guestfs_blockdev_getss_ret;

struct guestfs_blockdev_getbsz_args {
	char *device;
};
typedef struct guestfs_blockdev_getbsz_args guestfs_blockdev_getbsz_args;

struct guestfs_blockdev_getbsz_ret {
	int blocksize;
};
typedef struct guestfs_blockdev_getbsz_ret guestfs_blockdev_getbsz_ret;

struct guestfs_blockdev_setbsz_args {
	char *device;
	int blocksize;
};
typedef struct guestfs_blockdev_setbsz_args guestfs_blockdev_setbsz_args;

struct guestfs_blockdev_getsz_args {
	char *device;
};
typedef struct guestfs_blockdev_getsz_args guestfs_blockdev_getsz_args;

struct guestfs_blockdev_getsz_ret {
	quad_t sizeinsectors;
};
typedef struct guestfs_blockdev_getsz_ret guestfs_blockdev_getsz_ret;

struct guestfs_blockdev_getsize64_args {
	char *device;
};
typedef struct guestfs_blockdev_getsize64_args guestfs_blockdev_getsize64_args;

struct guestfs_blockdev_getsize64_ret {
	quad_t sizeinbytes;
};
typedef struct guestfs_blockdev_getsize64_ret guestfs_blockdev_getsize64_ret;

struct guestfs_blockdev_flushbufs_args {
	char *device;
};
typedef struct guestfs_blockdev_flushbufs_args guestfs_blockdev_flushbufs_args;

struct guestfs_blockdev_rereadpt_args {
	char *device;
};
typedef struct guestfs_blockdev_rereadpt_args guestfs_blockdev_rereadpt_args;

struct guestfs_upload_args {
	char *remotefilename;
};
typedef struct guestfs_upload_args guestfs_upload_args;

struct guestfs_download_args {
	char *remotefilename;
};
typedef struct guestfs_download_args guestfs_download_args;

struct guestfs_checksum_args {
	char *csumtype;
	char *path;
};
typedef struct guestfs_checksum_args guestfs_checksum_args;

struct guestfs_checksum_ret {
	char *checksum;
};
typedef struct guestfs_checksum_ret guestfs_checksum_ret;

struct guestfs_tar_in_args {
	char *directory;
};
typedef struct guestfs_tar_in_args guestfs_tar_in_args;

struct guestfs_tar_out_args {
	char *directory;
};
typedef struct guestfs_tar_out_args guestfs_tar_out_args;

struct guestfs_tgz_in_args {
	char *directory;
};
typedef struct guestfs_tgz_in_args guestfs_tgz_in_args;

struct guestfs_tgz_out_args {
	char *directory;
};
typedef struct guestfs_tgz_out_args guestfs_tgz_out_args;

struct guestfs_mount_ro_args {
	char *device;
	char *mountpoint;
};
typedef struct guestfs_mount_ro_args guestfs_mount_ro_args;

struct guestfs_mount_options_args {
	char *options;
	char *device;
	char *mountpoint;
};
typedef struct guestfs_mount_options_args guestfs_mount_options_args;

struct guestfs_mount_vfs_args {
	char *options;
	char *vfstype;
	char *device;
	char *mountpoint;
};
typedef struct guestfs_mount_vfs_args guestfs_mount_vfs_args;

struct guestfs_debug_args {
	char *subcmd;
	struct {
		u_int extraargs_len;
		guestfs_str *extraargs_val;
	} extraargs;
};
typedef struct guestfs_debug_args guestfs_debug_args;

struct guestfs_debug_ret {
	char *result;
};
typedef struct guestfs_debug_ret guestfs_debug_ret;

struct guestfs_lvremove_args {
	char *device;
};
typedef struct guestfs_lvremove_args guestfs_lvremove_args;

struct guestfs_vgremove_args {
	char *vgname;
};
typedef struct guestfs_vgremove_args guestfs_vgremove_args;

struct guestfs_pvremove_args {
	char *device;
};
typedef struct guestfs_pvremove_args guestfs_pvremove_args;

struct guestfs_set_e2label_args {
	char *device;
	char *label;
};
typedef struct guestfs_set_e2label_args guestfs_set_e2label_args;

struct guestfs_get_e2label_args {
	char *device;
};
typedef struct guestfs_get_e2label_args guestfs_get_e2label_args;

struct guestfs_get_e2label_ret {
	char *label;
};
typedef struct guestfs_get_e2label_ret guestfs_get_e2label_ret;

struct guestfs_set_e2uuid_args {
	char *device;
	char *uuid;
};
typedef struct guestfs_set_e2uuid_args guestfs_set_e2uuid_args;

struct guestfs_get_e2uuid_args {
	char *device;
};
typedef struct guestfs_get_e2uuid_args guestfs_get_e2uuid_args;

struct guestfs_get_e2uuid_ret {
	char *uuid;
};
typedef struct guestfs_get_e2uuid_ret guestfs_get_e2uuid_ret;

struct guestfs_fsck_args {
	char *fstype;
	char *device;
};
typedef struct guestfs_fsck_args guestfs_fsck_args;

struct guestfs_fsck_ret {
	int status;
};
typedef struct guestfs_fsck_ret guestfs_fsck_ret;

struct guestfs_zero_args {
	char *device;
};
typedef struct guestfs_zero_args guestfs_zero_args;

struct guestfs_grub_install_args {
	char *root;
	char *device;
};
typedef struct guestfs_grub_install_args guestfs_grub_install_args;

struct guestfs_cp_args {
	char *src;
	char *dest;
};
typedef struct guestfs_cp_args guestfs_cp_args;

struct guestfs_cp_a_args {
	char *src;
	char *dest;
};
typedef struct guestfs_cp_a_args guestfs_cp_a_args;

struct guestfs_mv_args {
	char *src;
	char *dest;
};
typedef struct guestfs_mv_args guestfs_mv_args;

struct guestfs_drop_caches_args {
	int whattodrop;
};
typedef struct guestfs_drop_caches_args guestfs_drop_caches_args;

struct guestfs_dmesg_ret {
	char *kmsgs;
};
typedef struct guestfs_dmesg_ret guestfs_dmesg_ret;

struct guestfs_equal_args {
	char *file1;
	char *file2;
};
typedef struct guestfs_equal_args guestfs_equal_args;

struct guestfs_equal_ret {
	bool_t equality;
};
typedef struct guestfs_equal_ret guestfs_equal_ret;

struct guestfs_strings_args {
	char *path;
};
typedef struct guestfs_strings_args guestfs_strings_args;

struct guestfs_strings_ret {
	struct {
		u_int stringsout_len;
		guestfs_str *stringsout_val;
	} stringsout;
};
typedef struct guestfs_strings_ret guestfs_strings_ret;

struct guestfs_strings_e_args {
	char *encoding;
	char *path;
};
typedef struct guestfs_strings_e_args guestfs_strings_e_args;

struct guestfs_strings_e_ret {
	struct {
		u_int stringsout_len;
		guestfs_str *stringsout_val;
	} stringsout;
};
typedef struct guestfs_strings_e_ret guestfs_strings_e_ret;

struct guestfs_hexdump_args {
	char *path;
};
typedef struct guestfs_hexdump_args guestfs_hexdump_args;

struct guestfs_hexdump_ret {
	char *dump;
};
typedef struct guestfs_hexdump_ret guestfs_hexdump_ret;

struct guestfs_zerofree_args {
	char *device;
};
typedef struct guestfs_zerofree_args guestfs_zerofree_args;

struct guestfs_pvresize_args {
	char *device;
};
typedef struct guestfs_pvresize_args guestfs_pvresize_args;

struct guestfs_sfdisk_N_args {
	char *device;
	int partnum;
	int cyls;
	int heads;
	int sectors;
	char *line;
};
typedef struct guestfs_sfdisk_N_args guestfs_sfdisk_N_args;

struct guestfs_sfdisk_l_args {
	char *device;
};
typedef struct guestfs_sfdisk_l_args guestfs_sfdisk_l_args;

struct guestfs_sfdisk_l_ret {
	char *partitions;
};
typedef struct guestfs_sfdisk_l_ret guestfs_sfdisk_l_ret;

struct guestfs_sfdisk_kernel_geometry_args {
	char *device;
};
typedef struct guestfs_sfdisk_kernel_geometry_args guestfs_sfdisk_kernel_geometry_args;

struct guestfs_sfdisk_kernel_geometry_ret {
	char *partitions;
};
typedef struct guestfs_sfdisk_kernel_geometry_ret guestfs_sfdisk_kernel_geometry_ret;

struct guestfs_sfdisk_disk_geometry_args {
	char *device;
};
typedef struct guestfs_sfdisk_disk_geometry_args guestfs_sfdisk_disk_geometry_args;

struct guestfs_sfdisk_disk_geometry_ret {
	char *partitions;
};
typedef struct guestfs_sfdisk_disk_geometry_ret guestfs_sfdisk_disk_geometry_ret;

struct guestfs_vg_activate_all_args {
	bool_t activate;
};
typedef struct guestfs_vg_activate_all_args guestfs_vg_activate_all_args;

struct guestfs_vg_activate_args {
	bool_t activate;
	struct {
		u_int volgroups_len;
		guestfs_str *volgroups_val;
	} volgroups;
};
typedef struct guestfs_vg_activate_args guestfs_vg_activate_args;

struct guestfs_lvresize_args {
	char *device;
	int mbytes;
};
typedef struct guestfs_lvresize_args guestfs_lvresize_args;

struct guestfs_resize2fs_args {
	char *device;
};
typedef struct guestfs_resize2fs_args guestfs_resize2fs_args;

struct guestfs_find_args {
	char *directory;
};
typedef struct guestfs_find_args guestfs_find_args;

struct guestfs_find_ret {
	struct {
		u_int names_len;
		guestfs_str *names_val;
	} names;
};
typedef struct guestfs_find_ret guestfs_find_ret;

struct guestfs_e2fsck_f_args {
	char *device;
};
typedef struct guestfs_e2fsck_f_args guestfs_e2fsck_f_args;

struct guestfs_sleep_args {
	int secs;
};
typedef struct guestfs_sleep_args guestfs_sleep_args;

struct guestfs_ntfs_3g_probe_args {
	bool_t rw;
	char *device;
};
typedef struct guestfs_ntfs_3g_probe_args guestfs_ntfs_3g_probe_args;

struct guestfs_ntfs_3g_probe_ret {
	int status;
};
typedef struct guestfs_ntfs_3g_probe_ret guestfs_ntfs_3g_probe_ret;

struct guestfs_sh_args {
	char *command;
};
typedef struct guestfs_sh_args guestfs_sh_args;

struct guestfs_sh_ret {
	char *output;
};
typedef struct guestfs_sh_ret guestfs_sh_ret;

struct guestfs_sh_lines_args {
	char *command;
};
typedef struct guestfs_sh_lines_args guestfs_sh_lines_args;

struct guestfs_sh_lines_ret {
	struct {
		u_int lines_len;
		guestfs_str *lines_val;
	} lines;
};
typedef struct guestfs_sh_lines_ret guestfs_sh_lines_ret;

struct guestfs_glob_expand_args {
	char *pattern;
};
typedef struct guestfs_glob_expand_args guestfs_glob_expand_args;

struct guestfs_glob_expand_ret {
	struct {
		u_int paths_len;
		guestfs_str *paths_val;
	} paths;
};
typedef struct guestfs_glob_expand_ret guestfs_glob_expand_ret;

struct guestfs_scrub_device_args {
	char *device;
};
typedef struct guestfs_scrub_device_args guestfs_scrub_device_args;

struct guestfs_scrub_file_args {
	char *file;
};
typedef struct guestfs_scrub_file_args guestfs_scrub_file_args;

struct guestfs_scrub_freespace_args {
	char *dir;
};
typedef struct guestfs_scrub_freespace_args guestfs_scrub_freespace_args;

struct guestfs_mkdtemp_args {
	char *tmpl;
};
typedef struct guestfs_mkdtemp_args guestfs_mkdtemp_args;

struct guestfs_mkdtemp_ret {
	char *dir;
};
typedef struct guestfs_mkdtemp_ret guestfs_mkdtemp_ret;

struct guestfs_wc_l_args {
	char *path;
};
typedef struct guestfs_wc_l_args guestfs_wc_l_args;

struct guestfs_wc_l_ret {
	int lines;
};
typedef struct guestfs_wc_l_ret guestfs_wc_l_ret;

struct guestfs_wc_w_args {
	char *path;
};
typedef struct guestfs_wc_w_args guestfs_wc_w_args;

struct guestfs_wc_w_ret {
	int words;
};
typedef struct guestfs_wc_w_ret guestfs_wc_w_ret;

struct guestfs_wc_c_args {
	char *path;
};
typedef struct guestfs_wc_c_args guestfs_wc_c_args;

struct guestfs_wc_c_ret {
	int chars;
};
typedef struct guestfs_wc_c_ret guestfs_wc_c_ret;

struct guestfs_head_args {
	char *path;
};
typedef struct guestfs_head_args guestfs_head_args;

struct guestfs_head_ret {
	struct {
		u_int lines_len;
		guestfs_str *lines_val;
	} lines;
};
typedef struct guestfs_head_ret guestfs_head_ret;

struct guestfs_head_n_args {
	int nrlines;
	char *path;
};
typedef struct guestfs_head_n_args guestfs_head_n_args;

struct guestfs_head_n_ret {
	struct {
		u_int lines_len;
		guestfs_str *lines_val;
	} lines;
};
typedef struct guestfs_head_n_ret guestfs_head_n_ret;

struct guestfs_tail_args {
	char *path;
};
typedef struct guestfs_tail_args guestfs_tail_args;

struct guestfs_tail_ret {
	struct {
		u_int lines_len;
		guestfs_str *lines_val;
	} lines;
};
typedef struct guestfs_tail_ret guestfs_tail_ret;

struct guestfs_tail_n_args {
	int nrlines;
	char *path;
};
typedef struct guestfs_tail_n_args guestfs_tail_n_args;

struct guestfs_tail_n_ret {
	struct {
		u_int lines_len;
		guestfs_str *lines_val;
	} lines;
};
typedef struct guestfs_tail_n_ret guestfs_tail_n_ret;

struct guestfs_df_ret {
	char *output;
};
typedef struct guestfs_df_ret guestfs_df_ret;

struct guestfs_df_h_ret {
	char *output;
};
typedef struct guestfs_df_h_ret guestfs_df_h_ret;

struct guestfs_du_args {
	char *path;
};
typedef struct guestfs_du_args guestfs_du_args;

struct guestfs_du_ret {
	quad_t sizekb;
};
typedef struct guestfs_du_ret guestfs_du_ret;

struct guestfs_initrd_list_args {
	char *path;
};
typedef struct guestfs_initrd_list_args guestfs_initrd_list_args;

struct guestfs_initrd_list_ret {
	struct {
		u_int filenames_len;
		guestfs_str *filenames_val;
	} filenames;
};
typedef struct guestfs_initrd_list_ret guestfs_initrd_list_ret;

struct guestfs_mount_loop_args {
	char *file;
	char *mountpoint;
};
typedef struct guestfs_mount_loop_args guestfs_mount_loop_args;

struct guestfs_mkswap_args {
	char *device;
};
typedef struct guestfs_mkswap_args guestfs_mkswap_args;

struct guestfs_mkswap_L_args {
	char *label;
	char *device;
};
typedef struct guestfs_mkswap_L_args guestfs_mkswap_L_args;

struct guestfs_mkswap_U_args {
	char *uuid;
	char *device;
};
typedef struct guestfs_mkswap_U_args guestfs_mkswap_U_args;

struct guestfs_mknod_args {
	int mode;
	int devmajor;
	int devminor;
	char *path;
};
typedef struct guestfs_mknod_args guestfs_mknod_args;

struct guestfs_mkfifo_args {
	int mode;
	char *path;
};
typedef struct guestfs_mkfifo_args guestfs_mkfifo_args;

struct guestfs_mknod_b_args {
	int mode;
	int devmajor;
	int devminor;
	char *path;
};
typedef struct guestfs_mknod_b_args guestfs_mknod_b_args;

struct guestfs_mknod_c_args {
	int mode;
	int devmajor;
	int devminor;
	char *path;
};
typedef struct guestfs_mknod_c_args guestfs_mknod_c_args;

struct guestfs_umask_args {
	int mask;
};
typedef struct guestfs_umask_args guestfs_umask_args;

struct guestfs_umask_ret {
	int oldmask;
};
typedef struct guestfs_umask_ret guestfs_umask_ret;

struct guestfs_readdir_args {
	char *dir;
};
typedef struct guestfs_readdir_args guestfs_readdir_args;

struct guestfs_readdir_ret {
	guestfs_int_dirent_list entries;
};
typedef struct guestfs_readdir_ret guestfs_readdir_ret;

struct guestfs_sfdiskM_args {
	char *device;
	struct {
		u_int lines_len;
		guestfs_str *lines_val;
	} lines;
};
typedef struct guestfs_sfdiskM_args guestfs_sfdiskM_args;

struct guestfs_zfile_args {
	char *meth;
	char *path;
};
typedef struct guestfs_zfile_args guestfs_zfile_args;

struct guestfs_zfile_ret {
	char *description;
};
typedef struct guestfs_zfile_ret guestfs_zfile_ret;

struct guestfs_getxattrs_args {
	char *path;
};
typedef struct guestfs_getxattrs_args guestfs_getxattrs_args;

struct guestfs_getxattrs_ret {
	guestfs_int_xattr_list xattrs;
};
typedef struct guestfs_getxattrs_ret guestfs_getxattrs_ret;

struct guestfs_lgetxattrs_args {
	char *path;
};
typedef struct guestfs_lgetxattrs_args guestfs_lgetxattrs_args;

struct guestfs_lgetxattrs_ret {
	guestfs_int_xattr_list xattrs;
};
typedef struct guestfs_lgetxattrs_ret guestfs_lgetxattrs_ret;

struct guestfs_setxattr_args {
	char *xattr;
	char *val;
	int vallen;
	char *path;
};
typedef struct guestfs_setxattr_args guestfs_setxattr_args;

struct guestfs_lsetxattr_args {
	char *xattr;
	char *val;
	int vallen;
	char *path;
};
typedef struct guestfs_lsetxattr_args guestfs_lsetxattr_args;

struct guestfs_removexattr_args {
	char *xattr;
	char *path;
};
typedef struct guestfs_removexattr_args guestfs_removexattr_args;

struct guestfs_lremovexattr_args {
	char *xattr;
	char *path;
};
typedef struct guestfs_lremovexattr_args guestfs_lremovexattr_args;

struct guestfs_mountpoints_ret {
	struct {
		u_int mps_len;
		guestfs_str *mps_val;
	} mps;
};
typedef struct guestfs_mountpoints_ret guestfs_mountpoints_ret;

struct guestfs_mkmountpoint_args {
	char *exemptpath;
};
typedef struct guestfs_mkmountpoint_args guestfs_mkmountpoint_args;

struct guestfs_rmmountpoint_args {
	char *exemptpath;
};
typedef struct guestfs_rmmountpoint_args guestfs_rmmountpoint_args;

struct guestfs_read_file_args {
	char *path;
};
typedef struct guestfs_read_file_args guestfs_read_file_args;

struct guestfs_read_file_ret {
	struct {
		u_int content_len;
		char *content_val;
	} content;
};
typedef struct guestfs_read_file_ret guestfs_read_file_ret;

struct guestfs_grep_args {
	char *regex;
	char *path;
};
typedef struct guestfs_grep_args guestfs_grep_args;

struct guestfs_grep_ret {
	struct {
		u_int lines_len;
		guestfs_str *lines_val;
	} lines;
};
typedef struct guestfs_grep_ret guestfs_grep_ret;

struct guestfs_egrep_args {
	char *regex;
	char *path;
};
typedef struct guestfs_egrep_args guestfs_egrep_args;

struct guestfs_egrep_ret {
	struct {
		u_int lines_len;
		guestfs_str *lines_val;
	} lines;
};
typedef struct guestfs_egrep_ret guestfs_egrep_ret;

struct guestfs_fgrep_args {
	char *pattern;
	char *path;
};
typedef struct guestfs_fgrep_args guestfs_fgrep_args;

struct guestfs_fgrep_ret {
	struct {
		u_int lines_len;
		guestfs_str *lines_val;
	} lines;
};
typedef struct guestfs_fgrep_ret guestfs_fgrep_ret;

struct guestfs_grepi_args {
	char *regex;
	char *path;
};
typedef struct guestfs_grepi_args guestfs_grepi_args;

struct guestfs_grepi_ret {
	struct {
		u_int lines_len;
		guestfs_str *lines_val;
	} lines;
};
typedef struct guestfs_grepi_ret guestfs_grepi_ret;

struct guestfs_egrepi_args {
	char *regex;
	char *path;
};
typedef struct guestfs_egrepi_args guestfs_egrepi_args;

struct guestfs_egrepi_ret {
	struct {
		u_int lines_len;
		guestfs_str *lines_val;
	} lines;
};
typedef struct guestfs_egrepi_ret guestfs_egrepi_ret;

struct guestfs_fgrepi_args {
	char *pattern;
	char *path;
};
typedef struct guestfs_fgrepi_args guestfs_fgrepi_args;

struct guestfs_fgrepi_ret {
	struct {
		u_int lines_len;
		guestfs_str *lines_val;
	} lines;
};
typedef struct guestfs_fgrepi_ret guestfs_fgrepi_ret;

struct guestfs_zgrep_args {
	char *regex;
	char *path;
};
typedef struct guestfs_zgrep_args guestfs_zgrep_args;

struct guestfs_zgrep_ret {
	struct {
		u_int lines_len;
		guestfs_str *lines_val;
	} lines;
};
typedef struct guestfs_zgrep_ret guestfs_zgrep_ret;

struct guestfs_zegrep_args {
	char *regex;
	char *path;
};
typedef struct guestfs_zegrep_args guestfs_zegrep_args;

struct guestfs_zegrep_ret {
	struct {
		u_int lines_len;
		guestfs_str *lines_val;
	} lines;
};
typedef struct guestfs_zegrep_ret guestfs_zegrep_ret;

struct guestfs_zfgrep_args {
	char *pattern;
	char *path;
};
typedef struct guestfs_zfgrep_args guestfs_zfgrep_args;

struct guestfs_zfgrep_ret {
	struct {
		u_int lines_len;
		guestfs_str *lines_val;
	} lines;
};
typedef struct guestfs_zfgrep_ret guestfs_zfgrep_ret;

struct guestfs_zgrepi_args {
	char *regex;
	char *path;
};
typedef struct guestfs_zgrepi_args guestfs_zgrepi_args;

struct guestfs_zgrepi_ret {
	struct {
		u_int lines_len;
		guestfs_str *lines_val;
	} lines;
};
typedef struct guestfs_zgrepi_ret guestfs_zgrepi_ret;

struct guestfs_zegrepi_args {
	char *regex;
	char *path;
};
typedef struct guestfs_zegrepi_args guestfs_zegrepi_args;

struct guestfs_zegrepi_ret {
	struct {
		u_int lines_len;
		guestfs_str *lines_val;
	} lines;
};
typedef struct guestfs_zegrepi_ret guestfs_zegrepi_ret;

struct guestfs_zfgrepi_args {
	char *pattern;
	char *path;
};
typedef struct guestfs_zfgrepi_args guestfs_zfgrepi_args;

struct guestfs_zfgrepi_ret {
	struct {
		u_int lines_len;
		guestfs_str *lines_val;
	} lines;
};
typedef struct guestfs_zfgrepi_ret guestfs_zfgrepi_ret;

struct guestfs_realpath_args {
	char *path;
};
typedef struct guestfs_realpath_args guestfs_realpath_args;

struct guestfs_realpath_ret {
	char *rpath;
};
typedef struct guestfs_realpath_ret guestfs_realpath_ret;

struct guestfs_ln_args {
	char *target;
	char *linkname;
};
typedef struct guestfs_ln_args guestfs_ln_args;

struct guestfs_ln_f_args {
	char *target;
	char *linkname;
};
typedef struct guestfs_ln_f_args guestfs_ln_f_args;

struct guestfs_ln_s_args {
	char *target;
	char *linkname;
};
typedef struct guestfs_ln_s_args guestfs_ln_s_args;

struct guestfs_ln_sf_args {
	char *target;
	char *linkname;
};
typedef struct guestfs_ln_sf_args guestfs_ln_sf_args;

struct guestfs_readlink_args {
	char *path;
};
typedef struct guestfs_readlink_args guestfs_readlink_args;

struct guestfs_readlink_ret {
	char *link;
};
typedef struct guestfs_readlink_ret guestfs_readlink_ret;

struct guestfs_fallocate_args {
	char *path;
	int len;
};
typedef struct guestfs_fallocate_args guestfs_fallocate_args;

struct guestfs_swapon_device_args {
	char *device;
};
typedef struct guestfs_swapon_device_args guestfs_swapon_device_args;

struct guestfs_swapoff_device_args {
	char *device;
};
typedef struct guestfs_swapoff_device_args guestfs_swapoff_device_args;

struct guestfs_swapon_file_args {
	char *file;
};
typedef struct guestfs_swapon_file_args guestfs_swapon_file_args;

struct guestfs_swapoff_file_args {
	char *file;
};
typedef struct guestfs_swapoff_file_args guestfs_swapoff_file_args;

struct guestfs_swapon_label_args {
	char *label;
};
typedef struct guestfs_swapon_label_args guestfs_swapon_label_args;

struct guestfs_swapoff_label_args {
	char *label;
};
typedef struct guestfs_swapoff_label_args guestfs_swapoff_label_args;

struct guestfs_swapon_uuid_args {
	char *uuid;
};
typedef struct guestfs_swapon_uuid_args guestfs_swapon_uuid_args;

struct guestfs_swapoff_uuid_args {
	char *uuid;
};
typedef struct guestfs_swapoff_uuid_args guestfs_swapoff_uuid_args;

struct guestfs_mkswap_file_args {
	char *path;
};
typedef struct guestfs_mkswap_file_args guestfs_mkswap_file_args;

struct guestfs_inotify_init_args {
	int maxevents;
};
typedef struct guestfs_inotify_init_args guestfs_inotify_init_args;

struct guestfs_inotify_add_watch_args {
	char *path;
	int mask;
};
typedef struct guestfs_inotify_add_watch_args guestfs_inotify_add_watch_args;

struct guestfs_inotify_add_watch_ret {
	quad_t wd;
};
typedef struct guestfs_inotify_add_watch_ret guestfs_inotify_add_watch_ret;

struct guestfs_inotify_rm_watch_args {
	int wd;
};
typedef struct guestfs_inotify_rm_watch_args guestfs_inotify_rm_watch_args;

struct guestfs_inotify_read_ret {
	guestfs_int_inotify_event_list events;
};
typedef struct guestfs_inotify_read_ret guestfs_inotify_read_ret;

struct guestfs_inotify_files_ret {
	struct {
		u_int paths_len;
		guestfs_str *paths_val;
	} paths;
};
typedef struct guestfs_inotify_files_ret guestfs_inotify_files_ret;

struct guestfs_setcon_args {
	char *context;
};
typedef struct guestfs_setcon_args guestfs_setcon_args;

struct guestfs_getcon_ret {
	char *context;
};
typedef struct guestfs_getcon_ret guestfs_getcon_ret;

struct guestfs_mkfs_b_args {
	char *fstype;
	int blocksize;
	char *device;
};
typedef struct guestfs_mkfs_b_args guestfs_mkfs_b_args;

struct guestfs_mke2journal_args {
	int blocksize;
	char *device;
};
typedef struct guestfs_mke2journal_args guestfs_mke2journal_args;

struct guestfs_mke2journal_L_args {
	int blocksize;
	char *label;
	char *device;
};
typedef struct guestfs_mke2journal_L_args guestfs_mke2journal_L_args;

struct guestfs_mke2journal_U_args {
	int blocksize;
	char *uuid;
	char *device;
};
typedef struct guestfs_mke2journal_U_args guestfs_mke2journal_U_args;

struct guestfs_mke2fs_J_args {
	char *fstype;
	int blocksize;
	char *device;
	char *journal;
};
typedef struct guestfs_mke2fs_J_args guestfs_mke2fs_J_args;

struct guestfs_mke2fs_JL_args {
	char *fstype;
	int blocksize;
	char *device;
	char *label;
};
typedef struct guestfs_mke2fs_JL_args guestfs_mke2fs_JL_args;

struct guestfs_mke2fs_JU_args {
	char *fstype;
	int blocksize;
	char *device;
	char *uuid;
};
typedef struct guestfs_mke2fs_JU_args guestfs_mke2fs_JU_args;

struct guestfs_modprobe_args {
	char *modulename;
};
typedef struct guestfs_modprobe_args guestfs_modprobe_args;

struct guestfs_echo_daemon_args {
	struct {
		u_int words_len;
		guestfs_str *words_val;
	} words;
};
typedef struct guestfs_echo_daemon_args guestfs_echo_daemon_args;

struct guestfs_echo_daemon_ret {
	char *output;
};
typedef struct guestfs_echo_daemon_ret guestfs_echo_daemon_ret;

struct guestfs_find0_args {
	char *directory;
};
typedef struct guestfs_find0_args guestfs_find0_args;

struct guestfs_case_sensitive_path_args {
	char *path;
};
typedef struct guestfs_case_sensitive_path_args guestfs_case_sensitive_path_args;

struct guestfs_case_sensitive_path_ret {
	char *rpath;
};
typedef struct guestfs_case_sensitive_path_ret guestfs_case_sensitive_path_ret;

struct guestfs_vfs_type_args {
	char *device;
};
typedef struct guestfs_vfs_type_args guestfs_vfs_type_args;

struct guestfs_vfs_type_ret {
	char *fstype;
};
typedef struct guestfs_vfs_type_ret guestfs_vfs_type_ret;

struct guestfs_truncate_args {
	char *path;
};
typedef struct guestfs_truncate_args guestfs_truncate_args;

struct guestfs_truncate_size_args {
	char *path;
	quad_t size;
};
typedef struct guestfs_truncate_size_args guestfs_truncate_size_args;

struct guestfs_utimens_args {
	char *path;
	quad_t atsecs;
	quad_t atnsecs;
	quad_t mtsecs;
	quad_t mtnsecs;
};
typedef struct guestfs_utimens_args guestfs_utimens_args;

struct guestfs_mkdir_mode_args {
	char *path;
	int mode;
};
typedef struct guestfs_mkdir_mode_args guestfs_mkdir_mode_args;

struct guestfs_lchown_args {
	int owner;
	int group;
	char *path;
};
typedef struct guestfs_lchown_args guestfs_lchown_args;

struct guestfs_lstatlist_args {
	char *path;
	struct {
		u_int names_len;
		guestfs_str *names_val;
	} names;
};
typedef struct guestfs_lstatlist_args guestfs_lstatlist_args;

struct guestfs_lstatlist_ret {
	guestfs_int_stat_list statbufs;
};
typedef struct guestfs_lstatlist_ret guestfs_lstatlist_ret;

struct guestfs_lxattrlist_args {
	char *path;
	struct {
		u_int names_len;
		guestfs_str *names_val;
	} names;
};
typedef struct guestfs_lxattrlist_args guestfs_lxattrlist_args;

struct guestfs_lxattrlist_ret {
	guestfs_int_xattr_list xattrs;
};
typedef struct guestfs_lxattrlist_ret guestfs_lxattrlist_ret;

struct guestfs_readlinklist_args {
	char *path;
	struct {
		u_int names_len;
		guestfs_str *names_val;
	} names;
};
typedef struct guestfs_readlinklist_args guestfs_readlinklist_args;

struct guestfs_readlinklist_ret {
	struct {
		u_int links_len;
		guestfs_str *links_val;
	} links;
};
typedef struct guestfs_readlinklist_ret guestfs_readlinklist_ret;

struct guestfs_pread_args {
	char *path;
	int count;
	quad_t offset;
};
typedef struct guestfs_pread_args guestfs_pread_args;

struct guestfs_pread_ret {
	struct {
		u_int content_len;
		char *content_val;
	} content;
};
typedef struct guestfs_pread_ret guestfs_pread_ret;

struct guestfs_part_init_args {
	char *device;
	char *parttype;
};
typedef struct guestfs_part_init_args guestfs_part_init_args;

struct guestfs_part_add_args {
	char *device;
	char *prlogex;
	quad_t startsect;
	quad_t endsect;
};
typedef struct guestfs_part_add_args guestfs_part_add_args;

struct guestfs_part_disk_args {
	char *device;
	char *parttype;
};
typedef struct guestfs_part_disk_args guestfs_part_disk_args;

struct guestfs_part_set_bootable_args {
	char *device;
	int partnum;
	bool_t bootable;
};
typedef struct guestfs_part_set_bootable_args guestfs_part_set_bootable_args;

struct guestfs_part_set_name_args {
	char *device;
	int partnum;
	char *name;
};
typedef struct guestfs_part_set_name_args guestfs_part_set_name_args;

struct guestfs_part_list_args {
	char *device;
};
typedef struct guestfs_part_list_args guestfs_part_list_args;

struct guestfs_part_list_ret {
	guestfs_int_partition_list partitions;
};
typedef struct guestfs_part_list_ret guestfs_part_list_ret;

struct guestfs_part_get_parttype_args {
	char *device;
};
typedef struct guestfs_part_get_parttype_args guestfs_part_get_parttype_args;

struct guestfs_part_get_parttype_ret {
	char *parttype;
};
typedef struct guestfs_part_get_parttype_ret guestfs_part_get_parttype_ret;

struct guestfs_fill_args {
	int c;
	int len;
	char *path;
};
typedef struct guestfs_fill_args guestfs_fill_args;

struct guestfs_available_args {
	struct {
		u_int groups_len;
		guestfs_str *groups_val;
	} groups;
};
typedef struct guestfs_available_args guestfs_available_args;

struct guestfs_dd_args {
	char *src;
	char *dest;
};
typedef struct guestfs_dd_args guestfs_dd_args;

struct guestfs_filesize_args {
	char *file;
};
typedef struct guestfs_filesize_args guestfs_filesize_args;

struct guestfs_filesize_ret {
	quad_t size;
};
typedef struct guestfs_filesize_ret guestfs_filesize_ret;

struct guestfs_lvrename_args {
	char *logvol;
	char *newlogvol;
};
typedef struct guestfs_lvrename_args guestfs_lvrename_args;

struct guestfs_vgrename_args {
	char *volgroup;
	char *newvolgroup;
};
typedef struct guestfs_vgrename_args guestfs_vgrename_args;

struct guestfs_initrd_cat_args {
	char *initrdpath;
	char *filename;
};
typedef struct guestfs_initrd_cat_args guestfs_initrd_cat_args;

struct guestfs_initrd_cat_ret {
	struct {
		u_int content_len;
		char *content_val;
	} content;
};
typedef struct guestfs_initrd_cat_ret guestfs_initrd_cat_ret;

struct guestfs_pvuuid_args {
	char *device;
};
typedef struct guestfs_pvuuid_args guestfs_pvuuid_args;

struct guestfs_pvuuid_ret {
	char *uuid;
};
typedef struct guestfs_pvuuid_ret guestfs_pvuuid_ret;

struct guestfs_vguuid_args {
	char *vgname;
};
typedef struct guestfs_vguuid_args guestfs_vguuid_args;

struct guestfs_vguuid_ret {
	char *uuid;
};
typedef struct guestfs_vguuid_ret guestfs_vguuid_ret;

struct guestfs_lvuuid_args {
	char *device;
};
typedef struct guestfs_lvuuid_args guestfs_lvuuid_args;

struct guestfs_lvuuid_ret {
	char *uuid;
};
typedef struct guestfs_lvuuid_ret guestfs_lvuuid_ret;

struct guestfs_vgpvuuids_args {
	char *vgname;
};
typedef struct guestfs_vgpvuuids_args guestfs_vgpvuuids_args;

struct guestfs_vgpvuuids_ret {
	struct {
		u_int uuids_len;
		guestfs_str *uuids_val;
	} uuids;
};
typedef struct guestfs_vgpvuuids_ret guestfs_vgpvuuids_ret;

struct guestfs_vglvuuids_args {
	char *vgname;
};
typedef struct guestfs_vglvuuids_args guestfs_vglvuuids_args;

struct guestfs_vglvuuids_ret {
	struct {
		u_int uuids_len;
		guestfs_str *uuids_val;
	} uuids;
};
typedef struct guestfs_vglvuuids_ret guestfs_vglvuuids_ret;

struct guestfs_copy_size_args {
	char *src;
	char *dest;
	quad_t size;
};
typedef struct guestfs_copy_size_args guestfs_copy_size_args;

struct guestfs_zero_device_args {
	char *device;
};
typedef struct guestfs_zero_device_args guestfs_zero_device_args;

struct guestfs_txz_in_args {
	char *directory;
};
typedef struct guestfs_txz_in_args guestfs_txz_in_args;

struct guestfs_txz_out_args {
	char *directory;
};
typedef struct guestfs_txz_out_args guestfs_txz_out_args;

struct guestfs_ntfsresize_args {
	char *device;
};
typedef struct guestfs_ntfsresize_args guestfs_ntfsresize_args;

struct guestfs_part_del_args {
	char *device;
	int partnum;
};
typedef struct guestfs_part_del_args guestfs_part_del_args;

struct guestfs_part_get_bootable_args {
	char *device;
	int partnum;
};
typedef struct guestfs_part_get_bootable_args guestfs_part_get_bootable_args;

struct guestfs_part_get_bootable_ret {
	bool_t bootable;
};
typedef struct guestfs_part_get_bootable_ret guestfs_part_get_bootable_ret;

struct guestfs_part_get_mbr_id_args {
	char *device;
	int partnum;
};
typedef struct guestfs_part_get_mbr_id_args guestfs_part_get_mbr_id_args;

struct guestfs_part_get_mbr_id_ret {
	int idbyte;
};
typedef struct guestfs_part_get_mbr_id_ret guestfs_part_get_mbr_id_ret;

struct guestfs_part_set_mbr_id_args {
	char *device;
	int partnum;
	int idbyte;
};
typedef struct guestfs_part_set_mbr_id_args guestfs_part_set_mbr_id_args;

struct guestfs_checksum_device_args {
	char *csumtype;
	char *device;
};
typedef struct guestfs_checksum_device_args guestfs_checksum_device_args;

struct guestfs_checksum_device_ret {
	char *checksum;
};
typedef struct guestfs_checksum_device_ret guestfs_checksum_device_ret;

struct guestfs_lvresize_free_args {
	char *lv;
	int percent;
};
typedef struct guestfs_lvresize_free_args guestfs_lvresize_free_args;

struct guestfs_aug_clear_args {
	char *augpath;
};
typedef struct guestfs_aug_clear_args guestfs_aug_clear_args;

struct guestfs_get_umask_ret {
	int mask;
};
typedef struct guestfs_get_umask_ret guestfs_get_umask_ret;

struct guestfs_debug_upload_args {
	char *tmpname;
	int mode;
};
typedef struct guestfs_debug_upload_args guestfs_debug_upload_args;

struct guestfs_base64_in_args {
	char *filename;
};
typedef struct guestfs_base64_in_args guestfs_base64_in_args;

struct guestfs_base64_out_args {
	char *filename;
};
typedef struct guestfs_base64_out_args guestfs_base64_out_args;

struct guestfs_checksums_out_args {
	char *csumtype;
	char *directory;
};
typedef struct guestfs_checksums_out_args guestfs_checksums_out_args;

struct guestfs_fill_pattern_args {
	char *pattern;
	int len;
	char *path;
};
typedef struct guestfs_fill_pattern_args guestfs_fill_pattern_args;

struct guestfs_write_args {
	char *path;
	struct {
		u_int content_len;
		char *content_val;
	} content;
};
typedef struct guestfs_write_args guestfs_write_args;

struct guestfs_pwrite_args {
	char *path;
	struct {
		u_int content_len;
		char *content_val;
	} content;
	quad_t offset;
};
typedef struct guestfs_pwrite_args guestfs_pwrite_args;

struct guestfs_pwrite_ret {
	int nbytes;
};
typedef struct guestfs_pwrite_ret guestfs_pwrite_ret;

struct guestfs_resize2fs_size_args {
	char *device;
	quad_t size;
};
typedef struct guestfs_resize2fs_size_args guestfs_resize2fs_size_args;

struct guestfs_pvresize_size_args {
	char *device;
	quad_t size;
};
typedef struct guestfs_pvresize_size_args guestfs_pvresize_size_args;

struct guestfs_ntfsresize_size_args {
	char *device;
	quad_t size;
};
typedef struct guestfs_ntfsresize_size_args guestfs_ntfsresize_size_args;

struct guestfs_available_all_groups_ret {
	struct {
		u_int groups_len;
		guestfs_str *groups_val;
	} groups;
};
typedef struct guestfs_available_all_groups_ret guestfs_available_all_groups_ret;

struct guestfs_fallocate64_args {
	char *path;
	quad_t len;
};
typedef struct guestfs_fallocate64_args guestfs_fallocate64_args;

struct guestfs_vfs_label_args {
	char *device;
};
typedef struct guestfs_vfs_label_args guestfs_vfs_label_args;

struct guestfs_vfs_label_ret {
	char *label;
};
typedef struct guestfs_vfs_label_ret guestfs_vfs_label_ret;

struct guestfs_vfs_uuid_args {
	char *device;
};
typedef struct guestfs_vfs_uuid_args guestfs_vfs_uuid_args;

struct guestfs_vfs_uuid_ret {
	char *uuid;
};
typedef struct guestfs_vfs_uuid_ret guestfs_vfs_uuid_ret;

struct guestfs_lvm_set_filter_args {
	struct {
		u_int devices_len;
		guestfs_str *devices_val;
	} devices;
};
typedef struct guestfs_lvm_set_filter_args guestfs_lvm_set_filter_args;

struct guestfs_luks_open_args {
	char *device;
	char *key;
	char *mapname;
};
typedef struct guestfs_luks_open_args guestfs_luks_open_args;

struct guestfs_luks_open_ro_args {
	char *device;
	char *key;
	char *mapname;
};
typedef struct guestfs_luks_open_ro_args guestfs_luks_open_ro_args;

struct guestfs_luks_close_args {
	char *device;
};
typedef struct guestfs_luks_close_args guestfs_luks_close_args;

struct guestfs_luks_format_args {
	char *device;
	char *key;
	int keyslot;
};
typedef struct guestfs_luks_format_args guestfs_luks_format_args;

struct guestfs_luks_format_cipher_args {
	char *device;
	char *key;
	int keyslot;
	char *cipher;
};
typedef struct guestfs_luks_format_cipher_args guestfs_luks_format_cipher_args;

struct guestfs_luks_add_key_args {
	char *device;
	char *key;
	char *newkey;
	int keyslot;
};
typedef struct guestfs_luks_add_key_args guestfs_luks_add_key_args;

struct guestfs_luks_kill_slot_args {
	char *device;
	char *key;
	int keyslot;
};
typedef struct guestfs_luks_kill_slot_args guestfs_luks_kill_slot_args;

struct guestfs_is_lv_args {
	char *device;
};
typedef struct guestfs_is_lv_args guestfs_is_lv_args;

struct guestfs_is_lv_ret {
	bool_t lvflag;
};
typedef struct guestfs_is_lv_ret guestfs_is_lv_ret;

struct guestfs_findfs_uuid_args {
	char *uuid;
};
typedef struct guestfs_findfs_uuid_args guestfs_findfs_uuid_args;

struct guestfs_findfs_uuid_ret {
	char *device;
};
typedef struct guestfs_findfs_uuid_ret guestfs_findfs_uuid_ret;

struct guestfs_findfs_label_args {
	char *label;
};
typedef struct guestfs_findfs_label_args guestfs_findfs_label_args;

struct guestfs_findfs_label_ret {
	char *device;
};
typedef struct guestfs_findfs_label_ret guestfs_findfs_label_ret;

struct guestfs_is_chardev_args {
	char *path;
};
typedef struct guestfs_is_chardev_args guestfs_is_chardev_args;

struct guestfs_is_chardev_ret {
	bool_t flag;
};
typedef struct guestfs_is_chardev_ret guestfs_is_chardev_ret;

struct guestfs_is_blockdev_args {
	char *path;
};
typedef struct guestfs_is_blockdev_args guestfs_is_blockdev_args;

struct guestfs_is_blockdev_ret {
	bool_t flag;
};
typedef struct guestfs_is_blockdev_ret guestfs_is_blockdev_ret;

struct guestfs_is_fifo_args {
	char *path;
};
typedef struct guestfs_is_fifo_args guestfs_is_fifo_args;

struct guestfs_is_fifo_ret {
	bool_t flag;
};
typedef struct guestfs_is_fifo_ret guestfs_is_fifo_ret;

struct guestfs_is_symlink_args {
	char *path;
};
typedef struct guestfs_is_symlink_args guestfs_is_symlink_args;

struct guestfs_is_symlink_ret {
	bool_t flag;
};
typedef struct guestfs_is_symlink_ret guestfs_is_symlink_ret;

struct guestfs_is_socket_args {
	char *path;
};
typedef struct guestfs_is_socket_args guestfs_is_socket_args;

struct guestfs_is_socket_ret {
	bool_t flag;
};
typedef struct guestfs_is_socket_ret guestfs_is_socket_ret;

struct guestfs_part_to_dev_args {
	char *partition;
};
typedef struct guestfs_part_to_dev_args guestfs_part_to_dev_args;

struct guestfs_part_to_dev_ret {
	char *device;
};
typedef struct guestfs_part_to_dev_ret guestfs_part_to_dev_ret;

struct guestfs_upload_offset_args {
	char *remotefilename;
	quad_t offset;
};
typedef struct guestfs_upload_offset_args guestfs_upload_offset_args;

struct guestfs_download_offset_args {
	char *remotefilename;
	quad_t offset;
	quad_t size;
};
typedef struct guestfs_download_offset_args guestfs_download_offset_args;

struct guestfs_pwrite_device_args {
	char *device;
	struct {
		u_int content_len;
		char *content_val;
	} content;
	quad_t offset;
};
typedef struct guestfs_pwrite_device_args guestfs_pwrite_device_args;

struct guestfs_pwrite_device_ret {
	int nbytes;
};
typedef struct guestfs_pwrite_device_ret guestfs_pwrite_device_ret;

struct guestfs_pread_device_args {
	char *device;
	int count;
	quad_t offset;
};
typedef struct guestfs_pread_device_args guestfs_pread_device_args;

struct guestfs_pread_device_ret {
	struct {
		u_int content_len;
		char *content_val;
	} content;
};
typedef struct guestfs_pread_device_ret guestfs_pread_device_ret;

struct guestfs_lvm_canonical_lv_name_args {
	char *lvname;
};
typedef struct guestfs_lvm_canonical_lv_name_args guestfs_lvm_canonical_lv_name_args;

struct guestfs_lvm_canonical_lv_name_ret {
	char *lv;
};
typedef struct guestfs_lvm_canonical_lv_name_ret guestfs_lvm_canonical_lv_name_ret;

struct guestfs_mkfs_opts_args {
	char *fstype;
	char *device;
	int blocksize;
	char *features;
	int inode;
	int sectorsize;
};
typedef struct guestfs_mkfs_opts_args guestfs_mkfs_opts_args;

struct guestfs_getxattr_args {
	char *path;
	char *name;
};
typedef struct guestfs_getxattr_args guestfs_getxattr_args;

struct guestfs_getxattr_ret {
	struct {
		u_int xattr_len;
		char *xattr_val;
	} xattr;
};
typedef struct guestfs_getxattr_ret guestfs_getxattr_ret;

struct guestfs_lgetxattr_args {
	char *path;
	char *name;
};
typedef struct guestfs_lgetxattr_args guestfs_lgetxattr_args;

struct guestfs_lgetxattr_ret {
	struct {
		u_int xattr_len;
		char *xattr_val;
	} xattr;
};
typedef struct guestfs_lgetxattr_ret guestfs_lgetxattr_ret;

struct guestfs_resize2fs_M_args {
	char *device;
};
typedef struct guestfs_resize2fs_M_args guestfs_resize2fs_M_args;

struct guestfs_is_zero_args {
	char *path;
};
typedef struct guestfs_is_zero_args guestfs_is_zero_args;

struct guestfs_is_zero_ret {
	bool_t zeroflag;
};
typedef struct guestfs_is_zero_ret guestfs_is_zero_ret;

struct guestfs_is_zero_device_args {
	char *device;
};
typedef struct guestfs_is_zero_device_args guestfs_is_zero_device_args;

struct guestfs_is_zero_device_ret {
	bool_t zeroflag;
};
typedef struct guestfs_is_zero_device_ret guestfs_is_zero_device_ret;

struct guestfs_list_9p_ret {
	struct {
		u_int mounttags_len;
		guestfs_str *mounttags_val;
	} mounttags;
};
typedef struct guestfs_list_9p_ret guestfs_list_9p_ret;

struct guestfs_mount_9p_args {
	char *mounttag;
	char *mountpoint;
	char *options;
};
typedef struct guestfs_mount_9p_args guestfs_mount_9p_args;

struct guestfs_list_dm_devices_ret {
	struct {
		u_int devices_len;
		guestfs_str *devices_val;
	} devices;
};
typedef struct guestfs_list_dm_devices_ret guestfs_list_dm_devices_ret;

struct guestfs_ntfsresize_opts_args {
	char *device;
	quad_t size;
	bool_t force;
};
typedef struct guestfs_ntfsresize_opts_args guestfs_ntfsresize_opts_args;

struct guestfs_btrfs_filesystem_resize_args {
	char *mountpoint;
	quad_t size;
};
typedef struct guestfs_btrfs_filesystem_resize_args guestfs_btrfs_filesystem_resize_args;

struct guestfs_write_append_args {
	char *path;
	struct {
		u_int content_len;
		char *content_val;
	} content;
};
typedef struct guestfs_write_append_args guestfs_write_append_args;

struct guestfs_compress_out_args {
	char *ctype;
	char *file;
	int level;
};
typedef struct guestfs_compress_out_args guestfs_compress_out_args;

struct guestfs_compress_device_out_args {
	char *ctype;
	char *device;
	int level;
};
typedef struct guestfs_compress_device_out_args guestfs_compress_device_out_args;

struct guestfs_part_to_partnum_args {
	char *partition;
};
typedef struct guestfs_part_to_partnum_args guestfs_part_to_partnum_args;

struct guestfs_part_to_partnum_ret {
	int partnum;
};
typedef struct guestfs_part_to_partnum_ret guestfs_part_to_partnum_ret;

struct guestfs_copy_device_to_device_args {
	char *src;
	char *dest;
	quad_t srcoffset;
	quad_t destoffset;
	quad_t size;
};
typedef struct guestfs_copy_device_to_device_args guestfs_copy_device_to_device_args;

struct guestfs_copy_device_to_file_args {
	char *src;
	char *dest;
	quad_t srcoffset;
	quad_t destoffset;
	quad_t size;
};
typedef struct guestfs_copy_device_to_file_args guestfs_copy_device_to_file_args;

struct guestfs_copy_file_to_device_args {
	char *src;
	char *dest;
	quad_t srcoffset;
	quad_t destoffset;
	quad_t size;
};
typedef struct guestfs_copy_file_to_device_args guestfs_copy_file_to_device_args;

struct guestfs_copy_file_to_file_args {
	char *src;
	char *dest;
	quad_t srcoffset;
	quad_t destoffset;
	quad_t size;
};
typedef struct guestfs_copy_file_to_file_args guestfs_copy_file_to_file_args;

struct guestfs_tune2fs_args {
	char *device;
	bool_t force;
	int maxmountcount;
	int mountcount;
	char *errorbehavior;
	quad_t group;
	int intervalbetweenchecks;
	int reservedblockspercentage;
	char *lastmounteddirectory;
	quad_t reservedblockscount;
	quad_t user;
};
typedef struct guestfs_tune2fs_args guestfs_tune2fs_args;

struct guestfs_md_create_args {
	char *name;
	struct {
		u_int devices_len;
		guestfs_str *devices_val;
	} devices;
	quad_t missingbitmap;
	int nrdevices;
	int spare;
	quad_t chunk;
	char *level;
};
typedef struct guestfs_md_create_args guestfs_md_create_args;

struct guestfs_list_md_devices_ret {
	struct {
		u_int devices_len;
		guestfs_str *devices_val;
	} devices;
};
typedef struct guestfs_list_md_devices_ret guestfs_list_md_devices_ret;

struct guestfs_md_detail_args {
	char *md;
};
typedef struct guestfs_md_detail_args guestfs_md_detail_args;

struct guestfs_md_detail_ret {
	struct {
		u_int info_len;
		guestfs_str *info_val;
	} info;
};
typedef struct guestfs_md_detail_ret guestfs_md_detail_ret;

struct guestfs_md_stop_args {
	char *md;
};
typedef struct guestfs_md_stop_args guestfs_md_stop_args;

struct guestfs_blkid_args {
	char *device;
};
typedef struct guestfs_blkid_args guestfs_blkid_args;

struct guestfs_blkid_ret {
	struct {
		u_int info_len;
		guestfs_str *info_val;
	} info;
};
typedef struct guestfs_blkid_ret guestfs_blkid_ret;

struct guestfs_e2fsck_args {
	char *device;
	bool_t correct;
	bool_t forceall;
};
typedef struct guestfs_e2fsck_args guestfs_e2fsck_args;

enum guestfs_procedure {
	GUESTFS_PROC_MOUNT = 1,
	GUESTFS_PROC_SYNC = 2,
	GUESTFS_PROC_TOUCH = 3,
	GUESTFS_PROC_CAT = 4,
	GUESTFS_PROC_LL = 5,
	GUESTFS_PROC_LS = 6,
	GUESTFS_PROC_LIST_DEVICES = 7,
	GUESTFS_PROC_LIST_PARTITIONS = 8,
	GUESTFS_PROC_PVS = 9,
	GUESTFS_PROC_VGS = 10,
	GUESTFS_PROC_LVS = 11,
	GUESTFS_PROC_PVS_FULL = 12,
	GUESTFS_PROC_VGS_FULL = 13,
	GUESTFS_PROC_LVS_FULL = 14,
	GUESTFS_PROC_READ_LINES = 15,
	GUESTFS_PROC_AUG_INIT = 16,
	GUESTFS_PROC_AUG_CLOSE = 26,
	GUESTFS_PROC_AUG_DEFVAR = 17,
	GUESTFS_PROC_AUG_DEFNODE = 18,
	GUESTFS_PROC_AUG_GET = 19,
	GUESTFS_PROC_AUG_SET = 20,
	GUESTFS_PROC_AUG_INSERT = 21,
	GUESTFS_PROC_AUG_RM = 22,
	GUESTFS_PROC_AUG_MV = 23,
	GUESTFS_PROC_AUG_MATCH = 24,
	GUESTFS_PROC_AUG_SAVE = 25,
	GUESTFS_PROC_AUG_LOAD = 27,
	GUESTFS_PROC_AUG_LS = 28,
	GUESTFS_PROC_RM = 29,
	GUESTFS_PROC_RMDIR = 30,
	GUESTFS_PROC_RM_RF = 31,
	GUESTFS_PROC_MKDIR = 32,
	GUESTFS_PROC_MKDIR_P = 33,
	GUESTFS_PROC_CHMOD = 34,
	GUESTFS_PROC_CHOWN = 35,
	GUESTFS_PROC_EXISTS = 36,
	GUESTFS_PROC_IS_FILE = 37,
	GUESTFS_PROC_IS_DIR = 38,
	GUESTFS_PROC_PVCREATE = 39,
	GUESTFS_PROC_VGCREATE = 40,
	GUESTFS_PROC_LVCREATE = 41,
	GUESTFS_PROC_MKFS = 42,
	GUESTFS_PROC_SFDISK = 43,
	GUESTFS_PROC_WRITE_FILE = 44,
	GUESTFS_PROC_UMOUNT = 45,
	GUESTFS_PROC_MOUNTS = 46,
	GUESTFS_PROC_UMOUNT_ALL = 47,
	GUESTFS_PROC_LVM_REMOVE_ALL = 48,
	GUESTFS_PROC_FILE = 49,
	GUESTFS_PROC_COMMAND = 50,
	GUESTFS_PROC_COMMAND_LINES = 51,
	GUESTFS_PROC_STAT = 52,
	GUESTFS_PROC_LSTAT = 53,
	GUESTFS_PROC_STATVFS = 54,
	GUESTFS_PROC_TUNE2FS_L = 55,
	GUESTFS_PROC_BLOCKDEV_SETRO = 56,
	GUESTFS_PROC_BLOCKDEV_SETRW = 57,
	GUESTFS_PROC_BLOCKDEV_GETRO = 58,
	GUESTFS_PROC_BLOCKDEV_GETSS = 59,
	GUESTFS_PROC_BLOCKDEV_GETBSZ = 60,
	GUESTFS_PROC_BLOCKDEV_SETBSZ = 61,
	GUESTFS_PROC_BLOCKDEV_GETSZ = 62,
	GUESTFS_PROC_BLOCKDEV_GETSIZE64 = 63,
	GUESTFS_PROC_BLOCKDEV_FLUSHBUFS = 64,
	GUESTFS_PROC_BLOCKDEV_REREADPT = 65,
	GUESTFS_PROC_UPLOAD = 66,
	GUESTFS_PROC_DOWNLOAD = 67,
	GUESTFS_PROC_CHECKSUM = 68,
	GUESTFS_PROC_TAR_IN = 69,
	GUESTFS_PROC_TAR_OUT = 70,
	GUESTFS_PROC_TGZ_IN = 71,
	GUESTFS_PROC_TGZ_OUT = 72,
	GUESTFS_PROC_MOUNT_RO = 73,
	GUESTFS_PROC_MOUNT_OPTIONS = 74,
	GUESTFS_PROC_MOUNT_VFS = 75,
	GUESTFS_PROC_DEBUG = 76,
	GUESTFS_PROC_LVREMOVE = 77,
	GUESTFS_PROC_VGREMOVE = 78,
	GUESTFS_PROC_PVREMOVE = 79,
	GUESTFS_PROC_SET_E2LABEL = 80,
	GUESTFS_PROC_GET_E2LABEL = 81,
	GUESTFS_PROC_SET_E2UUID = 82,
	GUESTFS_PROC_GET_E2UUID = 83,
	GUESTFS_PROC_FSCK = 84,
	GUESTFS_PROC_ZERO = 85,
	GUESTFS_PROC_GRUB_INSTALL = 86,
	GUESTFS_PROC_CP = 87,
	GUESTFS_PROC_CP_A = 88,
	GUESTFS_PROC_MV = 89,
	GUESTFS_PROC_DROP_CACHES = 90,
	GUESTFS_PROC_DMESG = 91,
	GUESTFS_PROC_PING_DAEMON = 92,
	GUESTFS_PROC_EQUAL = 93,
	GUESTFS_PROC_STRINGS = 94,
	GUESTFS_PROC_STRINGS_E = 95,
	GUESTFS_PROC_HEXDUMP = 96,
	GUESTFS_PROC_ZEROFREE = 97,
	GUESTFS_PROC_PVRESIZE = 98,
	GUESTFS_PROC_SFDISK_N = 99,
	GUESTFS_PROC_SFDISK_L = 100,
	GUESTFS_PROC_SFDISK_KERNEL_GEOMETRY = 101,
	GUESTFS_PROC_SFDISK_DISK_GEOMETRY = 102,
	GUESTFS_PROC_VG_ACTIVATE_ALL = 103,
	GUESTFS_PROC_VG_ACTIVATE = 104,
	GUESTFS_PROC_LVRESIZE = 105,
	GUESTFS_PROC_RESIZE2FS = 106,
	GUESTFS_PROC_FIND = 107,
	GUESTFS_PROC_E2FSCK_F = 108,
	GUESTFS_PROC_SLEEP = 109,
	GUESTFS_PROC_NTFS_3G_PROBE = 110,
	GUESTFS_PROC_SH = 111,
	GUESTFS_PROC_SH_LINES = 112,
	GUESTFS_PROC_GLOB_EXPAND = 113,
	GUESTFS_PROC_SCRUB_DEVICE = 114,
	GUESTFS_PROC_SCRUB_FILE = 115,
	GUESTFS_PROC_SCRUB_FREESPACE = 116,
	GUESTFS_PROC_MKDTEMP = 117,
	GUESTFS_PROC_WC_L = 118,
	GUESTFS_PROC_WC_W = 119,
	GUESTFS_PROC_WC_C = 120,
	GUESTFS_PROC_HEAD = 121,
	GUESTFS_PROC_HEAD_N = 122,
	GUESTFS_PROC_TAIL = 123,
	GUESTFS_PROC_TAIL_N = 124,
	GUESTFS_PROC_DF = 125,
	GUESTFS_PROC_DF_H = 126,
	GUESTFS_PROC_DU = 127,
	GUESTFS_PROC_INITRD_LIST = 128,
	GUESTFS_PROC_MOUNT_LOOP = 129,
	GUESTFS_PROC_MKSWAP = 130,
	GUESTFS_PROC_MKSWAP_L = 131,
	GUESTFS_PROC_MKSWAP_U = 132,
	GUESTFS_PROC_MKNOD = 133,
	GUESTFS_PROC_MKFIFO = 134,
	GUESTFS_PROC_MKNOD_B = 135,
	GUESTFS_PROC_MKNOD_C = 136,
	GUESTFS_PROC_UMASK = 137,
	GUESTFS_PROC_READDIR = 138,
	GUESTFS_PROC_SFDISKM = 139,
	GUESTFS_PROC_ZFILE = 140,
	GUESTFS_PROC_GETXATTRS = 141,
	GUESTFS_PROC_LGETXATTRS = 142,
	GUESTFS_PROC_SETXATTR = 143,
	GUESTFS_PROC_LSETXATTR = 144,
	GUESTFS_PROC_REMOVEXATTR = 145,
	GUESTFS_PROC_LREMOVEXATTR = 146,
	GUESTFS_PROC_MOUNTPOINTS = 147,
	GUESTFS_PROC_MKMOUNTPOINT = 148,
	GUESTFS_PROC_RMMOUNTPOINT = 149,
	GUESTFS_PROC_READ_FILE = 150,
	GUESTFS_PROC_GREP = 151,
	GUESTFS_PROC_EGREP = 152,
	GUESTFS_PROC_FGREP = 153,
	GUESTFS_PROC_GREPI = 154,
	GUESTFS_PROC_EGREPI = 155,
	GUESTFS_PROC_FGREPI = 156,
	GUESTFS_PROC_ZGREP = 157,
	GUESTFS_PROC_ZEGREP = 158,
	GUESTFS_PROC_ZFGREP = 159,
	GUESTFS_PROC_ZGREPI = 160,
	GUESTFS_PROC_ZEGREPI = 161,
	GUESTFS_PROC_ZFGREPI = 162,
	GUESTFS_PROC_REALPATH = 163,
	GUESTFS_PROC_LN = 164,
	GUESTFS_PROC_LN_F = 165,
	GUESTFS_PROC_LN_S = 166,
	GUESTFS_PROC_LN_SF = 167,
	GUESTFS_PROC_READLINK = 168,
	GUESTFS_PROC_FALLOCATE = 169,
	GUESTFS_PROC_SWAPON_DEVICE = 170,
	GUESTFS_PROC_SWAPOFF_DEVICE = 171,
	GUESTFS_PROC_SWAPON_FILE = 172,
	GUESTFS_PROC_SWAPOFF_FILE = 173,
	GUESTFS_PROC_SWAPON_LABEL = 174,
	GUESTFS_PROC_SWAPOFF_LABEL = 175,
	GUESTFS_PROC_SWAPON_UUID = 176,
	GUESTFS_PROC_SWAPOFF_UUID = 177,
	GUESTFS_PROC_MKSWAP_FILE = 178,
	GUESTFS_PROC_INOTIFY_INIT = 179,
	GUESTFS_PROC_INOTIFY_ADD_WATCH = 180,
	GUESTFS_PROC_INOTIFY_RM_WATCH = 181,
	GUESTFS_PROC_INOTIFY_READ = 182,
	GUESTFS_PROC_INOTIFY_FILES = 183,
	GUESTFS_PROC_INOTIFY_CLOSE = 184,
	GUESTFS_PROC_SETCON = 185,
	GUESTFS_PROC_GETCON = 186,
	GUESTFS_PROC_MKFS_B = 187,
	GUESTFS_PROC_MKE2JOURNAL = 188,
	GUESTFS_PROC_MKE2JOURNAL_L = 189,
	GUESTFS_PROC_MKE2JOURNAL_U = 190,
	GUESTFS_PROC_MKE2FS_J = 191,
	GUESTFS_PROC_MKE2FS_JL = 192,
	GUESTFS_PROC_MKE2FS_JU = 193,
	GUESTFS_PROC_MODPROBE = 194,
	GUESTFS_PROC_ECHO_DAEMON = 195,
	GUESTFS_PROC_FIND0 = 196,
	GUESTFS_PROC_CASE_SENSITIVE_PATH = 197,
	GUESTFS_PROC_VFS_TYPE = 198,
	GUESTFS_PROC_TRUNCATE = 199,
	GUESTFS_PROC_TRUNCATE_SIZE = 200,
	GUESTFS_PROC_UTIMENS = 201,
	GUESTFS_PROC_MKDIR_MODE = 202,
	GUESTFS_PROC_LCHOWN = 203,
	GUESTFS_PROC_LSTATLIST = 204,
	GUESTFS_PROC_LXATTRLIST = 205,
	GUESTFS_PROC_READLINKLIST = 206,
	GUESTFS_PROC_PREAD = 207,
	GUESTFS_PROC_PART_INIT = 208,
	GUESTFS_PROC_PART_ADD = 209,
	GUESTFS_PROC_PART_DISK = 210,
	GUESTFS_PROC_PART_SET_BOOTABLE = 211,
	GUESTFS_PROC_PART_SET_NAME = 212,
	GUESTFS_PROC_PART_LIST = 213,
	GUESTFS_PROC_PART_GET_PARTTYPE = 214,
	GUESTFS_PROC_FILL = 215,
	GUESTFS_PROC_AVAILABLE = 216,
	GUESTFS_PROC_DD = 217,
	GUESTFS_PROC_FILESIZE = 218,
	GUESTFS_PROC_LVRENAME = 219,
	GUESTFS_PROC_VGRENAME = 220,
	GUESTFS_PROC_INITRD_CAT = 221,
	GUESTFS_PROC_PVUUID = 222,
	GUESTFS_PROC_VGUUID = 223,
	GUESTFS_PROC_LVUUID = 224,
	GUESTFS_PROC_VGPVUUIDS = 225,
	GUESTFS_PROC_VGLVUUIDS = 226,
	GUESTFS_PROC_COPY_SIZE = 227,
	GUESTFS_PROC_ZERO_DEVICE = 228,
	GUESTFS_PROC_TXZ_IN = 229,
	GUESTFS_PROC_TXZ_OUT = 230,
	GUESTFS_PROC_NTFSRESIZE = 231,
	GUESTFS_PROC_VGSCAN = 232,
	GUESTFS_PROC_PART_DEL = 233,
	GUESTFS_PROC_PART_GET_BOOTABLE = 234,
	GUESTFS_PROC_PART_GET_MBR_ID = 235,
	GUESTFS_PROC_PART_SET_MBR_ID = 236,
	GUESTFS_PROC_CHECKSUM_DEVICE = 237,
	GUESTFS_PROC_LVRESIZE_FREE = 238,
	GUESTFS_PROC_AUG_CLEAR = 239,
	GUESTFS_PROC_GET_UMASK = 240,
	GUESTFS_PROC_DEBUG_UPLOAD = 241,
	GUESTFS_PROC_BASE64_IN = 242,
	GUESTFS_PROC_BASE64_OUT = 243,
	GUESTFS_PROC_CHECKSUMS_OUT = 244,
	GUESTFS_PROC_FILL_PATTERN = 245,
	GUESTFS_PROC_WRITE = 246,
	GUESTFS_PROC_PWRITE = 247,
	GUESTFS_PROC_RESIZE2FS_SIZE = 248,
	GUESTFS_PROC_PVRESIZE_SIZE = 249,
	GUESTFS_PROC_NTFSRESIZE_SIZE = 250,
	GUESTFS_PROC_AVAILABLE_ALL_GROUPS = 251,
	GUESTFS_PROC_FALLOCATE64 = 252,
	GUESTFS_PROC_VFS_LABEL = 253,
	GUESTFS_PROC_VFS_UUID = 254,
	GUESTFS_PROC_LVM_SET_FILTER = 255,
	GUESTFS_PROC_LVM_CLEAR_FILTER = 256,
	GUESTFS_PROC_LUKS_OPEN = 257,
	GUESTFS_PROC_LUKS_OPEN_RO = 258,
	GUESTFS_PROC_LUKS_CLOSE = 259,
	GUESTFS_PROC_LUKS_FORMAT = 260,
	GUESTFS_PROC_LUKS_FORMAT_CIPHER = 261,
	GUESTFS_PROC_LUKS_ADD_KEY = 262,
	GUESTFS_PROC_LUKS_KILL_SLOT = 263,
	GUESTFS_PROC_IS_LV = 264,
	GUESTFS_PROC_FINDFS_UUID = 265,
	GUESTFS_PROC_FINDFS_LABEL = 266,
	GUESTFS_PROC_IS_CHARDEV = 267,
	GUESTFS_PROC_IS_BLOCKDEV = 268,
	GUESTFS_PROC_IS_FIFO = 269,
	GUESTFS_PROC_IS_SYMLINK = 270,
	GUESTFS_PROC_IS_SOCKET = 271,
	GUESTFS_PROC_PART_TO_DEV = 272,
	GUESTFS_PROC_UPLOAD_OFFSET = 273,
	GUESTFS_PROC_DOWNLOAD_OFFSET = 274,
	GUESTFS_PROC_PWRITE_DEVICE = 275,
	GUESTFS_PROC_PREAD_DEVICE = 276,
	GUESTFS_PROC_LVM_CANONICAL_LV_NAME = 277,
	GUESTFS_PROC_MKFS_OPTS = 278,
	GUESTFS_PROC_GETXATTR = 279,
	GUESTFS_PROC_LGETXATTR = 280,
	GUESTFS_PROC_RESIZE2FS_M = 281,
	GUESTFS_PROC_INTERNAL_AUTOSYNC = 282,
	GUESTFS_PROC_IS_ZERO = 283,
	GUESTFS_PROC_IS_ZERO_DEVICE = 284,
	GUESTFS_PROC_LIST_9P = 285,
	GUESTFS_PROC_MOUNT_9P = 286,
	GUESTFS_PROC_LIST_DM_DEVICES = 287,
	GUESTFS_PROC_NTFSRESIZE_OPTS = 288,
	GUESTFS_PROC_BTRFS_FILESYSTEM_RESIZE = 289,
	GUESTFS_PROC_WRITE_APPEND = 290,
	GUESTFS_PROC_COMPRESS_OUT = 291,
	GUESTFS_PROC_COMPRESS_DEVICE_OUT = 292,
	GUESTFS_PROC_PART_TO_PARTNUM = 293,
	GUESTFS_PROC_COPY_DEVICE_TO_DEVICE = 294,
	GUESTFS_PROC_COPY_DEVICE_TO_FILE = 295,
	GUESTFS_PROC_COPY_FILE_TO_DEVICE = 296,
	GUESTFS_PROC_COPY_FILE_TO_FILE = 297,
	GUESTFS_PROC_TUNE2FS = 298,
	GUESTFS_PROC_MD_CREATE = 299,
	GUESTFS_PROC_LIST_MD_DEVICES = 300,
	GUESTFS_PROC_MD_DETAIL = 301,
	GUESTFS_PROC_MD_STOP = 302,
	GUESTFS_PROC_BLKID = 303,
	GUESTFS_PROC_E2FSCK = 304,
	GUESTFS_PROC_NR_PROCS = 304 + 1,
};
typedef enum guestfs_procedure guestfs_procedure;
#define GUESTFS_MESSAGE_MAX 4194304
#define GUESTFS_PROGRAM 0x2000F5F5
#define GUESTFS_PROTOCOL_VERSION 4
#define GUESTFS_LAUNCH_FLAG 0xf5f55ff5
#define GUESTFS_CANCEL_FLAG 0xffffeeee
#define GUESTFS_PROGRESS_FLAG 0xffff5555

enum guestfs_message_direction {
	GUESTFS_DIRECTION_CALL = 0,
	GUESTFS_DIRECTION_REPLY = 1,
};
typedef enum guestfs_message_direction guestfs_message_direction;

enum guestfs_message_status {
	GUESTFS_STATUS_OK = 0,
	GUESTFS_STATUS_ERROR = 1,
};
typedef enum guestfs_message_status guestfs_message_status;
#define GUESTFS_ERROR_LEN 65536

struct guestfs_message_error {
	char *errno_string;
	char *error_message;
};
typedef struct guestfs_message_error guestfs_message_error;

struct guestfs_message_header {
	u_int prog;
	u_int vers;
	guestfs_procedure proc;
	guestfs_message_direction direction;
	u_int serial;
	u_quad_t progress_hint;
	u_quad_t optargs_bitmask;
	guestfs_message_status status;
};
typedef struct guestfs_message_header guestfs_message_header;
#define GUESTFS_MAX_CHUNK_SIZE 8192

struct guestfs_chunk {
	int cancel;
	struct {
		u_int data_len;
		char *data_val;
	} data;
};
typedef struct guestfs_chunk guestfs_chunk;

struct guestfs_progress {
	guestfs_procedure proc;
	u_int serial;
	u_quad_t position;
	u_quad_t total;
};
typedef struct guestfs_progress guestfs_progress;

/* the xdr functions */

#if defined(__STDC__) || defined(__cplusplus)
extern  bool_t xdr_guestfs_str (XDR *, guestfs_str*);
extern  bool_t xdr_guestfs_int_int_bool (XDR *, guestfs_int_int_bool*);
extern  bool_t xdr_guestfs_int_int_bool_list (XDR *, guestfs_int_int_bool_list*);
extern  bool_t xdr_guestfs_int_lvm_pv (XDR *, guestfs_int_lvm_pv*);
extern  bool_t xdr_guestfs_int_lvm_pv_list (XDR *, guestfs_int_lvm_pv_list*);
extern  bool_t xdr_guestfs_int_lvm_vg (XDR *, guestfs_int_lvm_vg*);
extern  bool_t xdr_guestfs_int_lvm_vg_list (XDR *, guestfs_int_lvm_vg_list*);
extern  bool_t xdr_guestfs_int_lvm_lv (XDR *, guestfs_int_lvm_lv*);
extern  bool_t xdr_guestfs_int_lvm_lv_list (XDR *, guestfs_int_lvm_lv_list*);
extern  bool_t xdr_guestfs_int_stat (XDR *, guestfs_int_stat*);
extern  bool_t xdr_guestfs_int_stat_list (XDR *, guestfs_int_stat_list*);
extern  bool_t xdr_guestfs_int_statvfs (XDR *, guestfs_int_statvfs*);
extern  bool_t xdr_guestfs_int_statvfs_list (XDR *, guestfs_int_statvfs_list*);
extern  bool_t xdr_guestfs_int_dirent (XDR *, guestfs_int_dirent*);
extern  bool_t xdr_guestfs_int_dirent_list (XDR *, guestfs_int_dirent_list*);
extern  bool_t xdr_guestfs_int_version (XDR *, guestfs_int_version*);
extern  bool_t xdr_guestfs_int_version_list (XDR *, guestfs_int_version_list*);
extern  bool_t xdr_guestfs_int_xattr (XDR *, guestfs_int_xattr*);
extern  bool_t xdr_guestfs_int_xattr_list (XDR *, guestfs_int_xattr_list*);
extern  bool_t xdr_guestfs_int_inotify_event (XDR *, guestfs_int_inotify_event*);
extern  bool_t xdr_guestfs_int_inotify_event_list (XDR *, guestfs_int_inotify_event_list*);
extern  bool_t xdr_guestfs_int_partition (XDR *, guestfs_int_partition*);
extern  bool_t xdr_guestfs_int_partition_list (XDR *, guestfs_int_partition_list*);
extern  bool_t xdr_guestfs_int_application (XDR *, guestfs_int_application*);
extern  bool_t xdr_guestfs_int_application_list (XDR *, guestfs_int_application_list*);
extern  bool_t xdr_guestfs_mount_args (XDR *, guestfs_mount_args*);
extern  bool_t xdr_guestfs_touch_args (XDR *, guestfs_touch_args*);
extern  bool_t xdr_guestfs_cat_args (XDR *, guestfs_cat_args*);
extern  bool_t xdr_guestfs_cat_ret (XDR *, guestfs_cat_ret*);
extern  bool_t xdr_guestfs_ll_args (XDR *, guestfs_ll_args*);
extern  bool_t xdr_guestfs_ll_ret (XDR *, guestfs_ll_ret*);
extern  bool_t xdr_guestfs_ls_args (XDR *, guestfs_ls_args*);
extern  bool_t xdr_guestfs_ls_ret (XDR *, guestfs_ls_ret*);
extern  bool_t xdr_guestfs_list_devices_ret (XDR *, guestfs_list_devices_ret*);
extern  bool_t xdr_guestfs_list_partitions_ret (XDR *, guestfs_list_partitions_ret*);
extern  bool_t xdr_guestfs_pvs_ret (XDR *, guestfs_pvs_ret*);
extern  bool_t xdr_guestfs_vgs_ret (XDR *, guestfs_vgs_ret*);
extern  bool_t xdr_guestfs_lvs_ret (XDR *, guestfs_lvs_ret*);
extern  bool_t xdr_guestfs_pvs_full_ret (XDR *, guestfs_pvs_full_ret*);
extern  bool_t xdr_guestfs_vgs_full_ret (XDR *, guestfs_vgs_full_ret*);
extern  bool_t xdr_guestfs_lvs_full_ret (XDR *, guestfs_lvs_full_ret*);
extern  bool_t xdr_guestfs_read_lines_args (XDR *, guestfs_read_lines_args*);
extern  bool_t xdr_guestfs_read_lines_ret (XDR *, guestfs_read_lines_ret*);
extern  bool_t xdr_guestfs_aug_init_args (XDR *, guestfs_aug_init_args*);
extern  bool_t xdr_guestfs_aug_defvar_args (XDR *, guestfs_aug_defvar_args*);
extern  bool_t xdr_guestfs_aug_defvar_ret (XDR *, guestfs_aug_defvar_ret*);
extern  bool_t xdr_guestfs_aug_defnode_args (XDR *, guestfs_aug_defnode_args*);
extern  bool_t xdr_guestfs_aug_defnode_ret (XDR *, guestfs_aug_defnode_ret*);
extern  bool_t xdr_guestfs_aug_get_args (XDR *, guestfs_aug_get_args*);
extern  bool_t xdr_guestfs_aug_get_ret (XDR *, guestfs_aug_get_ret*);
extern  bool_t xdr_guestfs_aug_set_args (XDR *, guestfs_aug_set_args*);
extern  bool_t xdr_guestfs_aug_insert_args (XDR *, guestfs_aug_insert_args*);
extern  bool_t xdr_guestfs_aug_rm_args (XDR *, guestfs_aug_rm_args*);
extern  bool_t xdr_guestfs_aug_rm_ret (XDR *, guestfs_aug_rm_ret*);
extern  bool_t xdr_guestfs_aug_mv_args (XDR *, guestfs_aug_mv_args*);
extern  bool_t xdr_guestfs_aug_match_args (XDR *, guestfs_aug_match_args*);
extern  bool_t xdr_guestfs_aug_match_ret (XDR *, guestfs_aug_match_ret*);
extern  bool_t xdr_guestfs_aug_ls_args (XDR *, guestfs_aug_ls_args*);
extern  bool_t xdr_guestfs_aug_ls_ret (XDR *, guestfs_aug_ls_ret*);
extern  bool_t xdr_guestfs_rm_args (XDR *, guestfs_rm_args*);
extern  bool_t xdr_guestfs_rmdir_args (XDR *, guestfs_rmdir_args*);
extern  bool_t xdr_guestfs_rm_rf_args (XDR *, guestfs_rm_rf_args*);
extern  bool_t xdr_guestfs_mkdir_args (XDR *, guestfs_mkdir_args*);
extern  bool_t xdr_guestfs_mkdir_p_args (XDR *, guestfs_mkdir_p_args*);
extern  bool_t xdr_guestfs_chmod_args (XDR *, guestfs_chmod_args*);
extern  bool_t xdr_guestfs_chown_args (XDR *, guestfs_chown_args*);
extern  bool_t xdr_guestfs_exists_args (XDR *, guestfs_exists_args*);
extern  bool_t xdr_guestfs_exists_ret (XDR *, guestfs_exists_ret*);
extern  bool_t xdr_guestfs_is_file_args (XDR *, guestfs_is_file_args*);
extern  bool_t xdr_guestfs_is_file_ret (XDR *, guestfs_is_file_ret*);
extern  bool_t xdr_guestfs_is_dir_args (XDR *, guestfs_is_dir_args*);
extern  bool_t xdr_guestfs_is_dir_ret (XDR *, guestfs_is_dir_ret*);
extern  bool_t xdr_guestfs_pvcreate_args (XDR *, guestfs_pvcreate_args*);
extern  bool_t xdr_guestfs_vgcreate_args (XDR *, guestfs_vgcreate_args*);
extern  bool_t xdr_guestfs_lvcreate_args (XDR *, guestfs_lvcreate_args*);
extern  bool_t xdr_guestfs_mkfs_args (XDR *, guestfs_mkfs_args*);
extern  bool_t xdr_guestfs_sfdisk_args (XDR *, guestfs_sfdisk_args*);
extern  bool_t xdr_guestfs_write_file_args (XDR *, guestfs_write_file_args*);
extern  bool_t xdr_guestfs_umount_args (XDR *, guestfs_umount_args*);
extern  bool_t xdr_guestfs_mounts_ret (XDR *, guestfs_mounts_ret*);
extern  bool_t xdr_guestfs_file_args (XDR *, guestfs_file_args*);
extern  bool_t xdr_guestfs_file_ret (XDR *, guestfs_file_ret*);
extern  bool_t xdr_guestfs_command_args (XDR *, guestfs_command_args*);
extern  bool_t xdr_guestfs_command_ret (XDR *, guestfs_command_ret*);
extern  bool_t xdr_guestfs_command_lines_args (XDR *, guestfs_command_lines_args*);
extern  bool_t xdr_guestfs_command_lines_ret (XDR *, guestfs_command_lines_ret*);
extern  bool_t xdr_guestfs_stat_args (XDR *, guestfs_stat_args*);
extern  bool_t xdr_guestfs_stat_ret (XDR *, guestfs_stat_ret*);
extern  bool_t xdr_guestfs_lstat_args (XDR *, guestfs_lstat_args*);
extern  bool_t xdr_guestfs_lstat_ret (XDR *, guestfs_lstat_ret*);
extern  bool_t xdr_guestfs_statvfs_args (XDR *, guestfs_statvfs_args*);
extern  bool_t xdr_guestfs_statvfs_ret (XDR *, guestfs_statvfs_ret*);
extern  bool_t xdr_guestfs_tune2fs_l_args (XDR *, guestfs_tune2fs_l_args*);
extern  bool_t xdr_guestfs_tune2fs_l_ret (XDR *, guestfs_tune2fs_l_ret*);
extern  bool_t xdr_guestfs_blockdev_setro_args (XDR *, guestfs_blockdev_setro_args*);
extern  bool_t xdr_guestfs_blockdev_setrw_args (XDR *, guestfs_blockdev_setrw_args*);
extern  bool_t xdr_guestfs_blockdev_getro_args (XDR *, guestfs_blockdev_getro_args*);
extern  bool_t xdr_guestfs_blockdev_getro_ret (XDR *, guestfs_blockdev_getro_ret*);
extern  bool_t xdr_guestfs_blockdev_getss_args (XDR *, guestfs_blockdev_getss_args*);
extern  bool_t xdr_guestfs_blockdev_getss_ret (XDR *, guestfs_blockdev_getss_ret*);
extern  bool_t xdr_guestfs_blockdev_getbsz_args (XDR *, guestfs_blockdev_getbsz_args*);
extern  bool_t xdr_guestfs_blockdev_getbsz_ret (XDR *, guestfs_blockdev_getbsz_ret*);
extern  bool_t xdr_guestfs_blockdev_setbsz_args (XDR *, guestfs_blockdev_setbsz_args*);
extern  bool_t xdr_guestfs_blockdev_getsz_args (XDR *, guestfs_blockdev_getsz_args*);
extern  bool_t xdr_guestfs_blockdev_getsz_ret (XDR *, guestfs_blockdev_getsz_ret*);
extern  bool_t xdr_guestfs_blockdev_getsize64_args (XDR *, guestfs_blockdev_getsize64_args*);
extern  bool_t xdr_guestfs_blockdev_getsize64_ret (XDR *, guestfs_blockdev_getsize64_ret*);
extern  bool_t xdr_guestfs_blockdev_flushbufs_args (XDR *, guestfs_blockdev_flushbufs_args*);
extern  bool_t xdr_guestfs_blockdev_rereadpt_args (XDR *, guestfs_blockdev_rereadpt_args*);
extern  bool_t xdr_guestfs_upload_args (XDR *, guestfs_upload_args*);
extern  bool_t xdr_guestfs_download_args (XDR *, guestfs_download_args*);
extern  bool_t xdr_guestfs_checksum_args (XDR *, guestfs_checksum_args*);
extern  bool_t xdr_guestfs_checksum_ret (XDR *, guestfs_checksum_ret*);
extern  bool_t xdr_guestfs_tar_in_args (XDR *, guestfs_tar_in_args*);
extern  bool_t xdr_guestfs_tar_out_args (XDR *, guestfs_tar_out_args*);
extern  bool_t xdr_guestfs_tgz_in_args (XDR *, guestfs_tgz_in_args*);
extern  bool_t xdr_guestfs_tgz_out_args (XDR *, guestfs_tgz_out_args*);
extern  bool_t xdr_guestfs_mount_ro_args (XDR *, guestfs_mount_ro_args*);
extern  bool_t xdr_guestfs_mount_options_args (XDR *, guestfs_mount_options_args*);
extern  bool_t xdr_guestfs_mount_vfs_args (XDR *, guestfs_mount_vfs_args*);
extern  bool_t xdr_guestfs_debug_args (XDR *, guestfs_debug_args*);
extern  bool_t xdr_guestfs_debug_ret (XDR *, guestfs_debug_ret*);
extern  bool_t xdr_guestfs_lvremove_args (XDR *, guestfs_lvremove_args*);
extern  bool_t xdr_guestfs_vgremove_args (XDR *, guestfs_vgremove_args*);
extern  bool_t xdr_guestfs_pvremove_args (XDR *, guestfs_pvremove_args*);
extern  bool_t xdr_guestfs_set_e2label_args (XDR *, guestfs_set_e2label_args*);
extern  bool_t xdr_guestfs_get_e2label_args (XDR *, guestfs_get_e2label_args*);
extern  bool_t xdr_guestfs_get_e2label_ret (XDR *, guestfs_get_e2label_ret*);
extern  bool_t xdr_guestfs_set_e2uuid_args (XDR *, guestfs_set_e2uuid_args*);
extern  bool_t xdr_guestfs_get_e2uuid_args (XDR *, guestfs_get_e2uuid_args*);
extern  bool_t xdr_guestfs_get_e2uuid_ret (XDR *, guestfs_get_e2uuid_ret*);
extern  bool_t xdr_guestfs_fsck_args (XDR *, guestfs_fsck_args*);
extern  bool_t xdr_guestfs_fsck_ret (XDR *, guestfs_fsck_ret*);
extern  bool_t xdr_guestfs_zero_args (XDR *, guestfs_zero_args*);
extern  bool_t xdr_guestfs_grub_install_args (XDR *, guestfs_grub_install_args*);
extern  bool_t xdr_guestfs_cp_args (XDR *, guestfs_cp_args*);
extern  bool_t xdr_guestfs_cp_a_args (XDR *, guestfs_cp_a_args*);
extern  bool_t xdr_guestfs_mv_args (XDR *, guestfs_mv_args*);
extern  bool_t xdr_guestfs_drop_caches_args (XDR *, guestfs_drop_caches_args*);
extern  bool_t xdr_guestfs_dmesg_ret (XDR *, guestfs_dmesg_ret*);
extern  bool_t xdr_guestfs_equal_args (XDR *, guestfs_equal_args*);
extern  bool_t xdr_guestfs_equal_ret (XDR *, guestfs_equal_ret*);
extern  bool_t xdr_guestfs_strings_args (XDR *, guestfs_strings_args*);
extern  bool_t xdr_guestfs_strings_ret (XDR *, guestfs_strings_ret*);
extern  bool_t xdr_guestfs_strings_e_args (XDR *, guestfs_strings_e_args*);
extern  bool_t xdr_guestfs_strings_e_ret (XDR *, guestfs_strings_e_ret*);
extern  bool_t xdr_guestfs_hexdump_args (XDR *, guestfs_hexdump_args*);
extern  bool_t xdr_guestfs_hexdump_ret (XDR *, guestfs_hexdump_ret*);
extern  bool_t xdr_guestfs_zerofree_args (XDR *, guestfs_zerofree_args*);
extern  bool_t xdr_guestfs_pvresize_args (XDR *, guestfs_pvresize_args*);
extern  bool_t xdr_guestfs_sfdisk_N_args (XDR *, guestfs_sfdisk_N_args*);
extern  bool_t xdr_guestfs_sfdisk_l_args (XDR *, guestfs_sfdisk_l_args*);
extern  bool_t xdr_guestfs_sfdisk_l_ret (XDR *, guestfs_sfdisk_l_ret*);
extern  bool_t xdr_guestfs_sfdisk_kernel_geometry_args (XDR *, guestfs_sfdisk_kernel_geometry_args*);
extern  bool_t xdr_guestfs_sfdisk_kernel_geometry_ret (XDR *, guestfs_sfdisk_kernel_geometry_ret*);
extern  bool_t xdr_guestfs_sfdisk_disk_geometry_args (XDR *, guestfs_sfdisk_disk_geometry_args*);
extern  bool_t xdr_guestfs_sfdisk_disk_geometry_ret (XDR *, guestfs_sfdisk_disk_geometry_ret*);
extern  bool_t xdr_guestfs_vg_activate_all_args (XDR *, guestfs_vg_activate_all_args*);
extern  bool_t xdr_guestfs_vg_activate_args (XDR *, guestfs_vg_activate_args*);
extern  bool_t xdr_guestfs_lvresize_args (XDR *, guestfs_lvresize_args*);
extern  bool_t xdr_guestfs_resize2fs_args (XDR *, guestfs_resize2fs_args*);
extern  bool_t xdr_guestfs_find_args (XDR *, guestfs_find_args*);
extern  bool_t xdr_guestfs_find_ret (XDR *, guestfs_find_ret*);
extern  bool_t xdr_guestfs_e2fsck_f_args (XDR *, guestfs_e2fsck_f_args*);
extern  bool_t xdr_guestfs_sleep_args (XDR *, guestfs_sleep_args*);
extern  bool_t xdr_guestfs_ntfs_3g_probe_args (XDR *, guestfs_ntfs_3g_probe_args*);
extern  bool_t xdr_guestfs_ntfs_3g_probe_ret (XDR *, guestfs_ntfs_3g_probe_ret*);
extern  bool_t xdr_guestfs_sh_args (XDR *, guestfs_sh_args*);
extern  bool_t xdr_guestfs_sh_ret (XDR *, guestfs_sh_ret*);
extern  bool_t xdr_guestfs_sh_lines_args (XDR *, guestfs_sh_lines_args*);
extern  bool_t xdr_guestfs_sh_lines_ret (XDR *, guestfs_sh_lines_ret*);
extern  bool_t xdr_guestfs_glob_expand_args (XDR *, guestfs_glob_expand_args*);
extern  bool_t xdr_guestfs_glob_expand_ret (XDR *, guestfs_glob_expand_ret*);
extern  bool_t xdr_guestfs_scrub_device_args (XDR *, guestfs_scrub_device_args*);
extern  bool_t xdr_guestfs_scrub_file_args (XDR *, guestfs_scrub_file_args*);
extern  bool_t xdr_guestfs_scrub_freespace_args (XDR *, guestfs_scrub_freespace_args*);
extern  bool_t xdr_guestfs_mkdtemp_args (XDR *, guestfs_mkdtemp_args*);
extern  bool_t xdr_guestfs_mkdtemp_ret (XDR *, guestfs_mkdtemp_ret*);
extern  bool_t xdr_guestfs_wc_l_args (XDR *, guestfs_wc_l_args*);
extern  bool_t xdr_guestfs_wc_l_ret (XDR *, guestfs_wc_l_ret*);
extern  bool_t xdr_guestfs_wc_w_args (XDR *, guestfs_wc_w_args*);
extern  bool_t xdr_guestfs_wc_w_ret (XDR *, guestfs_wc_w_ret*);
extern  bool_t xdr_guestfs_wc_c_args (XDR *, guestfs_wc_c_args*);
extern  bool_t xdr_guestfs_wc_c_ret (XDR *, guestfs_wc_c_ret*);
extern  bool_t xdr_guestfs_head_args (XDR *, guestfs_head_args*);
extern  bool_t xdr_guestfs_head_ret (XDR *, guestfs_head_ret*);
extern  bool_t xdr_guestfs_head_n_args (XDR *, guestfs_head_n_args*);
extern  bool_t xdr_guestfs_head_n_ret (XDR *, guestfs_head_n_ret*);
extern  bool_t xdr_guestfs_tail_args (XDR *, guestfs_tail_args*);
extern  bool_t xdr_guestfs_tail_ret (XDR *, guestfs_tail_ret*);
extern  bool_t xdr_guestfs_tail_n_args (XDR *, guestfs_tail_n_args*);
extern  bool_t xdr_guestfs_tail_n_ret (XDR *, guestfs_tail_n_ret*);
extern  bool_t xdr_guestfs_df_ret (XDR *, guestfs_df_ret*);
extern  bool_t xdr_guestfs_df_h_ret (XDR *, guestfs_df_h_ret*);
extern  bool_t xdr_guestfs_du_args (XDR *, guestfs_du_args*);
extern  bool_t xdr_guestfs_du_ret (XDR *, guestfs_du_ret*);
extern  bool_t xdr_guestfs_initrd_list_args (XDR *, guestfs_initrd_list_args*);
extern  bool_t xdr_guestfs_initrd_list_ret (XDR *, guestfs_initrd_list_ret*);
extern  bool_t xdr_guestfs_mount_loop_args (XDR *, guestfs_mount_loop_args*);
extern  bool_t xdr_guestfs_mkswap_args (XDR *, guestfs_mkswap_args*);
extern  bool_t xdr_guestfs_mkswap_L_args (XDR *, guestfs_mkswap_L_args*);
extern  bool_t xdr_guestfs_mkswap_U_args (XDR *, guestfs_mkswap_U_args*);
extern  bool_t xdr_guestfs_mknod_args (XDR *, guestfs_mknod_args*);
extern  bool_t xdr_guestfs_mkfifo_args (XDR *, guestfs_mkfifo_args*);
extern  bool_t xdr_guestfs_mknod_b_args (XDR *, guestfs_mknod_b_args*);
extern  bool_t xdr_guestfs_mknod_c_args (XDR *, guestfs_mknod_c_args*);
extern  bool_t xdr_guestfs_umask_args (XDR *, guestfs_umask_args*);
extern  bool_t xdr_guestfs_umask_ret (XDR *, guestfs_umask_ret*);
extern  bool_t xdr_guestfs_readdir_args (XDR *, guestfs_readdir_args*);
extern  bool_t xdr_guestfs_readdir_ret (XDR *, guestfs_readdir_ret*);
extern  bool_t xdr_guestfs_sfdiskM_args (XDR *, guestfs_sfdiskM_args*);
extern  bool_t xdr_guestfs_zfile_args (XDR *, guestfs_zfile_args*);
extern  bool_t xdr_guestfs_zfile_ret (XDR *, guestfs_zfile_ret*);
extern  bool_t xdr_guestfs_getxattrs_args (XDR *, guestfs_getxattrs_args*);
extern  bool_t xdr_guestfs_getxattrs_ret (XDR *, guestfs_getxattrs_ret*);
extern  bool_t xdr_guestfs_lgetxattrs_args (XDR *, guestfs_lgetxattrs_args*);
extern  bool_t xdr_guestfs_lgetxattrs_ret (XDR *, guestfs_lgetxattrs_ret*);
extern  bool_t xdr_guestfs_setxattr_args (XDR *, guestfs_setxattr_args*);
extern  bool_t xdr_guestfs_lsetxattr_args (XDR *, guestfs_lsetxattr_args*);
extern  bool_t xdr_guestfs_removexattr_args (XDR *, guestfs_removexattr_args*);
extern  bool_t xdr_guestfs_lremovexattr_args (XDR *, guestfs_lremovexattr_args*);
extern  bool_t xdr_guestfs_mountpoints_ret (XDR *, guestfs_mountpoints_ret*);
extern  bool_t xdr_guestfs_mkmountpoint_args (XDR *, guestfs_mkmountpoint_args*);
extern  bool_t xdr_guestfs_rmmountpoint_args (XDR *, guestfs_rmmountpoint_args*);
extern  bool_t xdr_guestfs_read_file_args (XDR *, guestfs_read_file_args*);
extern  bool_t xdr_guestfs_read_file_ret (XDR *, guestfs_read_file_ret*);
extern  bool_t xdr_guestfs_grep_args (XDR *, guestfs_grep_args*);
extern  bool_t xdr_guestfs_grep_ret (XDR *, guestfs_grep_ret*);
extern  bool_t xdr_guestfs_egrep_args (XDR *, guestfs_egrep_args*);
extern  bool_t xdr_guestfs_egrep_ret (XDR *, guestfs_egrep_ret*);
extern  bool_t xdr_guestfs_fgrep_args (XDR *, guestfs_fgrep_args*);
extern  bool_t xdr_guestfs_fgrep_ret (XDR *, guestfs_fgrep_ret*);
extern  bool_t xdr_guestfs_grepi_args (XDR *, guestfs_grepi_args*);
extern  bool_t xdr_guestfs_grepi_ret (XDR *, guestfs_grepi_ret*);
extern  bool_t xdr_guestfs_egrepi_args (XDR *, guestfs_egrepi_args*);
extern  bool_t xdr_guestfs_egrepi_ret (XDR *, guestfs_egrepi_ret*);
extern  bool_t xdr_guestfs_fgrepi_args (XDR *, guestfs_fgrepi_args*);
extern  bool_t xdr_guestfs_fgrepi_ret (XDR *, guestfs_fgrepi_ret*);
extern  bool_t xdr_guestfs_zgrep_args (XDR *, guestfs_zgrep_args*);
extern  bool_t xdr_guestfs_zgrep_ret (XDR *, guestfs_zgrep_ret*);
extern  bool_t xdr_guestfs_zegrep_args (XDR *, guestfs_zegrep_args*);
extern  bool_t xdr_guestfs_zegrep_ret (XDR *, guestfs_zegrep_ret*);
extern  bool_t xdr_guestfs_zfgrep_args (XDR *, guestfs_zfgrep_args*);
extern  bool_t xdr_guestfs_zfgrep_ret (XDR *, guestfs_zfgrep_ret*);
extern  bool_t xdr_guestfs_zgrepi_args (XDR *, guestfs_zgrepi_args*);
extern  bool_t xdr_guestfs_zgrepi_ret (XDR *, guestfs_zgrepi_ret*);
extern  bool_t xdr_guestfs_zegrepi_args (XDR *, guestfs_zegrepi_args*);
extern  bool_t xdr_guestfs_zegrepi_ret (XDR *, guestfs_zegrepi_ret*);
extern  bool_t xdr_guestfs_zfgrepi_args (XDR *, guestfs_zfgrepi_args*);
extern  bool_t xdr_guestfs_zfgrepi_ret (XDR *, guestfs_zfgrepi_ret*);
extern  bool_t xdr_guestfs_realpath_args (XDR *, guestfs_realpath_args*);
extern  bool_t xdr_guestfs_realpath_ret (XDR *, guestfs_realpath_ret*);
extern  bool_t xdr_guestfs_ln_args (XDR *, guestfs_ln_args*);
extern  bool_t xdr_guestfs_ln_f_args (XDR *, guestfs_ln_f_args*);
extern  bool_t xdr_guestfs_ln_s_args (XDR *, guestfs_ln_s_args*);
extern  bool_t xdr_guestfs_ln_sf_args (XDR *, guestfs_ln_sf_args*);
extern  bool_t xdr_guestfs_readlink_args (XDR *, guestfs_readlink_args*);
extern  bool_t xdr_guestfs_readlink_ret (XDR *, guestfs_readlink_ret*);
extern  bool_t xdr_guestfs_fallocate_args (XDR *, guestfs_fallocate_args*);
extern  bool_t xdr_guestfs_swapon_device_args (XDR *, guestfs_swapon_device_args*);
extern  bool_t xdr_guestfs_swapoff_device_args (XDR *, guestfs_swapoff_device_args*);
extern  bool_t xdr_guestfs_swapon_file_args (XDR *, guestfs_swapon_file_args*);
extern  bool_t xdr_guestfs_swapoff_file_args (XDR *, guestfs_swapoff_file_args*);
extern  bool_t xdr_guestfs_swapon_label_args (XDR *, guestfs_swapon_label_args*);
extern  bool_t xdr_guestfs_swapoff_label_args (XDR *, guestfs_swapoff_label_args*);
extern  bool_t xdr_guestfs_swapon_uuid_args (XDR *, guestfs_swapon_uuid_args*);
extern  bool_t xdr_guestfs_swapoff_uuid_args (XDR *, guestfs_swapoff_uuid_args*);
extern  bool_t xdr_guestfs_mkswap_file_args (XDR *, guestfs_mkswap_file_args*);
extern  bool_t xdr_guestfs_inotify_init_args (XDR *, guestfs_inotify_init_args*);
extern  bool_t xdr_guestfs_inotify_add_watch_args (XDR *, guestfs_inotify_add_watch_args*);
extern  bool_t xdr_guestfs_inotify_add_watch_ret (XDR *, guestfs_inotify_add_watch_ret*);
extern  bool_t xdr_guestfs_inotify_rm_watch_args (XDR *, guestfs_inotify_rm_watch_args*);
extern  bool_t xdr_guestfs_inotify_read_ret (XDR *, guestfs_inotify_read_ret*);
extern  bool_t xdr_guestfs_inotify_files_ret (XDR *, guestfs_inotify_files_ret*);
extern  bool_t xdr_guestfs_setcon_args (XDR *, guestfs_setcon_args*);
extern  bool_t xdr_guestfs_getcon_ret (XDR *, guestfs_getcon_ret*);
extern  bool_t xdr_guestfs_mkfs_b_args (XDR *, guestfs_mkfs_b_args*);
extern  bool_t xdr_guestfs_mke2journal_args (XDR *, guestfs_mke2journal_args*);
extern  bool_t xdr_guestfs_mke2journal_L_args (XDR *, guestfs_mke2journal_L_args*);
extern  bool_t xdr_guestfs_mke2journal_U_args (XDR *, guestfs_mke2journal_U_args*);
extern  bool_t xdr_guestfs_mke2fs_J_args (XDR *, guestfs_mke2fs_J_args*);
extern  bool_t xdr_guestfs_mke2fs_JL_args (XDR *, guestfs_mke2fs_JL_args*);
extern  bool_t xdr_guestfs_mke2fs_JU_args (XDR *, guestfs_mke2fs_JU_args*);
extern  bool_t xdr_guestfs_modprobe_args (XDR *, guestfs_modprobe_args*);
extern  bool_t xdr_guestfs_echo_daemon_args (XDR *, guestfs_echo_daemon_args*);
extern  bool_t xdr_guestfs_echo_daemon_ret (XDR *, guestfs_echo_daemon_ret*);
extern  bool_t xdr_guestfs_find0_args (XDR *, guestfs_find0_args*);
extern  bool_t xdr_guestfs_case_sensitive_path_args (XDR *, guestfs_case_sensitive_path_args*);
extern  bool_t xdr_guestfs_case_sensitive_path_ret (XDR *, guestfs_case_sensitive_path_ret*);
extern  bool_t xdr_guestfs_vfs_type_args (XDR *, guestfs_vfs_type_args*);
extern  bool_t xdr_guestfs_vfs_type_ret (XDR *, guestfs_vfs_type_ret*);
extern  bool_t xdr_guestfs_truncate_args (XDR *, guestfs_truncate_args*);
extern  bool_t xdr_guestfs_truncate_size_args (XDR *, guestfs_truncate_size_args*);
extern  bool_t xdr_guestfs_utimens_args (XDR *, guestfs_utimens_args*);
extern  bool_t xdr_guestfs_mkdir_mode_args (XDR *, guestfs_mkdir_mode_args*);
extern  bool_t xdr_guestfs_lchown_args (XDR *, guestfs_lchown_args*);
extern  bool_t xdr_guestfs_lstatlist_args (XDR *, guestfs_lstatlist_args*);
extern  bool_t xdr_guestfs_lstatlist_ret (XDR *, guestfs_lstatlist_ret*);
extern  bool_t xdr_guestfs_lxattrlist_args (XDR *, guestfs_lxattrlist_args*);
extern  bool_t xdr_guestfs_lxattrlist_ret (XDR *, guestfs_lxattrlist_ret*);
extern  bool_t xdr_guestfs_readlinklist_args (XDR *, guestfs_readlinklist_args*);
extern  bool_t xdr_guestfs_readlinklist_ret (XDR *, guestfs_readlinklist_ret*);
extern  bool_t xdr_guestfs_pread_args (XDR *, guestfs_pread_args*);
extern  bool_t xdr_guestfs_pread_ret (XDR *, guestfs_pread_ret*);
extern  bool_t xdr_guestfs_part_init_args (XDR *, guestfs_part_init_args*);
extern  bool_t xdr_guestfs_part_add_args (XDR *, guestfs_part_add_args*);
extern  bool_t xdr_guestfs_part_disk_args (XDR *, guestfs_part_disk_args*);
extern  bool_t xdr_guestfs_part_set_bootable_args (XDR *, guestfs_part_set_bootable_args*);
extern  bool_t xdr_guestfs_part_set_name_args (XDR *, guestfs_part_set_name_args*);
extern  bool_t xdr_guestfs_part_list_args (XDR *, guestfs_part_list_args*);
extern  bool_t xdr_guestfs_part_list_ret (XDR *, guestfs_part_list_ret*);
extern  bool_t xdr_guestfs_part_get_parttype_args (XDR *, guestfs_part_get_parttype_args*);
extern  bool_t xdr_guestfs_part_get_parttype_ret (XDR *, guestfs_part_get_parttype_ret*);
extern  bool_t xdr_guestfs_fill_args (XDR *, guestfs_fill_args*);
extern  bool_t xdr_guestfs_available_args (XDR *, guestfs_available_args*);
extern  bool_t xdr_guestfs_dd_args (XDR *, guestfs_dd_args*);
extern  bool_t xdr_guestfs_filesize_args (XDR *, guestfs_filesize_args*);
extern  bool_t xdr_guestfs_filesize_ret (XDR *, guestfs_filesize_ret*);
extern  bool_t xdr_guestfs_lvrename_args (XDR *, guestfs_lvrename_args*);
extern  bool_t xdr_guestfs_vgrename_args (XDR *, guestfs_vgrename_args*);
extern  bool_t xdr_guestfs_initrd_cat_args (XDR *, guestfs_initrd_cat_args*);
extern  bool_t xdr_guestfs_initrd_cat_ret (XDR *, guestfs_initrd_cat_ret*);
extern  bool_t xdr_guestfs_pvuuid_args (XDR *, guestfs_pvuuid_args*);
extern  bool_t xdr_guestfs_pvuuid_ret (XDR *, guestfs_pvuuid_ret*);
extern  bool_t xdr_guestfs_vguuid_args (XDR *, guestfs_vguuid_args*);
extern  bool_t xdr_guestfs_vguuid_ret (XDR *, guestfs_vguuid_ret*);
extern  bool_t xdr_guestfs_lvuuid_args (XDR *, guestfs_lvuuid_args*);
extern  bool_t xdr_guestfs_lvuuid_ret (XDR *, guestfs_lvuuid_ret*);
extern  bool_t xdr_guestfs_vgpvuuids_args (XDR *, guestfs_vgpvuuids_args*);
extern  bool_t xdr_guestfs_vgpvuuids_ret (XDR *, guestfs_vgpvuuids_ret*);
extern  bool_t xdr_guestfs_vglvuuids_args (XDR *, guestfs_vglvuuids_args*);
extern  bool_t xdr_guestfs_vglvuuids_ret (XDR *, guestfs_vglvuuids_ret*);
extern  bool_t xdr_guestfs_copy_size_args (XDR *, guestfs_copy_size_args*);
extern  bool_t xdr_guestfs_zero_device_args (XDR *, guestfs_zero_device_args*);
extern  bool_t xdr_guestfs_txz_in_args (XDR *, guestfs_txz_in_args*);
extern  bool_t xdr_guestfs_txz_out_args (XDR *, guestfs_txz_out_args*);
extern  bool_t xdr_guestfs_ntfsresize_args (XDR *, guestfs_ntfsresize_args*);
extern  bool_t xdr_guestfs_part_del_args (XDR *, guestfs_part_del_args*);
extern  bool_t xdr_guestfs_part_get_bootable_args (XDR *, guestfs_part_get_bootable_args*);
extern  bool_t xdr_guestfs_part_get_bootable_ret (XDR *, guestfs_part_get_bootable_ret*);
extern  bool_t xdr_guestfs_part_get_mbr_id_args (XDR *, guestfs_part_get_mbr_id_args*);
extern  bool_t xdr_guestfs_part_get_mbr_id_ret (XDR *, guestfs_part_get_mbr_id_ret*);
extern  bool_t xdr_guestfs_part_set_mbr_id_args (XDR *, guestfs_part_set_mbr_id_args*);
extern  bool_t xdr_guestfs_checksum_device_args (XDR *, guestfs_checksum_device_args*);
extern  bool_t xdr_guestfs_checksum_device_ret (XDR *, guestfs_checksum_device_ret*);
extern  bool_t xdr_guestfs_lvresize_free_args (XDR *, guestfs_lvresize_free_args*);
extern  bool_t xdr_guestfs_aug_clear_args (XDR *, guestfs_aug_clear_args*);
extern  bool_t xdr_guestfs_get_umask_ret (XDR *, guestfs_get_umask_ret*);
extern  bool_t xdr_guestfs_debug_upload_args (XDR *, guestfs_debug_upload_args*);
extern  bool_t xdr_guestfs_base64_in_args (XDR *, guestfs_base64_in_args*);
extern  bool_t xdr_guestfs_base64_out_args (XDR *, guestfs_base64_out_args*);
extern  bool_t xdr_guestfs_checksums_out_args (XDR *, guestfs_checksums_out_args*);
extern  bool_t xdr_guestfs_fill_pattern_args (XDR *, guestfs_fill_pattern_args*);
extern  bool_t xdr_guestfs_write_args (XDR *, guestfs_write_args*);
extern  bool_t xdr_guestfs_pwrite_args (XDR *, guestfs_pwrite_args*);
extern  bool_t xdr_guestfs_pwrite_ret (XDR *, guestfs_pwrite_ret*);
extern  bool_t xdr_guestfs_resize2fs_size_args (XDR *, guestfs_resize2fs_size_args*);
extern  bool_t xdr_guestfs_pvresize_size_args (XDR *, guestfs_pvresize_size_args*);
extern  bool_t xdr_guestfs_ntfsresize_size_args (XDR *, guestfs_ntfsresize_size_args*);
extern  bool_t xdr_guestfs_available_all_groups_ret (XDR *, guestfs_available_all_groups_ret*);
extern  bool_t xdr_guestfs_fallocate64_args (XDR *, guestfs_fallocate64_args*);
extern  bool_t xdr_guestfs_vfs_label_args (XDR *, guestfs_vfs_label_args*);
extern  bool_t xdr_guestfs_vfs_label_ret (XDR *, guestfs_vfs_label_ret*);
extern  bool_t xdr_guestfs_vfs_uuid_args (XDR *, guestfs_vfs_uuid_args*);
extern  bool_t xdr_guestfs_vfs_uuid_ret (XDR *, guestfs_vfs_uuid_ret*);
extern  bool_t xdr_guestfs_lvm_set_filter_args (XDR *, guestfs_lvm_set_filter_args*);
extern  bool_t xdr_guestfs_luks_open_args (XDR *, guestfs_luks_open_args*);
extern  bool_t xdr_guestfs_luks_open_ro_args (XDR *, guestfs_luks_open_ro_args*);
extern  bool_t xdr_guestfs_luks_close_args (XDR *, guestfs_luks_close_args*);
extern  bool_t xdr_guestfs_luks_format_args (XDR *, guestfs_luks_format_args*);
extern  bool_t xdr_guestfs_luks_format_cipher_args (XDR *, guestfs_luks_format_cipher_args*);
extern  bool_t xdr_guestfs_luks_add_key_args (XDR *, guestfs_luks_add_key_args*);
extern  bool_t xdr_guestfs_luks_kill_slot_args (XDR *, guestfs_luks_kill_slot_args*);
extern  bool_t xdr_guestfs_is_lv_args (XDR *, guestfs_is_lv_args*);
extern  bool_t xdr_guestfs_is_lv_ret (XDR *, guestfs_is_lv_ret*);
extern  bool_t xdr_guestfs_findfs_uuid_args (XDR *, guestfs_findfs_uuid_args*);
extern  bool_t xdr_guestfs_findfs_uuid_ret (XDR *, guestfs_findfs_uuid_ret*);
extern  bool_t xdr_guestfs_findfs_label_args (XDR *, guestfs_findfs_label_args*);
extern  bool_t xdr_guestfs_findfs_label_ret (XDR *, guestfs_findfs_label_ret*);
extern  bool_t xdr_guestfs_is_chardev_args (XDR *, guestfs_is_chardev_args*);
extern  bool_t xdr_guestfs_is_chardev_ret (XDR *, guestfs_is_chardev_ret*);
extern  bool_t xdr_guestfs_is_blockdev_args (XDR *, guestfs_is_blockdev_args*);
extern  bool_t xdr_guestfs_is_blockdev_ret (XDR *, guestfs_is_blockdev_ret*);
extern  bool_t xdr_guestfs_is_fifo_args (XDR *, guestfs_is_fifo_args*);
extern  bool_t xdr_guestfs_is_fifo_ret (XDR *, guestfs_is_fifo_ret*);
extern  bool_t xdr_guestfs_is_symlink_args (XDR *, guestfs_is_symlink_args*);
extern  bool_t xdr_guestfs_is_symlink_ret (XDR *, guestfs_is_symlink_ret*);
extern  bool_t xdr_guestfs_is_socket_args (XDR *, guestfs_is_socket_args*);
extern  bool_t xdr_guestfs_is_socket_ret (XDR *, guestfs_is_socket_ret*);
extern  bool_t xdr_guestfs_part_to_dev_args (XDR *, guestfs_part_to_dev_args*);
extern  bool_t xdr_guestfs_part_to_dev_ret (XDR *, guestfs_part_to_dev_ret*);
extern  bool_t xdr_guestfs_upload_offset_args (XDR *, guestfs_upload_offset_args*);
extern  bool_t xdr_guestfs_download_offset_args (XDR *, guestfs_download_offset_args*);
extern  bool_t xdr_guestfs_pwrite_device_args (XDR *, guestfs_pwrite_device_args*);
extern  bool_t xdr_guestfs_pwrite_device_ret (XDR *, guestfs_pwrite_device_ret*);
extern  bool_t xdr_guestfs_pread_device_args (XDR *, guestfs_pread_device_args*);
extern  bool_t xdr_guestfs_pread_device_ret (XDR *, guestfs_pread_device_ret*);
extern  bool_t xdr_guestfs_lvm_canonical_lv_name_args (XDR *, guestfs_lvm_canonical_lv_name_args*);
extern  bool_t xdr_guestfs_lvm_canonical_lv_name_ret (XDR *, guestfs_lvm_canonical_lv_name_ret*);
extern  bool_t xdr_guestfs_mkfs_opts_args (XDR *, guestfs_mkfs_opts_args*);
extern  bool_t xdr_guestfs_getxattr_args (XDR *, guestfs_getxattr_args*);
extern  bool_t xdr_guestfs_getxattr_ret (XDR *, guestfs_getxattr_ret*);
extern  bool_t xdr_guestfs_lgetxattr_args (XDR *, guestfs_lgetxattr_args*);
extern  bool_t xdr_guestfs_lgetxattr_ret (XDR *, guestfs_lgetxattr_ret*);
extern  bool_t xdr_guestfs_resize2fs_M_args (XDR *, guestfs_resize2fs_M_args*);
extern  bool_t xdr_guestfs_is_zero_args (XDR *, guestfs_is_zero_args*);
extern  bool_t xdr_guestfs_is_zero_ret (XDR *, guestfs_is_zero_ret*);
extern  bool_t xdr_guestfs_is_zero_device_args (XDR *, guestfs_is_zero_device_args*);
extern  bool_t xdr_guestfs_is_zero_device_ret (XDR *, guestfs_is_zero_device_ret*);
extern  bool_t xdr_guestfs_list_9p_ret (XDR *, guestfs_list_9p_ret*);
extern  bool_t xdr_guestfs_mount_9p_args (XDR *, guestfs_mount_9p_args*);
extern  bool_t xdr_guestfs_list_dm_devices_ret (XDR *, guestfs_list_dm_devices_ret*);
extern  bool_t xdr_guestfs_ntfsresize_opts_args (XDR *, guestfs_ntfsresize_opts_args*);
extern  bool_t xdr_guestfs_btrfs_filesystem_resize_args (XDR *, guestfs_btrfs_filesystem_resize_args*);
extern  bool_t xdr_guestfs_write_append_args (XDR *, guestfs_write_append_args*);
extern  bool_t xdr_guestfs_compress_out_args (XDR *, guestfs_compress_out_args*);
extern  bool_t xdr_guestfs_compress_device_out_args (XDR *, guestfs_compress_device_out_args*);
extern  bool_t xdr_guestfs_part_to_partnum_args (XDR *, guestfs_part_to_partnum_args*);
extern  bool_t xdr_guestfs_part_to_partnum_ret (XDR *, guestfs_part_to_partnum_ret*);
extern  bool_t xdr_guestfs_copy_device_to_device_args (XDR *, guestfs_copy_device_to_device_args*);
extern  bool_t xdr_guestfs_copy_device_to_file_args (XDR *, guestfs_copy_device_to_file_args*);
extern  bool_t xdr_guestfs_copy_file_to_device_args (XDR *, guestfs_copy_file_to_device_args*);
extern  bool_t xdr_guestfs_copy_file_to_file_args (XDR *, guestfs_copy_file_to_file_args*);
extern  bool_t xdr_guestfs_tune2fs_args (XDR *, guestfs_tune2fs_args*);
extern  bool_t xdr_guestfs_md_create_args (XDR *, guestfs_md_create_args*);
extern  bool_t xdr_guestfs_list_md_devices_ret (XDR *, guestfs_list_md_devices_ret*);
extern  bool_t xdr_guestfs_md_detail_args (XDR *, guestfs_md_detail_args*);
extern  bool_t xdr_guestfs_md_detail_ret (XDR *, guestfs_md_detail_ret*);
extern  bool_t xdr_guestfs_md_stop_args (XDR *, guestfs_md_stop_args*);
extern  bool_t xdr_guestfs_blkid_args (XDR *, guestfs_blkid_args*);
extern  bool_t xdr_guestfs_blkid_ret (XDR *, guestfs_blkid_ret*);
extern  bool_t xdr_guestfs_e2fsck_args (XDR *, guestfs_e2fsck_args*);
extern  bool_t xdr_guestfs_procedure (XDR *, guestfs_procedure*);
extern  bool_t xdr_guestfs_message_direction (XDR *, guestfs_message_direction*);
extern  bool_t xdr_guestfs_message_status (XDR *, guestfs_message_status*);
extern  bool_t xdr_guestfs_message_error (XDR *, guestfs_message_error*);
extern  bool_t xdr_guestfs_message_header (XDR *, guestfs_message_header*);
extern  bool_t xdr_guestfs_chunk (XDR *, guestfs_chunk*);
extern  bool_t xdr_guestfs_progress (XDR *, guestfs_progress*);

#else /* K&R C */
extern bool_t xdr_guestfs_str ();
extern bool_t xdr_guestfs_int_int_bool ();
extern bool_t xdr_guestfs_int_int_bool_list ();
extern bool_t xdr_guestfs_int_lvm_pv ();
extern bool_t xdr_guestfs_int_lvm_pv_list ();
extern bool_t xdr_guestfs_int_lvm_vg ();
extern bool_t xdr_guestfs_int_lvm_vg_list ();
extern bool_t xdr_guestfs_int_lvm_lv ();
extern bool_t xdr_guestfs_int_lvm_lv_list ();
extern bool_t xdr_guestfs_int_stat ();
extern bool_t xdr_guestfs_int_stat_list ();
extern bool_t xdr_guestfs_int_statvfs ();
extern bool_t xdr_guestfs_int_statvfs_list ();
extern bool_t xdr_guestfs_int_dirent ();
extern bool_t xdr_guestfs_int_dirent_list ();
extern bool_t xdr_guestfs_int_version ();
extern bool_t xdr_guestfs_int_version_list ();
extern bool_t xdr_guestfs_int_xattr ();
extern bool_t xdr_guestfs_int_xattr_list ();
extern bool_t xdr_guestfs_int_inotify_event ();
extern bool_t xdr_guestfs_int_inotify_event_list ();
extern bool_t xdr_guestfs_int_partition ();
extern bool_t xdr_guestfs_int_partition_list ();
extern bool_t xdr_guestfs_int_application ();
extern bool_t xdr_guestfs_int_application_list ();
extern bool_t xdr_guestfs_mount_args ();
extern bool_t xdr_guestfs_touch_args ();
extern bool_t xdr_guestfs_cat_args ();
extern bool_t xdr_guestfs_cat_ret ();
extern bool_t xdr_guestfs_ll_args ();
extern bool_t xdr_guestfs_ll_ret ();
extern bool_t xdr_guestfs_ls_args ();
extern bool_t xdr_guestfs_ls_ret ();
extern bool_t xdr_guestfs_list_devices_ret ();
extern bool_t xdr_guestfs_list_partitions_ret ();
extern bool_t xdr_guestfs_pvs_ret ();
extern bool_t xdr_guestfs_vgs_ret ();
extern bool_t xdr_guestfs_lvs_ret ();
extern bool_t xdr_guestfs_pvs_full_ret ();
extern bool_t xdr_guestfs_vgs_full_ret ();
extern bool_t xdr_guestfs_lvs_full_ret ();
extern bool_t xdr_guestfs_read_lines_args ();
extern bool_t xdr_guestfs_read_lines_ret ();
extern bool_t xdr_guestfs_aug_init_args ();
extern bool_t xdr_guestfs_aug_defvar_args ();
extern bool_t xdr_guestfs_aug_defvar_ret ();
extern bool_t xdr_guestfs_aug_defnode_args ();
extern bool_t xdr_guestfs_aug_defnode_ret ();
extern bool_t xdr_guestfs_aug_get_args ();
extern bool_t xdr_guestfs_aug_get_ret ();
extern bool_t xdr_guestfs_aug_set_args ();
extern bool_t xdr_guestfs_aug_insert_args ();
extern bool_t xdr_guestfs_aug_rm_args ();
extern bool_t xdr_guestfs_aug_rm_ret ();
extern bool_t xdr_guestfs_aug_mv_args ();
extern bool_t xdr_guestfs_aug_match_args ();
extern bool_t xdr_guestfs_aug_match_ret ();
extern bool_t xdr_guestfs_aug_ls_args ();
extern bool_t xdr_guestfs_aug_ls_ret ();
extern bool_t xdr_guestfs_rm_args ();
extern bool_t xdr_guestfs_rmdir_args ();
extern bool_t xdr_guestfs_rm_rf_args ();
extern bool_t xdr_guestfs_mkdir_args ();
extern bool_t xdr_guestfs_mkdir_p_args ();
extern bool_t xdr_guestfs_chmod_args ();
extern bool_t xdr_guestfs_chown_args ();
extern bool_t xdr_guestfs_exists_args ();
extern bool_t xdr_guestfs_exists_ret ();
extern bool_t xdr_guestfs_is_file_args ();
extern bool_t xdr_guestfs_is_file_ret ();
extern bool_t xdr_guestfs_is_dir_args ();
extern bool_t xdr_guestfs_is_dir_ret ();
extern bool_t xdr_guestfs_pvcreate_args ();
extern bool_t xdr_guestfs_vgcreate_args ();
extern bool_t xdr_guestfs_lvcreate_args ();
extern bool_t xdr_guestfs_mkfs_args ();
extern bool_t xdr_guestfs_sfdisk_args ();
extern bool_t xdr_guestfs_write_file_args ();
extern bool_t xdr_guestfs_umount_args ();
extern bool_t xdr_guestfs_mounts_ret ();
extern bool_t xdr_guestfs_file_args ();
extern bool_t xdr_guestfs_file_ret ();
extern bool_t xdr_guestfs_command_args ();
extern bool_t xdr_guestfs_command_ret ();
extern bool_t xdr_guestfs_command_lines_args ();
extern bool_t xdr_guestfs_command_lines_ret ();
extern bool_t xdr_guestfs_stat_args ();
extern bool_t xdr_guestfs_stat_ret ();
extern bool_t xdr_guestfs_lstat_args ();
extern bool_t xdr_guestfs_lstat_ret ();
extern bool_t xdr_guestfs_statvfs_args ();
extern bool_t xdr_guestfs_statvfs_ret ();
extern bool_t xdr_guestfs_tune2fs_l_args ();
extern bool_t xdr_guestfs_tune2fs_l_ret ();
extern bool_t xdr_guestfs_blockdev_setro_args ();
extern bool_t xdr_guestfs_blockdev_setrw_args ();
extern bool_t xdr_guestfs_blockdev_getro_args ();
extern bool_t xdr_guestfs_blockdev_getro_ret ();
extern bool_t xdr_guestfs_blockdev_getss_args ();
extern bool_t xdr_guestfs_blockdev_getss_ret ();
extern bool_t xdr_guestfs_blockdev_getbsz_args ();
extern bool_t xdr_guestfs_blockdev_getbsz_ret ();
extern bool_t xdr_guestfs_blockdev_setbsz_args ();
extern bool_t xdr_guestfs_blockdev_getsz_args ();
extern bool_t xdr_guestfs_blockdev_getsz_ret ();
extern bool_t xdr_guestfs_blockdev_getsize64_args ();
extern bool_t xdr_guestfs_blockdev_getsize64_ret ();
extern bool_t xdr_guestfs_blockdev_flushbufs_args ();
extern bool_t xdr_guestfs_blockdev_rereadpt_args ();
extern bool_t xdr_guestfs_upload_args ();
extern bool_t xdr_guestfs_download_args ();
extern bool_t xdr_guestfs_checksum_args ();
extern bool_t xdr_guestfs_checksum_ret ();
extern bool_t xdr_guestfs_tar_in_args ();
extern bool_t xdr_guestfs_tar_out_args ();
extern bool_t xdr_guestfs_tgz_in_args ();
extern bool_t xdr_guestfs_tgz_out_args ();
extern bool_t xdr_guestfs_mount_ro_args ();
extern bool_t xdr_guestfs_mount_options_args ();
extern bool_t xdr_guestfs_mount_vfs_args ();
extern bool_t xdr_guestfs_debug_args ();
extern bool_t xdr_guestfs_debug_ret ();
extern bool_t xdr_guestfs_lvremove_args ();
extern bool_t xdr_guestfs_vgremove_args ();
extern bool_t xdr_guestfs_pvremove_args ();
extern bool_t xdr_guestfs_set_e2label_args ();
extern bool_t xdr_guestfs_get_e2label_args ();
extern bool_t xdr_guestfs_get_e2label_ret ();
extern bool_t xdr_guestfs_set_e2uuid_args ();
extern bool_t xdr_guestfs_get_e2uuid_args ();
extern bool_t xdr_guestfs_get_e2uuid_ret ();
extern bool_t xdr_guestfs_fsck_args ();
extern bool_t xdr_guestfs_fsck_ret ();
extern bool_t xdr_guestfs_zero_args ();
extern bool_t xdr_guestfs_grub_install_args ();
extern bool_t xdr_guestfs_cp_args ();
extern bool_t xdr_guestfs_cp_a_args ();
extern bool_t xdr_guestfs_mv_args ();
extern bool_t xdr_guestfs_drop_caches_args ();
extern bool_t xdr_guestfs_dmesg_ret ();
extern bool_t xdr_guestfs_equal_args ();
extern bool_t xdr_guestfs_equal_ret ();
extern bool_t xdr_guestfs_strings_args ();
extern bool_t xdr_guestfs_strings_ret ();
extern bool_t xdr_guestfs_strings_e_args ();
extern bool_t xdr_guestfs_strings_e_ret ();
extern bool_t xdr_guestfs_hexdump_args ();
extern bool_t xdr_guestfs_hexdump_ret ();
extern bool_t xdr_guestfs_zerofree_args ();
extern bool_t xdr_guestfs_pvresize_args ();
extern bool_t xdr_guestfs_sfdisk_N_args ();
extern bool_t xdr_guestfs_sfdisk_l_args ();
extern bool_t xdr_guestfs_sfdisk_l_ret ();
extern bool_t xdr_guestfs_sfdisk_kernel_geometry_args ();
extern bool_t xdr_guestfs_sfdisk_kernel_geometry_ret ();
extern bool_t xdr_guestfs_sfdisk_disk_geometry_args ();
extern bool_t xdr_guestfs_sfdisk_disk_geometry_ret ();
extern bool_t xdr_guestfs_vg_activate_all_args ();
extern bool_t xdr_guestfs_vg_activate_args ();
extern bool_t xdr_guestfs_lvresize_args ();
extern bool_t xdr_guestfs_resize2fs_args ();
extern bool_t xdr_guestfs_find_args ();
extern bool_t xdr_guestfs_find_ret ();
extern bool_t xdr_guestfs_e2fsck_f_args ();
extern bool_t xdr_guestfs_sleep_args ();
extern bool_t xdr_guestfs_ntfs_3g_probe_args ();
extern bool_t xdr_guestfs_ntfs_3g_probe_ret ();
extern bool_t xdr_guestfs_sh_args ();
extern bool_t xdr_guestfs_sh_ret ();
extern bool_t xdr_guestfs_sh_lines_args ();
extern bool_t xdr_guestfs_sh_lines_ret ();
extern bool_t xdr_guestfs_glob_expand_args ();
extern bool_t xdr_guestfs_glob_expand_ret ();
extern bool_t xdr_guestfs_scrub_device_args ();
extern bool_t xdr_guestfs_scrub_file_args ();
extern bool_t xdr_guestfs_scrub_freespace_args ();
extern bool_t xdr_guestfs_mkdtemp_args ();
extern bool_t xdr_guestfs_mkdtemp_ret ();
extern bool_t xdr_guestfs_wc_l_args ();
extern bool_t xdr_guestfs_wc_l_ret ();
extern bool_t xdr_guestfs_wc_w_args ();
extern bool_t xdr_guestfs_wc_w_ret ();
extern bool_t xdr_guestfs_wc_c_args ();
extern bool_t xdr_guestfs_wc_c_ret ();
extern bool_t xdr_guestfs_head_args ();
extern bool_t xdr_guestfs_head_ret ();
extern bool_t xdr_guestfs_head_n_args ();
extern bool_t xdr_guestfs_head_n_ret ();
extern bool_t xdr_guestfs_tail_args ();
extern bool_t xdr_guestfs_tail_ret ();
extern bool_t xdr_guestfs_tail_n_args ();
extern bool_t xdr_guestfs_tail_n_ret ();
extern bool_t xdr_guestfs_df_ret ();
extern bool_t xdr_guestfs_df_h_ret ();
extern bool_t xdr_guestfs_du_args ();
extern bool_t xdr_guestfs_du_ret ();
extern bool_t xdr_guestfs_initrd_list_args ();
extern bool_t xdr_guestfs_initrd_list_ret ();
extern bool_t xdr_guestfs_mount_loop_args ();
extern bool_t xdr_guestfs_mkswap_args ();
extern bool_t xdr_guestfs_mkswap_L_args ();
extern bool_t xdr_guestfs_mkswap_U_args ();
extern bool_t xdr_guestfs_mknod_args ();
extern bool_t xdr_guestfs_mkfifo_args ();
extern bool_t xdr_guestfs_mknod_b_args ();
extern bool_t xdr_guestfs_mknod_c_args ();
extern bool_t xdr_guestfs_umask_args ();
extern bool_t xdr_guestfs_umask_ret ();
extern bool_t xdr_guestfs_readdir_args ();
extern bool_t xdr_guestfs_readdir_ret ();
extern bool_t xdr_guestfs_sfdiskM_args ();
extern bool_t xdr_guestfs_zfile_args ();
extern bool_t xdr_guestfs_zfile_ret ();
extern bool_t xdr_guestfs_getxattrs_args ();
extern bool_t xdr_guestfs_getxattrs_ret ();
extern bool_t xdr_guestfs_lgetxattrs_args ();
extern bool_t xdr_guestfs_lgetxattrs_ret ();
extern bool_t xdr_guestfs_setxattr_args ();
extern bool_t xdr_guestfs_lsetxattr_args ();
extern bool_t xdr_guestfs_removexattr_args ();
extern bool_t xdr_guestfs_lremovexattr_args ();
extern bool_t xdr_guestfs_mountpoints_ret ();
extern bool_t xdr_guestfs_mkmountpoint_args ();
extern bool_t xdr_guestfs_rmmountpoint_args ();
extern bool_t xdr_guestfs_read_file_args ();
extern bool_t xdr_guestfs_read_file_ret ();
extern bool_t xdr_guestfs_grep_args ();
extern bool_t xdr_guestfs_grep_ret ();
extern bool_t xdr_guestfs_egrep_args ();
extern bool_t xdr_guestfs_egrep_ret ();
extern bool_t xdr_guestfs_fgrep_args ();
extern bool_t xdr_guestfs_fgrep_ret ();
extern bool_t xdr_guestfs_grepi_args ();
extern bool_t xdr_guestfs_grepi_ret ();
extern bool_t xdr_guestfs_egrepi_args ();
extern bool_t xdr_guestfs_egrepi_ret ();
extern bool_t xdr_guestfs_fgrepi_args ();
extern bool_t xdr_guestfs_fgrepi_ret ();
extern bool_t xdr_guestfs_zgrep_args ();
extern bool_t xdr_guestfs_zgrep_ret ();
extern bool_t xdr_guestfs_zegrep_args ();
extern bool_t xdr_guestfs_zegrep_ret ();
extern bool_t xdr_guestfs_zfgrep_args ();
extern bool_t xdr_guestfs_zfgrep_ret ();
extern bool_t xdr_guestfs_zgrepi_args ();
extern bool_t xdr_guestfs_zgrepi_ret ();
extern bool_t xdr_guestfs_zegrepi_args ();
extern bool_t xdr_guestfs_zegrepi_ret ();
extern bool_t xdr_guestfs_zfgrepi_args ();
extern bool_t xdr_guestfs_zfgrepi_ret ();
extern bool_t xdr_guestfs_realpath_args ();
extern bool_t xdr_guestfs_realpath_ret ();
extern bool_t xdr_guestfs_ln_args ();
extern bool_t xdr_guestfs_ln_f_args ();
extern bool_t xdr_guestfs_ln_s_args ();
extern bool_t xdr_guestfs_ln_sf_args ();
extern bool_t xdr_guestfs_readlink_args ();
extern bool_t xdr_guestfs_readlink_ret ();
extern bool_t xdr_guestfs_fallocate_args ();
extern bool_t xdr_guestfs_swapon_device_args ();
extern bool_t xdr_guestfs_swapoff_device_args ();
extern bool_t xdr_guestfs_swapon_file_args ();
extern bool_t xdr_guestfs_swapoff_file_args ();
extern bool_t xdr_guestfs_swapon_label_args ();
extern bool_t xdr_guestfs_swapoff_label_args ();
extern bool_t xdr_guestfs_swapon_uuid_args ();
extern bool_t xdr_guestfs_swapoff_uuid_args ();
extern bool_t xdr_guestfs_mkswap_file_args ();
extern bool_t xdr_guestfs_inotify_init_args ();
extern bool_t xdr_guestfs_inotify_add_watch_args ();
extern bool_t xdr_guestfs_inotify_add_watch_ret ();
extern bool_t xdr_guestfs_inotify_rm_watch_args ();
extern bool_t xdr_guestfs_inotify_read_ret ();
extern bool_t xdr_guestfs_inotify_files_ret ();
extern bool_t xdr_guestfs_setcon_args ();
extern bool_t xdr_guestfs_getcon_ret ();
extern bool_t xdr_guestfs_mkfs_b_args ();
extern bool_t xdr_guestfs_mke2journal_args ();
extern bool_t xdr_guestfs_mke2journal_L_args ();
extern bool_t xdr_guestfs_mke2journal_U_args ();
extern bool_t xdr_guestfs_mke2fs_J_args ();
extern bool_t xdr_guestfs_mke2fs_JL_args ();
extern bool_t xdr_guestfs_mke2fs_JU_args ();
extern bool_t xdr_guestfs_modprobe_args ();
extern bool_t xdr_guestfs_echo_daemon_args ();
extern bool_t xdr_guestfs_echo_daemon_ret ();
extern bool_t xdr_guestfs_find0_args ();
extern bool_t xdr_guestfs_case_sensitive_path_args ();
extern bool_t xdr_guestfs_case_sensitive_path_ret ();
extern bool_t xdr_guestfs_vfs_type_args ();
extern bool_t xdr_guestfs_vfs_type_ret ();
extern bool_t xdr_guestfs_truncate_args ();
extern bool_t xdr_guestfs_truncate_size_args ();
extern bool_t xdr_guestfs_utimens_args ();
extern bool_t xdr_guestfs_mkdir_mode_args ();
extern bool_t xdr_guestfs_lchown_args ();
extern bool_t xdr_guestfs_lstatlist_args ();
extern bool_t xdr_guestfs_lstatlist_ret ();
extern bool_t xdr_guestfs_lxattrlist_args ();
extern bool_t xdr_guestfs_lxattrlist_ret ();
extern bool_t xdr_guestfs_readlinklist_args ();
extern bool_t xdr_guestfs_readlinklist_ret ();
extern bool_t xdr_guestfs_pread_args ();
extern bool_t xdr_guestfs_pread_ret ();
extern bool_t xdr_guestfs_part_init_args ();
extern bool_t xdr_guestfs_part_add_args ();
extern bool_t xdr_guestfs_part_disk_args ();
extern bool_t xdr_guestfs_part_set_bootable_args ();
extern bool_t xdr_guestfs_part_set_name_args ();
extern bool_t xdr_guestfs_part_list_args ();
extern bool_t xdr_guestfs_part_list_ret ();
extern bool_t xdr_guestfs_part_get_parttype_args ();
extern bool_t xdr_guestfs_part_get_parttype_ret ();
extern bool_t xdr_guestfs_fill_args ();
extern bool_t xdr_guestfs_available_args ();
extern bool_t xdr_guestfs_dd_args ();
extern bool_t xdr_guestfs_filesize_args ();
extern bool_t xdr_guestfs_filesize_ret ();
extern bool_t xdr_guestfs_lvrename_args ();
extern bool_t xdr_guestfs_vgrename_args ();
extern bool_t xdr_guestfs_initrd_cat_args ();
extern bool_t xdr_guestfs_initrd_cat_ret ();
extern bool_t xdr_guestfs_pvuuid_args ();
extern bool_t xdr_guestfs_pvuuid_ret ();
extern bool_t xdr_guestfs_vguuid_args ();
extern bool_t xdr_guestfs_vguuid_ret ();
extern bool_t xdr_guestfs_lvuuid_args ();
extern bool_t xdr_guestfs_lvuuid_ret ();
extern bool_t xdr_guestfs_vgpvuuids_args ();
extern bool_t xdr_guestfs_vgpvuuids_ret ();
extern bool_t xdr_guestfs_vglvuuids_args ();
extern bool_t xdr_guestfs_vglvuuids_ret ();
extern bool_t xdr_guestfs_copy_size_args ();
extern bool_t xdr_guestfs_zero_device_args ();
extern bool_t xdr_guestfs_txz_in_args ();
extern bool_t xdr_guestfs_txz_out_args ();
extern bool_t xdr_guestfs_ntfsresize_args ();
extern bool_t xdr_guestfs_part_del_args ();
extern bool_t xdr_guestfs_part_get_bootable_args ();
extern bool_t xdr_guestfs_part_get_bootable_ret ();
extern bool_t xdr_guestfs_part_get_mbr_id_args ();
extern bool_t xdr_guestfs_part_get_mbr_id_ret ();
extern bool_t xdr_guestfs_part_set_mbr_id_args ();
extern bool_t xdr_guestfs_checksum_device_args ();
extern bool_t xdr_guestfs_checksum_device_ret ();
extern bool_t xdr_guestfs_lvresize_free_args ();
extern bool_t xdr_guestfs_aug_clear_args ();
extern bool_t xdr_guestfs_get_umask_ret ();
extern bool_t xdr_guestfs_debug_upload_args ();
extern bool_t xdr_guestfs_base64_in_args ();
extern bool_t xdr_guestfs_base64_out_args ();
extern bool_t xdr_guestfs_checksums_out_args ();
extern bool_t xdr_guestfs_fill_pattern_args ();
extern bool_t xdr_guestfs_write_args ();
extern bool_t xdr_guestfs_pwrite_args ();
extern bool_t xdr_guestfs_pwrite_ret ();
extern bool_t xdr_guestfs_resize2fs_size_args ();
extern bool_t xdr_guestfs_pvresize_size_args ();
extern bool_t xdr_guestfs_ntfsresize_size_args ();
extern bool_t xdr_guestfs_available_all_groups_ret ();
extern bool_t xdr_guestfs_fallocate64_args ();
extern bool_t xdr_guestfs_vfs_label_args ();
extern bool_t xdr_guestfs_vfs_label_ret ();
extern bool_t xdr_guestfs_vfs_uuid_args ();
extern bool_t xdr_guestfs_vfs_uuid_ret ();
extern bool_t xdr_guestfs_lvm_set_filter_args ();
extern bool_t xdr_guestfs_luks_open_args ();
extern bool_t xdr_guestfs_luks_open_ro_args ();
extern bool_t xdr_guestfs_luks_close_args ();
extern bool_t xdr_guestfs_luks_format_args ();
extern bool_t xdr_guestfs_luks_format_cipher_args ();
extern bool_t xdr_guestfs_luks_add_key_args ();
extern bool_t xdr_guestfs_luks_kill_slot_args ();
extern bool_t xdr_guestfs_is_lv_args ();
extern bool_t xdr_guestfs_is_lv_ret ();
extern bool_t xdr_guestfs_findfs_uuid_args ();
extern bool_t xdr_guestfs_findfs_uuid_ret ();
extern bool_t xdr_guestfs_findfs_label_args ();
extern bool_t xdr_guestfs_findfs_label_ret ();
extern bool_t xdr_guestfs_is_chardev_args ();
extern bool_t xdr_guestfs_is_chardev_ret ();
extern bool_t xdr_guestfs_is_blockdev_args ();
extern bool_t xdr_guestfs_is_blockdev_ret ();
extern bool_t xdr_guestfs_is_fifo_args ();
extern bool_t xdr_guestfs_is_fifo_ret ();
extern bool_t xdr_guestfs_is_symlink_args ();
extern bool_t xdr_guestfs_is_symlink_ret ();
extern bool_t xdr_guestfs_is_socket_args ();
extern bool_t xdr_guestfs_is_socket_ret ();
extern bool_t xdr_guestfs_part_to_dev_args ();
extern bool_t xdr_guestfs_part_to_dev_ret ();
extern bool_t xdr_guestfs_upload_offset_args ();
extern bool_t xdr_guestfs_download_offset_args ();
extern bool_t xdr_guestfs_pwrite_device_args ();
extern bool_t xdr_guestfs_pwrite_device_ret ();
extern bool_t xdr_guestfs_pread_device_args ();
extern bool_t xdr_guestfs_pread_device_ret ();
extern bool_t xdr_guestfs_lvm_canonical_lv_name_args ();
extern bool_t xdr_guestfs_lvm_canonical_lv_name_ret ();
extern bool_t xdr_guestfs_mkfs_opts_args ();
extern bool_t xdr_guestfs_getxattr_args ();
extern bool_t xdr_guestfs_getxattr_ret ();
extern bool_t xdr_guestfs_lgetxattr_args ();
extern bool_t xdr_guestfs_lgetxattr_ret ();
extern bool_t xdr_guestfs_resize2fs_M_args ();
extern bool_t xdr_guestfs_is_zero_args ();
extern bool_t xdr_guestfs_is_zero_ret ();
extern bool_t xdr_guestfs_is_zero_device_args ();
extern bool_t xdr_guestfs_is_zero_device_ret ();
extern bool_t xdr_guestfs_list_9p_ret ();
extern bool_t xdr_guestfs_mount_9p_args ();
extern bool_t xdr_guestfs_list_dm_devices_ret ();
extern bool_t xdr_guestfs_ntfsresize_opts_args ();
extern bool_t xdr_guestfs_btrfs_filesystem_resize_args ();
extern bool_t xdr_guestfs_write_append_args ();
extern bool_t xdr_guestfs_compress_out_args ();
extern bool_t xdr_guestfs_compress_device_out_args ();
extern bool_t xdr_guestfs_part_to_partnum_args ();
extern bool_t xdr_guestfs_part_to_partnum_ret ();
extern bool_t xdr_guestfs_copy_device_to_device_args ();
extern bool_t xdr_guestfs_copy_device_to_file_args ();
extern bool_t xdr_guestfs_copy_file_to_device_args ();
extern bool_t xdr_guestfs_copy_file_to_file_args ();
extern bool_t xdr_guestfs_tune2fs_args ();
extern bool_t xdr_guestfs_md_create_args ();
extern bool_t xdr_guestfs_list_md_devices_ret ();
extern bool_t xdr_guestfs_md_detail_args ();
extern bool_t xdr_guestfs_md_detail_ret ();
extern bool_t xdr_guestfs_md_stop_args ();
extern bool_t xdr_guestfs_blkid_args ();
extern bool_t xdr_guestfs_blkid_ret ();
extern bool_t xdr_guestfs_e2fsck_args ();
extern bool_t xdr_guestfs_procedure ();
extern bool_t xdr_guestfs_message_direction ();
extern bool_t xdr_guestfs_message_status ();
extern bool_t xdr_guestfs_message_error ();
extern bool_t xdr_guestfs_message_header ();
extern bool_t xdr_guestfs_chunk ();
extern bool_t xdr_guestfs_progress ();

#endif /* K&R C */

#ifdef __cplusplus
}
#endif

#endif /* !_GUESTFS_PROTOCOL_H_RPCGEN */
