/*******************************************************************************************************************************************
 menus.c

 simple compilation directives :
 c++ -Wno-multichar -O2 -o menus `pkg-config --cflags libgtkol-1.2` menus.c `pkg-config --libs libgtkol-1.2`

 This sample is the simpliest one. It instanciates a main form with a menu bar and an associated menu item listener.
*******************************************************************************************************************************************/

#include "capplication.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// the demo form has a menu item that is connected to this listener
//-----------------------------------------------------------------------------------------------------------------------------------------
class CMenuItemQuitListener : public CMenuItemListener 
{
	// called when the specified menu item is clicked
	virtual void OnClick (CObject *inSender)
	{
		// get the owner form by specifying the requested indirect owner type and close it
		static_cast <CForm *> (static_cast <CMenuItem *> (inSender) -> GetOwner (__metaclass(CForm))) -> Close ();
	}
};

//-----------------------------------------------------------------------------------------------------------------------------------------
// CDemoForm definition
//-----------------------------------------------------------------------------------------------------------------------------------------
class CDemoForm : public CForm
{
	// instanciation section
	public :

		CDemoForm (CApplication *inOwner) : CForm (inOwner)
		{
			// set the form bounds (center the form over screen with 320x240 dimensions)
			SetBounds  (TBounds ((CApplication::GetScreenSize().w-320)/2, (CApplication::GetScreenSize().h-240)/2, 320, 240));

			// set the form caption
			SetCaption (CString("Menus"));

			// instanciate a vertical box layout under the form and set some properties
			CVBoxLayout *VBoxLayout = new CVBoxLayout (this);
			VBoxLayout -> SetHomogeneous (false);
			VBoxLayout -> SetBoxPack     (BOXPACK_START, false, false, 0);

			// instanciate a menu bar under the layout and set the menu items
			CMenuBar       *MenuBar  = new CMenuBar           (VBoxLayout);
			CMenuItem      *MenuFile = new CMenuItem      	  (MenuBar,  CString("_File"));
			CMenuItem      *MenuQuit = new CMenuItem          (MenuFile, CString("_Quit"), _HKNone_, 
									   new CMenuItemQuitListener());
			CMenuItem      *Menu1    = new CMenuItem          (MenuBar,  CString("_Checks"));
			CMenuItemCheck *Menu2    = new CMenuItemCheck     (Menu1,    CString("Check _1"));
			CMenuItemCheck *Menu3    = new CMenuItemCheck     (Menu1,    CString("Check _2"));
			CMenuItemCheck *Menu4    = new CMenuItemCheck     (Menu1,    CString("Check _3"));
			CMenuItem      *Menu5    = new CMenuItem	  (MenuBar,  CString("_Radios"));
			CMenuItemRadio *Menu6    = new CMenuItemRadio	  (Menu5,    CString("Radio _1"));
			CMenuItemRadio *Menu7    = new CMenuItemRadio	  (Menu5,    CString("Radio _2"));
			CMenuItemRadio *Menu8    = new CMenuItemRadio	  (Menu5,    CString("Radio _3"));
						   new CMenuItemSeparator (Menu5);
			CMenuItemRadio *Menu9    = new CMenuItemRadio	  (Menu5,    CString("Radio _4"));
			CMenuItemRadio *Menu10   = new CMenuItemRadio	  (Menu5,    CString("Radio _5"));
			CMenuItemRadio *Menu11   = new CMenuItemRadio	  (Menu7,    CString("Radio _6"));
			CMenuItemRadio *Menu12   = new CMenuItemRadio	  (Menu7,    CString("Radio _7"));

			// show the form (CForm is the only gtkol component that is not automatically shown)
			Show ();
		}
};

//-----------------------------------------------------------------------------------------------------------------------------------------
// demo execution
//-----------------------------------------------------------------------------------------------------------------------------------------
int main (int argc, char **argv)
{
	// declare an application
	CApplication Application (argc, argv);

	// instanciate the demo form
	new CDemoForm (&Application);

	// run the application
	Application.Run ();

	// ok
	return 0;
}
