// CHN_INFO.CPP

// Copyright (C) 1998 Tommi Hassinen, Geoff Hutchison.

// This package is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this package; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

/*################################################################################################*/

#include "libghemicalconfig2.h"
#include "chn_info.h"

#include "v3d.h"

#include <cstring>
#include <iomanip>
#include <iostream>
#include <sstream>
using namespace std;

/*################################################################################################*/

chn_info::chn_info(void)
{
	type = chn_info::not_defined;
	
	id_mol = NOT_DEFINED;
	id_chn = NOT_DEFINED;
	
	length = NOT_DEFINED;
	
	sequence1 = NULL;
	sequence3 = NULL;
	
	ss_state = NULL;
	p_state = NULL;
	
	description = NULL;
}

chn_info::chn_info(chn_type p1, i32s p2)
{
	type = p1;
	
	id_mol = NOT_DEFINED;
	id_chn = NOT_DEFINED;
	
	length = p2;
	
	sequence1 = new char[length + 1];
	for (i32s n1 = 0;n1 < length;n1++) sequence1[n1] = 0;
	sequence1[length] = 0;		// endmark
	
	sequence3 = new char*[length + 1];
	for (i32s n1 = 0;n1 < length;n1++) sequence3[n1] = NULL;
	sequence3[length] = NULL;	// endmark
	
	ss_state = NULL;
	p_state = NULL;
	
	description = NULL;
}

chn_info::chn_info(const chn_info & p1)
{
	type = p1.type;
	
	id_mol = p1.id_mol;
	id_chn = p1.id_chn;
	
	length = p1.length;
	
	if (p1.sequence1 != NULL)
	{
		sequence1 = new char[length + 1];
		for (i32s n1 = 0;n1 < length;n1++) sequence1[n1] = p1.sequence1[n1];
		
		sequence1[length] = 0;		// endmark
	}
	else sequence1 = NULL;
	
	if (p1.sequence3 != NULL)
	{
		sequence3 = new char*[length + 1];
		for (i32s n1 = 0;n1 < length;n1++)
		{
			if (p1.sequence3[n1] != NULL)
			{
				sequence3[n1] = new char[strlen(p1.sequence3[n1]) + 1];
				strcpy(sequence3[n1], p1.sequence3[n1]);
			}
			else sequence3[n1] = NULL;
		}
		
		sequence3[length] = NULL;	// endmark
	}
	else sequence3 = NULL;
	
	if (p1.ss_state != NULL)
	{
		ss_state = new char[length + 1];
		for (i32s n1 = 0;n1 < length;n1++) ss_state[n1] = p1.ss_state[n1];
		
		ss_state[length] = 0;		// endmark
	}
	else ss_state = NULL;

	if (p1.p_state != NULL)
	{
		p_state = new char[length + 1];
		for (i32s n1 = 0;n1 < length;n1++) p_state[n1] = p1.p_state[n1];
		
		p_state[length] = 0;		// endmark
	}
	else p_state = NULL;
	
	if (p1.description != NULL)
	{
		description = new char[strlen(p1.description) + 1];
		strcpy(description, p1.description);
	}
	else description = NULL;
}

chn_info::~chn_info(void)
{
	if (sequence1 != NULL) delete[] sequence1;

	if (sequence3 != NULL)
	{
		for (i32s n1 = 0;n1 < length;n1++)
		{
			if (sequence3[n1] != NULL) delete[] sequence3[n1];
		}
		
		delete[] sequence3;
	}
	
	if (ss_state != NULL) delete[] ss_state;
	if (p_state != NULL) delete[] p_state;
	
	if (description != NULL) delete[] description;
}

/*################################################################################################*/

// eof
