
use strict;
use warnings;



use ExtUtils::MakeMaker 6.31;



my %WriteMakefileArgs = (
  'ABSTRACT' => 'Getopt::Long, but simpler and more powerful',
  'AUTHOR' => 'Hans Dieter Pearcey <hdp@cpan.org>, Ricardo Signes <rjbs@cpan.org>',
  'BUILD_REQUIRES' => {
    'Test::More' => '0.96'
  },
  'CONFIGURE_REQUIRES' => {
    'ExtUtils::MakeMaker' => '6.31'
  },
  'DISTNAME' => 'Getopt-Long-Descriptive',
  'EXE_FILES' => [],
  'LICENSE' => 'perl',
  'NAME' => 'Getopt::Long::Descriptive',
  'PREREQ_PM' => {
    'Carp' => '0',
    'File::Basename' => '0',
    'Getopt::Long' => '2.33',
    'List::Util' => '0',
    'Params::Validate' => '0.97',
    'Scalar::Util' => '0',
    'Sub::Exporter' => '0.972',
    'Sub::Exporter::Util' => '0',
    'overload' => '0'
  },
  'VERSION' => '0.090',
  'test' => {
    'TESTS' => 't/*.t'
  }
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



