/**
 * @file list-attributes.c Lists attributes for a person.
 *
 * @Copyright (C) 2004-2006 Christian Hammond
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA  02111-1307  USA
 */
#include <libgalago/galago.h>
#include <stdio.h>
#include <string.h>

int
main(int argc, char **argv)
{
	GalagoPerson *person;
	char *person_id;
	GList *attrs, *l;

	if (argc != 2)
	{
		printf("Usage: list-attributes person-id\n");
		exit(1);
	}

	person_id = argv[1];

	galago_init("list-attributes", GALAGO_INIT_CLIENT);

	person = galago_get_person(person_id, GALAGO_REMOTE, TRUE);

	if (person == NULL)
	{
		printf("Unknown person %s\n", person_id);
		exit(1);
	}

	printf("Attributes:\n");

	attrs = galago_object_get_attributes(GALAGO_OBJECT(person));

	if (attrs == NULL)
	{
		printf("\t(None)\n");
	}
	else
	{
		for (l = attrs; l != NULL; l = l->next)
		{
			GalagoKeyValue *key_value = (GalagoKeyValue *)l->data;

			if (G_VALUE_HOLDS_INT(key_value->value))
			{
				printf("\t%s: %d\n",
					   key_value->key,
					   g_value_get_int(key_value->value));
			}
			else if (G_VALUE_HOLDS_STRING(key_value->value))
			{
				printf("\t%s: %s\n",
					   key_value->key,
					   g_value_get_string(key_value->value));
			}
			else if (G_VALUE_HOLDS_DOUBLE(key_value->value))
			{
				printf("\t%s: %f\n",
					   key_value->key,
					   g_value_get_double(key_value->value));
			}
			else if (G_VALUE_HOLDS_BOOLEAN(key_value->value))
			{
				printf("\t%s: %s\n",
					   key_value->key,
					   g_value_get_boolean(key_value->value)
					   ? "true" : "false");
			}
		}
	}

	return 0;
}
