#include <libgalago-gtk/galago-gtk.h>
#include <stdio.h>

static GtkWidget *service_list        = NULL;
static GtkWidget *account_list        = NULL;
static GtkWidget *user_entry          = NULL;
static GtkWidget *presence_icon_large = NULL;
static GtkWidget *get_presence_button = NULL;

static void
user_entry_changed_cb(GtkEntry *entry)
{
	gtk_widget_set_sensitive(get_presence_button,
							 *gtk_entry_get_text(entry) != '\0');
}

static GtkWidget *
add_box(GtkWidget *parent, GtkSizeGroup *sg, const char *text)
{
	GtkWidget *label;
	GtkWidget *hbox;

	hbox = gtk_hbox_new(FALSE, 6);
	gtk_box_pack_start(GTK_BOX(parent), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

	label = gtk_label_new_with_mnemonic(text);
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_size_group_add_widget(sg, label);
	gtk_widget_show(label);

	return hbox;
}

static void
get_presence_cb(GtkButton *button)
{
	GalagoService *service;
	GalagoAccount *account, *contact;
	const char *user;

	service = galago_gtk_service_combo_box_get_service(
		GALAGO_GTK_SERVICE_COMBO_BOX(service_list));
	account = galago_gtk_account_combo_box_get_account(
		GALAGO_GTK_ACCOUNT_COMBO_BOX(account_list));

	user = gtk_entry_get_text(GTK_ENTRY(user_entry));

	if (*user == '\0')
		contact = NULL;
	else
	{
		contact = galago_account_get_contact(account, user, TRUE);

		if (contact == NULL)
			contact = galago_service_get_account(service, user, TRUE);
	}

	galago_gtk_presence_icon_set_account(
		GALAGO_GTK_PRESENCE_ICON(presence_icon_large), contact);
	galago_gtk_presence_icon_update(
		GALAGO_GTK_PRESENCE_ICON(presence_icon_large));
}

static void
icon_type_changed(GtkComboBox *icon_combo, GtkListStore *icon_model)
{
	GtkTreeIter iter;
	GalagoGtkIconPrecedence precedence;

	gtk_combo_box_get_active_iter(icon_combo, &iter);

	gtk_tree_model_get(GTK_TREE_MODEL(icon_model), &iter,
					   0, &precedence,
					   -1);

	galago_gtk_presence_icon_set_precedence(
		GALAGO_GTK_PRESENCE_ICON(presence_icon_large),
		precedence);
}

int
main(int argc, char **argv)
{
	GtkWidget *window;
	GtkWidget *main_vbox;
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *bbox;
	GtkWidget *button;
	GtkWidget *event_box;
	GtkWidget *icon_combo;
	GtkSizeGroup *sg;
	GtkCellRenderer *cell;
	GtkListStore *icon_model;
	GtkTreeIter iter;
	GtkEntryCompletion *completion;

	gtk_init(&argc, &argv);

	if (!galago_init("test-presence-icon", FALSE))
		exit(1);

	sg = gtk_size_group_new(GTK_SIZE_GROUP_HORIZONTAL);

	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(window), "Galago Presence Test");
	gtk_container_set_border_width(GTK_CONTAINER(window), 12);

	g_signal_connect(G_OBJECT(window), "destroy",
					 G_CALLBACK(gtk_main_quit), NULL);

	main_vbox = gtk_vbox_new(FALSE, 6);
	gtk_container_add(GTK_CONTAINER(window), main_vbox);
	gtk_widget_show(main_vbox);

	hbox = gtk_hbox_new(FALSE, 12);
	gtk_box_pack_start(GTK_BOX(main_vbox), hbox, TRUE, TRUE, 0);
	gtk_widget_show(hbox);

	vbox = gtk_vbox_new(FALSE, 6);
	gtk_box_pack_start(GTK_BOX(hbox), vbox, FALSE, FALSE, 0);
	gtk_widget_show(vbox);

	event_box = gtk_event_box_new();
	gtk_box_pack_start(GTK_BOX(vbox), event_box, TRUE, FALSE, 0);
	gtk_widget_show(event_box);

	presence_icon_large = galago_gtk_presence_icon_new();
	galago_gtk_presence_icon_set_size(
		GALAGO_GTK_PRESENCE_ICON(presence_icon_large), GTK_ICON_SIZE_DND);
	gtk_container_add(GTK_CONTAINER(event_box), presence_icon_large);
	gtk_widget_show(presence_icon_large);

	vbox = gtk_vbox_new(FALSE, 6);
	gtk_box_pack_start(GTK_BOX(hbox), vbox, TRUE, TRUE, 0);
	gtk_widget_show(vbox);

	/* Add the Service box */
	hbox = add_box(vbox, sg, "_Service:");

	service_list = galago_gtk_service_combo_box_new();

	gtk_box_pack_start(GTK_BOX(hbox), service_list, TRUE, TRUE, 0);
	gtk_widget_show(service_list);

	/* Add the Account box */
	hbox = add_box(vbox, sg, "_Account:");
	account_list = galago_gtk_account_combo_box_new(TRUE);
	galago_gtk_account_combo_box_set_services_combo_box(
		GALAGO_GTK_ACCOUNT_COMBO_BOX(account_list), service_list);
	gtk_box_pack_start(GTK_BOX(hbox), account_list, TRUE, TRUE, 0);
	gtk_widget_show(account_list);

	/* Add the user entry */
	hbox = add_box(vbox, sg, "_User:");
	user_entry = gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(hbox), user_entry, TRUE, TRUE, 0);
	gtk_widget_show(user_entry);

	completion = galago_gtk_entry_completion_new_with_accounts(NULL, TRUE);
	gtk_entry_set_completion(GTK_ENTRY(user_entry), completion);
	g_object_unref(G_OBJECT(completion));

	g_signal_connect(G_OBJECT(user_entry), "changed",
					 G_CALLBACK(user_entry_changed_cb), NULL);

	/* Add the Icon Precedence box */
	hbox = add_box(vbox, sg, "_Icon:");

	/* Icon precedence drop-down */
	icon_model = gtk_list_store_new(2, G_TYPE_UINT, G_TYPE_STRING);
	icon_combo = gtk_combo_box_new_with_model(GTK_TREE_MODEL(icon_model));
	g_object_unref(G_OBJECT(icon_model));

	gtk_list_store_append(icon_model, &iter);
	gtk_list_store_set(icon_model, &iter,
					   0, GALAGO_GTK_ICON_PHOTO,
					   1, "Photo",
					   -1);

	gtk_list_store_append(icon_model, &iter);
	gtk_list_store_set(icon_model, &iter,
					   0, GALAGO_GTK_ICON_AVATAR,
					   1, "Avatar",
					   -1);

	gtk_list_store_append(icon_model, &iter);
	gtk_list_store_set(icon_model, &iter,
					   0, GALAGO_GTK_ICON_PROTOCOL,
					   1, "Protocol",
					   -1);

	gtk_list_store_append(icon_model, &iter);
	gtk_list_store_set(icon_model, &iter,
					   0, GALAGO_GTK_ICON_GENERIC,
					   1, "Generic",
					   -1);

	cell = gtk_cell_renderer_text_new();
	gtk_cell_layout_pack_start(GTK_CELL_LAYOUT(icon_combo), cell, TRUE);
	gtk_cell_layout_set_attributes(GTK_CELL_LAYOUT(icon_combo), cell,
								   "text", 1, NULL);

	g_signal_connect(G_OBJECT(icon_combo), "changed",
					 G_CALLBACK(icon_type_changed), icon_model);

	gtk_combo_box_set_active(GTK_COMBO_BOX(icon_combo), 0);

	gtk_box_pack_start(GTK_BOX(hbox), icon_combo, TRUE, TRUE, 0);
	gtk_widget_show(icon_combo);

	g_object_unref(sg);

	bbox = gtk_hbutton_box_new();
	gtk_box_set_spacing(GTK_BOX(bbox), 6);
	gtk_button_box_set_layout(GTK_BUTTON_BOX(bbox), GTK_BUTTONBOX_END);
	gtk_box_pack_end(GTK_BOX(main_vbox), bbox, FALSE, TRUE, 0);
	gtk_widget_show(bbox);

	/* Close button */
	button = gtk_button_new_from_stock(GTK_STOCK_CLOSE);
	gtk_box_pack_start(GTK_BOX(bbox), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	g_signal_connect_swapped(G_OBJECT(button), "clicked",
							 G_CALLBACK(gtk_widget_destroy), window);

	/* Get Presence button */
	button = get_presence_button = gtk_button_new_with_label("Get Presence");
	gtk_widget_set_sensitive(button, FALSE);
	gtk_box_pack_start(GTK_BOX(bbox), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	g_signal_connect(G_OBJECT(button), "clicked",
					 G_CALLBACK(get_presence_cb), NULL);

	gtk_widget_show(window);

	gtk_main();

	return 0;
}
