/*
 * This files fixes that the hashing code from DC++
 * can be used almost verbatim.
 */

#ifndef _INCLUDED_COMPAT_H_
#define _INCLUDED_COMPAT_H_

#ifdef _WIN32

# include <io.h>
# define STDIN_FILENO _fileno(stdin)
# define SSIZE_MAX 4096
  extern "C" {
    extern int optind;
    int getopt(int argc, char* const argv[], char const* optstring);
  }
  typedef signed char int8_t;
  typedef signed short int16_t;
  typedef signed long int32_t;
  typedef unsigned char u_int8_t;
  typedef unsigned short u_int16_t;
  typedef unsigned long u_int32_t;
  typedef signed __int64 int64_t;
  typedef unsigned __int64 u_int64_t;

#else // _WIN32

  // like O_LARGEFILE for open, this enables large files for stat
# define _FILE_OFFSET_BITS 64
# define _LARGEFILE64_SOURCE 1
# include <unistd.h>
# define HAS_GETOPT
# ifndef u_int8_t
#   include <sys/types.h>  
# endif
# ifndef uint64_t
#   include <stdint.h>
# endif

#endif // _WIN32


// standard includes
#include <string.h>
#include <string>
#include <vector>
#include <utility>
using std::pair;
using std::make_pair;
using std::string;
using std::vector;

// defines used by the DC++ code
#ifndef _ULL
#define _ULL(x) x##ull
#endif
#ifndef min
#define min(x, y) (x < y ? x : y)
#endif
#define dcassert(x) 


#endif //_INCLUDED_COMPAT_H_
