/*--------------------------------------------------------------------------+
$Id: TXTSmokeTestlet.java 26285 2010-02-18 11:22:54Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.simulink.targetlink;

import java.io.FileReader;

import org.junit.Ignore;

import edu.tum.cs.commons.test.TestletBase;

/**
 * Smoke testlet for Targetlink parser. This reads a Targetlink struct
 * definition from a text file and parses it.
 * 
 * @author deissenb
 * @author $Author: juergens $
 * @version $Rev: 26285 $
 * @levd.rating GREEN Hash: 36FA758E52F29A418D522B124F4C5554
 */
@Ignore
public class TXTSmokeTestlet extends TestletBase {

	/** Name of file to read. */
	private final String filename;

	/** Create new testlet. */
	TXTSmokeTestlet(String filename) {
		this.filename = filename;
	}

	/** Return name smoke test. */
	@Override
	public String getName() {
		return filename;
	}

	/**
	 * Read Targetlink struct definition from a text file and parse it.
	 */
	@Override
	public void test() throws Exception {
		TargetlinkDataScanner scanner = new TargetlinkDataScanner(
				new FileReader(useTestFile(filename)));
		TargetlinkDataParser parser = new TargetlinkDataParser(scanner);
		parser.parse();
	}
}