/*--------------------------------------------------------------------------+
$Id: SimulinkModelWalker.java 26277 2010-02-18 10:46:58Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.simulink.util;

import java.util.Collection;

import edu.tum.cs.commons.assertion.CCSMAssert;
import edu.tum.cs.commons.collections.IdentityHashSet;
import edu.tum.cs.commons.error.NeverThrownRuntimeException;
import edu.tum.cs.commons.visitor.IMeshWalker;
import edu.tum.cs.simulink.model.SimulinkBlock;
import edu.tum.cs.simulink.model.SimulinkElementBase;
import edu.tum.cs.simulink.model.SimulinkInPort;
import edu.tum.cs.simulink.model.SimulinkLine;
import edu.tum.cs.simulink.model.SimulinkModel;
import edu.tum.cs.simulink.model.SimulinkOutPort;
import edu.tum.cs.simulink.model.SimulinkPortBase;
import edu.tum.cs.simulink.model.stateflow.IStateflowNodeContainer;
import edu.tum.cs.simulink.model.stateflow.StateflowBlock;
import edu.tum.cs.simulink.model.stateflow.StateflowDeclContainerBase;
import edu.tum.cs.simulink.model.stateflow.StateflowElementBase;
import edu.tum.cs.simulink.model.stateflow.StateflowMachine;
import edu.tum.cs.simulink.model.stateflow.StateflowNodeBase;
import edu.tum.cs.simulink.model.stateflow.StateflowTransition;

/**
 * Mesh walker for Simulink/Stateflow models.
 * 
 * @author deissenb
 * @author $Author: juergens $
 * @version $Rev: 26277 $
 * @levd.rating GREEN Hash: C5315C6EABEB791C7A6B433386A4751A
 */
public class SimulinkModelWalker implements
		IMeshWalker<Object, NeverThrownRuntimeException> {

	/** Gets adjacent elements for all elements of Simulink/Stateflow elements. */
	public Collection<Object> getAdjacentElements(Object element) {

		IdentityHashSet<Object> elements = new IdentityHashSet<Object>();

		if (element instanceof SimulinkElementBase) {
			SimulinkElementBase simulinkElement = (SimulinkElementBase) element;
			if (simulinkElement.getParent() != null) {
				elements.add(simulinkElement.getParent());
			}
			elements.add(simulinkElement.getModel());
		}

		if (element instanceof StateflowBlock) {
			StateflowBlock block = (StateflowBlock) element;
			elements.add(block.getChart());
		}

		if (element instanceof SimulinkModel) {
			SimulinkModel model = (SimulinkModel) element;
			if (model.getStateflowMachine() != null) {
				elements.add(model.getStateflowMachine());
			}
		}
		if (element instanceof SimulinkBlock) {
			SimulinkBlock block = (SimulinkBlock) element;
			elements.addAll(block.getSubBlocks());
			elements.addAll(block.getInPorts());
			elements.addAll(block.getOutPorts());
			elements.addAll(block.getAnnotations());
		}
		if (element instanceof StateflowBlock) {
			SimulinkBlock block = (SimulinkBlock) element;
			elements.addAll(block.getSubBlocks());
			elements.addAll(block.getInPorts());
			elements.addAll(block.getOutPorts());
		}
		if (element instanceof SimulinkPortBase) {
			SimulinkPortBase port = (SimulinkPortBase) element;
			elements.add(port.getBlock());
		}
		if (element instanceof SimulinkInPort) {
			SimulinkInPort inPort = (SimulinkInPort) element;
			if (inPort.getLine() != null) {
				elements.add(inPort.getLine());
			}
		}
		if (element instanceof SimulinkOutPort) {
			SimulinkOutPort inPort = (SimulinkOutPort) element;
			elements.addAll(inPort.getLines());
		}
		if (element instanceof SimulinkLine) {
			SimulinkLine line = (SimulinkLine) element;
			elements.add(line.getSrcPort());
			elements.add(line.getDstPort());
		}

		if (element instanceof StateflowElementBase<?>) {
			StateflowElementBase<?> stateflowElement = (StateflowElementBase<?>) element;
			if (stateflowElement.getParent() != null) {
				elements.add(stateflowElement.getParent());
			}
		}

		if (element instanceof StateflowDeclContainerBase<?>) {
			StateflowDeclContainerBase<?> declContainer = (StateflowDeclContainerBase<?>) element;
			elements.addAll(declContainer.getData());
			elements.addAll(declContainer.getEvents());
		}

		if (element instanceof IStateflowNodeContainer<?>) {
			IStateflowNodeContainer<?> nodeContainer = (IStateflowNodeContainer<?>) element;
			elements.addAll(nodeContainer.getNodes());
		}

		if (element instanceof StateflowNodeBase) {
			StateflowNodeBase node = (StateflowNodeBase) element;
			elements.addAll(node.getInTransitions());
			elements.addAll(node.getOutTransitions());
		}

		if (element instanceof StateflowMachine) {
			StateflowMachine machine = (StateflowMachine) element;
			elements.addAll(machine.getTargets());
		}
		if (element instanceof StateflowTransition) {
			StateflowTransition transition = (StateflowTransition) element;
			if (transition.getSrc() != null) {
				elements.add(transition.getSrc());
			}
			elements.add(transition.getDst());
		}

		CCSMAssert.isFalse(elements.contains(null), "Element " + element
				+ " has a null adjancency.");

		return elements;
	}
}