/*--------------------------------------------------------------------------+
$Id: Address.java 26268 2010-02-18 10:44:30Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.xml.example;

/**
 * XML facility demo model class. Instances of this class are persisted as
 * {@link EXMLElement#ADDRESS}.
 * 
 * @author Florian Deissenboeck
 * @author $Author: juergens $
 * @version $Rev: 26268 $
 * @levd.rating GREEN Hash: 2DEDB92D7C3D308F728219C6B466B2F8
 */
public class Address {

	/** Street (persisted as {@link EXMLElement#STREET}. */
	private final String street;

	/** City (persisted as {@link EXMLElement#CITY}. */
	private final String city;

	/** Create new address. */
	public Address(String street, String city) {
		this.street = street;
		this.city = city;
	}

	/** Returns the street. */
	public String getStreet() {
		return street;
	}

	/** Returns the city. */
	public String getCity() {
		return city;
	}

	/** Deep equals. */
	@Override
	public boolean equals(Object other) {
		if (!(other instanceof Address)) {
			return false;
		}
		Address otherAddress = (Address) other;

		return street.equals(otherAddress.street)
				&& city.equals(otherAddress.city);
	}

	/** {@inheritDoc} */
	@Override
	public int hashCode() {
		return street.hashCode() * 13 + city.hashCode();
	}
}