/*--------------------------------------------------------------------------+
$Id: Person.java 26268 2010-02-18 10:44:30Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.test.example;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import edu.tum.cs.commons.clone.IDeepCloneable;

/**
 * Person class.
 * 
 * @author Florian Deissenboeck
 * @author $Author: juergens $
 * @version $Rev: 26268 $
 * @levd.rating GREEN Hash: 6180AAABC1E07CBEA137537A062C4079
 */
public class Person implements IDeepCloneable {

	/** The name. */
	private final String name;

	/** The address. */
	private final Address address;

	/** The orders . */
	private final ArrayList<Order> orders = new ArrayList<Order>();

	/** The details. */
	private final String details;

	/** Create new person. */
	public Person(String name, Address address, String details) {
		this.name = name;
		this.address = address;
		this.details = details;
	}

	/** Copy constructor. */
	private Person(Person orig) {
		name = orig.name;
		address = orig.address.deepClone();
		details = orig.details;

		for (Order order : orig.orders) {
			add(order.deepClone());
		}
	}

	/** Add order. */
	public void add(Order order) {
		orders.add(order);
	}

	/** Get address. */
	public Address getAddress() {
		return address;
	}

	/** This returns null. */
	public Order getNullOrder() {
		return null;
	}

	/** This throws a {@link UnsupportedOperationException}. */
	public Order getExceptionOrder() {
		throw new UnsupportedOperationException();
	}

	/** This throws a {@link UnsupportedOperationException}. */
	public Order[] getExceptionOrderArray() {
		throw new UnsupportedOperationException();
	}

	/** This throws a {@link UnsupportedOperationException}. */
	public List<Order> getExceptionOrderList() {
		throw new UnsupportedOperationException();
	}

	/** Raw collection returnt type. */
	@SuppressWarnings("unchecked")
	public List getRawList() {
		return Collections.EMPTY_LIST;
	}

	/** Get name. */
	public String getName() {
		return name;
	}

	/** Get orders. */
	public Order[] getOrders() {
		return orders.toArray(new Order[0]);
	}

	/** Number of orders. */
	public int getOrderCount() {
		return orders.size();
	}

	/** Get details. */
	public String getDetails() {
		return details;
	}

	/** Deep equals. */
	@Override
	public boolean equals(Object other) {
		if (!(other instanceof Person)) {
			return false;
		}
		Person otherPerson = (Person) other;

		if (!name.equals(otherPerson.name)) {
			return false;
		}

		if (!address.equals(otherPerson.address)) {
			return false;
		}

		if (!details.equals(otherPerson.details)) {
			return false;
		}

		if (orders.size() != otherPerson.orders.size()) {
			return false;
		}

		for (int i = 0; i < orders.size(); i++) {
			if (!orders.get(i).equals(otherPerson.orders.get(i))) {
				return false;
			}
		}

		return true;
	}

	/** {@inheritDoc} */
	@Override
	public int hashCode() {
		// using fixed hash code here as this method should not be used in the
		// tests
		return 13;
	}

	/** Deep clone. */
	public Person deepClone() {
		return new Person(this);
	}
}