/*--------------------------------------------------------------------------+
$Id: RangeTest.java 26268 2010-02-18 10:44:30Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.math;

import junit.framework.TestCase;

/**
 * Test class for {@link Range}.
 * 
 * @author deissenb
 * @author $Author: juergens $
 * @version $Rev: 26268 $
 * @levd.rating GREEN Hash: 5A8D91789CA7BEFC4C89B0C1B4B35154
 */
public class RangeTest extends TestCase {

	/** Test range that contains a single int. */
	public void testRangeWithSingleInt() {
		assertTrue(new Range(3, true, 3, true).contains(3));
		assertFalse(new Range(3, true, 3, false).contains(3));
		assertFalse(new Range(3, true, 3, true).contains(3.5));
	}

	/** Test empty ranges. */
	public void testEmptyRange() {
		assertFalse(new Range(4, true, 3, true).contains(3));
		assertFalse(new Range(3, false, 3, true).contains(3));
		assertFalse(new Range(3, false, 3, false).contains(3));
		assertFalse(new Range(3, true, 3, false).contains(3.5));
	}

	/** Test {@link Range#isEmpty()} */
	public void testIsEmpty() {
		assertTrue(new Range(4, true, 3, true).isEmpty());
		assertTrue(new Range(4, true, 3, false).isEmpty());
		assertTrue(new Range(4, false, 3, true).isEmpty());
		assertTrue(new Range(4, false, 3, false).isEmpty());
		assertTrue(new Range(3, false, 3, true).isEmpty());
		assertTrue(new Range(3, false, 3, false).isEmpty());
		assertTrue(new Range(3, true, 3, false).isEmpty());

		assertFalse(new Range(1, true, 2, true).isEmpty());
	}

	/** Test ranges with ints. */
	public void testInt() {
		// inclusive ranges
		assertTrue(new Range(3, true, 7, true).contains(4));
		assertTrue(new Range(3, true, 7, true).contains(3));
		assertTrue(new Range(3, true, 7, true).contains(7));
		assertFalse(new Range(3, true, 7, true).contains(2));
		assertFalse(new Range(3, true, 7, true).contains(8));

		// exclusive upper ranges
		assertTrue(new Range(3, true, 7, false).contains(4));
		assertTrue(new Range(3, true, 7, false).contains(3));
		assertFalse(new Range(3, true, 7, false).contains(7));
		assertFalse(new Range(3, true, 7, false).contains(2));
		assertFalse(new Range(3, true, 7, false).contains(8));

		// exclusive lower ranges
		assertTrue(new Range(3, false, 7, true).contains(4));
		assertFalse(new Range(3, false, 7, true).contains(3));
		assertTrue(new Range(3, false, 7, true).contains(7));
		assertFalse(new Range(3, false, 7, true).contains(2));
		assertFalse(new Range(3, false, 7, true).contains(8));

		// exclusive lower and upper ranges
		assertTrue(new Range(3, false, 7, false).contains(4));
		assertFalse(new Range(3, false, 7, false).contains(3));
		assertFalse(new Range(3, false, 7, false).contains(7));
		assertFalse(new Range(3, false, 7, false).contains(2));
		assertFalse(new Range(3, false, 7, false).contains(8));
	}

	/** Test ranges with doubles. */
	public void testDouble() {
		// inclusive ranges
		assertTrue(new Range(3.5, true, 7.5, true).contains(3.5));
		assertTrue(new Range(3.5, true, 7.5, true).contains(7.5));

		// exclusive upper ranges
		assertTrue(new Range(3.5, true, 7.5, false).contains(3.5));
		assertTrue(new Range(3.5, true, 7.5, false).contains(7.49999));
		assertFalse(new Range(3.5, true, 7.5, false).contains(7.5));

		// exclusive lower ranges
		assertFalse(new Range(3.5, false, 7.5, true).contains(3.5));
		assertTrue(new Range(3.5, false, 7.5, true).contains(7.49999));
		assertTrue(new Range(3.5, false, 7.5, true).contains(7.5));

		// exclusive lower and upper ranges
		assertFalse(new Range(3.5, false, 7.5, false).contains(3.5));
		assertTrue(new Range(3.5, false, 7.5, false).contains(7.49999));
		assertFalse(new Range(3.5, false, 7.5, false).contains(7.5));
	}

	/** Test ranges with negative bounds. */
	public void testNegativeNumbers() {
		assertTrue(new Range(-3.5, true, 7.5, true).contains(3));
		assertTrue(new Range(-3.5, true, 7.5, true).contains(-3.5));
		assertTrue(new Range(-3.5, true, 7.5, true).contains(7.5));
	}

}