/*--------------------------------------------------------------------------+
$Id: CanonicalFilePoolTest.java 26268 2010-02-18 10:44:30Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.filesystem;

import java.io.IOException;

import edu.tum.cs.commons.test.CCSMTestCaseBase;

/**
 * Test case for {@link CanonicalFilePool}.
 * 
 * @author deissenb
 * @author $Author: juergens $
 * @version $Rev: 26268 $
 * @levd.rating GREEN Hash: DBEB1A3A99BF5B00D24F4DFD8D15D332
 */
public class CanonicalFilePoolTest extends CCSMTestCaseBase {

	/** Pool under test. */
	private CanonicalFilePool pool;

	/** {@inheritDoc} */
	@Override
	protected void setUp() {
		pool = new CanonicalFilePool();
	}

	/** Test basic behavior. */
	public void test() throws IOException {
		String filename1 = "canonical.txt";
		CanonicalFile canonicalFile1 = new CanonicalFile(filename1);
		CanonicalFile canonicalFile2 = new CanonicalFile(filename1);

		assertNotSame("Expecting different instances of canonical file",
				canonicalFile1, canonicalFile2);

		assertSame(pool(canonicalFile1), pool(canonicalFile2));

		String filename2 = "canonical2.txt";
		CanonicalFile different = new CanonicalFile(filename2);

		assertNotSame(pool(canonicalFile1), pool(different));
	}

	/** Get pooled file */
	private CanonicalFile pool(CanonicalFile file) {
		return pool.intern(file);
	}
}