/*--------------------------------------------------------------------------+
$Id: PairListTest.java 28269 2010-06-14 16:02:57Z hummelb $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.collections;

import junit.framework.TestCase;

/**
 * Tests the {@link PairList} class.
 * 
 * @author hummelb
 * @author $Author: hummelb $
 * @version $Rev: 28269 $
 * @levd.rating GREEN Hash: 3E7F65926A1A87BF722497D68E59036A
 */
public class PairListTest extends TestCase {

	/** Testcase for {@link PairList#clear()} */
	public void testClear() {
		PairList<Integer, String> p = createFilledPairList(100);
		p.clear();
		assertEquals(0, p.size());
		assertTrue(p.isEmpty());
	}

	/** Testcase for {@link PairList#addAll(PairList)} */
	public void testAddAll() {
		PairList<Integer, String> p = createFilledPairList(99);

		p.addAll(p);
		assertEquals(2 * 99, p.size());

		for (int i = 0; i < 99; ++i) {
			assertEquals(i, (int) p.getFirst(i));
			assertEquals(String.valueOf(i), p.getSecond(i));
			assertEquals(i, (int) p.getFirst(i + 99));
			assertEquals(String.valueOf(i), p.getSecond(i + 99));
		}
	}

	/** Testcase for {@link PairList#removeLast()} */
	public void testRemoveLast() {
		PairList<Integer, String> p = createFilledPairList(100);
		p.removeLast();
		assertListContent(p, 99);
	}

	/** Testcase for {@link PairList#add(Object, Object)} */
	public void testAdd() {
		PairList<Integer, String> p = createFilledPairList(100);
		assertListContent(p, 100);
	}

	/** Create {@link PairList} with length entries ranging from 0 to length-1 */
	private PairList<Integer, String> createFilledPairList(int length) {
		PairList<Integer, String> p = new PairList<Integer, String>();
		for (int i = 0; i < length; ++i) {
			p.add(i, String.valueOf(i));
		}
		return p;
	}

	/**
	 * Assert that {@link PairList} has specified size and that all entries are
	 * 0 to length-1
	 */
	private void assertListContent(PairList<Integer, String> p, int length) {
		assertEquals(length, p.size());
		for (int i = 0; i < length; ++i) {
			assertEquals(i, (int) p.getFirst(i));
			assertEquals(String.valueOf(i), p.getSecond(i));
		}
	}
}
