/*--------------------------------------------------------------------------+
$Id: SimpleTreeNodeHandler.java 26268 2010-02-18 10:44:30Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.tree;

/**
 * Handler for {@link SimpleTreeNode}.
 * 
 * @author deissenb
 * @author $Author: juergens $
 * @version $Rev: 26268 $
 * @levd.rating GREEN Hash: EAE7ADE3588C81DB8F6FEBF4403F0C91
 */
public class SimpleTreeNodeHandler<K> implements
		ITreeNodeHandler<SimpleTreeNode<K>, K> {

	/** The key used for the root. */
	private final K rootKey;

	/**
	 * Create new handler.
	 * 
	 * @param rootKey
	 *            the key used for the root node.
	 */
	public SimpleTreeNodeHandler(K rootKey) {
		this.rootKey = rootKey;
	}

	/** {@inheritDoc} */
	public SimpleTreeNode<K> createRoot() {
		return new SimpleTreeNode<K>(rootKey);
	}

	/** {@inheritDoc} */
	public SimpleTreeNode<K> getOrCreateChild(SimpleTreeNode<K> node, K key) {
		SimpleTreeNode<K> child = node.getChild(key);
		if (child != null) {
			return child;
		}

		child = new SimpleTreeNode<K>(key);
		node.addChild(child);
		return child;
	}

}