/*--------------------------------------------------------------------------+
$Id: StreamReaderThread.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

/**
 * A thread to drain an input stream.
 * 
 * @author Elmar Juergens
 * @author Florian Deissenboeck
 * @author $Author: juergens $
 * @version $Rev: 26283 $
 * @levd.rating GREEN Hash: 25DAC0F50BA3CBA7C86127762780A8C4
 */
public class StreamReaderThread extends Thread {

	/** Stream the reader reads from. */
	private final InputStream input;

	/** Content read from the stream.. */
	private StringBuilder content;

	/**
	 * Create a new reader that reads the content of this stream in its own
	 * thread. => This call is non- blocking
	 * 
	 * @param input
	 *            Stream to read from.
	 * 
	 */
	public StreamReaderThread(InputStream input) {
		super();
		this.input = input;
		start();
	}

	/**
	 * Reads content from the stream as long as the stream is not empty.
	 */
	@Override
	public synchronized void run() {
		BufferedReader reader = new BufferedReader(new InputStreamReader(input));

		char[] buffer = new char[1024];

		content = new StringBuilder();

		try {
			int read = 0;
			while ((read = reader.read(buffer)) != -1) {
				content.append(buffer, 0, read);
			}
		} catch (IOException e) {
			// in case of a problem append exception description to result.
			content.append(e);
		}

	}

	/** Returns the content read from the stream. */
	public synchronized String getContent() {
		return content.toString();
	}
}