;;;;; -*-coding: x-ctext;-*-
;;;;;
;;;;; ================================================================
;;;;;            _       _____    ____  _   _______   ________
;;;;;           | |     / /   |  / __ \/ | / /  _/ | / / ____/
;;;;;           | | /| / / /| | / /_/ /  |/ // //  |/ / / __
;;;;;           | |/ |/ / ___ |/ _, _/ /|  // // /|  / /_/ /
;;;;;           |__/|__/_/  |_/_/ |_/_/ |_/___/_/ |_/\____/
;;;;;
;;;;; This file is coded using x-ctext, since it contains both
;;;;; iso-8859-1 and iso-8859-2. If you open the file using any
;;;;; other coding, you'll probably screw it up.
;;;;;
;;;;; Look for the little x at the bottom-left of your Emacs frame!
;;;;;
;;;;; ================================================================
;;;;;
;;;;; $Id: names.el,v 44.10 2003/07/02 19:10:02 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: names.el
;;;;
;;;; This file contains code to deal with namedays
;;;;

(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: names.el,v 44.10 2003/07/02 19:10:02 byers Exp $\n"))

(def-komtype nameday-data
  ((code            :read-only t)
   (name            :read-only t)
   (description     :read-only t)
   (data            :read-only t)))

(defvar lyskom-namedays nil)

(defun lyskom-define-namedays (code name description data)
  "Define a new collection of namedays.
CODE is the unique code for the nameday collection.
NAME is a short name for the collection, in the language of the collection
DESCRIPTION is a longer description of the collection, in the langauge of
the collection.
DATA is nameday data"
  (setq lyskom-namedays
        (cons (cons code (lyskom-create-nameday-data
                          code name description data))
              lyskom-namedays)))


(defun lyskom-nameday (&optional now)
  (cond ((eq kom-show-namedays t) (lyskom-nameday-2 lyskom-language now))
        ((symbolp kom-show-namedays) (lyskom-nameday-2 kom-show-namedays now))
        ((listp kom-show-namedays)
         (mapconcat (lambda (x) (lyskom-nameday-2 x now t))
                    kom-show-namedays  "\n"))
        (t nil)))

(defun lyskom-nameday-2 (sym now &optional show-list-name)
  (let* ((time (or now (lyskom-current-server-time)))
         (data (cdr (assq sym lyskom-namedays)))
         (alist (and data (nameday-data->data data)))
         (mlist (cdr (assq (time->mon time) alist)))
         (dlist (cdr (assq (time->mday time) mlist))))
    (if data
        (cond ((null dlist) 
               (lyskom-format 'no-nameday nil (and show-list-name (nameday-data->name data))))
              ((eq 1 (length dlist))
               (lyskom-format 'has-nameday-1 
                              (car dlist)
                              (and show-list-name (nameday-data->name data))))
              ((eq 2 (length dlist))
               (lyskom-format 'has-nameday-2
                              (elt dlist 0)
                              (elt dlist 1)
                              (and show-list-name (nameday-data->name data))))
              (t (lyskom-format 'has-nameday-2
                                (mapconcat 'identity (lyskom-butlast dlist 1) ", ")
                                (elt dlist (1- (length dlist)))
                                (and show-list-name (nameday-data->name data)))))
      "")))



(lyskom-define-namedays 'sv 
                        "Sverige"
                        "\
Namnsdagar enligt svenska sprknmndens nya namnlngd (2001)."
                        '((1 . ((1 . ())
                                (2 . ("Svea"))
                                (3 . ("Alfred" "Alfrida"))
                                (4 . ("Rut"))
                                (5 . ("Hanna" "Hannele"))
                                (6 . ("Kasper" "Melker" "Baltsar"))
                                (7 . ("August" "Augusta"))
                                (8 . ("Erland"))
                                (9 . ("Gunnar" "Gunder"))
                                (10 . ("Sigurd" "Sigbritt"))
                                (11 . ("Jan" "Jannike"))
                                (12 . ("Frideborg" "Fridolf"))
                                (13 . ("Knut"))
                                (14 . ("Felix" "Felicia"))
                                (15 . ("Laura" "Lorentz"))
                                (16 . ("Hjalmar" "Helmer"))
                                (17 . ("Anton" "Tony"))
                                (18 . ("Hilda" "Hildur"))
                                (19 . ("Henrik"))
                                (20 . ("Fabian" "Sebastian"))
                                (21 . ("Agnes" "Agneta"))
                                (22 . ("Vincent" "Viktor"))
                                (23 . ("Frej" "Freja"))
                                (24 . ("Erika"))
                                (25 . ("Paul" "Pl"))
                                (26 . ("Bodil" "Boel"))
                                (27 . ("Gte" "Gta"))
                                (28 . ("Karl" "Karla"))
                                (29 . ("Diana"))
                                (30 . ("Gunilla" "Gunhild"))
                                (31 . ("Ivar" "Joar"))))

                          (2 . ((1 . ("Max" "Maximilian"))
                                (2 . ())
                                (3 . ("Disa" "Hjrdis"))
                                (4 . ("Ansgar" "Anselm"))
                                (5 . ("Agata" "Agda"))
                                (6 . ("Dorotea" "Doris"))
                                (7 . ("Rikard" "Dick"))
                                (8 . ("Berta" "Bert"))
                                (9 . ("Fanny" "Franciska"))
                                (10 . ("Iris"))
                                (11 . ("Yngve" "Inge"))
                                (12 . ("Evelina" "Evy"))
                                (13 . ("Agne" "Ove"))
                                (14 . ("Valentin"))
                                (15 . ("Sigfrid"))
                                (16 . ("Julia" "Julius"))
                                (17 . ("Alexandra" "Sandra"))
                                (18 . ("Frida" "Fritiof"))
                                (19 . ("Gabriella" "Ella"))
                                (20 . ("Vivianne"))
                                (21 . ("Hilding"))
                                (22 . ("Pia"))
                                (23 . ("Torsten" "Torun"))
                                (24 . ("Mattias" "Mats"))
                                (25 . ("Sigvard" "Sivert"))
                                (26 . ("Torgny" "Torkel"))
                                (27 . ("Lage"))
                                (28 . ("Maria"))))

                          (3 . ((1 . ("Albin" "Elvira"))
                                (2 . ("Ernst" "Erna"))
                                (3 . ("Gunborg" "Gunvor"))
                                (4 . ("Adrian" "Adriana"))
                                (5 . ("Tora" "Tove"))
                                (6 . ("Ebba" "Ebbe"))
                                (7 . ("Camilla"))
                                (8 . ("Siv"))
                                (9 . ("Torbjrn" "Torleif"))
                                (10 . ("Edla" "Ada"))
                                (11 . ("Edvin" "Egon"))
                                (12 . ("Viktoria"))
                                (13 . ("Greger"))
                                (14 . ("Matilda" "Maud"))
                                (15 . ("Kristoffer" "Christel"))
                                (16 . ("Herbert" "Gilbert"))
                                (17 . ("Gertrud"))
                                (18 . ("Edvard" "Edmund"))
                                (19 . ("Josef" "Josefina"))
                                (20 . ("Joakim" "Kim"))
                                (21 . ("Bengt"))
                                (22 . ("Kennet" "Kent"))
                                (23 . ("Gerda" "Gerd"))
                                (24 . ("Gabriel" "Rafael"))
                                (25 . ())
                                (26 . ("Emanuel"))
                                (27 . ("Rudolf" "Ralf"))
                                (28 . ("Malkolm" "Morgan"))
                                (29 . ("Jonas" "Jens"))
                                (30 . ("Holger" "Holmfrid"))
                                (31 . ("Ester"))))

                          (4 . ((1 . ("Harald" "Hervor"))
                                (2 . ("Gudmund" "Ingesund"))
                                (3 . ("Ferdinand" "Nanna"))
                                (4 . ("Marianne" "Marlene"))
                                (5 . ("Irene" "Irja"))
                                (6 . ("Vilhelm" "Helmi"))
                                (7 . ("Irma" "Irmelin"))
                                (8 . ("Nadja" "Tanja"))
                                (9 . ("Otto" "Ottilia"))
                                (10 . ("Ingvar" "Ingvor"))
                                (11 . ("Ulf" "Ylva"))
                                (12 . ("Liv"))
                                (13 . ("Artur" "Douglas"))
                                (14 . ("Tiburtius"))
                                (15 . ("Olivia" "Oliver"))
                                (16 . ("Patrik" "Patricia"))
                                (17 . ("Elias" "Elis"))
                                (18 . ("Valdemar" "Volmar"))
                                (19 . ("Olaus" "Ola"))
                                (20 . ("Amalia" "Amelie"))
                                (21 . ("Anneli" "Annika"))
                                (22 . ("Allan" "Glenn"))
                                (23 . ("Georg" "Gran"))
                                (24 . ("Vega"))
                                (25 . ("Markus"))
                                (26 . ("Teresia" "Terese"))
                                (27 . ("Engelbrekt"))
                                (28 . ("Ture" "Tyra"))
                                (29 . ("Tyko"))
                                (30 . ("Mariana"))))

                          (5 . ((1 . ("Valborg"))
                                (2 . ("Filip" "Filippa"))
                                (3 . ("John" "Jane"))
                                (4 . ("Monika" "Mona"))
                                (5 . ("Gotthard" "Erhard"))
                                (6 . ("Marit" "Rita"))
                                (7 . ("Carina" "Carita"))
                                (8 . ("ke"))
                                (9 . ("Reidar" "Reidun"))
                                (10 . ("Esbjrn" "Styrbjrn"))
                                (11 . ("Mrta" "Mrit"))
                                (12 . ("Charlotta" "Lotta"))
                                (13 . ("Linnea" "Linn"))
                                (14 . ("Halvard" "Halvar"))
                                (15 . ("Sofia" "Sonja"))
                                (16 . ("Ronald" "Ronny"))
                                (17 . ("Rebecka" "Ruben"))
                                (18 . ("Erik"))
                                (19 . ("Maj" "Majken"))
                                (20 . ("Karolina" "Carola"))
                                (21 . ("Konstantin" "Conny"))
                                (22 . ("Hemming" "Henning"))
                                (23 . ("Desideria" "Desiree"))
                                (24 . ("Ivan" "Vanja"))
                                (25 . ("Urban"))
                                (26 . ("Vilhelmina" "Vilma"))
                                (27 . ("Beda" "Blenda"))
                                (28 . ("Ingeborg" "Borghild"))
                                (29 . ("Yvonne" "Jeanette"))
                                (30 . ("Vera" "Veronika"))
                                (31 . ("Petronella" "Pernilla"))))

                          (6 . ((1 . ("Gun" "Gunnel"))
                                (2 . ("Rutger" "Roger"))
                                (3 . ("Ingemar" "Gudmar"))
                                (4 . ("Solbritt" "Solveig"))
                                (5 . ("Bo"))
                                (6 . ("Gustav" "Gsta"))
                                (7 . ("Robert" "Robin"))
                                (8 . ("Eivor" "Majvor"))
                                (9 . ("Brje" "Birger"))
                                (10 . ("Svante" "Boris"))
                                (11 . ("Bertil" "Berthold"))
                                (12 . ("Eskil"))
                                (13 . ("Aina" "Aino"))
                                (14 . ("Hkan" "Hakon"))
                                (15 . ("Margit" "Margot"))
                                (16 . ("Axel" "Axelina"))
                                (17 . ("Torborg" "Torvald"))
                                (18 . ("Bjrn" "Bjarne"))
                                (19 . ("Germund" "Grel"))
                                (20 . ("Linda"))
                                (21 . ("Alf" "Alvar"))
                                (22 . ("Paulina" "Paula"))
                                (23 . ("Adolf" "Alice"))
                                (24 . ())
                                (25 . ("David" "Salomon"))
                                (26 . ("Rakel" "Lea"))
                                (27 . ("Selma" "Fingal"))
                                (28 . ("Leo"))
                                (29 . ("Peter" "Petra"))
                                (30 . ("Elof" "Leif"))))

                          (7 . ((1 . ("Aron" "Mirjam"))
                                (2 . ("Rosa" "Rosita"))
                                (3 . ("Aurora"))
                                (4 . ("Ulrika" "Ulla"))
                                (5 . ("Laila" "Ritva"))
                                (6 . ("Esaias" "Jessika"))
                                (7 . ("Klas"))
                                (8 . ("Kjell"))
                                (9 . ("Jrgen" "rjan"))
                                (10 . ("Andre" "Andrea"))
                                (11 . ("Eleonora" "Ellinor"))
                                (12 . ("Herman" "Hermine"))
                                (13 . ("Joel" "Judit"))
                                (14 . ("Folke"))
                                (15 . ("Ragnhild" "Ragnvald"))
                                (16 . ("Reinhold" "Reine"))
                                (17 . ("Bruno"))
                                (18 . ("Fredrik" "Fritz"))
                                (19 . ("Sara"))
                                (20 . ("Margareta" "Greta"))
                                (21 . ("Johanna"))
                                (22 . ("Magdalena" "Madeleine"))
                                (23 . ("Emma"))
                                (24 . ("Kristina" "Kerstin"))
                                (25 . ("Jakob"))
                                (26 . ("Jesper"))
                                (27 . ("Marta"))
                                (28 . ("Botvid" "Seved"))
                                (29 . ("Olof"))
                                (30 . ("Algot"))
                                (31 . ("Helena" "Elin"))))

                          (8 . ((1 . ("Per"))
                                (2 . ("Karin" "Kajsa"))
                                (3 . ("Tage"))
                                (4 . ("Arne" "Arnold"))
                                (5 . ("Ulrik" "Alrik"))
                                (6 . ("Alfons" "Inez"))
                                (7 . ("Dennis" "Denise"))
                                (8 . ("Silvia" "Sylvia"))
                                (9 . ("Roland"))
                                (10 . ("Lars"))
                                (11 . ("Susanna"))
                                (12 . ("Klara"))
                                (13 . ("Kaj"))
                                (14 . ("Uno"))
                                (15 . ("Stella" "Estelle"))
                                (16 . ("Brynolf"))
                                (17 . ("Verner" "Valter"))
                                (18 . ("Ellen" "Lena"))
                                (19 . ("Magnus" "Mns"))
                                (20 . ("Bernhard" "Bernt"))
                                (21 . ("Jon" "Jonna"))
                                (22 . ("Henrietta" "Henrika"))
                                (23 . ("Signe" "Signhild"))
                                (24 . ("Bartolomeus"))
                                (25 . ("Lovisa" "Louise"))
                                (26 . ("sten"))
                                (27 . ("Rolf" "Raoul"))
                                (28 . ("Gurli" "Leila"))
                                (29 . ("Hans" "Hampus"))
                                (30 . ("Albert" "Albertina"))
                                (31 . ("Arvid" "Vidar"))))

                          (9 . ((1 . ("Samuel"))
                                (2 . ("Justus" "Justina"))
                                (3 . ("Alfhild" "Alva"))
                                (4 . ("Gisela"))
                                (5 . ("Adela" "Heidi"))
                                (6 . ("Lilian" "Lilly"))
                                (7 . ("Regina" "Roy"))
                                (8 . ("Alma" "Hulda"))
                                (9 . ("Anita" "Annette"))
                                (10 . ("Tord" "Turid"))
                                (11 . ("Dagny" "Helny"))
                                (12 . ("sa" "slg"))
                                (13 . ("Sture"))
                                (14 . ("Ida"))
                                (15 . ("Sigrid" "Siri"))
                                (16 . ("Dag" "Daga"))
                                (17 . ("Hildegard" "Magnhild"))
                                (18 . ("Orvar"))
                                (19 . ("Fredrika"))
                                (20 . ("Elise" "Lisa"))
                                (21 . ("Matteus"))
                                (22 . ("Maurits" "Moritz"))
                                (23 . ("Tekla" "Tea"))
                                (24 . ("Gerhard" "Gert"))
                                (25 . ("Tryggve"))
                                (26 . ("Enar" "Einar"))
                                (27 . ("Dagmar" "Rigmor"))
                                (28 . ("Lennart" "Leonard"))
                                (29 . ("Mikael" "Mikaela"))
                                (30 . ("Helge"))))

                          (10 . ((1 . ("Ragnar" "Ragna"))
                                 (2 . ("Ludvig" "Love"))
                                 (3 . ("Evald" "Osvald"))
                                 (4 . ("Frans" "Frank"))
                                 (5 . ("Bror"))
                                 (6 . ("Jenny" "Jennifer"))
                                 (7 . ("Birgitta" "Britta"))
                                 (8 . ("Nils"))
                                 (9 . ("Ingrid" "Inger"))
                                 (10 . ("Harry" "Harriet"))
                                 (11 . ("Erling" "Jarl"))
                                 (12 . ("Valfrid" "Manfred"))
                                 (13 . ("Berit" "Birgit"))
                                 (14 . ("Stellan"))
                                 (15 . ("Hedvig" "Hillevi"))
                                 (16 . ("Finn"))
                                 (17 . ("Antonia" "Toini"))
                                 (18 . ("Lukas"))
                                 (19 . ("Tore" "Tor"))
                                 (20 . ("Sibylla"))
                                 (21 . ("Ursula" "Yrsa"))
                                 (22 . ("Marika" "Marita"))
                                 (23 . ("Severin" "Sren"))
                                 (24 . ("Evert" "Eilert"))
                                 (25 . ("Inga" "Ingalill"))
                                 (26 . ("Amanda" "Rasmus"))
                                 (27 . ("Sabina"))
                                 (28 . ("Simon" "Simone"))
                                 (29 . ("Viola"))
                                 (30 . ("Elsa" "Isabella"))
                                 (31 . ("Edit" "Edgar"))))

                          (11 . ((1 . ())
                                 (2 . ("Tobias"))
                                 (3 . ("Hubert" "Hugo"))
                                 (4 . ("Sverker"))
                                 (5 . ("Eugen" "Eugenia"))
                                 (6 . ("Gustav" "Adolf"))
                                 (7 . ("Ingegerd" "Ingela"))
                                 (8 . ("Vendela"))
                                 (9 . ("Teodor" "Teodora"))
                                 (10 . ("Martin" "Martina"))
                                 (11 . ("Mrten"))
                                 (12 . ("Konrad" "Kurt"))
                                 (13 . ("Kristian" "Krister"))
                                 (14 . ("Emil" "Emilia"))
                                 (15 . ("Leopold"))
                                 (16 . ("Vibeke" "Viveka"))
                                 (17 . ("Naemi" "Naima"))
                                 (18 . ("Lillemor" "Moa"))
                                 (19 . ("Elisabet" "Lisbet"))
                                 (20 . ("Pontus" "Marina"))
                                 (21 . ("Helga" "Olga"))
                                 (22 . ("Cecilia" "Sissela"))
                                 (23 . ("Klemens"))
                                 (24 . ("Gudrun" "Rune"))
                                 (25 . ("Katarina" "Katja"))
                                 (26 . ("Linus"))
                                 (27 . ("Astrid" "Asta"))
                                 (28 . ("Malte"))
                                 (29 . ("Sune"))
                                 (30 . ("Andreas" "Anders"))))

                          (12 . ((1 . ("Oskar" "Ossian"))
                                 (2 . ("Beata" "Beatrice"))
                                 (3 . ("Lydia"))
                                 (4 . ("Barbara" "Barbro"))
                                 (5 . ("Sven"))
                                 (6 . ("Nikolaus" "Niklas"))
                                 (7 . ("Angela" "Angelika"))
                                 (8 . ("Virginia"))
                                 (9 . ("Anna"))
                                 (10 . ("Malin" "Malena"))
                                 (11 . ("Daniel" "Daniela"))
                                 (12 . ("Alexander" "Alexis"))
                                 (13 . ("Lucia"))
                                 (14 . ("Sten" "Sixten"))
                                 (15 . ("Gottfrid"))
                                 (16 . ("Assar"))
                                 (17 . ("Stig"))
                                 (18 . ("Abraham"))
                                 (19 . ("Isak"))
                                 (20 . ("Israel" "Moses"))
                                 (21 . ("Tomas"))
                                 (22 . ("Natanael" "Jonatan"))
                                 (23 . ("Adam"))
                                 (24 . ("Eva"))
                                 (25 . ())
                                 (26 . ("Stefan" "Staffan"))
                                 (27 . ("Johannes" "Johan"))
                                 (28 . ("Benjamin"))
                                 (29 . ("Natalia" "Natalie"))
                                 (30 . ("Abel" "Set"))
                                 (31 . ("Sylvester"))))))

(lyskom-define-namedays 'sv-pre-1901
                        "Sverige, fre 1901"
                        "\
Namnsdagar enligt namnlngd frn fre 1901, med uppenbara helgdagar
borttagna."
                        '((1 . ((1 . ())
                                (2 . ("Abel" "Set"))
                                (3 . ("Enoch"))
                                (4 . ("Titus"))
                                (5 . ("Simeon"))
                                (6 . ("Epifania"))
                                (7 . ("Knut"))
                                (8 . ("Erhard"))
                                (9 . ("Julianus"))
                                (10 . ("Nikanor"))
                                (11 . ("Hyginus"))
                                (12 . ("Arcadius"))
                                (13 . ("Knut"))
                                (14 . ("Felix"))
                                (15 . ("Maurus"))
                                (16 . ("Hjalmar"))
                                (17 . ("Anton"))
                                (18 . ("Prisca"))
                                (19 . ("Henrik"))
                                (20 . ("Fabianus"))
                                (21 . ("Agneta"))
                                (22 . ("Vincentius"))
                                (23 . ("Emerentia"))
                                (24 . ("Ericus Translatus"))
                                (25 . ("Paulus"))
                                (26 . ("Polykarpus"))
                                (27 . ("Gte"))
                                (28 . ("Karl"))
                                (29 . ("Valerius"))
                                (30 . ("Adelgunda"))
                                (31 . ("Vigilius"))
                                ))
                          (2 . (
                                (1 . ("Maximiliana"))
                                (2 . ())
                                (3 . ("Blasius"))
                                (4 . ("Ansgar (Ansgarius)"))
                                (5 . ("Agatha"))
                                (6 . ("Dorothea"))
                                (7 . ("Rikard"))
                                (8 . ("Malakias"))
                                (9 . ("Apollonia"))
                                (10 . ("Eugenia"))
                                (11 . ("Eufrosyne"))
                                (12 . ("Eulalia"))
                                (13 . ("Agabus"))
                                (14 . ("Valentin"))
                                (15 . ("Sigfrid"))
                                (16 . ("Juliana"))
                                (17 . ("Alexandra"))
                                (18 . ("Concordia"))
                                (19 . ("Gabinus"))
                                (20 . ("Eukarius" "Hulda"))
                                (21 . ("Hilarius"))
                                (22 . ("Petter Katt"))
                                (23 . ("Tertullianus"))
                                (24 . ("Mattias"))
                                (25 . ("Victorinus"))
                                (26 . ("Nestor"))
                                (27 . ("Leander"))
                                (28 . ("Makarius"))
                                ))
                          (3 . (
                                (1 . ("Albin"))
                                (2 . ("Ernst"))
                                (3 . ("Kunigunda"))
                                (4 . ("Adrian"))
                                (5 . ("Conon"))
                                (6 . ("Fulgentius"))
                                (7 . ("Felicitas"))
                                (8 . ("Philemon"))
                                (9 . ())
                                (10 . ("Apollonius"))
                                (11 . ("Vindicianus"))
                                (12 . ("Victoria"))
                                (13 . ("Gregorius"))
                                (14 . ("Matilda"))
                                (15 . ("Kristofer"))
                                (16 . ("Herbert"))
                                (17 . ("Gertrud"))
                                (18 . ("Edvard"))
                                (19 . ("Josef"))
                                (20 . ("Joakim"))
                                (21 . ("Bengt"))
                                (22 . ("Viktor"))
                                (23 . ("Axel"))
                                (24 . ("Gabriel"))
                                (25 . ())
                                (26 . ("Emanuel"))
                                (27 . ("Rupert"))
                                (28 . ("Malchus"))
                                (29 . ("Jonas"))
                                (30 . ("Qvirinus"))
                                (31 . ("Amos"))
                                ))
                          (4 . (
                                (1 . ("Hugo"))
                                (2 . ("Teodosius"))
                                (3 . ("Ferdinand"))
                                (4 . ("Ambrosius"))
                                (5 . ("Irene"))
                                (6 . ("Vilhelm"))
                                (7 . ("Hegesippus"))
                                (8 . ("Perpetuus"))
                                (9 . ("Otto"))
                                (10 . ("Hezekiel"))
                                (11 . ("Antipas"))
                                (12 . ("Julius"))
                                (13 . ("Artur"))
                                (14 . ("Tiburtius"))
                                (15 . ("Olympias"))
                                (16 . ("Patrik"))
                                (17 . ("Elias"))
                                (18 . ("Valerianus"))
                                (19 . ("Bernhard"))
                                (20 . ("Amalia"))
                                (21 . ("Anselm"))
                                (22 . ("Bernhardina"))
                                (23 . ("Georg"))
                                (24 . ("Vega"))
                                (25 . ("Markus"))
                                (26 . ("Kletus"))
                                (27 . ("Antimus" "Teresia"))
                                (28 . ("Theodora"))
                                (29 . ("Tycho"))
                                (30 . ("Mariana"))
                                ))
                          (5 . (
                                (1 . ("Valborg"))
                                (2 . ("Athanasius"))
                                (3 . ())
                                (4 . ("Monika"))
                                (5 . ("Gotthard"))
                                (6 . ("Sigismund"))
                                (7 . ("Stanislaus"))
                                (8 . ("Achatius"))
                                (9 . ("Timotheus"))
                                (10 . ("Epimachus"))
                                (11 . ("Mamertus"))
                                (12 . ("Charlotta"))
                                (13 . ("Linnea"))
                                (14 . ("Corona"))
                                (15 . ("Sophia"))
                                (16 . ("Peregrinus"))
                                (17 . ("Rebecka"))
                                (18 . ("Erik"))
                                (19 . ("Potentiana" "Potentia"))
                                (20 . ("Karolina"))
                                (21 . ("Konstantin"))
                                (22 . ("Hemming"))
                                (23 . ("Desideria" "Deriree"))
                                (24 . ("Rogatius"))
                                (25 . ("Urban"))
                                (26 . ("Vilhelmina"))
                                (27 . ("Beda"))
                                (28 . ("Germanus"))
                                (29 . ("Maximinus"))
                                (30 . ("Basilius"))
                                (31 . ("Petronella"))
                                ))
                          (6 . (
                                (1 . ("Nikodemus"))
                                (2 . ("Marcellinus"))
                                (3 . ("Erasmus"))
                                (4 . ("Optatus"))
                                (5 . ("Bonifacius"))
                                (6 . ("Gustaf"))
                                (7 . ("Robert"))
                                (8 . ("Salomon"))
                                (9 . ("Primus"))
                                (10 . ("Svante"))
                                (11 . ("Barnabas"))
                                (12 . ("Eskil"))
                                (13 . ("Akvilina"))
                                (14 . ("Elisa"))
                                (15 . ("Vitus"))
                                (16 . ("Justina"))
                                (17 . ("Botolf"))
                                (18 . ("Leontius"))
                                (19 . ("Gervasius"))
                                (20 . ("Florentin"))
                                (21 . ("Albanus"))
                                (22 . ("Paulinus"))
                                (23 . ("Adold"))
                                (24 . ())
                                (25 . ("David"))
                                (26 . ("Jeremias"))
                                (27 . ("Crescens"))
                                (28 . ("Leo"))
                                (29 . ("Petrus" "Paulus"))
                                (30 . ("Martialis"))
                                ))
                          (7 . (
                                (1 . ("Aron"))
                                (2 . ())
                                (3 . ("Anatolius"))
                                (4 . ("Ulrika"))
                                (5 . ("Melker"))
                                (6 . ("Esaias"))
                                (7 . ("Klas"))
                                (8 . ("Kilian"))
                                (9 . ("Cyrillus"))
                                (10 . ("Knut"))
                                (11 . ("Eleonora"))
                                (12 . ("Herman"))
                                (13 . ("Joel"))
                                (14 . ("Fokas"))
                                (15 . ())
                                (16 . ("Reinhold"))
                                (17 . ("Alexius"))
                                (18 . ("Fredrik"))
                                (19 . ("Sara"))
                                (20 . ("Margareta"))
                                (21 . ("Johanna"))
                                (22 . ("Maria Magdalena"))
                                (23 . ("Emma"))
                                (24 . ("Kristina"))
                                (25 . ("Jakob"))
                                (26 . ("Martha"))
                                (27 . ())
                                (28 . ("Botvid"))
                                (29 . ("Olof"))
                                (30 . ("Abdon"))
                                (31 . ("Helena"))
                                ))
                          (8 . (
                                (1 . ())
                                (2 . ("Karin"))
                                (3 . ("Stefanus"))
                                (4 . ("Aristarchus"))
                                (5 . ("Dominikus"))
                                (6 . ("Sixtus"))
                                (7 . ("Donatus"))
                                (8 . ("Cyriacus"))
                                (9 . ("Romanus"))
                                (10 . ("Lars"))
                                (11 . ("Susanna"))
                                (12 . ("Klara"))
                                (13 . ("Hippolytus"))
                                (14 . ("Eusebius"))
                                (15 . ())
                                (16 . ("Brynolf"))
                                (17 . ("Verner"))
                                (18 . ("Agapetus"))
                                (19 . ("Magnus"))
                                (20 . ("Samuel"))
                                (21 . ("Josefina"))
                                (22 . ("Henrietta"))
                                (23 . ("Zacheus"))
                                (24 . ("Bartolomeus"))
                                (25 . ("Lovisa"))
                                (26 . ("Zefyrinus"))
                                (27 . ("Rufus"))
                                (28 . ("Augustinus"))
                                (29 . ())
                                (30 . ("Albert"))
                                (31 . ("Arvid"))
                                ))
                          (9 . (
                                (1 . ("Egidius"))
                                (2 . ("Justus"))
                                (3 . ("Seraphia"))
                                (4 . ("Moses"))
                                (5 . ("Eudoxus"))
                                (6 . ("Zacharias" "Sakarias"))
                                (7 . ("Regina"))
                                (8 . ())
                                (9 . ("Augusta"))
                                (10 . ("Teodard"))
                                (11 . ("Protus"))
                                (12 . ("Cyrus"))
                                (13 . ("Amatus"))
                                (14 . ())
                                (15 . ("Nicetas"))
                                (16 . ("Eufemia"))
                                (17 . ("Lambertus"))
                                (18 . ("Methodius"))
                                (19 . ("Fredrika"))
                                (20 . ("Fausta"))
                                (21 . ("Matteus"))
                                (22 . ("Mauritz"))
                                (23 . ("Tekla"))
                                (24 . ("Gerhard"))
                                (25 . ("KLeofas"))
                                (26 . ("Cyprianus"))
                                (27 . ("Damianus"))
                                (28 . ("Leonard"))
                                (29 . ("Mikael"))
                                (30 . ("Hieronymus"))
                                ))
                          (10 . (
                                 (1 . ("Remigius"))
                                 (2 . ("Ludvig"))
                                 (3 . ("Evald"))
                                 (4 . ("Frans"))
                                 (5 . ("Placidus"))
                                 (6 . ("Bruno"))
                                 (7 . ("Birgitta"))
                                 (8 . ("Demetrius"))
                                 (9 . ("Dionysius"))
                                 (10 . ("Gereon"))
                                 (11 . ("Probus"))
                                 (12 . ("Valfrid"))
                                 (13 . ("Theophilus"))
                                 (14 . ("Calixtus"))
                                 (15 . ("Hedvig"))
                                 (16 . ("Gallus"))
                                 (17 . ("Antoinetta"))
                                 (18 . ("Lukas"))
                                 (19 . ("Ptolemeus"))
                                 (20 . ("Kasper"))
                                 (21 . ("Ursula" "Ursila"))
                                 (22 . ("Severus"))
                                 (23 . ("Severin"))
                                 (24 . ("Evergistus"))
                                 (25 . ("Crispinus"))
                                 (26 . ("Amandus"))
                                 (27 . ("Sabina"))
                                 (28 . ("Simon" "Judas"))
                                 (29 . ("Narcissus"))
                                 (30 . ("Zenobia"))
                                 (31 . ("Quintinus"))
                                 ))
                          (11 . (
                                 (1 . ())
                                 (2 . ("Tobias"))
                                 (3 . ("Eustachius"))
                                 (4 . ("Amatius"))
                                 (5 . ("Eugen"))
                                 (6 . ("Gustaf Adolf"))
                                 (7 . ("Engelbert"))
                                 (8 . ("Willehad"))
                                 (9 . ("Teodor"))
                                 (10 . ("Martin Luther"))
                                 (11 . ("Mrten"))
                                 (12 . ("Konrad"))
                                 (13 . ("Kristian"))
                                 (14 . ("Hypatius"))
                                 (15 . ("Leopold"))
                                 (16 . ("Edmund"))
                                 (17 . ("Napoleon"))
                                 (18 . ("Maximus"))
                                 (19 . ("Elisabet"))
                                 (20 . ("Pontus"))
                                 (21 . ("Heliodorus"))
                                 (22 . ("Cecilia"))
                                 (23 . ("Klemens"))
                                 (24 . ("Kristogonus"))
                                 (25 . ("Katarina"))
                                 (26 . ("Linus"))
                                 (27 . ("Vitalis"))
                                 (28 . ("Sten"))
                                 (29 . ("Saturninus"))
                                 (30 . ("Anders"))
                                 ))
                          (12 . (
                                 (1 . ("Oscar"))
                                 (2 . ("Beata"))
                                 (3 . ("Zephanias"))
                                 (4 . ("Barbro"))
                                 (5 . ("Crispina"))
                                 (6 . ("Nikolaus"))
                                 (7 . ("Agaton"))
                                 (8 . ())
                                 (9 . ("Anna"))
                                 (10 . ("Judit"))
                                 (11 . ("Daniel"))
                                 (12 . ("Alexander"))
                                 (13 . ("Lucia"))
                                 (14 . ("Isidor"))
                                 (15 . ("Ireneus"))
                                 (16 . ("Lazarus"))
                                 (17 . ("Ignatius"))
                                 (18 . ("Abraham"))
                                 (19 . ("Isak"))
                                 (20 . ("Jakob"))
                                 (21 . ("Tomas"))
                                 (22 . ("Josef"))
                                 (23 . ("Israel"))
                                 (24 . ("Adam" "Eva"))
                                 (25 . ())
                                 (26 . ("Stefan"))
                                 (27 . ("Johannes"))
                                 (28 . ())
                                 (29 . ())
                                 (30 . ("David"))
                                 (31 . ("Sylvester"))
                                 ))))

(lyskom-define-namedays 'sv-1901
                        "Sverige, 1901 rs namnlngd"
                        "\
Namnsdagar enligt namnlngd frn 1901, med uppenbara helgdagar borttagna."
                        '((1 . (
                                (1 . ())
                                (2 . ("Svea"))
                                (3 . ("Alfred"))
                                (4 . ("Rut"))
                                (5 . ("Hanna"))
                                (6 . ())
                                (7 . ("August"))
                                (8 . ("Erland"))
                                (9 . ("Gunnar"))
                                (10 . ("Sigurd"))
                                (11 . ("Hugo"))
                                (12 . ("Frideborg"))
                                (13 . ("Knut"))
                                (14 . ("Felix"))
                                (15 . ("Laura"))
                                (16 . ("Hjalmar"))
                                (17 . ("Anton"))
                                (18 . ("Hilda"))
                                (19 . ("Henrik"))
                                (20 . ("Fabian"))
                                (21 . ("Agnes"))
                                (22 . ("Vincent"))
                                (23 . ("Emilia"))
                                (24 . ("Erika"))
                                (25 . ("Paulus"))
                                (26 . ("Botilda"))
                                (27 . ("Gte"))
                                (28 . ("Karl"))
                                (29 . ("Valter"))
                                (30 . ("Gunhild"))
                                (31 . ("Ivar"))
                                ))
                          (2 . (
                                (1 . ("Max"))
                                (2 . ())
                                (3 . ("Disa"))
                                (4 . ("Ansgar"))
                                (5 . ("Agata"))
                                (6 . ("Dorotea"))
                                (7 . ("Rikard"))
                                (8 . ("Berta"))
                                (9 . ("Fanny"))
                                (10 . ("Eugenia"))
                                (11 . ("Yngve"))
                                (12 . ("Evelina"))
                                (13 . ("Agne"))
                                (14 . ("Valentin"))
                                (15 . ("Sigfrid"))
                                (16 . ("Julia"))
                                (17 . ("Alexandra"))
                                (18 . ("Frida"))
                                (19 . ("Gabriella"))
                                (20 . ("Hulda"))
                                (21 . ("Hilding"))
                                (22 . ("Martina"))
                                (23 . ("Torsten"))
                                (24 . ("Mattias"))
                                (25 . ("Sigvard"))
                                (26 . ("Torgny"))
                                (27 . ("Lage"))
                                (28 . ("Maria"))
                                ))
                          (3 . (
                                (1 . ("Albin"))
                                (2 . ("Ernst"))
                                (3 . ("Gunborg"))
                                (4 . ("Adrian"))
                                (5 . ("Tora"))
                                (6 . ("Ebba"))
                                (7 . ("Ottilia"))
                                (8 . ("Filippa"))
                                (9 . ("Torbjrn"))
                                (10 . ("Edla"))
                                (11 . ("Edvin"))
                                (12 . ("Viktoria"))
                                (13 . ("Greger"))
                                (14 . ("Matilda"))
                                (15 . ("Kristofer"))
                                (16 . ("Herbert"))
                                (17 . ("Gertrud"))
                                (18 . ("Edvard"))
                                (19 . ("Josef"))
                                (20 . ("Joakim"))
                                (21 . ("Bengt"))
                                (22 . ("Viktor"))
                                (23 . ("Gerda"))
                                (24 . ("Gabriel"))
                                (25 . ())
                                (26 . ("Emanuel"))
                                (27 . ("Rudolf"))
                                (28 . ("Malkolm"))
                                (29 . ("Jonas"))
                                (30 . ("Holger"))
                                (31 . ("Ester"))
                                ))
                          (4 . (
                                (1 . ("Harald"))
                                (2 . ("Gudmund"))
                                (3 . ("Ferdinand"))
                                (4 . ("Ambrosius"))
                                (5 . ("Nanna"))
                                (6 . ("Vilhelm"))
                                (7 . ("Ingemund"))
                                (8 . ("Hemming"))
                                (9 . ("Otto"))
                                (10 . ("Ingvar"))
                                (11 . ("Ulf"))
                                (12 . ("Julius"))
                                (13 . ("Artur"))
                                (14 . ("Tiburtius"))
                                (15 . ("Olivia"))
                                (16 . ("Patrik"))
                                (17 . ("Elias"))
                                (18 . ("Valdemar"))
                                (19 . ("Olavus Petri"))
                                (20 . ("Amalia"))
                                (21 . ("Anselm"))
                                (22 . ("Albertina"))
                                (23 . ("Georg"))
                                (24 . ("Vega"))
                                (25 . ("Markus"))
                                (26 . ("Teresia"))
                                (27 . ("Engelbrekt"))
                                (28 . ("Ture"))
                                (29 . ("Tyko"))
                                (30 . ("Mariana"))
                                ))
                          (5 . (
                                (1 . ("Valborg"))
                                (2 . ("Filip"))
                                (3 . ("Gta"))
                                (4 . ("Monika"))
                                (5 . ("Gotthard"))
                                (6 . ("Sigmund"))
                                (7 . ("Gustava"))
                                (8 . ("ke"))
                                (9 . ("Jonatan"))
                                (10 . ("Esbjrn"))
                                (11 . ("Mrta"))
                                (12 . ("Charlotta"))
                                (13 . ("Linnea"))
                                (14 . ("Halvard"))
                                (15 . ("Sofia"))
                                (16 . ("Hilma"))
                                (17 . ("Rebecka"))
                                (18 . ("Erik"))
                                (19 . ("Alrik"))
                                (20 . ("Karolina"))
                                (21 . ("Konstantin"))
                                (22 . ("Henning"))
                                (23 . ("Desideria"))
                                (24 . ("Ragnvald"))
                                (25 . ("Urban"))
                                (26 . ("Vilhelmina"))
                                (27 . ("Blenda"))
                                (28 . ("Ingeborg"))
                                (29 . ("Baltsar"))
                                (30 . ("Fritjof"))
                                (31 . ("Isabella"))
                                ))
                          (6 . (
                                (1 . ("Nikodemus"))
                                (2 . ("Rutger"))
                                (3 . ("Ingemar"))
                                (4 . ("Holmfrid"))
                                (5 . ("Bo"))
                                (6 . ("Gustav"))
                                (7 . ("Robert"))
                                (8 . ("Salomon"))
                                (9 . ("Brje"))
                                (10 . ("Svante"))
                                (11 . ("Barnabas" "Bertil"))
                                (12 . ("Eskil"))
                                (13 . ("Aina"))
                                (14 . ("Hkan"))
                                (15 . ("Justina"))
                                (16 . ("Axel"))
                                (17 . ("Torborg"))
                                (18 . ("Bjrn"))
                                (19 . ("Germund"))
                                (20 . ("Flora"))
                                (21 . ("Alf"))
                                (22 . ("Paulina"))
                                (23 . ("Adolf"))
                                (24 . ())
                                (25 . ("David"))
                                (26 . ("Rakel"))
                                (27 . ("Selma"))
                                (28 . ("Leo"))
                                (29 . ("Petrus"))
                                (30 . ("Elof"))
                                ))
                          (7 . (
                                (1 . ("Aron"))
                                (2 . ("Rosa"))
                                (3 . ("Aurora"))
                                (4 . ("Ulrika"))
                                (5 . ("Melker"))
                                (6 . ("Esaias"))
                                (7 . ("Klas"))
                                (8 . ("Kjell"))
                                (9 . ("Gtilda"))
                                (10 . ("Anund"))
                                (11 . ("Eleonora"))
                                (12 . ("Herman"))
                                (13 . ("Joel"))
                                (14 . ("Folke"))
                                (15 . ("Ragnhild"))
                                (16 . ("Reinhold"))
                                (17 . ("Alexis"))
                                (18 . ("Fredrik"))
                                (19 . ("Sara"))
                                (20 . ("Margareta"))
                                (21 . ("Johanna"))
                                (22 . ("Magdalena"))
                                (23 . ("Emma"))
                                (24 . ("Kristina"))
                                (25 . ("Jakob"))
                                (26 . ("Jesper"))
                                (27 . ("Marta"))
                                (28 . ("Botvid"))
                                (29 . ("Olof"))
                                (30 . ("Algot"))
                                (31 . ("Elin"))
                                ))
                          (8 . (
                                (1 . ("Per"))
                                (2 . ("Karin"))
                                (3 . ("Tage"))
                                (4 . ("Arne"))
                                (5 . ("Ulrik"))
                                (6 . ("Sixten"))
                                (7 . ("Arnold"))
                                (8 . ("Sylvia"))
                                (9 . ("Roland"))
                                (10 . ("Lars"))
                                (11 . ("Susanna"))
                                (12 . ("Klara"))
                                (13 . ("Hillevi"))
                                (14 . ("Ebbe"))
                                (15 . ("Stella"))
                                (16 . ("Brynolf"))
                                (17 . ("Verner"))
                                (18 . ("Helena"))
                                (19 . ("Magnus"))
                                (20 . ("Bernhard"))
                                (21 . ("Josefina"))
                                (22 . ("Henrietta"))
                                (23 . ("Signe"))
                                (24 . ("Bartolomeus"))
                                (25 . ("Lovisa"))
                                (26 . ("sten"))
                                (27 . ("Rolf"))
                                (28 . ("Augustin"))
                                (29 . ("Hans"))
                                (30 . ("Albert"))
                                (31 . ("Arvid"))
                                ))
                          (9 . (
                                (1 . ("Samuel"))
                                (2 . ("Justus"))
                                (3 . ("Alfhild"))
                                (4 . ("Moses"))
                                (5 . ("Adela"))
                                (6 . ("Sakarias"))
                                (7 . ("Regina"))
                                (8 . ("Alma"))
                                (9 . ("Augusta"))
                                (10 . ("Tord"))
                                (11 . ("Dagny"))
                                (12 . ("Tyra"))
                                (13 . ("Ambjrn"))
                                (14 . ("Ida"))
                                (15 . ("Sigrid"))
                                (16 . ("Eufemia"))
                                (17 . ("Hildegard"))
                                (18 . ("Alvar"))
                                (19 . ("Fredrika"))
                                (20 . ("Agda"))
                                (21 . ("Matteus"))
                                (22 . ("Maurits"))
                                (23 . ("Tekla"))
                                (24 . ("Gerhard"))
                                (25 . ("Signild"))
                                (26 . ("Enar"))
                                (27 . ("Dagmar"))
                                (28 . ("Lennart"))
                                (29 . ("Mikael"))
                                (30 . ("Helge"))
                                ))
                          (10 . (
                                 (1 . ("Ragnar"))
                                 (2 . ("Ludvig"))
                                 (3 . ("Evald"))
                                 (4 . ("Frans"))
                                 (5 . ("Bror"))
                                 (6 . ("Jenny"))
                                 (7 . ("Birgitta"))
                                 (8 . ("Nils"))
                                 (9 . ("Ingrid"))
                                 (10 . ("Helmer"))
                                 (11 . ("Erling"))
                                 (12 . ("Valfrid"))
                                 (13 . ("Teofil"))
                                 (14 . ("Manfred"))
                                 (15 . ("Hedvig"))
                                 (16 . ("Fingal"))
                                 (17 . ("Antoinetta"))
                                 (18 . ("Lukas"))
                                 (19 . ("Tore"))
                                 (20 . ("Kasper" "Sibylla"))
                                 (21 . ("Birger"))
                                 (22 . ("Seved"))
                                 (23 . ("Sren"))
                                 (24 . ("Evert"))
                                 (25 . ("Inga"))
                                 (26 . ("Amanda"))
                                 (27 . ("Sabina"))
                                 (28 . ("Simon"))
                                 (29 . ("Viola"))
                                 (30 . ("Elsa"))
                                 (31 . ("Edit"))
                                 ))
                          (11 . (
                                 (1 . ())
                                 (2 . ("Tobias"))
                                 (3 . ("Hubert"))
                                 (4 . ("Sverker"))
                                 (5 . ("Eugen"))
                                 (6 . ("Gustav Adolf"))
                                 (7 . ("Ingegerd"))
                                 (8 . ("Vendela"))
                                 (9 . ("Teodor"))
                                 (10 . ("Martin Luther"))
                                 (11 . ("Mrten"))
                                 (12 . ("Konrad"))
                                 (13 . ("Kristian"))
                                 (14 . ("Emil"))
                                 (15 . ("Leopold"))
                                 (16 . ("Edmund"))
                                 (17 . ("Napoleon"))
                                 (18 . ("Magnhild"))
                                 (19 . ("Elisabet"))
                                 (20 . ("Pontus"))
                                 (21 . ("Helga"))
                                 (22 . ("Cecilia"))
                                 (23 . ("Klemens"))
                                 (24 . ("Gudrun"))
                                 (25 . ("Katarina"))
                                 (26 . ("Torkel"))
                                 (27 . ("Astrid"))
                                 (28 . ("Malte"))
                                 (29 . ("Sune"))
                                 (30 . ("Anders"))
                                 ))
                          (12 . (
                                 (1 . ("Oskar"))
                                 (2 . ("Beata"))
                                 (3 . ("Lydia"))
                                 (4 . ("Barbro"))
                                 (5 . ("Sven"))
                                 (6 . ("Nikolaus"))
                                 (7 . ("Agaton"))
                                 (8 . ("Virginia"))
                                 (9 . ("Anna"))
                                 (10 . ("Malin"))
                                 (11 . ("Daniel"))
                                 (12 . ("Alexander"))
                                 (13 . ("Lucia"))
                                 (14 . ("Sten"))
                                 (15 . ("Gottfrid"))
                                 (16 . ("Assar"))
                                 (17 . ("Inge"))
                                 (18 . ("Abraham"))
                                 (19 . ("Isak"))
                                 (20 . ("Israel"))
                                 (21 . ("Tomas"))
                                 (22 . ("Natanael"))
                                 (23 . ("Adam"))
                                 (24 . ("Eva"))
                                 (25 . ())
                                 (26 . ("Stefan"))
                                 (27 . ("Johannes"))
                                 (28 . ())
                                 (29 . ("Abel"))
                                 (30 . ("Set"))
                                 (31 . ("Sylvester"))
                                 ))))

(lyskom-define-namedays 'sv-1986
                        "Sverige, 1986 rs namnlngd"
                        "\
Namnsdagar enligt namnlngd frn 1986, med uppenbara helgdagar borttagna."
                        '((1 . (
                                (1 . ())
                                (2 . ("Svea" "Bore" "Sverre"))
                                (3 . ("Alfred" "Alfrida" "Annefrid"))
                                (4 . ("Rut" "Ritva" "Roger"))
                                (5 . ("Hanna" "Hannele" "Hanny"))
                                (6 . ())
                                (7 . ("August" "jar" "rjan"))
                                (8 . ("Erland" "Erhard" "Erla"))
                                (9 . ("Gunnar" "Gun" "Gunno"))
                                (10 . ("Sigurd" "Sigrun" "Sigyn"))
                                (11 . ("Hugo" "Hagar"))
                                (12 . ("Frideborg" "Fridolf" "Fridolin"))
                                (13 . ("Knut" "Kennet" "Kent"))
                                (14 . ("Felix" "Felicia" "Fritz"))
                                (15 . ("Laura" "Lauritz" "Lotten"))
                                (16 . ("Hjalmar" "Herdis" "Hjrdis"))
                                (17 . ("Anton" "Anja" "Antonia"))
                                (18 . ("Hilda" "Hildor" "Hildur"))
                                (19 . ("Henrik" "Henrika" "Henry"))
                                (20 . ("Fabian" "Lina" "Linus"))
                                (21 . ("Agnes" "Agnar" "Agneta"))
                                (22 . ("Vincent" "Vanja" "Veine"))
                                (23 . ("Emilia" "Emilie" "Mildred"))
                                (24 . ("Erika" "Jarl" "Jarla"))
                                (25 . ("Paulus" "Paul" "Paula"))
                                (26 . ("Botilda" "Tilda" "Tilly"))
                                (27 . ("Gte" "Gtar" "Jns"))
                                (28 . ("Karl" "Kally" "Karla"))
                                (29 . ("Valter" "Valerie" "Volter"))
                                (30 . ("Gunhild" "Gunilla" "Gunnel"))
                                (31 . ("Ivar" "Iva" "Ivan"))
                                ))
                          (2 . (
                                (1 . ("Max" "Marielle" "Marietta"))
                                (2 . ())
                                (3 . ("Disa" "Dick" "Didrik"))
                                (4 . ("Ansgar" "Anneli" "Ansa"))
                                (5 . ("Agata" "Aili" "Alvi"))
                                (6 . ("Dorotea" "Dora" "Doris"))
                                (7 . ("Rikard" "Ricky" "Rigmor"))
                                (8 . ("Berta" "Bert" "Bertram"))
                                (9 . ("Fanny" "Sanny" "Sonny"))
                                (10 . ("Eugenia" "Egon" "Eira"))
                                (11 . ("Yngve" "Yvette" "Yvonne"))
                                (12 . ("Evelina" "Elaine" "Evelyn"))
                                (13 . ("Agne" "Alin" "Alina"))
                                (14 . ("Valentin" "Valentina" "Vally"))
                                (15 . ("Sigfrid" "Sigbert" "Sigbritt"))
                                (16 . ("Julia" "Juliana" "Juliette"))
                                (17 . ("Alexandra" "Sandor" "Sandra"))
                                (18 . ("Frida" "Fride" "Frode"))
                                (19 . ("Gabriella" "Ella" "Elna"))
                                (20 . ("Hulda" "Haldis" "Haldo"))
                                (21 . ("Hilding" "Hildeborg" "Hildemar"))
                                (22 . ("Martina" "Tim" "Tina"))
                                (23 . ("Torsten" "Toivo" "Torun"))
                                (24 . ("Mattias" "Matti" "Mats"))
                                (25 . ("Sigvard" "Sigvald" "Sigvor"))
                                (26 . ("Torgny" "Torvald"))
                                (27 . ("Lage" "Laila" "Lave"))
                                (28 . ("Maria" "Marie" "Mary"))
                                ))
                          (3 . (
                                (1 . ("Albin" "Alba" "Alban"))
                                (2 . ("Ernst" "Erna" "Ernfrid"))
                                (3 . ("Gunborg" "Gunbritt" "Gunvald"))
                                (4 . ("Adrian" "Adrienne" "Astor"))
                                (5 . ("Tora" "Toini" "Tor"))
                                (6 . ("Ebba" "Ebon" "Yvonne"))
                                (7 . ("Ottilia" "Petra" "Petronella"))
                                (8 . ("Filippa" "Gunlg" "slg"))
                                (9 . ("Torbjrn" "Torben" "Torgun"))
                                (10 . ("Edla" "Edling" "Ethel"))
                                (11 . ("Edvin" "Diana" "Edna"))
                                (12 . ("Viktoria" "Vibeke" "Viking"))
                                (13 . ("Greger" "Grels" "Greta"))
                                (14 . ("Matilda" "Maud" "Moa"))
                                (15 . ("Kristofer" "Christel" "Christer"))
                                (16 . ("Herbert" "Herta" "Hervor"))
                                (17 . ("Gertrud" "Gertie" "Glin"))
                                (18 . ("Edvard" "Eda" "Eddie"))
                                (19 . ("Josef" "James" "Janet"))
                                (20 . ("Joakim" "Jockum" "Kim"))
                                (21 . ("Bengt" "Bengta" "Benita"))
                                (22 . ("Viktor" "Vimar" "Vge"))
                                (23 . ("Gerda" "Anngerd" "Gerd"))
                                (24 . ("Gabriel" "Gabrielle" "Gunni"))
                                (25 . ())
                                (26 . ("Emanuel" "Emanuella" "Immanuel"))
                                (27 . ("Rudolf" "Rode" "Rudi"))
                                (28 . ("Malkolm" "Elma" "Elmer"))
                                (29 . ("Jonas" "Jon" "Jonna"))
                                (30 . ("Holger" "Olga"))
                                (31 . ("Ester" "Estrid" "Vasti"))
                                ))
                          (4 . (
                                (1 . ("Harald" "Hadar" "Hardy"))
                                (2 . ("Gudmund" "Gudmar" "Gunder"))
                                (3 . ("Ferdinand" "Gunvi" "Gunvor"))
                                (4 . ("Ambrosius" "Irene" "Irina"))
                                (5 . ("Nanna" "Nancy" "Nanny"))
                                (6 . ("Vilhelm" "William" "Willy"))
                                (7 . ("Ingemund" "Ingemo" "Irma"))
                                (8 . ("Hemming" "Heimir" "Helmut"))
                                (9 . ("Otto" "Orvar" "Ottar"))
                                (10 . ("Ingvar" "Ingvald" "Ingvor"))
                                (11 . ("Ulf" "Ylva" "Yrsa"))
                                (12 . ("Julius" "Gillis"))
                                (13 . ("Artur" "Aldor" "Atle"))
                                (14 . ("Tiburtius" "Ellen" "Elly"))
                                (15 . ("Olivia" "Oliver" "Ove"))
                                (16 . ("Patrik" "Patricia" "Percy"))
                                (17 . ("Elias" "Elis" "Elise"))
                                (18 . ("Valdemar" "Valdis" "Volmar"))
                                (19 . ("Olavus Petri" "Olaus" "Olavi"))
                                (20 . ("Amalia" "Amelie" "Amy"))
                                (21 . ("Anselm" "Annevi" "Annvor"))
                                (22 . ("Albertina" "Alida" "Allan"))
                                (23 . ("Georg" "Georgina" "Jrgen"))
                                (24 . ("Vega" "Viggo" "Viveka"))
                                (25 . ("Markus" "Marika" "Mark"))
                                (26 . ("Teresia" "Terese" "Tessy"))
                                (27 . ("Engelbrekt" "Engelbert" "Enok"))
                                (28 . ("Ture" "Turid" "Tuve"))
                                (29 . ("Tyko" "Toralf" "Torulf"))
                                (30 . ("Mariana" "Marianne" "Marina"))
                                ))
                          (5 . (
                                (1 . ("Valborg" "Maj" "Maja"))
                                (2 . ("Filip" "sa" "se"))
                                (3 . ("Gta" "Grel" "Gtmar"))
                                (4 . ("Monika" "Majne" "Mona"))
                                (5 . ("Gotthard" "Gotthild" "Gotty"))
                                (6 . ("Sigmund" "Sigge"))
                                (7 . ("Gustava" "Gullvi" "Gullbritt"))
                                (8 . ("ke" "ge" "got"))
                                (9 . ("Jonatan" "John" "Johnny"))
                                (10 . ("Esbjrn" "Elvy" "Essy"))
                                (11 . ("Mrta" "Meta" "Mrit"))
                                (12 . ("Charlotta" "Charlotte" "Lotta"))
                                (13 . ("Linnea" "Linn" "Lis"))
                                (14 . ("Halvard" "Halvor" "Halvar"))
                                (15 . ("Sofia" "Sia" "Sofie"))
                                (16 . ("Hilma" "Helvi" "Hilmer"))
                                (17 . ("Rebecka" "Renee" "Rosita"))
                                (18 . ("Erik" "Erk" "Jerker"))
                                (19 . ("Alrik" "Alda" "Altea"))
                                (20 . ("Karolina" "Carola" "Caroline"))
                                (21 . ("Konstantin" "Conny" "Konstantia"))
                                (22 . ("Henning" "Henny" "Pl"))
                                (23 . ("Desideria" "Dennis" "Desiree"))
                                (24 . ("Ragnvald" "Ragnvi" "Ragnvor"))
                                (25 . ("Urban" "Una" "Uno"))
                                (26 . ("Vilhelmina" "Vilma" "Vilmar"))
                                (27 . ("Blenda" "Beda" "Britten"))
                                (28 . ("Ingeborg" "Ingabritt" "Ingbritt"))
                                (29 . ("Baltsar" "Bill" "Billy"))
                                (30 . ("Fritjof" "Majny" "Majvi"))
                                (31 . ("Isabella" "Iris" "Isa"))
                                ))
                          (6 . (
                                (1 . ("Nikodemus" "Nina" "Ninni"))
                                (2 . ("Rutger" "Runa" "Rune"))
                                (3 . ("Ingemar" "Ingar" "Ingmarie"))
                                (4 . ("Holmfrid" "Helfrid" "Helfrida"))
                                (5 . ("Bo" "Bodil" "Boel"))
                                (6 . ("Gustav" "Gusten" "Gsta"))
                                (7 . ("Robert" "Robin" "Ruben"))
                                (8 . ("Salomon" "Sally"))
                                (9 . ("Brje" "Belinda" "Bjrg"))
                                (10 . ("Svante" "Sante" "Sjunne"))
                                (11 . ("Bertil" "Berit" "Berthold"))
                                (12 . ("Eskil" "Eje" "Evan"))
                                (13 . ("Aina" "Aino" "Roine"))
                                (14 . ("Hkan" "Hakon" "Hakvin"))
                                (15 . ("Justina" "Jim" "Jimmy"))
                                (16 . ("Axel" "Axelia" "Axelina"))
                                (17 . ("Torborg" "Torhild" "Toril"))
                                (18 . ("Bjrn" "Bjarne" "Bjrne"))
                                (19 . ("Germund" "Jerry" "Jill"))
                                (20 . ("Flora" "Florence" "Florentin"))
                                (21 . ("Alf" "Alvin" "Alvina"))
                                (22 . ("Paulina" "Pamela" "Paulette"))
                                (23 . ("Adolf" "Adolfina" "Ally"))
                                (24 . ())
                                (25 . ("David" "Davida" "Daisy"))
                                (26 . ("Rakel" "Rafael" "Ralf"))
                                (27 . ("Selma" "Selim" "Selmer"))
                                (28 . ("Leo" "Lola" "Liselott"))
                                (29 . ("Petrus" "Peter" "Petter"))
                                (30 . ("Elof" "Elvira" "Viran"))
                                ))
                          (7 . (
                                (1 . ("Aron" "Arent" "Arild"))
                                (2 . ("Rosa" "Rose" "Rosmarie"))
                                (3 . ("Aurora" "Andre" "Aurelia"))
                                (4 . ("Ulrika" "Ellika" "Ulla"))
                                (5 . ("Melker" "Marja" "Mirjam"))
                                (6 . ("Esaias" "Elisiv" "Esse"))
                                (7 . ("Klas" "Claudia" "Klaus"))
                                (8 . ("Kjell" "Katja" "Kettil"))
                                (9 . ("Gtilda" "Gran" "Jrn"))
                                (10 . ("Anund" "Anita" "Ante"))
                                (11 . ("Eleonora" "Eleonor" "Ellinor"))
                                (12 . ("Herman" "Hanne" "Hermine"))
                                (13 . ("Joel" "Joar" "Jorunn"))
                                (14 . ("Folke" "Fale" "Fylgia"))
                                (15 . ("Ragnhild" "Ragni" "Runo"))
                                (16 . ("Reinhold" "Reine" "Reino"))
                                (17 . ("Alexis" "Alex" "Alice"))
                                (18 . ("Fredrik" "Fred" "Freddy"))
                                (19 . ("Sara" "Charles" "Saga"))
                                (20 . ("Margareta" "Margit" "Margret"))
                                (21 . ("Johanna" "Jean" "Jeanette"))
                                (22 . ("Magdalena" "Magda" "Madeleine"))
                                (23 . ("Emma" "Elena" "Emmy"))
                                (24 . ("Kristina" "Kerstin" "Kristin"))
                                (25 . ("Jakob" "Jack"))
                                (26 . ("Jesper" "Jessika" "Jesse"))
                                (27 . ("Marta" "Marit" "Marita"))
                                (28 . ("Botvid" "Reidar" "Reidun"))
                                (29 . ("Olof" "Ola" "Olle"))
                                (30 . ("Algot" "Margot" "Vilgot"))
                                (31 . ("Elin" "Elon" "Elina"))
                                ))
                          (8 . (
                                (1 . ("Per" "Peder" "Pernilla"))
                                (2 . ("Karin" "Karen" "Kre"))
                                (3 . ("Tage" "Tanja" "Truls"))
                                (4 . ("Arne" "Arna" "Arnevi"))
                                (5 . ("Ulrik" "Unn" "Unni"))
                                (6 . ("Sixten" "Sve" "Slve"))
                                (7 . ("Arnold" "Annika" "Annmari"))
                                (8 . ("Sylvia" "Silja" "Silvia"))
                                (9 . ("Roland" "Ronald" "Ronny"))
                                (10 . ("Lars" "Lasse" "Lorentz"))
                                (11 . ("Susanna" "Sanna" "Susanne"))
                                (12 . ("Klara" "Clarence" "Clary"))
                                (13 . ("Hillevi" "Hilja" "Ilja"))
                                (14 . ("Ebbe" "Eberhard" "Efraim"))
                                (15 . ("Stella" "Estelle" "Stefan"))
                                (16 . ("Brynolf" "Benjamin" "Benny"))
                                (17 . ("Verner" "Verna" "Veronika"))
                                (18 . ("Helena" "Helen" "Helny"))
                                (19 . ("Magnus" "Mogens" "Mns"))
                                (20 . ("Bernhard" "Berna" "Bernt"))
                                (21 . ("Josefina" "Josefin"))
                                (22 . ("Henrietta" "Harriet" "Harry"))
                                (23 . ("Signe" "Signar" "Signy"))
                                (24 . ("Bartolomeus" "Carita" "Rita"))
                                (25 . ("Lovisa" "Louis" "Louise"))
                                (26 . ("sten" "Ejvind" "jvind"))
                                (27 . ("Rolf" "Raoul" "Rasmus"))
                                (28 . ("Augustin" "Gusti" "Gurli"))
                                (29 . ("Hans" "Hampus" "Hasse"))
                                (30 . ("Albert" "Albrekt" "Aste"))
                                (31 . ("Arvid" "Arvida" "Vidar"))
                                ))
                          (9 . (
                                (1 . ("Samuel" "Sam" "Solveig"))
                                (2 . ("Justus" "Jane" "Judit"))
                                (3 . ("Alfhild" "Alfons" "Arja"))
                                (4 . ("Moses" "Molly" "My"))
                                (5 . ("Adela" "Adele" "Adin"))
                                (6 . ("Sakarias" "Siv" "Sivert"))
                                (7 . ("Regina" "Gilbert" "Gisela"))
                                (8 . ("Alma" "Adils" "Almar"))
                                (9 . ("Augusta" "Gunda" "Gunde"))
                                (10 . ("Tord" "Tordis" "Torgil"))
                                (11 . ("Dagny" "Dag" "Daga"))
                                (12 . ("Tyra" "Tyr"))
                                (13 . ("Ambjrn" "Stig" "Styrbjrn"))
                                (14 . ("Ida" "Idar" "Vida"))
                                (15 . ("Sigrid" "Siri" "Solbritt"))
                                (16 . ("Eufemia" "Cornelia" "Cornelius"))
                                (17 . ("Hildegard" "Hilbert" "Hildebrand"))
                                (18 . ("Alvar" "Alve" "Alva"))
                                (19 . ("Fredrika" "Frej" "Freja"))
                                (20 . ("Agda" "Jan" "Jannika"))
                                (21 . ("Matteus" "Majbritt" "Majlis"))
                                (22 . ("Maurits" "Marlene" "Moritz"))
                                (23 . ("Tekla" "Trond" "Tryggve"))
                                (24 . ("Gerhard" "Gert" "Glenn"))
                                (25 . ("Signild" "Sanfrid" "Signhild"))
                                (26 . ("Enar" "Einar" "Eja"))
                                (27 . ("Dagmar" "Donald" "Douglas"))
                                (28 . ("Lennart" "Lena" "Leonard"))
                                (29 . ("Mikael" "Majken" "Mikaela"))
                                (30 . ("Helge" "Heidi" "Hrje"))
                                ))
                          (10 . (
                                 (1 . ("Ragnar" "Ragna" "Ragne"))
                                 (2 . ("Ludvig" "Levi" "Liv"))
                                 (3 . ("Evald" "Eila" "Eilert"))
                                 (4 . ("Frans" "Franciska" "Frank"))
                                 (5 . ("Bror" "Brage" "Bruno"))
                                 (6 . ("Jenny" "Jennifer" "Jens"))
                                 (7 . ("Birgitta" "Birgit" "Britt"))
                                 (8 . ("Nils" "Nilla" "Nelly"))
                                 (9 . ("Ingrid" "Inger" "Ingolf"))
                                 (10 . ("Helmer" "Helmina" "Helmy"))
                                 (11 . ("Erling" "Elvin" "Elvina"))
                                 (12 . ("Valfrid" "Ina" "Inez"))
                                 (13 . ("Teofil" "Terje" "Tjelvar"))
                                 (14 . ("Manfred" "Mandor" "Manne"))
                                 (15 . ("Hedvig" "Hartvig" "Hedda"))
                                 (16 . ("Fingal" "Finn" "Flemming"))
                                 (17 . ("Antoinetta" "Annette" "Tony"))
                                 (18 . ("Lukas" "Lillemor" "Lilly"))
                                 (19 . ("Tore" "Bojan" "Borghild"))
                                 (20 . ("Sibylla" "Camilla" "Kasper"))
                                 (21 . ("Birger" "Brita" "Britta"))
                                 (22 . ("Seved" "Sigvid" "Ursula"))
                                 (23 . ("Sren" "Severin"))
                                 (24 . ("Evert" "Eivor" "Elving"))
                                 (25 . ("Inga" "Ingalill" "Ingert"))
                                 (26 . ("Amanda" "Manda" "Mandy"))
                                 (27 . ("Sabina" "Sebastian" "Sussy"))
                                 (28 . ("Simon" "Simeon" "Simone"))
                                 (29 . ("Viola" "Vivi" "Vivianne"))
                                 (30 . ("Elsa" "Elsie" "Ilse"))
                                 (31 . ("Edit" "Edgar" "Edor"))
                                 ))
                          (11 . (
                                 (1 . ())
                                 (2 . ("Tobias" "Tova" "Tove"))
                                 (3 . ("Hubert" "Raymond" "Roy"))
                                 (4 . ("Sverker" "Nore" "Nora"))
                                 (5 . ("Eugen" "Ebert" "Egil"))
                                 (6 . ("Gustav Adolf" "Gull" "Gulli"))
                                 (7 . ("Ingegerd" "Ingel" "Ingela"))
                                 (8 . ("Vendela" "Vanda" "Ville"))
                                 (9 . ("Teodor" "Tea" "Ted"))
                                 (10 . ("Martin Luther" "Mait" "Martin"))
                                 (11 . ("Mrten" "Marion" "Morgan"))
                                 (12 . ("Konrad" "Kuno" "Kurt"))
                                 (13 . ("Kristian" "Karsten" "Kersti"))
                                 (14 . ("Emil" "Milly" "Mimmi"))
                                 (15 . ("Leopold" "Leif" "Lilian"))
                                 (16 . ("Edmund" "Elida" "Elisa"))
                                 (17 . ("Napoleon" "Naemi" "Naima"))
                                 (18 . ("Magnhild" "Magna" "Magne"))
                                 (19 . ("Elisabet" "Lisa" "Lisbet"))
                                 (20 . ("Pontus" "Polly" "Povel"))
                                 (21 . ("Helga" "Helle" "Hilde"))
                                 (22 . ("Cecilia" "Cilla" "Cissi"))
                                 (23 . ("Klemens" "Ketty" "Kitty"))
                                 (24 . ("Gudrun" "Gullan" "Gullvor"))
                                 (25 . ("Katarina" "Carina" "Katrin"))
                                 (26 . ("Torkel" "Torleif"))
                                 (27 . ("Astrid" "Asta" "Astri"))
                                 (28 . ("Malte" "Malvina" "Mia"))
                                 (29 . ("Sune" "Sonja" "Synnve"))
                                 (30 . ("Anders" "Andrea" "Andreas"))
                                 ))
                          (12 . (
                                 (1 . ("Oskar" "Ole" "Ossian"))
                                 (2 . ("Beata" "Beatrice" "Betty"))
                                 (3 . ("Lydia" "Linda" "Love"))
                                 (4 . ("Barbro" "Barbara" "Boris"))
                                 (5 . ("Sven" "Svend" "Svenning"))
                                 (6 . ("Nikolaus" "Niklas" "Nikolina"))
                                 (7 . ("Agaton" "Angela" "Angelika"))
                                 (8 . ("Virginia" "Vera" "Vesta"))
                                 (9 . ("Anna" "Ann" "Annie"))
                                 (10 . ("Malin" "Majvor" "Malena"))
                                 (11 . ("Daniel" "Dan" "Daniela"))
                                 (12 . ("Alexander" "Pia" "Pierre"))
                                 (13 . ("Lucia" "Lisen" "Lisette"))
                                 (14 . ("Sten" "Stina" "Sture"))
                                 (15 . ("Gottfrid" "Kaj" "Kajsa"))
                                 (16 . ("Assar" "Odd" "Osvald"))
                                 (17 . ("Inge" "Ilona" "Irmeli"))
                                 (18 . ("Abraham" "Abdon" "Gideon"))
                                 (19 . ("Isak" "Isidor" "Isidora"))
                                 (20 . ("Israel" "Gina" "Gitte"))
                                 (21 . ("Tomas" "Tom" "Tommy"))
                                 (22 . ("Natanael" "Natalia" "Natan"))
                                 (23 . ("Adam" "Ada" "Adina"))
                                 (24 . ("Eva" "Evita" "Evy"))
                                 (25 . ())
                                 (26 . ("Stefan" "Staffan" "Stefanie"))
                                 (27 . ("Johannes" "Hannes" "Johan"))
                                 (28 . ())
                                 (29 . ("Abel" "Abbe"))
                                 (30 . ("Set" "Viva" "Vivan"))
                                 (31 . ("Sylvester" "Sylve" "Sylvi"))
                                 ))))

(lyskom-define-namedays 'sv-1993
                        "Sverige, 1993 rs namnlngd"
                        "\
Namnsdagar enligt namnlngd frn 1993, med uppenbara helgdagar borttagna."
                        '((1 . (
                                (1 . (""))
                                (2 . ("Svea" "Sverker"))
                                (3 . ("Alfred" "Alfrida"))
                                (4 . ("Rut" "Ritva"))
                                (5 . ("Hanna" "Hannele"))
                                (6 . ("Baltsar" "Kasper"))
                                (7 . ("August" "Augusta"))
                                (8 . ("Erland" "Erhard"))
                                (9 . ("Gunnar" "Gunder"))
                                (10 . ("Sigurd" "Sigmund"))
                                (11 . ("Hugo" "Hagar"))
                                (12 . ("Frideborg" "Fridolf"))
                                (13 . ("Knut"))
                                (14 . ("Felix" "Felicia"))
                                (15 . ("Laura" "Liv"))
                                (16 . ("Hjalmar" "Hervor"))
                                (17 . ("Anton" "Tony"))
                                (18 . ("Hilda" "Hildur"))
                                (19 . ("Henrik" "Henry"))
                                (20 . ("Fabian" "Sebastian"))
                                (21 . ("Agnes" "Agneta"))
                                (22 . ("Vincent" "Veine"))
                                (23 . ("Emilia" "Emilie"))
                                (24 . ("Erika" "Eira"))
                                (25 . ("Paul" "Pl"))
                                (26 . ("Bodil" "Boel"))
                                (27 . ("Gte" "Gta"))
                                (28 . ("Karl" "Karla"))
                                (29 . ("Valter" "Vilma"))
                                (30 . ("Gunhild" "Gunilla"))
                                (31 . ("Ivar" "Joar"))
                                ))
                          (2 . (
                                (1 . ("Max" "Magda"))
                                (2 . ("Marja" "Mia"))
                                (3 . ("Disa" "Hjrdis"))
                                (4 . ("Ansgar" "Anselm"))
                                (5 . ("Lisa" "Elise"))
                                (6 . ("Dorotea" "Dora"))
                                (7 . ("Rikard" "Dick"))
                                (8 . ("Berta" "Berthold"))
                                (9 . ("Fanny" "Betty"))
                                (10 . ("Egon" "Egil"))
                                (11 . ("Yngve" "Ingolf"))
                                (12 . ("Evelina" "Evy"))
                                (13 . ("Agne" "Agnar"))
                                (14 . ("Valentin" "Tina"))
                                (15 . ("Sigfrid" "Sigbritt"))
                                (16 . ("Julia" "Jill"))
                                (17 . ("Alexandra" "Sandra"))
                                (18 . ("Frida" "Fritz"))
                                (19 . ("Gabriella" "Ella"))
                                (20 . ("Rasmus" "Ruben"))
                                (21 . ("Hilding" "Hulda"))
                                (22 . ("Marina" "Marlene"))
                                (23 . ("Torsten" "Torun"))
                                (24 . ("Mattias" "Mats"))
                                (25 . ("Sigvard" "Sivert"))
                                (26 . ("Torgny" "Torkel"))
                                (27 . ("Lage" "Laila"))
                                (28 . ("Maria" "Maja"))
                                ))
                          (3 . (
                                (1 . ("Albin" "Inez"))
                                (2 . ("Ernst" "Erna"))
                                (3 . ("Gunborg" "Gunvor"))
                                (4 . ("Adrian" "Ada"))
                                (5 . ("Tora" "Tor"))
                                (6 . ("Ebba" "Ebbe"))
                                (7 . ("Isidor" "Doris"))
                                (8 . ("Siv" "Saga"))
                                (9 . ("Torbjrn" "Ambjrn"))
                                (10 . ("Edla" "Ethel"))
                                (11 . ("Edvin" "Elon"))
                                (12 . ("Viktoria" "Viktor"))
                                (13 . ("Greger" "Iris"))
                                (14 . ("Matilda" "Maud"))
                                (15 . ("Kristofer" "Christel"))
                                (16 . ("Herbert" "Gilbert"))
                                (17 . ("Gertrud" "Grel"))
                                (18 . ("Edvard" "Eddie"))
                                (19 . ("Josef" "Josefina"))
                                (20 . ("Joakim" "Kim"))
                                (21 . ("Bengt" "Benny"))
                                (22 . ("Viking" "Vilgot"))
                                (23 . ("Gerda" "Gerd"))
                                (24 . ("Gabriel" "Rafael"))
                                (25 . ("Mary" "Marion"))
                                (26 . ("Emanuel" "Manne"))
                                (27 . ("Ralf" "Raymond"))
                                (28 . ("Elma" "Elmer"))
                                (29 . ("Jonas" "Jens"))
                                (30 . ("Holger" "Reidar"))
                                (31 . ("Ester" "Estrid"))
                                ))
                          (4 . (
                                (1 . ("Harald" "Halvar"))
                                (2 . ("Gunnel" "Gun"))
                                (3 . ("Ferdinand" "Florence"))
                                (4 . ("Irene" "Irja"))
                                (5 . ("Nanna" "Nanny"))
                                (6 . ("Vilhelm" "Willy"))
                                (7 . ("Irma" "Mimmi"))
                                (8 . ("Vanja" "Ronja"))
                                (9 . ("Otto" "Ottilia"))
                                (10 . ("Ingvar" "Ingvor"))
                                (11 . ("Ulf" "Ylva"))
                                (12 . ("Julius" "Gillis"))
                                (13 . ("Artur" "Douglas"))
                                (14 . ("Tiburtius" "Tim"))
                                (15 . ("Olivia" "Oliver"))
                                (16 . ("Patrik" "Patricia"))
                                (17 . ("Elias" "Elis"))
                                (18 . ("Valdemar" "Volmar"))
                                (19 . ("Olaus" "Ola"))
                                (20 . ("Amalia" "Amelie"))
                                (21 . ("Annika" "Anneli"))
                                (22 . ("Allan" "Alida"))
                                (23 . ("Georg" "Gran"))
                                (24 . ("Vega" "Viveka"))
                                (25 . ("Markus" "Mark"))
                                (26 . ("Teresia" "Terese"))
                                (27 . ("Engelbrekt" "Enok"))
                                (28 . ("Ture" "Tyko"))
                                (29 . ("Kennet" "Kent"))
                                (30 . ("Mariana" "Marianne"))
                                ))
                          (5 . (
                                (1 . ("Valborg" "Maj"))
                                (2 . ("Filip" "Filippa"))
                                (3 . ("John" "Jack"))
                                (4 . ("Monika" "Mona"))
                                (5 . ("Vivianne" "Vivan"))
                                (6 . ("Marit" "Rita"))
                                (7 . ("Lilian" "Lilly"))
                                (8 . ("ke" "Ove"))
                                (9 . ("Jonatan" "Gideon"))
                                (10 . ("Elvira" "Elvy"))
                                (11 . ("Mrta" "Mrit"))
                                (12 . ("Charlotta" "Lotta"))
                                (13 . ("Linnea" "Nina"))
                                (14 . ("Lillemor" "Lill"))
                                (15 . ("Sofia" "Sonja"))
                                (16 . ("Hilma" "Hilmer"))
                                (17 . ("Nore" "Nora"))
                                (18 . ("Erik" "Jerker"))
                                (19 . ("Majken" "Majvor"))
                                (20 . ("Karolina" "Lina"))
                                (21 . ("Konstantin" "Conny"))
                                (22 . ("Henning" "Hemming"))
                                (23 . ("Desiree" "Renee"))
                                (24 . ("Ivan" "Yvonne"))
                                (25 . ("Urban" "Ursula"))
                                (26 . ("Vilhelmina" "Helmy"))
                                (27 . ("Blenda" "Beda"))
                                (28 . ("Ingeborg" "Borghild"))
                                (29 . ("Jean" "Jeanette"))
                                (30 . ("Fritiof" "Frej"))
                                (31 . ("Isabella" "Isa"))
                                ))
                          (6 . (
                                (1 . ("Rune" "Runa"))
                                (2 . ("Rutger" "Roger"))
                                (3 . ("Ingemar" "Gudmar"))
                                (4 . ("Solveig" "Solbritt"))
                                (5 . ("Bo" "Boris"))
                                (6 . ("Gustav" "Gsta"))
                                (7 . ("Robert" "Robin"))
                                (8 . ("Eivor" "Elaine"))
                                (9 . ("Petra" "Petronella"))
                                (10 . ("Kerstin" "Karsten"))
                                (11 . ("Bertil" "Berit"))
                                (12 . ("Eskil" "Esbjrn"))
                                (13 . ("Aina" "Eila"))
                                (14 . ("Hkan" "Heidi"))
                                (15 . ("Margit" "Mait"))
                                (16 . ("Axel" "Axelina"))
                                (17 . ("Torborg" "Torvald"))
                                (18 . ("Bjrn" "Bjarne"))
                                (19 . ("Germund" "Jerry"))
                                (20 . ("Linda" "Linn"))
                                (21 . ("Alf" "Alva"))
                                (22 . ("Paulina" "Paula"))
                                (23 . ("Adolf" "Adela"))
                                (24 . ("Johan" "Jan"))
                                (25 . ("David" "Salomon"))
                                (26 . ("Gunni" "Jim"))
                                (27 . ("Selma" "Herta"))
                                (28 . ("Leo" "Leopold"))
                                (29 . ("Petrus" "Peter"))
                                (30 . ("Elof" "Leif"))
                                ))
                          (7 . (
                                (1 . ("Aron" "Mirjam"))
                                (2 . ("Rosa" "Rosita"))
                                (3 . ("Aurora" "Adina"))
                                (4 . ("Ulrika" "Ulla"))
                                (5 . ("Melker" "Agaton"))
                                (6 . ("Ronald" "Ronny"))
                                (7 . ("Klas" "Kaj"))
                                (8 . ("Kjell" "Tjelvar"))
                                (9 . ("Jrgen" "rjan"))
                                (10 . ("Anund" "Gunda"))
                                (11 . ("Eleonora" "Ellinor"))
                                (12 . ("Herman" "Hermine"))
                                (13 . ("Joel" "Judit"))
                                (14 . ("Folke" "Odd"))
                                (15 . ("Ragnhild" "Ragnvald"))
                                (16 . ("Reinhold" "Reine"))
                                (17 . ("Alexis" "Alice"))
                                (18 . ("Fredrik" "Fred"))
                                (19 . ("Sara" "Sally"))
                                (20 . ("Margareta" "Greta"))
                                (21 . ("Johanna" "Jane"))
                                (22 . ("Magdalena" "Madeleine"))
                                (23 . ("Emma" "Emmy"))
                                (24 . ("Kristina" "Stina"))
                                (25 . ("Jakob" "James"))
                                (26 . ("Jesper" "Jessika"))
                                (27 . ("Marta" "Moa"))
                                (28 . ("Botvid" "Seved"))
                                (29 . ("Olof" "Olle"))
                                (30 . ("Algot" "Margot"))
                                (31 . ("Elin" "Elna"))
                                ))
                          (8 . (
                                (1 . ("Per" "Pernilla"))
                                (2 . ("Karin" "Kajsa"))
                                (3 . ("Tage" "Tanja"))
                                (4 . ("Arne" "Arnold"))
                                (5 . ("Ulrik" "Alrik"))
                                (6 . ("Sixten" "Slve"))
                                (7 . ("Dennis" "Donald"))
                                (8 . ("Silvia" "Sylvia"))
                                (9 . ("Roland" "Roine"))
                                (10 . ("Lars" "Lorentz"))
                                (11 . ("Susanna" "Sanna"))
                                (12 . ("Klara" "Clary"))
                                (13 . ("Hillevi" "Gullvi"))
                                (14 . ("William" "Bill"))
                                (15 . ("Stella" "Stellan"))
                                (16 . ("Brynolf" "Sigyn"))
                                (17 . ("Verner" "Veronika"))
                                (18 . ("Helena" "Lena"))
                                (19 . ("Magnus" "Mns"))
                                (20 . ("Bernhard" "Bernt"))
                                (21 . ("Jon" "Jonna"))
                                (22 . ("Henrietta" "Henny"))
                                (23 . ("Signe" "Signhild"))
                                (24 . ("Bartolomeus" "Bert"))
                                (25 . ("Lovisa" "Louise"))
                                (26 . ("sten" "Ejvind"))
                                (27 . ("Rolf" "Rudolf"))
                                (28 . ("Gurli" "Gull"))
                                (29 . ("Hans" "Hampus"))
                                (30 . ("Albert" "Albertina"))
                                (31 . ("Arvid" "Vidar"))
                                ))
                          (9 . (
                                (1 . ("Samuel" "Sam"))
                                (2 . ("Justus" "Justina"))
                                (3 . ("Alfhild" "Alfons"))
                                (4 . ("Gisela" "Glenn"))
                                (5 . ("Harry" "Harriet"))
                                (6 . ("Sakarias" "Esaias"))
                                (7 . ("Regina" "Roy"))
                                (8 . ("Alma" "Ally"))
                                (9 . ("Anita" "Anja"))
                                (10 . ("Tord" "Tove"))
                                (11 . ("Dagny" "Daniela"))
                                (12 . ("Tyra" "sa"))
                                (13 . ("Sture" "Styrbjrn"))
                                (14 . ("Ida" "Ellida"))
                                (15 . ("Sigrid" "Siri"))
                                (16 . ("Dag" "Daga"))
                                (17 . ("Hildegard" "Magnhild"))
                                (18 . ("Alvar" "Orvar"))
                                (19 . ("Fredrika" "Carita"))
                                (20 . ("Agda" "Agata"))
                                (21 . ("Ellen" "Elly"))
                                (22 . ("Maurits" "Morgan"))
                                (23 . ("Tekla" "Tea"))
                                (24 . ("Gerhard" "Gert"))
                                (25 . ("Kre" "Tryggve"))
                                (26 . ("Einar" "Enar"))
                                (27 . ("Dagmar" "Rigmor"))
                                (28 . ("Lennart" "Leonard"))
                                (29 . ("Mikael" "Mikaela"))
                                (30 . ("Helge" "Helny"))
                                ))
                          (10 . (
                                 (1 . ("Ragnar" "Ragna"))
                                 (2 . ("Ludvig" "Louis"))
                                 (3 . ("Evald" "Osvald"))
                                 (4 . ("Frans" "Frank"))
                                 (5 . ("Bror" "Bruno"))
                                 (6 . ("Jenny" "Jennifer"))
                                 (7 . ("Birgitta" "Britta"))
                                 (8 . ("Nils" "Nelly"))
                                 (9 . ("Ingrid" "Inger"))
                                 (10 . ("Helmer" "Hadar"))
                                 (11 . ("Erling" "Jarl"))
                                 (12 . ("Valfrid" "Ernfrid"))
                                 (13 . ("Birgit" "Britt"))
                                 (14 . ("Manfred" "Helfrid"))
                                 (15 . ("Hedvig" "Hedda"))
                                 (16 . ("Fingal" "Finn"))
                                 (17 . ("Antonia" "Annette"))
                                 (18 . ("Lukas" "Matteus"))
                                 (19 . ("Tore" "Torleif"))
                                 (20 . ("Sibylla" "Camilla"))
                                 (21 . ("Birger" "Brje"))
                                 (22 . ("Marika" "Marita"))
                                 (23 . ("Sren" "Severin"))
                                 (24 . ("Evert" "Eilert"))
                                 (25 . ("Inga" "Ingvald"))
                                 (26 . ("Amanda" "My"))
                                 (27 . ("Sabina" "Ina"))
                                 (28 . ("Simon" "Simone"))
                                 (29 . ("Viola" "Vivi"))
                                 (30 . ("Elsa" "Elsie"))
                                 (31 . ("Edit" "Edgar"))
                                 ))
                          (11 . (
                                 (1 . ("Andre" "Andrea"))
                                 (2 . ("Tobias" "Toini"))
                                 (3 . ("Hubert" "Diana"))
                                 (4 . ("Uno" "Unn"))
                                 (5 . ("Eugen" "Eugenia"))
                                 (6 . ("Gustav Adolf"))
                                 (7 . ("Ingegerd" "Ingela"))
                                 (8 . ("Vendela" "Vanda"))
                                 (9 . ("Teodor" "Ted"))
                                 (10 . ("Martin" "Martina"))
                                 (11 . ("Mrten"))
                                 (12 . ("Konrad" "Kurt"))
                                 (13 . ("Kristian" "Krister"))
                                 (14 . ("Emil" "Mildred"))
                                 (15 . ("Katja" "Nadja"))
                                 (16 . ("Edmund" "Gudmund"))
                                 (17 . ("Naemi" "Nancy"))
                                 (18 . ("Pierre" "Percy"))
                                 (19 . ("Elisabet" "Lisbeth"))
                                 (20 . ("Pontus" "Pia"))
                                 (21 . ("Helga" "Olga"))
                                 (22 . ("Cecilia" "Cornelia"))
                                 (23 . ("Klemens" "Clarence"))
                                 (24 . ("Gudrun" "Runar"))
                                 (25 . ("Katarina" "Carina"))
                                 (26 . ("Linus" "Love"))
                                 (27 . ("Astrid" "Asta"))
                                 (28 . ("Malte" "Malkolm"))
                                 (29 . ("Sune" "Synnve"))
                                 (30 . ("Anders" "Andreas"))
                                 ))
                          (12 . (
                                 (1 . ("Oskar" "Ossian"))
                                 (2 . ("Beata" "Beatrice"))
                                 (3 . ("Lydia" "Carola"))
                                 (4 . ("Barbro" "Barbara"))
                                 (5 . ("Sven" "Svante"))
                                 (6 . ("Nikolaus" "Niklas"))
                                 (7 . ("Angelika" "Angela"))
                                 (8 . ("Virginia" "Vera"))
                                 (9 . ("Anna" "Annie"))
                                 (10 . ("Malin" "Malena"))
                                 (11 . ("Daniel" "Dan"))
                                 (12 . ("Alexander" "Alex"))
                                 (13 . ("Lucia"))
                                 (14 . ("Sten" "Stig"))
                                 (15 . ("Gottfrid" "Gotthard"))
                                 (16 . ("Assar" "Astor"))
                                 (17 . ("Inge" "Ingemund"))
                                 (18 . ("Abraham" "Efraim"))
                                 (19 . ("Isak" "Rebecka"))
                                 (20 . ("Israel" "Moses"))
                                 (21 . ("Tomas" "Tom"))
                                 (22 . ("Natanael" "Natalia"))
                                 (23 . ("Adam"))
                                 (24 . ("Eva"))
                                 (25 . ())
                                 (26 . ("Stefan" "Staffan"))
                                 (27 . ("Johannes" "Hannes"))
                                 (28 . ("Rakel" "Benjamin"))
                                 (29 . ("Abel" "Set"))
                                 (30 . ("Gunlg" "slg"))
                                 (31 . ("Sylvester"))
                                 ))))



(lyskom-define-namedays 'fi
                        "Finska"
                        "\
Namnsdagar ur ngon finsk namnlngd. Eftersom utvecklarna inte
kan finska r beskrivningen p svenska, med frhoppningen att
ngon som kan finska kommer att reta sig p den och skriva om
texten p rtt sprk."
                        '((1 . ((1 . ())
                                (2 . ("Aapeli"))
                                (3 . ("Elmeri" "Elmer" "Elmo"))
                                (4 . ("Ruut"))
                                (5 . ("Lea" "Leea"))
                                (6 . ("Harri"))
                                (7 . ("Aukusti" "Aku" "August"))
                                (8 . ("Hilppa" "Titta"))
                                (9 . ("Veikko" "Veli" "Veijo"))
                                (10 . ("Nyyrikki"))
                                (11 . ("Kari" "Karri"))
                                (12 . ("Toini"))
                                (13 . ("Nuutti"))
                                (14 . ("Sakari" "Saku"))
                                (15 . ("Solja"))
                                (16 . ("Ilmari" "Ilmo"))
                                (17 . ("Toni" "Anttoni" "Antto" "Anton"))
                                (18 . ("Laura"))
                                (19 . ("Heikki" "Henrik" "Henrikki" "Henri"))
                                (20 . ("Henna" "Henni" "Henriikka"))
                                (21 . ("Aune" "Oona" "Auni"))
                                (22 . ("Visa"))
                                (23 . ("Eine" "Eini" "Enni"))
                                (24 . ("Senja"))
                                (25 . ("Paavo" "Pauli" "Paavali" "Paul"))
                                (26 . ("Joonatan"))
                                (27 . ("Viljo"))
                                (28 . ("Kaarlo" "Kalle" "Kaarle" "Mies"))
                                (29 . ("Valtteri"))
                                (30 . ("Irja"))
                                (31 . ("Alli"))
                                ))
                          (2 . (
                                (1 . ("Riitta"))
                                (2 . ("Aamu" "Jemina"))
                                (3 . ("Valo"))
                                (4 . ("Armi" "Ronja"))
                                (5 . ("Asser"))
                                (6 . ("Terhi" "Teija" "Tiia" "Tea" "Terhikki"))
                                (7 . ("Riku" "Rikhard"))
                                (8 . ("Laina"))
                                (9 . ("Raija" "Raisa"))
                                (10 . ("Elina" "Elna" "Ella" "Ellen"))
                                (11 . ("Talvikki"))
                                (12 . ("Elma" "Elmi"))
                                (13 . ("Sulo" "Sulho"))
                                (14 . ("Voitto" "Valentin" "Tino"))
                                (15 . ("Sipi" "Sippo"))
                                (16 . ("Kai"))
                                (17 . ("Vin" "Vonm"))
                                (18 . ("Kaino"))
                                (19 . ("Eija"))
                                (20 . ("Heli" "Helin" "Helj" "Hely"))
                                (21 . ("Keijo"))
                                (22 . ("Tuulikki" "Tuuli" "Tuulia"))
                                (23 . ("Aslak"))
                                (24 . ("Matti" "Matias"))
                                (25 . ("Tuija" "Tuire"))
                                (26 . ("Nestori"))
                                (27 . ("Torsti"))
                                (28 . ("Onni"))
                                ))
                          (3 . (
                                (1 . ("Alpo" "Alvi" "Alpi"))
                                (2 . ("Virve" "Virva"))
                                (3 . ("Kauko"))
                                (4 . ("Ari" "Arsi" "Atro"))
                                (5 . ("Laila" "Leila"))
                                (6 . ("Tarmo"))
                                (7 . ("Tarja" "Taru"))
                                (8 . ("Vilppu"))
                                (9 . ("Auvo"))
                                (10 . ("Aurora" "Aura" "Auri"))
                                (11 . ("Kalervo"))
                                (12 . ("Reijo" "Reko"))
                                (13 . ("Erno" "Tarvo" "Ernesti"))
                                (14 . ("Matilda" "Tilda"))
                                (15 . ("Risto"))
                                (16 . ("Ilkka"))
                                (17 . ("Kerttu" "Kerttuli"))
                                (18 . ("Eetu" "Edvard"))
                                (19 . ("Jooseppi" "Juuso" "Joosef" "Josefiina"))
                                (20 . ("Aki" "Joakim" "Kim" "Jaakkima"))
                                (21 . ("Pentti"))
                                (22 . ("Vihtori"))
                                (23 . ("Akseli"))
                                (24 . ("Kaapo" "Gabriel" "Kaapro" "Kaappo"))
                                (25 . ("Aija"))
                                (26 . ("Manu" "Immanuel" "Manne" "Immo"))
                                (27 . ("Sauli" "Saul"))
                                (28 . ("Armas"))
                                (29 . ("Joonas" "Jouni" "Joni" "Joonas" "Jonne" "Jonni"))
                                (30 . ("Usko"))
                                (31 . ("Irma" "Irmeli"))
                                ))
                          (4 . (
                                (1 . ("Raita" "Pulmu"))
                                (2 . ("Pellervo"))
                                (3 . ("Sampo"))
                                (4 . ("Ukko"))
                                (5 . ("Irene" "Irina" "Ira" "Iro"))
                                (6 . ("Vilho" "Ville" "Viljami" "Vilhelm" "Vili" "Jami"))
                                (7 . ("Allan" "Ahvo"))
                                (8 . ("Suoma" "Suometar"))
                                (9 . ("Elias" "Eelis" "Eljas"))
                                (10 . ("Tero"))
                                (11 . ("Verna"))
                                (12 . ("Julius" "Julia" "Juliaana"))
                                (13 . ("Tellervo"))
                                (14 . ("Taito"))
                                (15 . ("Lina" "Tuomi"))
                                (16 . ("Jalo" "Patrik"))
                                (17 . ("Otto"))
                                (18 . ("Valto" "Valdemar"))
                                (19 . ("Plvi" "Pilvi"))
                                (20 . ("Lauha"))
                                (21 . ("Anssi" "Anselmi"))
                                (22 . ("Alina"))
                                (23 . ("Yrj" "Jyrki" "Jyri" "Yrjn" "Jori"))
                                (24 . ("Pertti" "Albert" "Altti"))
                                (25 . ("Markku" "Markus" "Marko"))
                                (26 . ("Terttu" "Teresa"))
                                (27 . ("Merja"))
                                (28 . ("Ilpo" "Ilppo" "Tuure"))
                                (29 . ("Teijo"))
                                (30 . ("Mirja" "Mirva" "Mira" "Miia" "Mirjami" "Mirka" "Mirkka"))
                                ))
                          (5 . (
                                (1 . ("Vappu" "Valpuri"))
                                (2 . ("Vuokko" "Viivi"))
                                (3 . ("Outi"))
                                (4 . ("Ruusu" "Roosa"))
                                (5 . ("Maini"))
                                (6 . ("Ylermi"))
                                (7 . ("Helmi" "Kastehelmi"))
                                (8 . ("Heino"))
                                (9 . ("Timo"))
                                (10 . ("Aino" "Aina" "Ainikki"))
                                (11 . ("Osmo"))
                                (12 . ("Liotta"))
                                (13 . ("Kukka" "Floora"))
                                (14 . ("Tuula"))
                                (15 . ("Sofia" "Sinja" "Sohvi"))
                                (16 . ("Esteri" "Essi" "Ester"))
                                (17 . ("Maila" "Maili" "Mailis" "Rebekka"))
                                (18 . ("Erkki" "Eero" "Eerikki" "Eerika"))
                                (19 . ("Emilia" "Emma" "Emmi" "Milla" "Milja" "Milka" "Amalia"))
                                (20 . ("Lilja" "Karoliina" "Lilli"))
                                (21 . ("Kosti" "Konsta" "Konstantin"))
                                (22 . ("Hemmikki" "Hemmo"))
                                (23 . ("Lyydia" "Lyyli"))
                                (24 . ("Tuukka" "Tuoko"))
                                (25 . ("Urpo"))
                                (26 . ("Vilhelmiina" "Minna" "Vilma" "Miina" "Mimmi"))
                                (27 . ("Ritva"))
                                (28 . ("Alma"))
                                (29 . ("Oiva" "Oivi" "Olivia"))
                                (30 . ("Pasi"))
                                (31 . ("Helka" "Helga"))
                                ))
                          (6 . (
                                (1 . ("Teemu" "Nikodemus"))
                                (2 . ("Venla"))
                                (3 . ("Orvokki" "Viola"))
                                (4 . ("Toivo"))
                                (5 . ("Sulevi"))
                                (6 . ("Kustaa" "Kysti" "Kustavi"))
                                (7 . ("Suvi" "Robert" "Roope"))
                                (8 . ("Salomo" "Salomon"))
                                (9 . ("Ensio"))
                                (10 . ("Seppo"))
                                (11 . ("Impi" "Immi"))
                                (12 . ("Esko"))
                                (13 . ("Raili" "Raila"))
                                (14 . ("Kielo"))
                                (15 . ("Vieno" "Viena"))
                                (16 . ("Pivi" "Pivikki" "Piv"))
                                (17 . ("Urho"))
                                (18 . ("Tapio"))
                                (19 . ("Siiri"))
                                (20 . ("Into"))
                                (21 . ("Ahti" "Ahto"))
                                (22 . ("PaulaLiina" "Pauliina"))
                                (23 . ("Aatto" "Aatu" "Aadolf"))
                                (24 . ("Johannes" "Juhani" "Juha" "Juho" "Jukka" "Jussi" "Janne" "Jani" "Juhana"))
                                (25 . ("Uuno"))
                                (26 . ("Jorm" "Jarmo" "Jarkko" "Jarno" "Jere" "Jeremias"))
                                (27 . ("Elviira" "Elvi"))
                                (28 . ("Leo"))
                                (29 . ("Pietari" "Pekka" "Petri" "Petra" "Petteri" "Pekko"))
                                (30 . ("Pivi" "Piv"))
                                ))
                          (7 . (
                                (1 . ("Aaro" "Aaron"))
                                (2 . ("Maria" "Mari" "Maija" "Meeri" "Maaria" "Marika" "Maiju" "Maikki" "Kukka-Maaria"))
                                (3 . ("Arvo"))
                                (4 . ("Ulla" "Ulpu"))
                                (5 . ("Unto" "Untamo"))
                                (6 . ("Esa" "Esaias"))
                                (7 . ("Klaus" "Launo"))
                                (8 . ("Turo" "Turkka"))
                                (9 . ("Ilta" "Jasmin"))
                                (10 . ("Saima" "Saimi"))
                                (11 . ("Elli" "Noora" "Nelli" "Eleonoora"))
                                (12 . ("Hermanni" "Herkko" "Herman"))
                                (13 . ("Ilari" "Lari" "Joel"))
                                (14 . ("Aliisa"))
                                (15 . ("Rauni" "Rauna"))
                                (16 . ("Reino"))
                                (17 . ("Ossi" "Ossian"))
                                (18 . ("Riikka"))
                                (19 . ("Saara" "Sari" "Salli" "Salla" "Sara"))
                                (20 . ("Marketta" "Maarit" "Reeta" "Maaret" "Reetta" "Margareeta"))
                                (21 . ("Johanna" "Hanna" "Hanne" "Jenni" "Jonna" "Jenna" "Hannele" "Joanna"))
                                (22 . ("Leena" "Leeni" "Lenita" "Matleena"))
                                (23 . ("Oili" "Olga"))
                                (24 . ("Kristiina" "Kirsti" "Tiina" "Kirsi" "Kiia"))
                                (25 . ("Jaakko" "Jaakoppi" "Jaakob"))
                                (26 . ("Martta"))
                                (27 . ("Heidi"))
                                (28 . ("Atso"))
                                (29 . ("Olavi" "Olli" "Uolevi" "Uoti"))
                                (30 . ("Asta"))
                                (31 . ("Helena" "Elena"))
                                ))
                          (8 . (
                                (1 . ("Maire"))
                                (2 . ("Kimmo"))
                                (3 . ("Linnea" "Nea" "Vanamo"))
                                (4 . ("Veera"))
                                (5 . ("Salme" "Sanelma"))
                                (6 . ("Toimi" "Keimo"))
                                (7 . ("Lahja"))
                                (8 . ("Sylvi" "Sylvia" "Silva"))
                                (9 . ("Erja" "Eira"))
                                (10 . ("Lauri" "Lasse" "Lassi"))
                                (11 . ("Sanna" "Sanni" "Susanna" "Susanne"))
                                (12 . ("Klaara"))
                                (13 . ("Jesse"))
                                (14 . ("Onerva" "Kanerva"))
                                (15 . ("Marjatta" "Marja" "Jaana" "Marjo" "Marjut" "Marjaana" "Marjukka" "Marita" "Maritta" "Marianne" "Marianna"))
                                (16 . ("Aulis"))
                                (17 . ("Verneri"))
                                (18 . ("Leevi"))
                                (19 . ("Mauno" "Maunu"))
                                (20 . ("Samuli" "Sami" "Samuel" "Samu"))
                                (21 . ("Soini" "Veini"))
                                (22 . ("Iivari" "Iivo"))
                                (23 . ("Varma" "Signe"))
                                (24 . ("Perttu"))
                                (25 . ("Loviisa"))
                                (26 . ("Ilma" "Ilmi" "Ilmatar"))
                                (27 . ("Rauli"))
                                (28 . ("Tauno"))
                                (29 . ("Iines" "Iina" "Iinari"))
                                (30 . ("Eemil" "Eemeli"))
                                (31 . ("Arvi"))
                                ))
                          (9 . (
                                (1 . ("Pirkka"))
                                (2 . ("Sinikka" "Sini"))
                                (3 . ("Soili" "Soile" "Soila"))
                                (4 . ("Ansa"))
                                (5 . ("Roni" "Mainio"))
                                (6 . ("Asko"))
                                (7 . ("Miro" "Arho" "Arhippa"))
                                (8 . ("Taimi"))
                                (9 . ("Eevert" "Isto"))
                                (10 . ("Kalevi" "Kaleva"))
                                (11 . ("Aleksanteri" "Ali" "Ale" "Aleksandra"))
                                (12 . ("Valma" "Vilja"))
                                (13 . ("Orvo"))
                                (14 . ("Iida"))
                                (15 . ("Sirpa"))
                                (16 . ("Hellevi" "Hillevi" "Hille" "Hilla"))
                                (17 . ("Aili" "Aila"))
                                (18 . ("Tyyne" "Tytti" "Tyyni"))
                                (19 . ("Reija"))
                                (20 . ("Varpu" "Vaula"))
                                (21 . ("Mervi"))
                                (22 . ("Mauri"))
                                (23 . ("Mielikki"))
                                (24 . ("Alvar" "Auno"))
                                (25 . ("Kullervo"))
                                (26 . ("Kuisma"))
                                (27 . ("Vesa"))
                                (28 . ("Arja"))
                                (29 . ("Mikael" "Mikko" "Miika" "Miikka" "Miska" "Mikaela"))
                                (30 . ("Sorja" "Sirja"))
                                ))
                          (10 . (
                                 (1 . ("Rauno" "Rainer" "Raine" "Raino"))
                                 (2 . ("Valio"))
                                 (3 . ("Raimo"))
                                 (4 . ("Saila" "Saija"))
                                 (5 . ("Inkeri" "Inka"))
                                 (6 . ("Minttu" "Pinja"))
                                 (7 . ("Pirkko" "Pirjo" "Piritta" "Pirita" "Birgitta"))
                                 (8 . ("Hilja"))
                                 (9 . ("Ilona"))
                                 (10 . ("Aleksi" "Aleksis"))
                                 (11 . ("Otso" "Ohto"))
                                 (12 . ("Aarre" "Aarto"))
                                 (13 . ("Taina" "Tanja" "Taija"))
                                 (14 . ("Elsa" "Else" "Elsi"))
                                 (15 . ("Helvi" "Heta"))
                                 (16 . ("Sirkka" "Sirkku"))
                                 (17 . ("Saini" "Saana"))
                                 (18 . ("Satu" "Sde"))
                                 (19 . ("Uljas"))
                                 (20 . ("Kauno" "Kasperi"))
                                 (21 . ("Ursula"))
                                 (22 . ("Anja" "Anita" "Anniina" "Anitta"))
                                 (23 . ("Severi"))
                                 (24 . ("Asmo" "Rasmus"))
                                 (25 . ("Sointu"))
                                 (26 . ("Amanda" "Niina" "Manta"))
                                 (27 . ("Helli" "Hell" "Hellin" "Helle"))
                                 (28 . ("Simo"))
                                 (29 . ("Alfred" "Urmas"))
                                 (30 . ("Eila"))
                                 (31 . ("Artturi" "Arto" "Arttu"))
                                 ))
                          (11 . (
                                 (1 . ("Pyry" "Lyly"))
                                 (2 . ("Topi" "Topias"))
                                 (3 . ("Terho"))
                                 (4 . ("Hertta"))
                                 (5 . ("Reima"))
                                 (6 . ("Kustaa Aadolf"))
                                 (7 . ("Taisto"))
                                 (8 . ("Aatos"))
                                 (9 . ("Teuvo"))
                                 (10 . ("Martti"))
                                 (11 . ("Panu"))
                                 (12 . ("Virpi"))
                                 (13 . ("Ano" "Kristian"))
                                 (14 . ("Iiris"))
                                 (15 . ("Janika" "Janita" "Janina" "Janette"))
                                 (16 . ("Aarne" "Aarno" "Aarni"))
                                 (17 . ("Eino" "Einari"))
                                 (18 . ("Tenho" "Jousia"))
                                 (19 . ("Elisabet" "Liisa" "Eliisa" "Elisa" "Elise" "Liisi"))
                                 (20 . ("Jalmari" "Jari"))
                                 (21 . ("Hilma"))
                                 (22 . ("Silja" "Selja"))
                                 (23 . ("Ismo"))
                                 (24 . ("Lempi" "Lemmikki" "Sivi"))
                                 (25 . ("Katri" "Kaisa" "Kaija" "Katja" "Kaarina" "Katariina" "Katriina" "Kati" "Kaisu" "Riina"))
                                 (26 . ("Sisko"))
                                 (27 . ("Hilkka"))
                                 (28 . ("Heini"))
                                 (29 . ("Aimo"))
                                 (30 . ("Antti" "Antero" "Atte"))
                                 ))
                          (12 . (
                                 (1 . ("Oskari"))
                                 (2 . ("Anelma" "Unelma"))
                                 (3 . ("Vellamo" "Meri"))
                                 (4 . ("Airi" "Aira"))
                                 (5 . ("Selma"))
                                 (6 . ("Niilo" "Nikolai" "Niko" "Niklas"))
                                 (7 . ("Sampsa"))
                                 (8 . ("Kyllikki" "Kylli"))
                                 (9 . ("Anna" "Anne" "Anni" "Anu" "Annikki" "Anneli" "Annukka" "Annika"))
                                 (10 . ("Jutta"))
                                 (11 . ("Taneli" "Tatu" "Daniel"))
                                 (12 . ("Tuovi"))
                                 (13 . ("Seija"))
                                 (14 . ("Jouko"))
                                 (15 . ("Heimo"))
                                 (16 . ("Auli" "Aulikki" "Aada"))
                                 (17 . ("Raakel"))
                                 (18 . ("Aapo" "Aappo" "Rami"))
                                 (19 . ("Iikka" "Iiro" "Iisakki" "Isko"))
                                 (20 . ("Benjamin" "Kerkko"))
                                 (21 . ("Tuomas" "Tuomo" "Tommi" "Tomi"))
                                 (22 . ("Raafael"))
                                 (23 . ("Senni"))
                                 (24 . ("Aatami" "Eeva" "Eevi" "Eveliina"))
                                 (25 . ())
                                 (26 . ("Tapani" "Teppo" "Tahvo"))
                                 (27 . ("Hannu" "Hannes"))
                                 (28 . ("Piia"))
                                 (29 . ("Rauha"))
                                 (30 . ("Daavid" "Taavetti" "Taavi"))
                                 (31 . ("Sylvester" "Silvo"))
                                 ))))

(lyskom-define-namedays 'fi-sv
                        "Finlandssvenska"
                        "\
Namnsdagar enligt ngon finlandssvensk namnlngd."
                        '((1 . ((1 . ())
                                (2 . ("Gehard" "Gert"))
                                (3 . ("Elmer" "Helmer"))
                                (4 . ("Rut"))
                                (5 . ("Lea"))
                                (6 . ("Harry" "Harriet"))
                                (7 . ("August" "Augusta"))
                                (8 . ("Gunnar"))
                                (9 . ("Bror"))
                                (10 . ("Sigurd"))
                                (11 . ("Osvald"))
                                (12 . ("Eivor"))
                                (13 . ("Knut"))
                                (14 . ("Zacharias"))
                                (15 . ("Doris"))
                                (16 . ("Gudmund" "Germund"))
                                (17 . ("Anton" "Tony" "Antonia"))
                                (18 . ("Laura"))
                                (19 . ("Henrik" "Henry" "Henrika" "Henrietta"))
                                (20 . ("Sebastian" "Fabian"))
                                (21 . ("Agnes" "Agneta"))
                                (22 . ("Fridolf"))
                                (23 . ("Ingegerd" "Ingela"))
                                (24 . ("Jarl"))
                                (25 . ("Paul"))
                                (26 . ("Jonatan"))
                                (27 . ("Folke"))
                                (28 . ("Karl" "Carola"))
                                (29 . ("Valter" "Volter"))
                                (30 . ("Gunnel" "Gunilla"))
                                (31 . ("Alfhild" "Alfa"))
                                ))
                          (2 . (
                                (1 . ("Berit"))
                                (2 . ("Disa"))
                                (3 . ("Hugo"))
                                (4 . ("My" "Ronja"))
                                (5 . ("Sture"))
                                (6 . ("Dorotea" "Dora" "Tea" "Dorrit"))
                                (7 . ("Rikard" "Dick"))
                                (8 . ("Rigmor"))
                                (9 . ("Bodil"))
                                (10 . ("Elin" "Ellen" "Ella" "Elna"))
                                (11 . ("Isabella" "Isa"))
                                (12 . ("Elma"))
                                (13 . ("Algot"))
                                (14 . ("Valenton"))
                                (15 . ("Sigfrid"))
                                (16 . ("Kaj"))
                                (17 . ("Carita" "Rita"))
                                (18 . ("Tyra"))
                                (19 . ("Fritjof"))
                                (20 . ("Ragnborg"))
                                (21 . ("Alf" "Alva"))
                                (22 . ("Hildur" "Hilda"))
                                (23 . ("Bjarne"))
                                (24 . ("Mattias" "Mats"))
                                (25 . ("Jessica"))
                                (26 . ("Ingvar" "Ingvald"))
                                (27 . ("Torsten"))
                                (28 . ("Rune" "Runa"))
                                ))
                          (3 . (
                                (1 . ("Albin"))
                                (2 . ("Fanny"))
                                (3 . ("Torbjrn"))
                                (4 . ("Adrian" "Atle"))
                                (5 . ("Laila" "Leila"))
                                (6 . ("Rudolf" "Rolf"))
                                (7 . ("Gudrun"))
                                (8 . ("Filip" "Filippa"))
                                (9 . ("Edvin"))
                                (10 . ("Aurora"))
                                (11 . ("Torgny" "Torkel"))
                                (12 . ("Gregorius" "Greger" "Grels"))
                                (13 . ("Ernst"))
                                (14 . ("Matilda"))
                                (15 . ("Kristoffer"))
                                (16 . ("Herbert"))
                                (17 . ("Gertrud" "Trude"))
                                (18 . ("Edvard"))
                                (19 . ("Josef" "Josefina"))
                                (20 . ("Joakim" "Kim"))
                                (21 . ("Bengt" "Bengta" "Benita"))
                                (22 . ("Viktor" "Viktoria"))
                                (23 . ("Axel"))
                                (24 . ("Gabriel" "Gabriella"))
                                (25 . ("Gunvor" "Gunnevi"))
                                (26 . ("Emanuel" "Immanuel" "Manne"))
                                (27 . ("Torvald"))
                                (28 . ("Sune"))
                                (29 . ("Jonas"))
                                (30 . ("Tage" "Guy"))
                                (31 . ("Irma" "Irmelin"))
                                ))
                          (4 . (
                                (1 . ("Harald"))
                                (2 . ("Vidar"))
                                (3 . ("Ferdinand"))
                                (4 . ("Odin"))
                                (5 . ("Irene"))
                                (6 . ("Vilhelm" "William"))
                                (7 . ("Allan"))
                                (8 . ("Rea"))
                                (9 . ("Elias" "Elis" "Eliel"))
                                (10 . ("Tryggve"))
                                (11 . ("Verna"))
                                (12 . ("Julius" "Julia" "Juliana"))
                                (13 . ("Etel"))
                                (14 . ("Ruben"))
                                (15 . ("Linda" "Linn"))
                                (16 . ("Patrik" "Patricia"))
                                (17 . ("Otto"))
                                (18 . ("Valdemar" "Volmar"))
                                (19 . ("Bernhard" "Bernt"))
                                (20 . ("Arla"))
                                (21 . ("Camilla"))
                                (22 . ("Alina"))
                                (23 . ("Georg" "Gran" "rjan" "Jran" "Jrgen" "Jrn"))
                                (24 . ("Albert" "Albertina"))
                                (25 . ("Markus"))
                                (26 . ("Teresia" "Teresa" "Terese"))
                                (27 . ("Engelbrekt" "Engelbert"))
                                (28 . ("Ture"))
                                (29 . ("Henning"))
                                (30 . ("Mirjam" "Mia"))
                                ))
                          (5 . (
                                (1 . ("Valborg"))
                                (2 . ("Vivan" "Vivi"))
                                (3 . ("Linus"))
                                (4 . ("Rosa"))
                                (5 . ("Ulrik"))
                                (6 . ("Frej" "Frejvid" "Freja"))
                                (7 . ("Tua"))
                                (8 . ("ke"))
                                (9 . ("Dennis"))
                                (10 . ("Aina" "Aino"))
                                (11 . ("Kennet" "Kent"))
                                (12 . ("Charlotta" "Lotta" "Lotten"))
                                (13 . ("Flora"))
                                (14 . ("Edit"))
                                (15 . ("Sofia" "Sonja"))
                                (16 . ("Ester"))
                                (17 . ("Rebecka" "Hagar"))
                                (18 . ("Erik" "Jerker" "Erika"))
                                (19 . ("Emilia" "Emma" "Amalia" "Mili"))
                                (20 . ("Karolina" "Lilli" "Lilian"))
                                (21 . ("Konstantin" "Conny"))
                                (22 . ("Hemming"))
                                (23 . ("Lydia"))
                                (24 . ("Alarik"))
                                (25 . ("Urban"))
                                (26 . ("Vilhelmina" "Minna"))
                                (27 . ("Ingeborg"))
                                (28 . ("Alma"))
                                (29 . ("Orvar" "Oliver" "Olivia"))
                                (30 . ("Rurik"))
                                (31 . ("Helge" "Helga"))
                                ))
                          (6 . (
                                (1 . ("Rabbe"))
                                (2 . ("Vendla"))
                                (3 . ("Viola"))
                                (4 . ("Selim"))
                                (5 . ("Stig"))
                                (6 . ("Gustav" "Gsta" "Gustava"))
                                (7 . ("Robert" "Robin"))
                                (8 . ("Kjell" "Kettil"))
                                (9 . ("Dag" "Daga"))
                                (10 . ("Svante"))
                                (11 . ("Hjrdis"))
                                (12 . ("Eskil"))
                                (13 . ("sa" "Aslg"))
                                (14 . ("Tord"))
                                (15 . ("Mona" "Monika"))
                                (16 . ("Eugen"))
                                (17 . ("Birger" "Brje"))
                                (18 . ("Ingolf"))
                                (19 . ("Sigrid" "Siri"))
                                (20 . ("Inga"))
                                (21 . ("Ingemar" "Ingmar" "Inge"))
                                (22 . ("Paula" "Paulina" "Lina"))
                                (23 . ("Adolf"))
                                (24 . ("Johannes" "Johan" "Jan" "Jon" "John" "Johnny" "Jens"))
                                (25 . ("Uno"))
                                (26 . ("Viveka"))
                                (27 . ("Elvira" "Elvi"))
                                (28 . ("Leo" "Leopold"))
                                (29 . ("Peter" "Per" "Pette" "Petra" "Pernilla"))
                                (30 . ("Leif"))
                                ))
                          (7 . (
                                (1 . ("Kasimir"))
                                (2 . ("Maria" "Marika" "Maja" "Maj" "Mary"))
                                (3 . ("Egil" "Ejvind" "jvind"))
                                (4 . ("Ulrika" "Ulla"))
                                (5 . ("Ulf"))
                                (6 . ("Halvar"))
                                (7 . ("Klas" "Klaus"))
                                (8 . ("Tor" "Tore" "Tora"))
                                (9 . ("Nanna" "Nanny"))
                                (10 . ("Saima" "Saimi"))
                                (11 . ("Eleonora" "Nora" "Leonora" "Elli" "Ellinor"))
                                (12 . ("Herman"))
                                (13 . ("Joel"))
                                (14 . ("Alice"))
                                (15 . ("Ragnhild" "Ragni" "Ragna"))
                                (16 . ("Reinhold"))
                                (17 . ("Ossian"))
                                (18 . ("Fredrik" "Fred" "Fredrika"))
                                (19 . ("Sara" "Sally"))
                                (20 . ("Margareta" "Margit" "Marit" "Greta" "Gretel"))
                                (21 . ("Johanna" "Joanna" "Jonna" "Jenny" "Hanna" "Hannele"))
                                (22 . ("Magdalena" "Malin" "Lena"))
                                (23 . ("Olga"))
                                (24 . ("Kristina" "Kerstin" "Kristel" "Kia" "Stina" "Tina"))
                                (25 . ("Jakob" "Jim"))
                                (26 . ("Marta"))
                                (27 . ("Heidi"))
                                (28 . ("Hkan"))
                                (29 . ("Olof" "Olav" "Ola" "Ole" "Olle"))
                                (30 . ("Asta"))
                                (31 . ("Helena"))
                                ))
                          (8 . (
                                (1 . ("Gerda" "Gerd"))
                                (2 . ("Holger"))
                                (3 . ("Linnea"))
                                (4 . ("Vera"))
                                (5 . ("Gurli"))
                                (6 . ("Sixten"))
                                (7 . ("Yrsa"))
                                (8 . ("Sylvia"))
                                (9 . ("Eira" "Natalie"))
                                (10 . ("Lars"))
                                (11 . ("Susanna" "Susanne" "Sanna"))
                                (12 . ("Klara"))
                                (13 . ("Alfons"))
                                (14 . ("Svea"))
                                (15 . ("Marita" "Marianne" "Marlene"))
                                (16 . ("Brynolf"))
                                (17 . ("Verner" "Veronika"))
                                (18 . ("Bo"))
                                (19 . ("Magnus" "Mns"))
                                (20 . ("Samuel" "Sam"))
                                (21 . ("Sven"))
                                (22 . ("Ivar"))
                                (23 . ("Signe" "Signhild"))
                                (24 . ("Bertel" "Bertil" "Berta"))
                                (25 . ("Lovisa" "Louise"))
                                (26 . ("Mrta" "Mrit"))
                                (27 . ("Ralf" "Rufus"))
                                (28 . ("Hilding"))
                                (29 . ("Ines" "Ina"))
                                (30 . ("Emil"))
                                (31 . ("Arvid"))
                                ))
                          (9 . (
                                (1 . ("Gottfrid"))
                                (2 . ("Sunnve"))
                                (3 . ("Solveig"))
                                (4 . ("Roland"))
                                (5 . ("Ragnvald" "Ronald" "Ronny"))
                                (6 . ("Felix"))
                                (7 . ("Regina" "Roy"))
                                (8 . ("Gte" "Gta"))
                                (9 . ("Evert"))
                                (10 . ("sten"))
                                (11 . ("Alexander" "Alex" "Alexandra" "Sandra"))
                                (12 . ("Dagny"))
                                (13 . ("Ylva"))
                                (14 . ("Ida"))
                                (15 . ("Runar"))
                                (16 . ("Hellevi" "Hillevi" "Helvig"))
                                (17 . ("Hildegard" "Hildegerd"))
                                (18 . ("Pamela"))
                                (19 . ("Torborg"))
                                (20 . ("Erna"))
                                (21 . ("Gunborg" "Gunlg"))
                                (22 . ("Mauritz" "Moritz"))
                                (23 . ("Tekla"))
                                (24 . ("Alvar"))
                                (25 . ("Sigvard"))
                                (26 . ("Finn"))
                                (27 . ("Torolf"))
                                (28 . ("Leonard" "Lennart"))
                                (29 . ("Mikael" "Mikaela"))
                                (30 . ("Roger"))
                                ))
                          (10 . (
                                 (1 . ("Ragnar" "Rainer"))
                                 (2 . ("Ludvig"))
                                 (3 . ("Evald"))
                                 (4 . ("Frans" "Frank"))
                                 (5 . ("Ingrid" "Inger"))
                                 (6 . ("Bruno"))
                                 (7 . ("Birgitta" "Brita" "Britta" "Britt" "Birgit"))
                                 (8 . ("Peik"))
                                 (9 . ("Marina"))
                                 (10 . ("Alexis"))
                                 (11 . ("Bjrn"))
                                 (12 . ("Valfrid"))
                                 (13 . ("Ebbe" "Ebba"))
                                 (14 . ("Elsa" "Else" "Ilse"))
                                 (15 . ("Hedvig" "Hedda"))
                                 (16 . ("Stella"))
                                 (17 . ("Vesta" "Diana"))
                                 (18 . ("Saga"))
                                 (19 . ("Viking"))
                                 (20 . ("Kasper" "Jesper"))
                                 (21 . ("Ursula"))
                                 (22 . ("Anita" "Anja"))
                                 (23 . ("Severin" "Sren"))
                                 (24 . ("Fjalar" "Rasmus"))
                                 (25 . ("Yvonne"))
                                 (26 . ("Amanda" "Nina" "Ninni"))
                                 (27 . ("Sabina"))
                                 (28 . ("Simon"))
                                 (29 . ("Alfred"))
                                 (30 . ("Jennifer"))
                                 (31 . ("Artur"))
                                 ))
                          (11 . (
                                 (1 . ("Gun" "Gunhild"))
                                 (2 . ("Tobias"))
                                 (3 . ("Erland"))
                                 (4 . ("Carina"))
                                 (5 . ("Torhild"))
                                 (6 . ("Gustav Adolf"))
                                 (7 . ("Glenn"))
                                 (8 . ("Styrbjrn"))
                                 (9 . ("Teodor" "Theo"))
                                 (10 . ("Martin" "Mrten" "Martina"))
                                 (11 . ("Boris"))
                                 (12 . ("Konrad" "Kurt"))
                                 (13 . ("Kristian" "Krister"))
                                 (14 . ("Iris"))
                                 (15 . ("Janina" "Jannika" "Jeanette"))
                                 (16 . ("Arne" "Arnold" "Arna"))
                                 (17 . ("Einar" "Enar"))
                                 (18 . ("Max"))
                                 (19 . ("Elisabet" "Lisa" "Lisen" "Lisbet" "Elise"))
                                 (20 . ("Hjalmar" "Pontus"))
                                 (21 . ("Hilma"))
                                 (22 . ("Cecilia"))
                                 (23 . ("Yngve" "Yngvar"))
                                 (24 . ("Siv"))
                                 (25 . ("Katarina" "Karin" "Kajsa" "Katja"))
                                 (26 . ("Dagmar"))
                                 (27 . ("Astrid" "Estrid"))
                                 (28 . ("Sten"))
                                 (29 . ("Edgar"))
                                 (30 . ("Anders" "Andreas" "Andr" "Andrea"))
                                 ))
                          (12 . (
                                 (1 . ("Oskar"))
                                 (2 . ("Beata" "Beatrice"))
                                 (3 . ("Urda"))
                                 (4 . ("Barbara" "Barbro"))
                                 (5 . ("Selma"))
                                 (6 . ("Nils" "Niklas"))
                                 (7 . ("Agata" "Agda" "got"))
                                 (8 . ("Magnhild" "Magna"))
                                 (9 . ("Anna" "Anni" "Anne" "Annika" "Anneli" "Annette"))
                                 (10 . ("Judit" "Jutta"))
                                 (11 . ("Daniel" "Dan" "Daniela"))
                                 (12 . ("Tove"))
                                 (13 . ("Lucia"))
                                 (14 . ("Ove"))
                                 (15 . ("Sverker"))
                                 (16 . ("Ada" "Adele"))
                                 (17 . ("Rakel"))
                                 (18 . ("Abraham"))
                                 (19 . ("Isak"))
                                 (20 . ("Benjamin" "Ben" "Benny"))
                                 (21 . ("Tomas" "Tom" "Tommy"))
                                 (22 . ("Rafael"))
                                 (23 . ("Elof"))
                                 (24 . ("Adam" "Eva"))
                                 (25 . ())
                                 (26 . ("Stefan" "Staffan"))
                                 (27 . ("Hans"))
                                 (28 . ("Pia"))
                                 (29 . ("Frida"))
                                 (30 . ("David"))
                                 (31 . ("Sylvester"))
                                 ))))

(lyskom-define-namedays 'hu
                        "Magyar"
                        "\
Namnsdagar ur ngon ungersk namnlngd. Eftersom utvecklarna inte kan
ungerska s r beskrivningen p svenska, med frhoppningen att ngon
som kan ungerska kommer att reta sig p den och skriva om texten p
rtt sprk."
                        '((1 . (
                                (1 . ("Fruzsina"))
                                (2 . ("bel"))
                                (3 . ("Genovna" "Benjmin"))
                                (4 . ("Titusz" "Lena" "Angla"))
                                (5 . ("Simon" "Amata"))
                                (6 . ("Boldizsr"))
                                (7 . ("Attila" "Ramna"))
                                (8 . ("Gyngyvr"))
                                (9 . ("Marcell"))
                                (10 . ("Melnia"))
                                (11 . ("gota"))
                                (12 . ("Ern"))
                                (13 . ("Veronika"))
                                (14 . ("Bdog"))
                                (15 . ("Lrnt" "Lrnd"))
                                (16 . ("Gusztv"))
                                (17 . ("Antal" "Antnia"))
                                (18 . ("Piroska"))
                                (19 . ("Sra" "Mri"))
                                (20 . ("Fbin" "Sebestyn"))
                                (21 . ("gnes"))
                                (22 . ("Vince" "Artr" "Anasztz"))
                                (23 . ("Zelma" "Rajmund"))
                                (24 . ("Timt"))
                                (25 . ("Pl"))
                                (26 . ("Vanda" "Paula"))
                                (27 . ("Angelika" "Angla"))
                                (28 . ("Kroly" "Karola"))
                                (29 . ("Adl"))
                                (30 . ("Martina" "Gerda"))
                                (31 . ("Marcella"))
                                ))
                          (2 . (
                                (1 . ("Ignc"))
                                (2 . ("Karolina" "Aida"))
                                (3 . ("Balzs"))
                                (4 . ("Rhel" "Csenge" "Andrs"))
                                (5 . ("gota" "Ingrid"))
                                (6 . ("Dorottya" "Dra" "Ajndk" "Amanda"))
                                (7 . ("Tdor" "Rme"))
                                (8 . ("Aranka"))
                                (9 . ("Abigl" "Alex"))
                                (10 . ("Elvira"))
                                (11 . ("Bertold" "Marietta" "Adolf"))
                                (12 . ("Lvia" "Ldia"))
                                (13 . ("Ella" "Linda"))
                                (14 . ("Blint" "Valentin"))
                                (15 . ("Kolos" "Georgina"))
                                (16 . ("Julianna" "Lilla"))
                                (17 . ("Dont"))
                                (18 . ("Bernadett"))
                                (19 . ("Zsuzsanna"))
                                (20 . ("Aladr" "lmos" "Amata"))
                                (21 . ("Eleonra"))
                                (22 . ("Gerzson"))
                                (23 . ("Alfrd"))
                                (24 . ("Mtys"))
                                (25 . ("Gza"))
                                (26 . ("Edina"))
                                (27 . ("kos" "Btor"))
                                (28 . ("Elemr"))
                                ))
                          (3 . (
                                (1 . ("Albin" "Albina"))
                                (2 . ("Lujza"))
                                (3 . ("Kornlia"))
                                (4 . ("Kzmr" "Adorjn" "Adrin" "Adrienn"))
                                (5 . ("Adorjn" "Adrin" "Adrienn"))
                                (6 . ("Leonora" "Inez"))
                                (7 . ("Tams"))
                                (8 . ("Zoltn"))
                                (9 . ("Franciska" "Fanni"))
                                (10 . ("Ildik"))
                                (11 . ("Szilrd" "Aladr"))
                                (12 . ("Gergely"))
                                (13 . ("Krisztin" "Ajtny"))
                                (14 . ("Matild"))
                                (15 . ("Kristf"))
                                (16 . ("Henrietta"))
                                (17 . ("Gertrd" "Patrik"))
                                (18 . ("Sndor" "Ede" "Alexandra"))
                                (19 . ("Jzsef" "Bnk"))
                                (20 . ("Klaudia"))
                                (21 . ("Benedek"))
                                (22 . ("Beta" "Izolda"))
                                (23 . ("Emke"))
                                (24 . ("Gbor" "Karina"))
                                (25 . ("Irn" "risz"))
                                (26 . ("Emnuel"))
                                (27 . ("Hajnalka"))
                                (28 . ("Gedeon" "Johanna"))
                                (29 . ("Aguszta"))
                                (30 . ("Zaln" "Amade"))
                                (31 . ("rpd" "Ajtny"))
                                ))
                          (4 . (
                                (1 . ("Hug"))
                                (2 . ("ron"))
                                (3 . ("Buda" "Richrd"))
                                (4 . ("Izidor"))
                                (5 . ("Vince"))
                                (6 . ("Vilmos" "Bborka"))
                                (7 . ("Herman"))
                                (8 . ("Dnes"))
                                (9 . ("Erhard"))
                                (10 . ("Zsolt"))
                                (11 . ("Le" "Szaniszl"))
                                (12 . ("Gyula"))
                                (13 . ("Ida"))
                                (14 . ("Tibor"))
                                (15 . ("Anasztzia" "Tas"))
                                (16 . ("Csongor"))
                                (17 . ("Rudolf"))
                                (18 . ("Andrea" "Ilma" "Andrs"))
                                (19 . ("Emma"))
                                (20 . ("Tivadar"))
                                (21 . ("Konrd"))
                                (22 . ("Csilla" "Nomi"))
                                (23 . ("Bla"))
                                (24 . ("Gyrgy"))
                                (25 . ("Mrk"))
                                (26 . ("Ervin"))
                                (27 . ("Zita"))
                                (28 . ("Valria"))
                                (29 . ("Pter" "Albert" "Albertna"))
                                (30 . ("Katalin" "Kitti"))
                                ))
                          (5 . (
                                (1 . ("Flp" "Jakab" "Amarilla"))
                                (2 . ("Zsigmond"))
                                (3 . ("Tmea" "Irma"))
                                (4 . ("Mnika" "Flrin"))
                                (5 . ("Gyrgyi"))
                                (6 . ("Ivett" "Frida"))
                                (7 . ("Gizella"))
                                (8 . ("Mihly"))
                                (9 . ("Gergely"))
                                (10 . ("rmin" "Plma"))
                                (11 . ("Ferenc" "Adolf"))
                                (12 . ("Pongrc"))
                                (13 . ("Szervc" "Imola"))
                                (14 . ("Bonifc"))
                                (15 . ("Zsfia" "Szonja"))
                                (16 . ("Mzes" "Botond"))
                                (17 . ("Paszkl"))
                                (18 . ("Erik" "Alexandra"))
                                (19 . ("Iv" "Miln"))
                                (20 . ("Bernt" "Felcia"))
                                (21 . ("Konstantin" "Andrs"))
                                (22 . ("Jlia" "Rita"))
                                (23 . ("Dezs"))
                                (24 . ("Eszter" "Eliza"))
                                (25 . ("Orbn"))
                                (26 . ("Flp" "Evelin" "Amanda"))
                                (27 . ("Hella"))
                                (28 . ("Emil" "Csand" "goston"))
                                (29 . ("Magdolna"))
                                (30 . ("Janka" "Zsanett"))
                                (31 . ("Angla" "Petronella"))
                                ))
                          (6 . (
                                (1 . ("Tnde"))
                                (2 . ("Krmen" "Anita" "Anna" "Annamria"))
                                (3 . ("Klotild"))
                                (4 . ("Bulcs"))
                                (5 . ("Fatime"))
                                (6 . ("Norbert" "Cintia"))
                                (7 . ("Rbert"))
                                (8 . ("Medrd"))
                                (9 . ("Flix" "Annabella"))
                                (10 . ("Margit" "Grta"))
                                (11 . ("Barnabs"))
                                (12 . ("Vill"))
                                (13 . ("Antal" "Anett" "Anna"))
                                (14 . ("Vazul"))
                                (15 . ("Joln" "Vid"))
                                (16 . ("Jusztin"))
                                (17 . ("Laura" "Alida" "Adolf" "Alina" "Alinda"))
                                (18 . ("Arnold" "Levente"))
                                (19 . ("Gyrfs"))
                                (20 . ("Rafael"))
                                (21 . ("Alajos" "Leila" "Aladr" "Aloma"))
                                (22 . ("Paulina"))
                                (23 . ("Zoltn"))
                                (24 . ("Ivn"))
                                (25 . ("Vilmos"))
                                (26 . ("Jnos" "Pl"))
                                (27 . ("Lszlo"))
                                (28 . ("Levente" "Irn"))
                                (29 . ("Pter" "Pl"))
                                (30 . ("Pl"))
                                ))
                          (7 . (
                                (1 . ("Tihamr" "Annamria"))
                                (2 . ("Ott"))
                                (3 . ("Kornl" "Soma" "Anatol"))
                                (4 . ("Ulrik"))
                                (5 . ("Emese" "Sarolta" "Antal"))
                                (6 . ("Csaba"))
                                (7 . ("Apollonia"))
                                (8 . ("Ellk"))
                                (9 . ("Lukrcia"))
                                (10 . ("Amlia" "Alma"))
                                (11 . ("Nra" "Lili"))
                                (12 . ("Izabella" "Dalma"))
                                (13 . ("Jen"))
                                (14 . ("rs" "Stella"))
                                (15 . ("Henrik" "Roland"))
                                (16 . ("Valter"))
                                (17 . ("Endre" "Elek" "Ajndk" "Andrs"))
                                (18 . ("Frigyes"))
                                (19 . ("Emlia"))
                                (20 . ("lls"))
                                (21 . ("Dniel" "Daniella"))
                                (22 . ("Magdolna"))
                                (23 . ("Lenke"))
                                (24 . ("Kinga" "Kincs"))
                                (25 . ("Kristf" "Jakab"))
                                (26 . ("Anna" "Anik" "Annamria"))
                                (27 . ("Olga" "Liliana" "Ajtny"))
                                (28 . ("Szabolcs"))
                                (29 . ("Mrta" "Flra"))
                                (30 . ("Judit" "Xnia"))
                                (31 . ("Oszkr"))
                                ))
                          (8 . (
                                (1 . ("Boglrka"))
                                (2 . ("Lehel" "Alfonz"))
                                (3 . ("Hermina"))
                                (4 . ("Domonkos" "Dominika"))
                                (5 . ("Krisztina" "Afrodit"))
                                (6 . ("Berta" "Bettna"))
                                (7 . ("Ibolya" "Afrodit"))
                                (8 . ("Lszl"))
                                (9 . ("Emd"))
                                (10 . ("Lrinc"))
                                (11 . ("Zsuzsanna" "Tiborc"))
                                (12 . ("Klra"))
                                (13 . ("Ipoly"))
                                (14 . ("Marcell"))
                                (15 . ("Mria"))
                                (16 . ("brahm"))
                                (17 . ("Jcint" "Anasztz"))
                                (18 . ("Ilona"))
                                (19 . ("Huba"))
                                (20 . ("Istvn"))
                                (21 . ("Smuel" "Hajna"))
                                (22 . ("Menyhrt" "Mirjam"))
                                (23 . ("Bence"))
                                (24 . ("Bertalan"))
                                (25 . ("Lajos" "Patrcia"))
                                (26 . ("Izs"))
                                (27 . ("Gspr"))
                                (28 . ("goston"))
                                (29 . ("Beatrix" "Erna"))
                                (30 . ("Rzsa"))
                                (31 . ("Erika" "Bella"))
                                ))
                          (9 . (
                                (1 . ("Egyed" "Egon"))
                                (2 . ("Rebeka" "Dorina"))
                                (3 . ("Hilda"))
                                (4 . ("Rozlia"))
                                (5 . ("Viktor" "Lrinc" "Alpr"))
                                (6 . ("Zakaris"))
                                (7 . ("Regina"))
                                (8 . ("Mria" "Adrienn" "Adorjn" "Adrin"))
                                (9 . ("dm" "Andrs"))
                                (10 . ("Nikolett" "Hunor"))
                                (11 . ("Teodra"))
                                (12 . ("Mria"))
                                (13 . ("Kornl" "Amata"))
                                (14 . ("Szerna" "Roxna"))
                                (15 . ("Enik" "Melitta"))
                                (16 . ("Edit"))
                                (17 . ("Zsfia"))
                                (18 . ("Dina"))
                                (19 . ("Vilhelmina"))
                                (20 . ("Friderika"))
                                (21 . ("Mt" "Mirella"))
                                (22 . ("Mric"))
                                (23 . ("Tekla"))
                                (24 . ("Gellrt" "Mercdesz"))
                                (25 . ("Eufrzina" "Kende"))
                                (26 . ("Jusztina"))
                                (27 . ("Adalbert" "Adolf" "Albertina"))
                                (28 . ("Vencel"))
                                (29 . ("Mihly"))
                                (30 . ("Jeromos"))
                                ))
                          (10 . (
                                 (1 . ("Malvin"))
                                 (2 . ("Petra"))
                                 (3 . ("Helga"))
                                 (4 . ("Ferenc"))
                                 (5 . ("Aurl"))
                                 (6 . ("Brn" "Renta"))
                                 (7 . ("Amlia"))
                                 (8 . ("Koppny"))
                                 (9 . ("Dnes"))
                                 (10 . ("Gedeon"))
                                 (11 . ("Brigitta"))
                                 (12 . ("Miksa"))
                                 (13 . ("Klmn" "Ede"))
                                 (14 . ("Heln"))
                                 (15 . ("Terz"))
                                 (16 . ("Gl"))
                                 (17 . ("Hedvig"))
                                 (18 . ("Lukcs"))
                                 (19 . ("Nndor"))
                                 (20 . ("Vendel"))
                                 (21 . ("Orsolya"))
                                 (22 . ("Eld"))
                                 (23 . ("Gyngyi"))
                                 (24 . ("Salamon"))
                                 (25 . ("Blanka" "Bianka"))
                                 (26 . ("Dmtr"))
                                 (27 . ("Szabina"))
                                 (28 . ("Simon" "Szimonetta"))
                                 (29 . ("Nrcisz"))
                                 (30 . ("Alfonz"))
                                 (31 . ("Farkas"))
                                 ))
                          (11 . (
                                 (1 . ("Marianna"))
                                 (2 . ("Achilles"))
                                 (3 . ("Gyz"))
                                 (4 . ("Kroly"))
                                 (5 . ("Imre"))
                                 (6 . ("Lnrd"))
                                 (7 . ("Rezs"))
                                 (8 . ("Zsombor"))
                                 (9 . ("Tivadar"))
                                 (10 . ("Rka" "Andrs"))
                                 (11 . ("Mrton"))
                                 (12 . ("Jns" "Rent" "Aba"))
                                 (13 . ("Szilvia"))
                                 (14 . ("Alz"))
                                 (15 . ("Albert" "Lipt"))
                                 (16 . ("dn"))
                                 (17 . ("Hortenzia" "Gerg"))
                                 (18 . ("Jen"))
                                 (19 . ("Erzsbet"))
                                 (20 . ("Joln"))
                                 (21 . ("Olivr"))
                                 (22 . ("Ceclia"))
                                 (23 . ("Kelemen" "Klementna"))
                                 (24 . ("Emma"))
                                 (25 . ("Katalin" "Alan"))
                                 (26 . ("Virg"))
                                 (27 . ("Virgil"))
                                 (28 . ("Stefnia"))
                                 (29 . ("Taksony"))
                                 (30 . ("Andrs" "Andor"))
                                 ))
                          (12 . (
                                 (1 . ("Elza"))
                                 (2 . ("Melinda" "Vivien"))
                                 (3 . ("Ferenc"))
                                 (4 . ("Borbla" "Barbara"))
                                 (5 . ("Vilma"))
                                 (6 . ("Mikls"))
                                 (7 . ("Ambrus"))
                                 (8 . ("Mria"))
                                 (9 . ("Natlia"))
                                 (10 . ("Judit"))
                                 (11 . ("rpd"))
                                 (12 . ("Gabriella"))
                                 (13 . ("Luca" "Otlia"))
                                 (14 . ("Szilrda"))
                                 (15 . ("Valr"))
                                 (16 . ("Etelka" "Aletta" "Albina"))
                                 (17 . ("Lzr" "Olimpia"))
                                 (18 . ("Auguszta"))
                                 (19 . ("Viola"))
                                 (20 . ("Teofil"))
                                 (21 . ("Tams"))
                                 (22 . ("Zn"))
                                 (23 . ("Viktria"))
                                 (24 . ("dm" "va" "Ada" "Adl"))
                                 (25 . ("Eugnia"))
                                 (26 . ("Istvn"))
                                 (27 . ("Jnos"))
                                 (28 . ("Kamilla"))
                                 (29 . ("Tams" "Tamara"))
                                 (30 . ("Dvid"))
                                 (31 . ("Szilveszter"))
                                 ))
                          ))


(lyskom-define-namedays 'cz
                        "Czechia"
                        "\
Namnsdagar ur ngon tjeckisk namnlngd. Eftersom utvecklarna inte kan
tjeckiska s r beskrivningen p svenska, med frhoppningen att ngon
som kan tjeckiska kommer att reta sig p den och skriva om texten p
rtt sprk."
                        '((1 . (
                                (1 . ("Nov-B-A rok"))
                                (2 . ("Karina"))
                                (3 . ("Radmila"))
                                (4 . ("Diana"))
                                (5 . ("Dalimil"))
                                (6 . ("T-Bi-A kr-Blov"))-A
                                (7 . ("Vilma"))
                                (8 . ("-Bestmr"))-A
                                (9 . ("Vladan"))
                                (10 . ("B-Betislav"))-A
                                (11 . ("Bohdana"))
                                (12 . ("Pravoslav"))
                                (13 . ("Edita"))
                                (14 . ("Radovan"))
                                (15 . ("Alice"))
                                (16 . ("Ctirad"))
                                (17 . ("Drahoslav"))
                                (18 . ("Vladislav"))
                                (19 . ("Doubravka"))
                                (20 . ("Ilona"))
                                (21 . ("B-Bla"))-A
                                (22 . ("Slavom-Br"))-A
                                (23 . ("Zden-Bk"))-A
                                (24 . ("Milena"))
                                (25 . ("Milo-B"))-A
                                (26 . ("Zora"))
                                (27 . ("Ingrid"))
                                (28 . ("Ot-Blie"))-A
                                (29 . ("Zdislava"))
                                (30 . ("Robin"))
                                (31 . ("Marika"))
                                ))
                          (2 . (
                                (1 . ("Hynek"))
                                (2 . ("Nela"))
                                (3 . ("Bla-Bej"))-A
                                (4 . ("Jarmila"))
                                (5 . ("Dobromila"))
                                (6 . ("Vanda"))
                                (7 . ("Veronika"))
                                (8 . ("Milada"))
                                (9 . ("Apolena"))
                                (10 . ("Mojm-Br"))-A
                                (11 . ("Bo-Bena"))-A
                                (12 . ("Slav-Bna"))-A
                                (13 . ("V-Bnceslav"))-A
                                (14 . ("Valent-Bn"))-A
                                (15 . ("Ji-Bina"))-A
                                (16 . ("Ljuba"))
                                (17 . ("Miloslava"))
                                (18 . ("Gizela"))
                                (19 . ("Patrik"))
                                (20 . ("Old-Bich"))-A
                                (21 . ("Lenka"))
                                (22 . ("Petr"))
                                (23 . ("Svatopluk"))
                                (24 . ("Mat-Bj"))-A
                                (25 . ("Liliana"))
                                (26 . ("Dora"))
                                (27 . ("Alexandr"))
                                (28 . ("Lum-Br"))-A
                                ))
                          (3 . (
                                (1 . ("Alb-Bn"))-A
                                (2 . ("Ane-Bka"))-A
                                (3 . ("Kamil"))
                                (4 . ("Stela"))
                                (5 . ("Kazim-Br"))-A
                                (6 . ("Miroslav"))
                                (7 . ("Tom-B"))-A
                                (8 . ("Gabriela"))
                                (9 . ("Franti-Bka"))-A
                                (10 . ("Viktorie"))
                                (11 . ("And-Bla"))-A
                                (12 . ("-Beho"))-A
                                (13 . ("R-Bena"))-A
                                (14 . ("Matylda" "R-Bt"))-A
                                (15 . ("Ida"))
                                (16 . ("Amos"))
                                (17 . ("Vlastimil"))
                                (18 . ("Eduard"))
                                (19 . ("Josef"))
                                (20 . ("Sv-Btlana"))-A
                                (21 . ("Radek"))
                                (22 . ("Leona"))
                                (23 . ("Ivona"))
                                (24 . ("Gabriel"))
                                (25 . ("Mari-Bn"))-A
                                (26 . ("Emanuel"))
                                (27 . ("Dita"))
                                (28 . ("So-Ba"))-A
                                (29 . ("Ta-Bna"))-A
                                (30 . ("Arno-Bt"))-A
                                (31 . ("Kvido"))
                                ))
                          (4 . (
                                (1 . ("Hugo"))
                                (2 . ("Erika"))
                                (3 . ("Richard"))
                                (4 . ("Ivana"))
                                (5 . ("Miroslava"))
                                (6 . ("Vendula"))
                                (7 . ("He-Bman"-A "Herm-Bna"))-A
                                (8 . ("Ema"))
                                (9 . ("Du-Ban"))-A
                                (10 . ("Darja"))
                                (11 . ("Izabela"))
                                (12 . ("Julius"))
                                (13 . ("Ale-B"))-A
                                (14 . ("Vincenc"))
                                (15 . ("Anast-Bzie"))-A
                                (16 . ("Irena"))
                                (17 . ("Rudolf"))
                                (18 . ("Val-Brie"))-A
                                (19 . ("Rostislav"))
                                (20 . ("Marcela"))
                                (21 . ("Alexandra"))
                                (22 . ("Ev-Benie"))-A
                                (23 . ("Vojt-Bch"))-A
                                (24 . ("Ji-B"))-A
                                (25 . ("Marek"))
                                (26 . ("Oto"))
                                (27 . ("Jaroslav"))
                                (28 . ("Vlastislav"))
                                (29 . ("Robert"))
                                (30 . ("Blahoslav"))
                                ))
                          (5 . (
                                (1 . ("Sv-Btek-A pr-Bce"))-A
                                (2 . ("Zikmund"))
                                (3 . ("Alexej"))
                                (4 . ("Kv-Btoslav"))-A
                                (5 . ("Klaudie"))
                                (6 . ("Radoslav"))
                                (7 . ("Stanislav"))
                                (8 . ())
                                (9 . ("Ctibor"))
                                (10 . ("Bla-Bena"))-A
                                (11 . ("Svatava"))
                                (12 . ("Pankr-Bc"))-A
                                (13 . ("Serv-Bc"))-A
                                (14 . ("Bonif-Bc"))-A
                                (15 . ("-Bofie"))-A
                                (16 . ("P-Bemysl"))-A
                                (17 . ("Aneta"))
                                (18 . ("Nata-Ba"))-A
                                (19 . ("Ivo"))
                                (20 . ("Zby-Bek"))-A
                                (21 . ("Monika"))
                                (22 . ("Emil"))
                                (23 . ("Vladim-Br"))-A
                                (24 . ("Jana"))
                                (25 . ("Viola"))
                                (26 . ("Filip"))
                                (27 . ("Valdemar"))
                                (28 . ("Vil-Bm"))-A
                                (29 . ("Maximili-Bn"-A "Maxim"))
                                (30 . ("Ferdinand"))
                                (31 . ("Kamila"))
                                ))
                          (6 . (
                                (1 . ("Laura"))
                                (2 . ("Jarmil"))
                                (3 . ("Tamara"))
                                (4 . ("Dalibor"))
                                (5 . ("Dobroslav"))
                                (6 . ("Norbert"))
                                (7 . ("Iveta"))
                                (8 . ("Medard"))
                                (9 . ("Stanislava"))
                                (10 . ("Gita"))
                                (11 . ("Fl-Bra"))-A
                                (12 . ("Antonie"))
                                (13 . ("Anton-Bn"))-A
                                (14 . ("Vasil"))
                                (15 . ("V-Bt"))-A
                                (16 . ("Zbyn-Bk"))-A
                                (17 . ("Adolf"))
                                (18 . ("Milan"))
                                (19 . ("Leo-B"))-A
                                (20 . ("Kv-Bta"))-A
                                (21 . ("Alois"))
                                (22 . ("Pavla"))
                                (23 . ("Zde-Bka"))-A
                                (24 . ("Jan"))
                                (25 . ("Ivan"))
                                (26 . ("Adriana"))
                                (27 . ("Ladislav"))
                                (28 . ("Lubom-Br"))-A
                                (29 . ("Petr a Pav"))
                                (30 . ("-Brka"))-A
                                ))
                          (7 . (
                                (1 . ("Jaroslava"))
                                (2 . ("Patricie"))
                                (3 . ("Radom-Br"))-A
                                (4 . ("Prokop"))
                                (5 . ("Cyril"))
                                (6 . ("Jan Hus"))
                                (7 . ("Bohuslava"))
                                (8 . ("Nora"))
                                (9 . ("Drahoslava"))
                                (10 . ("Libu-Be"))-A
                                (11 . ("Olga"))
                                (12 . ("Bo-Bek"))-A
                                (13 . ("Mark-Bta"))-A
                                (14 . ("Karol-Bna"))-A
                                (15 . ("Jind-Bich"))-A
                                (16 . ("Lubo-B"))-A
                                (17 . ("Martina"))
                                (18 . ("Drahom-Bra"))-A
                                (19 . ("-Benk"))-A
                                (20 . ("Ilja"))
                                (21 . ("V-Btzslav"))-A
                                (22 . ("Magdal-Bna"))-A
                                (23 . ("Libor"))
                                (24 . ("Krist-Bna"))-A
                                (25 . ("Jakub"))
                                (26 . ("Anna"))
                                (27 . ("V-Broslav"))-A
                                (28 . ("Viktor"))
                                (29 . ("Marta"))
                                (30 . ("Bo-Bivoj"))-A
                                (31 . ("Ign-Bc"))-A
                                ))
                          (8 . (
                                (1 . ("Oskar"))
                                (2 . ("Gustav"))
                                (3 . ("Milu-Be"))-A
                                (4 . ("Dominik"))
                                (5 . ("Milivoj"))
                                (6 . ("Old-Bika"))-A
                                (7 . ("Lada"))
                                (8 . ("Sob-Bslav"))-A
                                (9 . ("Roman"))
                                (10 . ("Vav-Binec"))-A
                                (11 . ("Zuzana"))
                                (12 . ("Kl-Bra"))-A
                                (13 . ("Alena"))
                                (14 . ("Alan"))
                                (15 . ("Hana"))
                                (16 . ("J-Bchym"))-A
                                (17 . ("Petra"))
                                (18 . ("Helena"))
                                (19 . ("Ludv-Bk"))-A
                                (20 . ("Bernard"))
                                (21 . ("Johana"))
                                (22 . ("Bohuslav"))
                                (23 . ("Sandra"))
                                (24 . ("Bartolom-Bj"))-A
                                (25 . ("Radim"))
                                (26 . ("Lud-Bk"))-A
                                (27 . ("Otakar"))
                                (28 . ("August-Bn"))-A
                                (29 . ())
                                (30 . ("-Btpn"))-A
                                (31 . ("Pavl-Bna"))-A
                                ))
                          (9 . (
                                (1 . ("Linda" "Samuel"))
                                (2 . ("Ad-Bla"))-A
                                (3 . ("Bronislav"))
                                (4 . ("Jind-Bika"))-A
                                (5 . ("Boris"))
                                (6 . ("Boleslav"))
                                (7 . ("Regina"))
                                (8 . ("Mariana"))
                                (9 . ("Daniela"))
                                (10 . ("Irma"))
                                (11 . ("Denisa"))
                                (12 . ("Marie"))
                                (13 . ("Lubor"))
                                (14 . ("Radka"))
                                (15 . ("Jolana"))
                                (16 . ("Ludmil"))
                                (17 . ("Nad-Bda"))-A
                                (18 . ("Kry-Btof"))-A
                                (19 . ("Zita"))
                                (20 . ("Oleg"))
                                (21 . ("Matou-B"))-A
                                (22 . ("Darina"))
                                (23 . ("Berta"))
                                (24 . ("Jarom-Br"))-A
                                (25 . ("Zlata"))
                                (26 . ("Andrea"))
                                (27 . ("Jon-B"))-A
                                (28 . ("V-Bclav"))-A
                                (29 . ("Michal"))
                                (30 . ("Jeron-Bm"))-A
                                ))
                          (10 . (
                                 (1 . ("Igor"))
                                 (2 . ("Ol-Bvie"-A "Galina" "Oliver"))
                                 (3 . ("Bohumil"))
                                 (4 . ("Franti-Bek"))-A
                                 (5 . ("Eli-Bka"))-A
                                 (6 . ("Hanu-B"))-A
                                 (7 . ("Sergej"))
                                 (8 . ("V-Bra"))-A
                                 (9 . ("-Btefan"-A "S-Bra"))-A
                                 (10 . ("Marina"))
                                 (11 . ("Andrej"))
                                 (12 . ("Marcel"))
                                 (13 . ("Ren-Bta"))-A
                                 (14 . ("Ag-Bta"))-A
                                 (15 . ("Tereza"))
                                 (16 . ("Havel"))
                                 (17 . ("Hedvika"))
                                 (18 . ("Luk-B"))-A
                                 (19 . ("Michaela"))
                                 (20 . ("Vendel-Bn"))-A
                                 (21 . ("Brigita"))
                                 (22 . ("Sabina"))
                                 (23 . ("Teodor"))
                                 (24 . ("Nina"))
                                 (25 . ("Be-Bta"))-A
                                 (26 . ("Erik"))
                                 (27 . ("-Barlota"-A "Zoja" "Zoe"))
                                 (28 . ())
                                 (29 . ("Silvie"))
                                 (30 . ("Tade-B"))-A
                                 (31 . ("-Btpnka"))-A
                                 ))
                          (11 . (
                                 (1 . ("Felix"))
                                 (2 . ("Du-Biky"))-A
                                 (3 . ("Hubert"))
                                 (4 . ("Karel"))
                                 (5 . ("Miriam"))
                                 (6 . ("Lib-Bna"))-A
                                 (7 . ("Saskie"))
                                 (8 . ("Bohum-Br"))-A
                                 (9 . ("Bohdan"))
                                 (10 . ("Ev-Ben"))-A
                                 (11 . ("MArtin"))
                                 (12 . ("Benedikt"))
                                 (13 . ("Tibor"))
                                 (14 . ("S-Bva"))-A
                                 (15 . ("Leopold"))
                                 (16 . ("Otmar"))
                                 (17 . ("Mahulena"))
                                 (18 . ("Romana"))
                                 (19 . ("Al-Bbta"))-A
                                 (20 . ("Nikola"))
                                 (21 . ("Albert"))
                                 (22 . ("Cec-Blie"))-A
                                 (23 . ("Klement"))
                                 (24 . ("Em-Blie"))-A
                                 (25 . ("Kate-Bina"))-A
                                 (26 . ("Artur"))
                                 (27 . ("Xenie"))
                                 (28 . ("Ren-B"))-A
                                 (29 . ("Zina"))
                                 (30 . ("Ond-Bej"))-A
                                 ))
                          (12 . (
                                 (1 . ("Iva"))
                                 (2 . ("Blanka"))
                                 (3 . ("Svatoslav"))
                                 (4 . ("Barbora"))
                                 (5 . ("Jitka"))
                                 (6 . ("Mikul-B"))-A
                                 (7 . ("Ambro-B"-A "Benjam-Bn"))-A
                                 (8 . ("Kv-Btoslava"))-A
                                 (9 . ("Vratislav"))
                                 (10 . ("Julie"))
                                 (11 . ("Dana"))
                                 (12 . ("Simona"))
                                 (13 . ("Lucie"))
                                 (14 . ("L-Bdie"))-A
                                 (15 . ("Radan" "Radana"))
                                 (16 . ("Alb-Bna"))-A
                                 (17 . ("Daniel"))
                                 (18 . ("Miloslav"))
                                 (19 . ("Ester"))
                                 (20 . ("Dagmar"))
                                 (21 . ("Nat-Blie"))-A
                                 (22 . ("-Bimon"))-A
                                 (23 . ("Vlasta"))
                                 (24 . ("Adam a Eva"))
                                 (25 . ("Bo-B-A hod"))
                                 (26 . ("-Btpn"))-A
                                 (27 . ("-Baneta"))-A
                                 (28 . ("Bohumila"))
                                 (29 . ("Judita"))
                                 (30 . ("David"))
                                 (31 . ("Silvestr"))
                                 ))
                          ))

(lyskom-define-namedays 'fi-orthodox
                        "Finska (ortodoxa)"
                        "\
Namnsdagar ur ngon finsk ortodox namnlngd. Eftersom utvecklarna inte
kan finska r beskrivningen p svenska, med frhoppningen att ngon
som kan finska kommer att reta sig p den och skriva om texten p rtt
sprk."
                        '((1 . ((1 . ("Vasili" "Vilho" "Pasi"))
                                (2 . ("Sylvester" "Tapio" "Serafim"))
                                (3 . ("Malakia" "Harto"))
                                (4 . ("Isto"))
                                (5 . ("Pentti" "Tauno" "Sylvi"))
                                (6 . ())
                                (7 . ("Johannes" "Juhani" "Juha"))
                                (8 . ("Jyrki" "Yrj" "Tuomi" "Keijo"))
                                (9 . ("Jehto" "Ilpo" "Filip" "Vilppu" "Heimo"))
                                (10 . ("Riiko" "Marko" "Tommo" "Paavali"))
                                (11 . ("Teo" "Mikael" "Miihkali" "Mikko"))
                                (12 . ("Tatjana" "Tanja" "Taina" "Sauvo"))
                                (13 . ("Jermi" "Tarvo" "Ele"))
                                (14 . ("Aatto" "Aatos" "Benjamin" "Niina"))
                                (15 . ("Paavali" "Paavo" "Johannes" "Juhani"))
                                (16 . ("Leonilla" "Leila"))
                                (17 . ("Anttoni" "Toni"))
                                (18 . ("Ahvo" "Ohvo" "Kiril" "Kiril"))
                                (19 . ("Makari" "Kari"))
                                (20 . ("Jehki"))
                                (21 . ("Maksima" "Visa" "Jouko" "Valeri" "Auni"))
                                (22 . ("Timo" "Anastisi" "Nasto"))
                                (23 . ("Klemens" "Klementti" "Liimo" "Oiva" "Aatos"))
                                (24 . ("Senja" "Senni" "Seni"))
                                (25 . ("Riiko" "Riku" "Reijo"))
                                (26 . ("Maria" "Marja" "Mari" "Arjo"))
                                (27 . ("Johannes" "Juhani" "Juha"))
                                (28 . ("Raimo" "Reima" "Jehri"))
                                (29 . ("Ignati" "Iknata" "Iikka"))
                                (30 . ("Vasili" "Vilho" "Riiko" "Johannes" "Ilpo"))
                                (31 . ("Kyr" "Johannes" "Juhani" "Juha" "Nikita" "Niikko" "Ritva"))
                                ))
                          (2 . (
                                (1 . ("Triifon" "Tuija" "Tua" "Aino"))
                                (2 . ())
                                (3 . ("Simeoni" "Simana" "Hanna"))
                                (4 . ("Isko" "Jyrki" "Yrj" "Kiril" "Kiril"))
                                (5 . ("Helli" "Helvi" "Hellevi" "Tuula" "Tuulikki"))
                                (6 . ("Nyyrikki" "Nyri" "Terhi"))
                                (7 . ("Pertti" "Luukas"))
                                (8 . ("Feodor" "Heikki" "Sakari"))
                                (9 . ("Voitto" "Pellervo"))
                                (10 . ("Kaarle" "Valentina" "Enni" "Anna"))
                                (11 . ("Valassi" "Lassi" "Dimitri" "Miska" "Mitja" "Valto"))
                                (12 . ("Mitjo" "Aleksi" "Aleksis"))
                                (13 . ("Martti"))
                                (14 . ("Soini" "Kiril"))
                                (15 . ("Anssi" "Anto"))
                                (16 . ("Vilkko"))
                                (17 . ("Feodor" "Heikki" "Marianne" "Marjaana"))
                                (18 . ("Leonilla" "Leila"))
                                (19 . ("Arhippa" "Arhi"))
                                (20 . ("Leo" "Agaton" "Oiva"))
                                (21 . ("Timo" "Jesto"))
                                (22 . ("Mauri"))
                                (23 . ("Viljo"))
                                (24 . ("Asmo" "Osmo"))
                                (25 . ("Tarasi"))
                                (26 . ("Pirkka"))
                                (27 . ("Prokko" "Okko"))
                                (28 . ("Vasili" "Vilho" "Kassian" "Kiira"))
                                ))
                          (3 . (
                                (1 . ("Outi" "Tyyne"))
                                (2 . ("Esko" "Teuvo" "Arseni" "Arsi" "Taila"))
                                (3 . ("Otto" "Kleo" "Pasi"))
                                (4 . ("Arvo"))
                                (5 . ("Kuuno"))
                                (6 . ("Heikko" "Teuvo" "Kosti" "Kysti" "Viljo"))
                                (7 . ("Ilmari" "Ilmo" "Toivo"))
                                (8 . ("Lasari" "Lasse" "Ahvo" "Ohvo"))
                                (9 . ("Rauli" "Valeri"))
                                (10 . ("Konni" "Galina" "Iina" "Inna"))
                                (11 . ("Roni" "Jehki"))
                                (12 . ("Teo" "Riiko" "Riku" "Reijo"))
                                (13 . ("Nikifor" "Voitto"))
                                (14 . ("Pentti"))
                                (15 . ("Armas"))
                                (16 . ("Savina" "Risto"))
                                (17 . ("Aleksi" "Patrik" "Makari" "Kari"))
                                (18 . ("Kiril" "Kiril"))
                                (19 . ("Darja" "Tarja" "Larja"))
                                (20 . ("Tinja" "Svetlana"))
                                (21 . ("Jaakko"))
                                (22 . ("Vasili" "Vilho" "Helmi" "Rosita"))
                                (23 . ("Niko" "Lyydia" "Lyyli"))
                                (24 . ("Arto"))
                                (25 . ("Maria" "Mari" "Maija" "Marjatta" "Meeri"))
                                (26 . ("Gabriel" "Kauri" "Alli" "Larissa" "Maisa"))
                                (27 . ("Matja"))
                                (28 . ("Ilari" "Ilkka" "Teppo" "Teppana" "Tapani"))
                                (29 . ("Markus" "Markku" "Kiril" "Kiril" "Joona" "Joonas"))
                                (30 . ("Johannes" "Juhani" "Juha"))
                                (31 . ("Ylermi"))
                                ))
                          (4 . (
                                (1 . ("Maria" "Marja" "Mari" "Jehki"))
                                (2 . ("Tiitus" "Tito"))
                                (3 . ("Nikita" "Niikko"))
                                (4 . ("Jyrki" "Yrj" "Ossi" "Virve" "Virpi"))
                                (5 . ("Turo" "Siro" "Tuulo"))
                                (6 . ("Tyko"))
                                (7 . ("Lippo" "Jyrki" "Yrj"))
                                (8 . ("Iiro" "Ermo"))
                                (9 . ("Aulis" "Uoti" "Risto" "Anastasia"))
                                (10 . ("Tero"))
                                (11 . ("Antippa"))
                                (12 . ("Vasili" "Vilho"))
                                (13 . ("Arto"))
                                (14 . ("Martti" "Tuomi"))
                                (15 . ("Ari" "Rohkima" "Runo"))
                                (16 . ("Irina" "Irinja" "Irja" "Rauha" "Lempi" "Leonid" "Heini" "Aliisa"))
                                (17 . ("Simeoni" "Simana" "Aake" "Sosima"))
                                (18 . ("Johannes" "Juhani" "Hannele" "Hanni"))
                                (19 . ("Johannes" "Juhani" "Juha" "Nuutti"))
                                (20 . ("Feodor" "Heikki" "Aleksanteri" "Ale"))
                                (21 . ("Jani" "Janne" "Feodor" "Heikki" "Hilppa"))
                                (22 . ("Feodor" "Heikki"))
                                (23 . ("Jyrki" "Yrj" "Aleksandra" "Sanni" "Sanja"))
                                (24 . ("Elisabet" "Liisa" "Elisa" "Elsa" "Sauvo"))
                                (25 . ("Markus" "Markku"))
                                (26 . ("Vasili" "Vilho" "Teppo" "Teppana" "Tapani"))
                                (27 . ("Simeoni" "Simana"))
                                (28 . ("Jason" "Maksima"))
                                (29 . ("Mauno"))
                                (30 . ("Jaakko" "Ignati"))
                                ))
                          (5 . (
                                (1 . ("Jere" "Jari" "Jarkko" "Nuutti" "Tamara"))
                                (2 . ("Tamara"))
                                (3 . ("Ahvo" "Ohvo" "Saija" "Soja"))
                                (4 . ("Timo" "Maura" "Teo"))
                                (5 . ("Pelagia" "Alvi" "Alpo"))
                                (6 . ("Irene" "Irina" "Irinja" "Irja" "Rauha"))
                                (7 . ("Jopi" "Job"))
                                (8 . ("Aake"))
                                (9 . ("Johannes" "Juhani" "Arseni ,Arsi"))
                                (10 . ("Esa" "Risto" "Nikolai" "Niko" "Niilo"))
                                (11 . ("Simo" "Taisia" "Taija"))
                                (12 . ("Ilkka" "Kiril" "Kiril" "Mefodi" "Torsti"))
                                (13 . ("Ilmo" "Herman" "Hemmo"))
                                (14 . ("Lauha" "Isko"))
                                (15 . ("Heimo" "Esa"))
                                (16 . ("Heikki" "Raimo" "Reima" "Muusa"))
                                (17 . ("Jussi" "Antero"))
                                (18 . ("Petri" "Teino" "Klaudia" "Faina" "Julia"))
                                (19 . ("Patrik" "Niila" "Dimitri" "Miska" "Mitja"))
                                (20 . ("Vesa" "Aleksi" "Asko"))
                                (21 . ("Konsta" "Helena" "Mikael" "Feodor"))
                                (22 . ("Pasi"))
                                (23 . ("Mikael" "Mikko" "Leino" "Onni"))
                                (24 . ("Simeoni" "Simana" "Niikko" "Voitto" "Kristian"))
                                (25 . ("Johannes" "Juham Juhani"))
                                (26 . ("Viljo" "Alf" "Jyrki" "Yrj"))
                                (27 . ("Piv" "Terho"))
                                (28 . ("Tyko" "Niikko" "Voitto" "Ignati" "Kaino"))
                                (29 . ("Heidi" "Johannes" "Juhani" "Juha"))
                                (30 . ("Iisakki"))
                                (31 . ("Erjo"))
                                ))
                          (6 . (
                                (1 . ("Usti" "Teino"))
                                (2 . ("Voitto" "Johannes" "Juhani" "Juha"))
                                (3 . ("Valo" "Paula" "Pauliina"))
                                (4 . ("Mitro"))
                                (5 . ("Terho" "Joona" "Joonas" "Igor" "Iikka"))
                                (6 . ("Ilkka" "Ilari" "Vesa" "Visa" "Joonas"))
                                (7 . ("Teuvo" "Eira" "Erja" "Valeria" "Vaula"))
                                (8 . ("Feodor" "Heikki"))
                                (9 . ("Kiril" "Kiril"))
                                (10 . ("Timo" "Aleksanteri" "Ale" "Antoniina"))
                                (11 . ("Perttu"))
                                (12 . ("Unto" "Pietari" "Petri" "Pekka" "Arseni"))
                                (13 . ("Akuliina" "Alina" "Liina" "Ville"))
                                (14 . ("Eeli" "Torsti"))
                                (15 . ("Aamos" "Joonas" "Aukusti" "Kriska"))
                                (16 . ("Tiihon"))
                                (17 . ("Sauri" "Manuel" "Manu" "Sauli" "Ismo"))
                                (18 . ("Leino" "Onni"))
                                (19 . ("Juuda"))
                                (20 . ("Torsti"))
                                (21 . ("Uljas" "Jesse" "Harras"))
                                (22 . ("Ahri" "Harras"))
                                (23 . ("Ahri" "Aura"))
                                (24 . ("Johannes" "Juhani" "Juha" "Eero"))
                                (25 . ("Rauni" "Pietari" "Petro" "Pekka"))
                                (26 . ("Taavi" "Taavetti"))
                                (27 . ("Johanna" "Jonna" "Sampo" "Sampsa"))
                                (28 . ("Sergei" "Herman" "Kyr" "Johannes"))
                                (29 . ("Pietari" "Petri" "Pekka" "Paavali" "Paavo" "Pauli"))
                                (30 . ("Andreas" "Simo" "Petri" "Jaakko" "Juha" "Tani" "Matti" "Tuomas"))
                                ))
                          (7 . (
                                (1 . ("Kosma" "Kuisma" "Tami"))
                                (2 . ("Maria" "Mari" "Maija" "Marja" "Marjatta" "Meeri"))
                                (3 . ("Anto" "Anatoli"))
                                (4 . ("Antti" "Antero" "Martta"))
                                (5 . ("Ahvo" "Ohvo" "Leimu" "Sergei"))
                                (6 . ("Sisso"))
                                (7 . ("Kiia" "Tuomas" "Tuomo"))
                                (8 . ("Prokko" "Okko"))
                                (9 . ("Valto"))
                                (10 . ("Anton" "Anttoni" "Toni"))
                                (11 . ("Jefimia" "Olga" "Oilo" "Helga"))
                                (12 . ("Kauko" "Ilari" "Mikael" "Veronika"))
                                (13 . ("Kauri" "Teppo" "Teppana" "Tapani"))
                                (14 . ("Aki" "Eeli"))
                                (15 . ("Kerkko" "Jutta" "Vladimir"))
                                (16 . ("Teino" "Aila" "Aili"))
                                (17 . ("Marina" "Marketta" "Maarit" "Erho"))
                                (18 . ("Eemeli" "Eemil" "Into"))
                                (19 . ("Riina" "Teijo" "Serafim"))
                                (20 . ("Elias" "Eelis" "Ilja"))
                                (21 . ("Maria" "Johanne" "Juhani" "Juha" "Simeoni" "Simana"))
                                (22 . ("Maria" "Magdaleena"))
                                (23 . ("Rohkima" "Runo" "Viljo" "Tuukka"))
                                (24 . ("Kristiina" "Kirsti" "Kirsi" "Tiina" "Boris"))
                                (25 . ("Anna" "Anni" "Piia" "Ruusa"))
                                (26 . ("Jorma" "Jarmo" "Paraske" "Eeva"))
                                (27 . ("Leimo" "Pauno"))
                                (28 . ("Timo"))
                                (29 . ("Tea" "Teija" "Serafiima" "Fiina"))
                                (30 . ("Silvo" "Herman" "Hemmo" "Valentin"))
                                (31 . ("Kim" "Kimmo"))
                                ))
                          (8 . (
                                (1 . ("Soile" "Soili" "Ele"))
                                (2 . ("Stefna" "Teemu" "Vasili" "Vilho" "Ville"))
                                (3 . ("Iisakki" "Anton" "Salome" "Salme"))
                                (4 . ("Maksim" "Kustaa" "Martti" "Teino"))
                                (5 . ("Joutsi" "Nonna" "Nanna"))
                                (6 . ())
                                (7 . ("Tarmo"))
                                (8 . ("Eemeli" "Eemil"))
                                (9 . ("Matias" "Matti" "Herman" "Hemmo"))
                                (10 . ("Lauri"))
                                (11 . ("Susanna" "Sanna"))
                                (12 . ("Huoti"))
                                (13 . ("Maksima" "Tiihon" "Noora" "Tiia"))
                                (14 . ("Miika"))
                                (15 . ("Maria" "Mari" "Maija" "Marja" "Marjatta" "Meeri"))
                                (16 . ("Toimi"))
                                (17 . ("Miro" "Heikki" "Teuvo"))
                                (18 . ("Lauri"))
                                (19 . ("Antti" "Antero"))
                                (20 . ("Samuel" "Samuli"))
                                (21 . ("Tatu" "Assi" "Usko" "Avrami" "Aapo"))
                                (22 . ("Ake" "Laila"))
                                (23 . ("Reino"))
                                (24 . ("Tyko" "Siiri" "Sirkka"))
                                (25 . ("Perttu" "Tiitus" "Tito"))
                                (26 . ("Atro" "Natalia"))
                                (27 . ("Pimen" "Pimin"))
                                (28 . ("Mooses"))
                                (29 . ("Hannes" "Hannu" "Iivo" "Juha" "Juhana"))
                                (30 . ("Ale" "Aleksander" "Paavo" "Pauli"))
                                (31 . ("Kiprian"))
                                ))
                          (9 . (
                                (1 . ("Simeoni" "Simana" "Joosua"))
                                (2 . ("Johannes" "Juhani" "Veli" "Veikko"))
                                (3 . ("Anto" "Isto" "Ari" "Viici"))
                                (4 . ("Mooses" "Irma" "Irmeli"))
                                (5 . ("Sakari" "Elisabet" "Liisa" "Elisa" "Elsa"))
                                (6 . ("Raisa" "Raija"))
                                (7 . ("Johannes" "Juhani" "Juha"))
                                (8 . ("Maria" "Mari" "Maija" "Marjatta" "Meeri"))
                                (9 . ("Joakim" "Aki" "Anna" "Severi" "Ossi"))
                                (10 . ("Minna" "Miina" "Tuire"))
                                (11 . ("Lahja" "Sergei" "Herman" "Hemmo" "Iia"))
                                (12 . ("Ahti"))
                                (13 . ("Niila" "Vieno"))
                                (14 . ())
                                (15 . ("Nikita" "Voitto"))
                                (16 . ("Jefimia" "Milla" "Milja"))
                                (17 . ("Veera" "Elpi" "Elvi" "Lempi" "Sofia" "Sonja"))
                                (18 . ("Arja" "Aira" "Airi"))
                                (19 . ("Tuure" "Feodor" "Heikki" "Taavetti" "Taavi" "Konsta" "Kosti"))
                                (20 . ("Jesto" "Mikael" "Mikko" "Olli" "Helge"))
                                (21 . ("Dimitri" "Miska" "Mitja"))
                                (22 . ("Tuukka" "Joona" "Joonas"))
                                (23 . ("Iira" "Raita"))
                                (24 . ("Tekla" "Silvo"))
                                (25 . ("Opri" "Sergei"))
                                (26 . ("Johannes" "Juhani" "Juha"))
                                (27 . ("Kaari"))
                                (28 . ("Hariton" "Harri"))
                                (29 . ("Kyr"))
                                (30 . ("Riiki" "Riku" "Reijo" "Kaija"))
                                ))
                          (10 . (
                                 (1 . ("Romana" "Sauvo"))
                                 (2 . ("Kiprian" "Stiina" "Antti" "Antero"))
                                 (3 . ("Teino"))
                                 (4 . ("Guri"))
                                 (5 . ("Karita" "Pietari" "Petri" "Pekka" "Aleksi" "Joona" "Joonas" "Ilpo"))
                                 (6 . ("Tuomas" "Tuomo"))
                                 (7 . ("Sergei" "Vaka"))
                                 (8 . ("Pelagia" "Laina"))
                                 (9 . ("Jaakko" "Antero" "Hannele" "Hanni"))
                                 (10 . ("Oula" "Eila"))
                                 (11 . ("Ilpo" "Teo" "Siina"))
                                 (12 . ("Antero" "Kosma" "Kuisma"))
                                 (13 . ("Viljo" "Armi"))
                                 (14 . ("Nasari" "Paraske" "Eeva"))
                                 (15 . ("Jehki"))
                                 (16 . ("Heino"))
                                 (17 . ("Antti" "Antero"))
                                 (18 . ("Luukas"))
                                 (19 . ("Joel"))
                                 (20 . ("Artemi" "Arttu" "Arvo"))
                                 (21 . ("Iiari" "Ilkka"))
                                 (22 . ("Erkki"))
                                 (23 . ("Jaakko"))
                                 (24 . ("Aarre"))
                                 (25 . ("Marko"))
                                 (26 . ("Dimitri" "Miska" "Mitja"))
                                 (27 . ("Nestori"))
                                 (28 . ("Tero" "Neonilla" "Teppo" "Teppana" "Tapani" "Arseni" "Paraske" "Eeva"))
                                 (29 . ("Anastasia" "Asta" "Aapo" "Rostislav"))
                                 (30 . ("Veijo" "Vilja"))
                                 (31 . ("Urpo" "Panu" "Taisto"))
                                 ))
                          (11 . (
                                 (1 . ("Kosma" "Kuisma" "Taimi"))
                                 (2 . ("Ahto" "Ohto"))
                                 (3 . ("Ossi"))
                                 (4 . ("Joni" "Jonne" "Kauno"))
                                 (5 . ("Joona" "Joonas" "Kai"))
                                 (6 . ("Paavali" "Paavo" "Pauli"))
                                 (7 . ("Lasari" "Lasse" "Kaisa"))
                                 (8 . ("Mikael" "Mika" "Miihkali" "Mikko" "Raafael"))
                                 (9 . ("Pirkka" "Matja" "Eija" "Eini"))
                                 (10 . ("Iiro" "Ere" "Martti"))
                                 (11 . ("Viktor" "Iida" "Feodor" "Heikki"))
                                 (12 . ("Johannes" "Juhani" "Juha" "Niilo"))
                                 (13 . ("Johannes" "Juhani" "Juha"))
                                 (14 . ("Ilpo"))
                                 (15 . ("Guri"))
                                 (16 . ("Matti"))
                                 (17 . ("Riiki" "Riku" "Reijo"))
                                 (18 . ("Rauno" "Romana"))
                                 (19 . ("Pivi"))
                                 (20 . ("Riiko" "Riku" "Reijo" "Kauko"))
                                 (21 . ("Maria" "Maija" "Marjatta"))
                                 (22 . ("Silja" "Mikael" "Miihkali" "Mikko"))
                                 (23 . ("Riiko" "Riku" "Aleksanteri" "Mitro"))
                                 (24 . ("Katariina" "Katja"))
                                 (25 . ("Liimo" "Pekka" "Petri" "Katariina" "Katja"))
                                 (26 . ("Jyrki" "Yrj"))
                                 (27 . ("Jaakko"))
                                 (28 . ("Teppo" "Teppana" "Tapani" "Arho"))
                                 (29 . ("Aake"))
                                 (30 . ("Antti" "Antero"))
                                 ))
                          (12 . (
                                 (1 . ("Uuno"))
                                 (2 . ("Auvo" "Mira" "Mirka" "Salomo"))
                                 (3 . ("Sauvo"))
                                 (4 . ("Varvara" "Johannes" "Aleksanteri"))
                                 (5 . ("Sauvo"))
                                 (6 . ("Nikolai" "Niko" "Niilo"))
                                 (7 . ("Ambrosius" "Anton" "Anttoni" "Toni"))
                                 (8 . ("Tapio" "Kiril" "Kiril"))
                                 (9 . ("Anna" "Anni" "Anja" "Anneli" "Anita"))
                                 (10 . ("Minkka" "Kirmo"))
                                 (11 . ("Taneli"))
                                 (12 . ("Piri" "Pirkka"))
                                 (13 . ("Lusia" "Seija"))
                                 (14 . ("Aari"))
                                 (15 . ("Paavo" "Pauli" "Teppo" "Tapani" "Triifon"))
                                 (16 . ("Fanni"))
                                 (17 . ("Taneli"))
                                 (18 . ("Seppo"))
                                 (19 . ("Vaito"))
                                 (20 . ("Ignatios" "Juha"))
                                 (21 . ("Jaana" "Pietari" "Petri" "Pekka"))
                                 (22 . ("Anastasia" "Nasti" "Asta"))
                                 (23 . ("Tuulo"))
                                 (24 . ("Jenni"))
                                 (25 . ("Immanuel"))
                                 (26 . ("Jehki"))
                                 (27 . ("Joosef" "Daavid" "Jaakko" "Teppo"))
                                 (28 . ("Domna" "Vilja"))
                                 (29 . ("Markko"))
                                 (30 . ("Ani"))
                                 (31 . ("Maila"))
                                 ))))



(defun kom-list-nameday-lists ()
  (interactive)
  (with-output-to-temp-buffer "*Help*"
    (princ
     (mapconcat 
      (lambda (x)
        (format "%s -- %s\n%s\n\n"
                (nameday-data->code (cdr x))
                (nameday-data->name (cdr x))
                (nameday-data->description (cdr x))))
      lyskom-namedays
      ""))))

