// vim:sw=4:sts=4

#include "config.h"

#ifdef LUAGTK_linux
#include <dlfcn.h>
#include <ffi.h>		/* foreign function interface library */
// #define EXPORT
#endif

#ifdef LUAGTK_win32
#include <windows.h>
#include "ffi.h"
// #define EXPORT __declspec(dllexport)
#ifndef __GNUC_PREREQ
# define __GNUC_PREREQ(maj,min) 0
#endif
#endif

#include <lua.h>
#include <gtk/gtk.h>


/* settings */

/* Max. number of dynamic libraries to load */
#define MAX_DLL			10

/* Max. number of arguments that Gtk2 functions can have */
#define MAX_FUNC_ARGS		20

/* ---- end of configuration ---- */

// #define NAME(ofs) (type_strings + (ofs))
#define STRUCT_INFO(type_idx) (type_list + (type_idx))

// keys in the environment of the gtk module
#define LUAGTK_METATABLES   "metatables"
#define LUAGTK_WIDGETS	    "widgets"
#define LUAGTK_ALIASES	    "aliases"
#define LUAGTK_EMPTYATTR    "emptyattr"

// Access to type and structure element names
#define FTYPE_NAME(t) (ffi_type_names + (t)->name_ofs)
#define TYPE_NAME(ti) (type_strings_types + (ti)->name_ofs)
#define STRUCT_ELEM_NAME(elem) (type_strings_elem + (elem)->name_ofs)
#define WIDGET_NAME(w) (type_strings_types + (type_list[w->type_idx].name_ofs))
#define LUAGTK_ENUM_NAME(e) TYPE_NAME(type_list + (e)->type_idx)
#define GET_PROTOTYPE(type) (type_strings_proto + (type)->fu.signature_ofs)

/*-
 * Description of a type.  There are about 1600 in the list.  Size: 8 bytes
 * The values given for each attribute is the approximate max. value for the
 * last tested Gtk release.
 */
struct type_info {
    unsigned int
	fundamental_id : 6,		/* index into ffi_type_map table (50) */
	is_const : 2,			/* set if a const data type */
	name_ofs : 16;			/* offset in name string (21000) */

    union {
	/* for structures */
	struct {
	    unsigned int
		struct_size : 11,	/* in bytes, max. 1032 */
		elem_start : 13,	/* index into struct_elem; 4168 */
		elem_count : 8;		/* number of elements; max 81 (xmlParserCtxtPtr*) */
	} st;

	/* for functions */
	struct {
	    unsigned int signature_ofs : 16;	/* max. 2034 */
	} fu;
    };
};
extern const struct type_info type_list[];


/*-
 * Description of one structure element.  Size: 6 bytes (48 bits).
 *
 * name_ofs: offset into type_strings_elem where the name of the element can be
 * found.
 * bit_offset: position within the structure
 * bit_length: length of this item; if 0, use type_idx
 * type_idx: index into type_list
 *
 * 8 bits are still unused; the compiler probably pads to 64 bit.
 */
struct struct_elem {
    unsigned int
	name_ofs : 16,		/* curr max 22000 */
	bit_offset : 14,	/* curr max 8224 */
	bit_length : 14,    	/* curr max ca. 600, if 0 look at type */
	type_idx : 12;		/* curr max 1350 */
};

extern const struct struct_elem elem_list[];
extern const int type_count;
extern const char type_strings_elem[];
extern const unsigned char type_strings_proto[];
extern const char type_strings_types[];


union gtk_arg_types {
    void	*p;		// 4 or 8 bytes
    long	l;
    long long	ll;		// 8 bytes
    double	d;
    float	f;
    int		i;
    signed char	sc;
    unsigned char uc;
};

/*-
 * ENUM and FLAG values are stored as a userdata with this structure.
 * Size: 12 bytes (96 bit)
 */
struct luagtk_enum_t {
    unsigned int value;		// current value
    GType	gtype;		// cache for GType of type_idx; unsigned int
    short int	type_idx;	// required 12 bits
    short int	enum_or_flags;	// 1=enum, 2=flags; 1 bit would be enough.
};
#define ENUM_META "enum_flags"
#define LUAGTK_TO_ENUM(L, idx) (struct luagtk_enum_t*) luaL_checkudata(L, \
    idx, ENUM_META)




/*-
 * All the lua2ffi_xxx and ffi2lua_xxx functions in types.c get this structure
 * as argument.  Passing the values individually would just be too much.
 */
struct argconv_t {
    lua_State	*L;
    int		func_arg_nr;	// number of argument to function
    const struct type_info *type;   // spec of the argument
    int		type_idx;	// for convenience, same info as in type
    int		index;		// location of the input value
    union gtk_arg_types *arg;	// location of the output value
    int		ffi_type_nr;
    const struct ffi_type_map_t *arg_type;
    int		lua_type;	// type of the input value
    struct call_info *ci;
};


typedef int (*lua2ffi_t)(struct argconv_t*);
typedef int (*ffi2lua_t)(struct argconv_t*);
typedef int (*lua2struct_t)(lua_State *L, const struct type_info *si,
    const struct struct_elem *se, unsigned char *ptr, int index);
typedef int (*struct2lua_t)(lua_State *L, const struct struct_elem *se,
	unsigned char *ptr);

/*-
 * One entry in the type map.  By replacing pointers by indices to separate
 * tables, the size of each entry is just 8 bytes.
 */
struct ffi_type_map_t {
    unsigned int
	name_ofs : 16,		// offset into ffi_type_names
	bit_len : 16,		// length in bits; max. 256
	indirections : 4,	// how many levels of pointers? max. 3
	flags2 : 4,		// see below

//	flags : 4,		// 0001=numeric, 0010=integer, 0100=const,
//				// 1000=compound

        lua2ffi_idx : 5,	// indices into the respective function tables
	ffi2lua_idx : 5,
	lua2struct_idx : 4,
	struct2lua_idx : 4,
	ffi_type_idx : 6;	// arg for FFI_TYPE() -> ffi_type*
};
extern struct ffi_type_map_t ffi_type_map[];
extern const int ffi_type_count;
extern const char ffi_type_names[];
extern const lua2ffi_t ffi_type_lua2ffi[];
extern const ffi2lua_t ffi_type_ffi2lua[];
extern const lua2struct_t ffi_type_lua2struct[];
extern const struct2lua_t ffi_type_struct2lua[];

#define FFI_CHAR_PTR_CONST 1	// for char_ptr: don't free this retval


// in types.c
unsigned long int luagtk_get_bits(const unsigned char *ptr, int bitofs,
    int bitlen);
void luagtk_empty_table(lua_State *L, int index);

// in voidptr.c
struct value_wrapper;
struct value_wrapper *luagtk_make_value_wrapper(lua_State *L, int index);
int luagtk_push_value_wrapper(lua_State *L, struct value_wrapper *wrp);
int lua2ffi_void_ptr(struct argconv_t *ar);
int luagtk_is_vwrapper(void *p);
int luagtk_userdata_to_ffi(lua_State *L, int index, union gtk_arg_types *dest,
    int only_ptr);
int luagtk_vwrapper_get(lua_State *L, struct value_wrapper *p);

// in enum.c
int luagtk_enum_push(lua_State *L, int value, int type_idx);
struct luagtk_enum_t *luagtk_enum_get(lua_State *L, int index, int type_idx,
    int raise_error);

/* Information about a function in the shared library.  This structure
 * is filled before calling luagtk_call. */
struct func_info {
    void *func;
    const char *name;		/* full name in dynamic library;
				   usually malloc()ed */
    const unsigned char *args_info;
    int args_len;
};

/*-
 * entry (type "userdata") in the meta table of a widget.  These entries are
 * created on the first access to a method or attribute to make later
 * uses quicker.
 */
struct meta_entry {
    int type_idx;			/* 0=function, else struct nr */
    union {
	struct func_info fi;		/* 16 bytes */
	const struct struct_elem *se;   /* 4 bytes */
    };
    int iface_type_idx;			/* see below */
    int iface_type_id;
    char name[0];
};
/* iface_*: if the meta_entry refers to a function found in an Interface,
 * then it can be overridden.  To make this assignment easier, i.e. avoid
 * searching all interfaces again, the type_idx of the interface is stored
 * here.  If 0, then this is not a virtual function.
 */


/*-
 * Widgets and structures are represented in Lua by this userdata.  It also
 * has a metatable that contains more information, see gtk2.c:get_widget_meta.
 *
 * The table "widgets" in the gtk environment maps the widget address to a
 * reference in widgets_aliases.  These aliases can form a singly linked
 * circular list.  Entries in the widget table are not weak; entries in the
 * aliases table are.  Garbage collection of aliases works like this:
 *
 *  - get the matching entry in "widgets" using the "p" field (pointer)
 *  - if "next" is not 0, follow until an alias is found whose "next" points
 *    to the current alias; set its "next" to this "next" or 0
 *  - if the "first" of the widgets entry points here, set it to this "next";
 *    if this was the last alias, remove the entry in widgets.
 *
 * widget_type: index into the widget_types table with names and pointers to
 * handler functions; these functions manage refcounting, which differs
 * between different types of objects.
 */

/*-
 * Entry in the "aliases" table.
 *
 * Note: storing a reference to the next entry is not enough.  During garbage
 * collection, some or all of the entries in "aliases" might be removed before
 * the GC methods are called.  The references therefore don't exist anymore.
 * So instead a pointer is stored.  This is OK because before a widget is
 * really free()d, it is removed from the circular list (if any).
 *
 * Size: 5*4 bytes = 20 on 32 bit, 28 byte on 64 bit architectures.
 */
struct widget {
    void *p;			/* addr of the widget & key to "widget" tbl */
    int type_idx;		/* index to type_list */
    int own_ref;		/* ref in gtk.aliases */
    unsigned int
	widget_type : 8,	/* how memory management is done */
	is_deleted : 1,		/* has been freed, *p is NULL */
	flags: 23;		/* meaning depends on type_idx */
    struct widget *next;	/* ptr to next alias, or NULL if just one */
};


// operations defined on widget type handlers
typedef enum {
    WIDGET_SCORE,
    WIDGET_GET_REFCOUNT,
    WIDGET_REF,
    WIDGET_UNREF,
} widget_op;

typedef int (*widget_handler)(struct widget*, widget_op, int);

struct widget_type {
    const char *name;
    widget_handler handler;
};


/*-
 * This structure holds all the variables describing a C function call.
 * Using this structure, the complex call function can be split into multiple
 * parts easily.  Additionally, elimination of global variables is good
 * for reentrancy (which isn't required, but still...).
 *
 * Due to the high MAX_FUNC_ARGS, this structure is quite large, about
 * 350 bytes.  To avoid repetitive malloc() and free() calls, a pool
 * is used.  No more than a few of these are allocated at any time.
 */
struct call_info {
    /* function info */
    lua_State *L;
    int index;			/* stack index of first parameter */
    struct func_info *fi;
    int warnings;		/* 0=no warning, 1=warning, 2=traced */

    /* arguments. [0] is for the return value */
    int arg_count;
    union gtk_arg_types ffi_args[MAX_FUNC_ARGS];
    ffi_type *argtypes[MAX_FUNC_ARGS];
    void *argvalues[MAX_FUNC_ARGS];	    /* [0] not used */
    char arg_flags[MAX_FUNC_ARGS];	    // to save state

    union {
	struct call_info_list *first;	    /* allocated extra memory */
	struct call_info *next;		    /* chain of free call_infos */
    };
};

/*-
 * Some functions from the dynamic libraries are used from this code.  To avoid
 * linking the DLL directly, they are looked up once at init time after
 * manually loading the DLL.  Calls are redirected to function pointers;
 * see script/make-link.lua for more information.
 */
typedef void (*linkfuncptr)();

// in build/.../link.c
extern linkfuncptr dl_link[];
extern const char dl_names[];

// in data.c
int luagtk_dl_init();
int luagtk_make_func_name(char *buf, int buf_size, const char *class_name,
    const char *attr_name);
int luagtk_g_type_from_name(const char *s);
void luagtk_type_name(lua_State *L, int type_idx, char *buf);
int find_func(const char *func_name, struct func_info *fi);
const struct type_info *find_struct(const char *class_name, int indirections);
const struct struct_elem *find_attribute(const struct type_info *si,
    const char *attr_name);
int find_enum(lua_State *L, const char *key, int keylen, int *result,
    int *type_idx);

// current max length of a type name is 45, plus "const " and ***
#define LUAGTK_NAMELEN 55
#define TYPE_NAME_VAR(varname, type_idx) char varname[LUAGTK_NAMELEN]; \
    luagtk_type_name(L, type_idx, varname)


// in debug.c
void luagtk_init_debug(lua_State *L);
int luagtk_breakfunc(lua_State *L);
int luagtk_tostring(lua_State *L);
void luagtk_call_trace(lua_State *L, struct func_info *fi, int index);

extern int runtime_flags;
#define RUNTIME_TRACE_ALL_CALLS	    1
#define RUNTIME_WARN_RETURN_VALUE   2	/* warn about unused return values */
#define RUNTIME_DEBUG_MEMORY	    4	/* show allocation and GC of widget */
#define RUNTIME_GMEM_PROFILE	    8	/* enable g_mem_profile */
#define RUNTIME_VALGRIND	    16	/* valgrind friendly */

// in widget.c
void luagtk_get_widget(lua_State *L, void *p, int type_idx, int flags);
int luagtk_register_widget_type(const char *name, widget_handler handler);
struct widget_type *luagtk_get_widget_type(struct widget *w);
struct widget *luagtk_check_widget(lua_State *L, int index);

// in widget_types.c
void luagtk_init_widget(lua_State *L);
void luagtk_guess_widget_type(lua_State *L, struct widget *w, int flags);
int luagtk_get_refcount(struct widget *w);
void luagtk_inc_refcount(struct widget *w, int flags);
void luagtk_dec_refcount(struct widget *w);

// in widget_meta.c
int luagtk_index(lua_State *L);
int luagtk_newindex(lua_State *L);


// flags to luagtk_get_widget.  The first one is just for documentation
// purposes.
#define FLAG_NOT_NEW_OBJECT 0
#define FLAG_NEW_OBJECT 1
#define FLAG_ALLOCATED 2

// in gtk2.c
extern const char msgprefix[];
void luagtk_init_gtk();
extern int gtk_is_initialized;
#define GTK_INITIALIZE() if (G_UNLIKELY(!gtk_is_initialized)) luagtk_init_gtk();

// in call.c
enum luagtk_msg_level { LUAGTK_DEBUG=0, LUAGTK_INFO, LUAGTK_WARNING,
    LUAGTK_ERROR };
int luagtk_call(lua_State *L, struct func_info *fi, int index);
int luagtk_call_byname(lua_State *L, const char *func_name);
void call_info_warn(struct call_info *ci);
void call_info_msg(struct call_info *ci, enum luagtk_msg_level level,
    const char *format, ...);
void *call_info_alloc_item(struct call_info *ci, int size);
void call_info_free_pool();
inline int get_next_argument(const unsigned char **p);
const struct type_info *luagtk_type_modify(const struct type_info *ti,
    int ind_delta);


// callback.c
int luagtk_connect(lua_State *L);
int luagtk_disconnect(lua_State *L);
void *luagtk_make_closure(lua_State *L, int index,
    const unsigned char *signature);

// channel.c
void luagtk_init_channel(lua_State *L);

// override.c
void luagtk_init_overrides(lua_State *L);

// gvalue.c
int luagtk_fill_gvalue(lua_State *L, GValue *gv, int type_nr, int index);
GValue *luagtk_set_gvalue(lua_State *L, GValue *gvalue, int index, int type);
void luagtk_push_gvalue(lua_State *L, GValue *gv);

#ifdef RUNTIME_LINKING
#include "link.h"
#endif

