/*
    Copyright (C) 2008 Andrew Caudwell (acaudwell@gmail.com)

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version
    3 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "main.h"

int main(int argc, char *argv[]) {

    //defaults
    int   width       = 1024;
    int   height      = 768;
    bool  fullscreen  = false;
    float simu_speed  = 1.0f;
    float update_rate = 5.0f;

    std::string logfile = "";

    std::vector<std::string> groupstr;

    for (int i=0; i<argc; i++) {
        debugLog("argv[%d] = %s\n", i, argv[i]);

        if(i==0) continue;

        std::string argstr(argv[i]);

        //if given a non option arg treat it as a file, or if it is '-', pass that too (stdin)
        if(argstr.rfind("-") != 0 || argstr.size()==1) {
            logfile = argstr;
        }

        if(argstr.compare("-?") == 0 || argstr.compare("-h") == 0) {
            logstalgia_help();
        }

        if(argstr.compare("-c") == 0) {
            gSplash = 15.0f;
        }

        if(argstr.compare("-x") == 0) {
            gMask = false;
        }

        if(argstr.compare("-s") == 0 && i+1<argc) {
            i++;
            simu_speed = (float) atoi(argv[i]);
            if(simu_speed < 1.0f || simu_speed > 30.0f) {
                logstalgia_help("-s: speed should be between 1 and 30\n");
            }
        }

        if(argstr.compare("-u") == 0 && i+1<argc) {
            i++;
            update_rate = (float) atoi(argv[i]);
            if(update_rate < 1.0f || update_rate > 60.0f) {
                logstalgia_help("-u: update rate should be between 1 and 60\n");
            }
        }

        //dont bounce
        if(argstr.compare("-b") == 0) {
            gBounce = false;
        }

        //dont draw response code
        if(argstr.compare("-r") == 0) {
            gResponseCode = false;
        }

        //no paddle
        if(argstr.compare("-p") == 0) {
            gPaddle = false;
        }

        //specify page url group
        if(argstr.compare("-g") == 0 && i+1<argc) {
            i++;
            groupstr.push_back(argv[i]);
        }
    }

    //wait for data before launching
    if(logfile.compare("-") == 0) {

        //set stdin to non-blocking
#ifndef _WIN32
            int ret = fcntl(STDIN_FILENO, F_GETFL, 0);
            if (fcntl (STDIN_FILENO, F_SETFL, ret | O_NONBLOCK) < 0) {
                debugLog("fcntl(stdin) failed: %s\n", strerror (errno));
                exit(1);
            }
#endif

        char line[1024];
        while( fgets(line, sizeof(line), stdin) == NULL ) {
            SDL_Delay(100);
        }
    }

    display.displayArgs(argc, argv, &width, &height, &fullscreen);

    display.init("Logstalgia", width, height, fullscreen);

    Logstalgia logs(logfile, simu_speed, update_rate);

    for(size_t i=0;i<groupstr.size();i++) {
        logs.addGroup(groupstr[i]);
    }

    logs.run();

    debugLog("\nExiting.\n");

    return 0;
}
