#!/usr/bin/perl
# This script configures dictionaries-common (sarge version > 0.20)
use strict;
use warnings;

require '/usr/lib/localization-config/common/log.pl';

my %lang_locale_map = (
    # entries sorted alphabetically
    'bs'              => 'Bosnian',
    'bg'              => 'Bulgarian',
    'ca'              => 'Catalan',
    'cs'              => 'Czech',
    'da'              => 'Danish',
    'de_BE'           => 'German (BE)',
    'de_CH'           => 'Swiss (DE)',
    'de_DE'           => 'German (DE)',
    'de'              => 'German',
    'el'              => 'Greek',
    'en_AU'           => 'Australian',
    'en_CA'           => 'Canadian',
    'en_IE'           => 'Irish (UK)',
    'ga'              => 'Irish',
    'gl'              => 'Galician',
    'en_GB'           => 'British',
    'gd'              => 'Scots Gaelic',
    'gv'              => 'Manx Gaelic',
    'kw'              => 'Cornish',
    'en_US'           => 'American (US)',
    'en'              => 'English',
    'es'              => 'Spanish',
    'es_AR'           => 'Spanish (AR)',
    'es_ES'           => 'Spanish (ES)',
    'es_MX'           => 'Spanish (MX)',
    'es_PE'           => 'Spanish (PE)',
    'fa'              => 'Faroe',
    'fi'              => 'Finnish',
    'fr_BE'           => 'French (BE)',
    'fr_CA'           => 'French (CA)',
    'fr_CH'           => 'Swiss (FR)',
    'fr'              => 'French',
    'he'              => 'Hebrew',
    'hu'              => 'Hungarian',
    'it'              => 'Italian',
    'ja'              => 'Japanese',
    'ko'              => 'Korean',
    'lv'              => 'Latvian',
    'lt'              => 'Lithuanian',
    'mk'              => 'Macedonian',
    'nb'              => 'Norwegian',
    'nds_DE'          => 'German (ndk)',
    'nl_BE'           => 'Dutch (BE)',
    'nl'              => 'Dutch',
    'nn'              => 'New Norwegian',
    'no'              => 'Norwegian',
    'pa'              => 'Punjabi (Gumurkhi)',
    'pl'              => 'Polish',
    'pt'              => 'Portuguese',
    'pt_BR'           => 'Brazilian',
    'ru'              => 'Russian',
    'se'              => 'Saami',
    'sk'              => 'Slovakian',
    'sl'              => 'Slovenian',
    'sq'              => 'Albanian',
    'sv'              => 'Swedish',
    'sv_FI'           => 'Swedish (FI)',
    'th'              => 'Thai',
    'tr'              => 'Turkish',
    'tl'              => 'Tagalog',
    'uk'              => 'Ukrainian',
) ;

sub get_lang_map() {
    return %lang_locale_map;
}

# This is a bit complicated. If the locale passed as an argument is not on 
# the %locale_lang_map, then the script will try to do its best to guess 
# what's the closest locale in the map.
# First it will strip the the @euro part, then the encoding, the country and
# if even that fails, only the language letters will remain, and it will do 
# a search in the map for all the locales that match the language (convenient
# for weird combinations). It will then take the first entry there (hm, 
# something screams for a priority list here, but later).

sub choose_language {
    my $stage = 1;
    my ($lng, $locale_lang_map) = @_;
    while ($stage > 0) {
        if (defined($locale_lang_map->{$lng})) {
            log_msg("$0:choose_language(): Found $lng =>\t".$locale_lang_map->{$lng});
            
            return $locale_lang_map->{$lng};
        } else {
            if ($stage == 1) {
                my @keys = grep /^$lng.*$/, keys %$locale_lang_map;
                if (defined($keys[0])) {
                    $lng = $keys[0];
                }
                $stage++;
            } elsif ($stage == 2) {
                log_msg("$0:choose_language(): $lng not defined!");
                log_msg("$0:choose_language(): removing part after \@ (if any)...");
                $lng =~ s/\@.*$//g;
                $stage++;
            } elsif ($stage == 3) {
                log_msg("$0:choose_language(): $lng not defined!");
                log_msg("$0:choose_language(): removing encoding (if any)...");
                $lng =~ s/\..*$//g;
                $stage++;
            } elsif ($stage == 4) {
                log_msg("$0:choose_language(): $lng not defined!");
                log_msg("$0:choose_language(): removing country part (if any)...");
                $lng =~ s/\_.*$//g;
                $stage++;
            } elsif ($stage == 5) {
                log_msg("$0:choose_language(): $lng not defined!");
                log_msg("$0:choose_language(): last chance, will take the first entry from a search in the list...");
                my @keys = grep /^$lng.*$/, keys %$locale_lang_map;
                foreach my $item (@keys) {
                    log_msg("$0:choose_language(): item: $item");
                }
                if (defined($keys[0])) {
                    $lng = $keys[0];
                    $stage++;
                } else {
                    log_msg("$0:choose_language(): nothing found...");
                    $stage = 0;
                }
            } else {
                log_msg("$0:choose_language(): $lng not defined!");
                log_msg("$0:choose_language(): can't do anything more...");
                $stage = 0;
            }
            log_msg("$0:choose_language(): lng = ".$lng);
        }
    }
}

1;
