/* (C) Marcin Kwadrans <quar@vitea.pl> */

/*! \file project.h 
	\brief Zarządzanie projektami
*/

#ifndef __LW_PROJECT_H
#define __LW_PROJECT_H

#include <libxml/tree.h>

#include "board.h"

/*! \class LWProject
	\brief Zarządzanie projektem

	Zarządzanie projektem, składającym się ze świata oraz programu.
	Klasa umożliwia również zapis oraz odczyt projektów z plików XML.
*/

class LWProject {
LWBoard *world;
LWBoard *program;
gchar *file_name;	
void setFileName (const gchar *a_file_name);
public:
LWProject ();
~LWProject ();
gboolean load (const gchar *file_name);
gboolean save (const gchar *file_name);
gchar *getFileName ();
LWBoard *getWorld ();
LWBoard *getProgram ();
};

#endif
