#include <qimage.h>
#include "vlvisibleboxtableitem.h"

static const unsigned char eye_image_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x14,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x8d, 0x89, 0x1d, 0x0d, 0x00, 0x00, 0x01,
    0xf7, 0x49, 0x44, 0x41, 0x54, 0x38, 0x8d, 0xed, 0x92, 0x4f, 0x48, 0x93,
    0x71, 0x18, 0xc7, 0x3f, 0xbf, 0xfe, 0x10, 0x0d, 0x62, 0x63, 0x0b, 0x9b,
    0x7b, 0xed, 0x9d, 0xa0, 0xe2, 0xa1, 0xa0, 0xa6, 0xd3, 0x5a, 0x76, 0xd8,
    0x9a, 0x46, 0x87, 0xda, 0x24, 0xa4, 0x9a, 0xa7, 0x08, 0x3a, 0x44, 0x75,
    0x90, 0xd1, 0x32, 0x3c, 0x0f, 0x5e, 0x16, 0x14, 0x58, 0xd7, 0x75, 0x0b,
    0x8a, 0xa8, 0xd6, 0x76, 0x88, 0xec, 0x1f, 0x6d, 0x98, 0x5e, 0xec, 0x92,
    0x7f, 0xb6, 0xca, 0x53, 0xd6, 0x48, 0x48, 0x52, 0x0b, 0x7d, 0xc7, 0xd6,
    0xaf, 0x83, 0x2f, 0xcb, 0x74, 0x42, 0x47, 0x0f, 0x7e, 0xe0, 0x77, 0xf9,
    0x3e, 0xf0, 0xfd, 0x3d, 0xcf, 0xf7, 0x79, 0x60, 0x83, 0x75, 0x87, 0x58,
    0xab, 0xa0, 0xc5, 0xa2, 0x2e, 0xe0, 0xf7, 0x0a, 0x79, 0x93, 0xa1, 0xe5,
    0x7b, 0x23, 0x7d, 0xd3, 0xff, 0x65, 0xa8, 0xc5, 0xa2, 0x7b, 0x80, 0xbd,
    0x40, 0x23, 0x10, 0x00, 0x9a, 0x97, 0x95, 0x33, 0xc0, 0x18, 0xf0, 0x00,
    0x18, 0xad, 0x64, 0xba, 0x79, 0x85, 0xd9, 0x3e, 0xc0, 0x07, 0xc4, 0x01,
    0xdf, 0xc1, 0xd6, 0xb6, 0x2f, 0xef, 0x3e, 0x6f, 0x51, 0x9e, 0x8e, 0xcc,
    0x32, 0xfe, 0x55, 0x60, 0xb7, 0x3b, 0x9c, 0xf5, 0x8a, 0xd9, 0x39, 0x3f,
    0x3f, 0x77, 0x01, 0xa8, 0x6b, 0xef, 0xf0, 0xe7, 0x5e, 0x3c, 0x7f, 0xf5,
    0x6d, 0x55, 0x87, 0x5a, 0x2c, 0x5a, 0x07, 0xd4, 0x02, 0x4e, 0x20, 0xee,
    0xb0, 0xef, 0x9e, 0xf5, 0x78, 0x3c, 0xe6, 0xfe, 0x87, 0xa3, 0xf4, 0x5f,
    0xed, 0x04, 0xc0, 0x71, 0xf8, 0x32, 0x36, 0xa5, 0x01, 0x5f, 0x93, 0x4a,
    0x38, 0xe4, 0xe2, 0xde, 0xfd, 0xbb, 0x00, 0xaf, 0x81, 0x2b, 0xbd, 0x91,
    0xbe, 0x91, 0x72, 0x26, 0x5a, 0x2c, 0xda, 0x0a, 0xb4, 0x00, 0x5d, 0x40,
    0xbc, 0x7a, 0x57, 0x8d, 0xee, 0xf5, 0x7a, 0xcd, 0x8a, 0xa2, 0x90, 0x4a,
    0x67, 0xcb, 0x3f, 0xe7, 0x07, 0x6f, 0x53, 0xa3, 0x56, 0x93, 0x4a, 0x67,
    0x31, 0x6d, 0x37, 0x71, 0xaa, 0xeb, 0x0c, 0xc6, 0x34, 0x61, 0x2d, 0x16,
    0x3d, 0xb9, 0x3c, 0xe4, 0xef, 0xc0, 0x0e, 0xa0, 0x01, 0x20, 0x10, 0x08,
    0x6c, 0xb3, 0x58, 0x2c, 0x48, 0x29, 0xcb, 0x9d, 0x09, 0xb1, 0x14, 0xf5,
    0xe2, 0x82, 0x0e, 0x80, 0x94, 0x12, 0xab, 0xd5, 0xc6, 0xb9, 0xb3, 0xe7,
    0x01, 0x42, 0x40, 0x9b, 0x31, 0xe5, 0xdf, 0xa5, 0x24, 0x53, 0x89, 0xe0,
    0xf8, 0xc4, 0xd8, 0x45, 0xa0, 0x23, 0xdc, 0x13, 0xa1, 0x54, 0x2a, 0x71,
    0xed, 0xd6, 0x33, 0x32, 0xef, 0xf3, 0xec, 0xac, 0xb2, 0xb2, 0xb8, 0xa0,
    0xa3, 0xeb, 0x05, 0xdc, 0xf5, 0x56, 0x6e, 0x84, 0x8f, 0x33, 0x39, 0xf9,
    0x89, 0x44, 0xf2, 0x11, 0x00, 0xaa, 0x5a, 0x7b, 0x33, 0x74, 0xba, 0xfb,
    0xba, 0x10, 0x22, 0x5f, 0x36, 0x94, 0x52, 0x9a, 0xd2, 0x99, 0x37, 0xa1,
    0xa1, 0xe1, 0xc1, 0x4b, 0xc0, 0xfe, 0xe0, 0x89, 0x4e, 0x8a, 0x5b, 0xad,
    0x24, 0xd3, 0x39, 0x0a, 0xc5, 0x12, 0x73, 0xbf, 0x74, 0x1a, 0x55, 0x1b,
    0xc1, 0x43, 0x2a, 0x1f, 0x3e, 0x66, 0x19, 0x1a, 0x7e, 0x0b, 0x70, 0xa7,
    0xb9, 0xc9, 0xfd, 0xb2, 0xdd, 0x7f, 0x34, 0x01, 0x14, 0x84, 0x10, 0xc5,
    0x55, 0x67, 0x23, 0xa5, 0x74, 0x24, 0x92, 0x8f, 0x7b, 0x72, 0xb9, 0x89,
    0x63, 0x2c, 0x9d, 0x4f, 0x25, 0x06, 0x8e, 0xf8, 0xfc, 0x03, 0x2d, 0xee,
    0x03, 0x4f, 0x80, 0x19, 0x21, 0xc4, 0xcc, 0x3f, 0x5b, 0xae, 0x84, 0x94,
    0xb2, 0x0a, 0x70, 0x01, 0x12, 0x50, 0x0d, 0x79, 0x0a, 0x98, 0x06, 0x7e,
    0x18, 0xef, 0xa7, 0x10, 0xa2, 0xb0, 0x96, 0xc7, 0x06, 0xeb, 0x84, 0x3f,
    0x03, 0x0d, 0xa6, 0x56, 0x0d, 0x3b, 0x36, 0xe4, 0x00, 0x00, 0x00, 0x00,
    0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};

vlVisibleBoxTableItem::vlVisibleBoxTableItem(QTable* t)
    : QTableItem(t, QTableItem::Always)
{
    setReplaceable(false);
    m_visible = true;    
    QImage img;
    img.loadFromData(eye_image_data, sizeof(eye_image_data), "PNG");
    m_eye_image = img;
}

vlVisibleBoxTableItem::~ vlVisibleBoxTableItem( )
{
   /*if(m_pbutton != NULL) {
      delete m_pbutton;
   }*/
}

QWidget* vlVisibleBoxTableItem::createEditor() const {
    
   ((vlVisibleBoxTableItem *)this)->m_pbutton = 
        new QPushButton(table()->viewport());
       
    m_pbutton->setPixmap (m_eye_image);
    connect(m_pbutton, SIGNAL(clicked()), this, SLOT(buttonClicked()));

    return m_pbutton;
}

void vlVisibleBoxTableItem::setContentFromEditor(QWidget* widget) {
    QTableItem::setContentFromEditor(widget);
}

void vlVisibleBoxTableItem::setText(const QString &s) {
    QTableItem::setText(s);
}

void vlVisibleBoxTableItem::buttonClicked() {
    
    // toogle state
    m_visible = !m_visible;
    
    // icon anpassen
    if(!m_visible) {
       m_pbutton->setPixmap(0); 
    }
    else {
        m_pbutton->setPixmap(m_eye_image);
    }
    
    // den Rest der Welt benachrichtigen, dass sich in Zeile row() die
    // Sichtbarkeit des Segments geaendert hat.
    emit visibilityChanged(m_visible, row());
}

