/****************************************************************
 *
 * vdictov: convert.H
 *
 * Copyright (C) Max Planck Institute 
 * for Human Cognitive and Brain Sciences, Leipzig
 *
 * Author Thomas Arnold, 2002, <lipsia@cbs.mpg.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * $Id: convert.H 687 2004-02-12 09:29:58Z karstenm $
 *
 *****************************************************************/

#ifndef CONVERT_H_INCLUDED
#define CONVERT_H_INCLUDED

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <float.h>
#include <math.h>
#include <time.h>
#include <assert.h>

extern "C"
{
   #include <Vlib.h>
   #include <VImage.h>
   #include <option.h>
   #include <mu.h>
}


/*------------------------------------------------------------------------------

ConvertType
===========

Src    source image with voxels of type T
Dest   converted image with voxels of type U (created)
Type   type of created image (MUST correspond to type U)

------------------------------------------------------------------------------*/

template <class T, class U> void ConvertType (VImage Src, VImage& Dest, VRepnKind Type)
{
   int Voxels;   /* number of voxels */

   T* src;    /* source data pointer      */
   U* dest;   /* destination data pointer */

   long n;   /* index */


   /* get source image size */
   Voxels = VImageNPixels (Src);

   /* create converted image */
   Dest = VCreateImage (VImageNBands (Src), VImageNRows (Src), VImageNColumns (Src), Type);
   VImageAttrList (Dest) = VCopyAttrList (VImageAttrList (Src));


   /* convert image */
   src  = (T*) VPixelPtr (Src,  0, 0, 0);
   dest = (U*) VPixelPtr (Dest, 0, 0, 0);
   for (n = 0; n < Voxels; n++)
      *(dest++) = (U) *(src++);

} /* ConvertType */

template <class T, class U> void ConvertType (VImage& Src, VRepnKind Type)
{
   VImage Dest;   /* destination image */


   /* convert image */
   ConvertType<T,U> (Src, Dest, Type);
   VDestroyImage (Src);
   Src = Dest;

} /* ConvertType */

/*----------------------------------------------------------------------------*/

#endif
