/***************************************************************************
                          |FILENAME|  -  description
                             -------------------
    begin                : |DATE|
    copyright            : (C) |YEAR| by |AUTHOR|
    email                : |EMAIL|
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include <qvariant.h>
#include <qradiobutton.h>
#include <qslider.h>
#include <qlayout.h>
#include <qpainter.h>
#include <qstyle.h>
#include <qlabel.h>

#include <qdrawutil.h>
#include <qpalette.h>

#include "csquelch.h"
#include "color.h"

#define Black color[0]
#define Grey  color[64]
#define Cyan  color[127]
#define Yellow color[192]

mySlider::mySlider(QWidget *parent, const char *name = 0) :
QSlider(parent,name)
{
    setOrientation( QSlider::Vertical );
    setTickmarks( QSlider::NoMarks );
    setTickInterval( 10 );
    setMinValue(0);
    setMaxValue(100);

setValue(50);
SquelchLevel=0;


}

mySlider::~mySlider()
{
}
/** Painting Slider Background depending on Threshold and Signal Strength
*/

void mySlider::paintEvent(QPaintEvent *)
{

QPainter p;

QColorGroup cg(colorGroup());
const QColor c0 = cg.shadow();
const QColor c1 = cg.dark();
const QColor c3 = cg.light();
QColor c4;

int scale;

//p=new QPainter();
p.begin(this);

int mid = this->width()/2;
QRect groove = this->rect();
QRect handle = this->sliderRect();
                
int x, y, w, h;
             
if ( this->orientation() == Horizontal )
 {
  x = 0;
  y = groove.y() + mid - 3;
  w = this->width();
  h = 7;
 }
 else
 {
   
   x = groove.x() + mid - 3;
   
   w = 10;
   y = w/2;
   h = this->height()-w;
 }
p.fillRect( x, y, w, h, c1);
scale=(h*(100-SquelchLevel))/100;

if (SquelchLevel > (100-value()) )
  c4=Yellow;
else
 c4 = Cyan;
 
if ( SquelchLevel == 0  )
 c4 = c1;

// the dark side
p.setPen( c1 );
//p->drawLine( x, y, x + w - 1, y );
p.drawLine( x, y, x, y + h - 1);
p.setPen( c0 );
//p->drawLine( x + 1, y + 1, x + w - 2, y + 1 );
p.drawLine( x + 1, y + 1, x + 1, y + h - 2 );
// the bright side!

p.drawLine( x + 1,  y + h - 2, x + w - 2,  y + h - 2 );
p.drawLine( x + w - 2, y + 1, x + w - 2, y + h - 2 );
p.setPen( c3 );
p.drawLine( x, y + h - 1, x + w - 1, y + h - 1 );
p.drawLine( x + w - 1, y, x + w - 1, y + h - 1 );

p.fillRect(x+1,y+scale,w-2,h-scale,c4);       

p.setBrush(c1);
p.setPen(c1);
p.drawPie(x,y-w/2,w-1,w-1,0,2880);
p.setBrush(c4);
p.setPen(c4);
p.drawPie(x,h,w-1,w-1,2880,2880);
p.setPen(c1);
p.drawArc(x,h,w-1,w-1,2880,1440);
p.setPen( c3 );
p.drawArc(x,h,w-1,w-1,4320,1440);

// ### end slider groove

// Slider Handle
                int x1 = handle.x();
                int x2 = handle.x() + handle.width() - 1;
                int y1 = handle.y();
                int y2 = handle.y() + handle.height() - 1;
                int mx = handle.width() / 2;
                int my = handle.height() / 2;

                if ( this->orientation() == Vertical ) {
                    // Background
                    QBrush oldBrush = p.brush();
                    p.setBrush( cg.brush( QColorGroup::Button ) );
                    p.setPen( NoPen );
                    QPointArray a(6);
                    a.setPoint( 0, x1 + 1, y1 + 1 );
                    a.setPoint( 1, x2 - my + 2, y1 + 1 );
                    a.setPoint( 2, x2 - 1, y1 + my - 1 );
                    a.setPoint( 3, x2 - 1, y2 - my + 1 );
                    a.setPoint( 4, x2 - my + 2, y2 - 1 );
                    a.setPoint( 5, x1 + 1, y2 - 1 );
                    p.drawPolygon( a );
                    p.setBrush( oldBrush );

                    // shadow border
                    p.setPen( c0 );
                    p.drawLine( x1, y1 + 1, x1,y2 - 1 );
                    p.drawLine( x2 - my + 2, y1, x2, y1 + my - 2 );
                    p.drawLine( x2 - my + 2, y2, x2, y1 + my + 2 );
                    p.drawLine( x2, y1 + my - 2, x2, y1 + my + 2 );
                    p.drawLine( x1 + 1, y1, x2 - my + 2, y1 );
                    p.drawLine( x1 + 1, y2, x2 - my + 2, y2 );

                    // light shadow
                    p.setPen( c3 );
                    p.drawLine( x1 + 1, y1 + 2, x1 + 1, y2 - 2 );
                    p.drawLine( x1 + 1, y1 + 1, x2 - my + 2, y1 + 1 );
                    p.drawLine( x2 - my + 2, y1 + 1, x2 - 1, y1 + my - 2 );

                    // dark shadow
                    p.setPen(c1);
                    p.drawLine( x2 - 1, y1 + my - 2, x2 - 1, y1 + my + 2 );
                    p.drawLine( x2 - my + 2, y2 - 1, x2 - 1, y1 + my + 2 );
                    p.drawLine( x1 + 1, y2 - 1, x2 -my + 2, y2 - 1 );

                } else {  // Horizontal
                    QBrush oldBrush = p.brush();
                    p.setBrush( cg.brush( QColorGroup::Button ) );
                    p.setPen( NoPen );
                    QPointArray a(6);
                    a.setPoint( 0, x2 - 1, y1 + 1 );
                    a.setPoint( 1, x2 - 1, y2 - mx + 2 );
                    a.setPoint( 2, x2 - mx + 1, y2 - 1 );
                    a.setPoint( 3, x1 + mx - 1, y2 - 1 );
                    a.setPoint( 4, x1 + 1, y2 - mx + 2 );
                    a.setPoint( 5, x1 + 1, y1 + 1 );
                    p.drawPolygon( a );
                    p.setBrush( oldBrush );

                    // shadow border
                    p.setPen( c0 );
                    p.drawLine( x1 + 1, y1, x2 - 1, y1 );
                    p.drawLine( x1, y2 - mx + 2, x1 + mx - 2, y2 );
                    p.drawLine( x2, y2 - mx + 2, x1 + mx + 2, y2 );
                    p.drawLine( x1 + mx - 2, y2, x1 + mx + 2, y2 );
                    p.drawLine( x1, y1 + 1, x1, y2 - mx + 2 );
                    p.drawLine( x2, y1 + 1, x2, y2 - mx + 2 );

                    // light shadow
                    p.setPen(c3);
                    p.drawLine( x1 + 1, y1 + 1, x2 - 1, y1 + 1 );
                    p.drawLine( x1 + 1, y1 + 1, x1 + 1, y2 - mx + 2 );

                    // dark shadow
                    p.setPen(c1);
                    p.drawLine( x2 - 1, y1 + 1, x2 - 1, y2 - mx + 2 );
                    p.drawLine( x1 + 1, y2 - mx + 2, x1 + mx - 2, y2 - 1 );
                    p.drawLine( x2 - 1, y2 - mx + 2, x1 + mx + 2, y2 - 1 );
                    p.drawLine( x1 + mx - 2, y2 - 1, x1 + mx + 2, y2 - 1 );

	}



p.end();


}

void mySlider::setSquelchLevel(int level)
{
SquelchLevel=level;
repaint();
}

int mySlider::getThreshold()
{
return 100-value();
}

/* 
 *  Constructs a CSquelch which is a child of 'parent', with the 
 *  name 'name'.' 
 */
CSquelch::CSquelch( QWidget* parent,  const char* name )
    : QGroupBox( parent, name )
{
    setFrameShape( QGroupBox::WinPanel );
    setFrameShadow( QGroupBox::Raised );
    setAlignment( int( QGroupBox::AlignHCenter ) );

    Activate = new QRadioButton( this, "Activate" );
    Activate->setGeometry( QRect( 120, 340, 60, 41 ) );
    ActivateText = new QLabel(this,"ActivateText");
    ActivateText->setAlignment(AlignHCenter);
 

    Squelch = new mySlider( this, "Squelch" );
 //   Squelch->setPaletteBackgroundColor( QColor( 0, 0, 0 ) );
    Squelch->setOrientation( QSlider::Vertical );
    Squelch->setTickmarks( QSlider::NoMarks );
    Squelch->setTickInterval( 10 );
    Squelch->setMinValue(0);
    Squelch->setMaxValue(100);

   
    languageChange();

}

/*
 *  Destroys the object and frees any allocated resources
 */
CSquelch::~CSquelch()
{
    // no need to delete child widgets, Qt does it all for us
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void CSquelch::languageChange()
{
    setTitle( tr( "Squelch" ) );
    ActivateText->setText( tr( "On/Off" ) );
}
void CSquelch::resizeEvent( QResizeEvent * )
{
calculateSizeofComponents();
}

void CSquelch::calculateSizeofComponents()
{
/** Margins **/
#define TOPMARGIN 10
/** WIDTH and Height in % **/
#define SQUELCHWIDTH 25
#define SQUELCHHEIGHT 70
#define BUTTONWIDTH 90
#define BUTTONHEIGHT 10

int xpos,ypos, width,height,innerwidth,innerheight;

width=this->width();
height=this->height();
innerwidth=width*SQUELCHWIDTH/100;
xpos=(width-innerwidth)/2;
ypos=height*TOPMARGIN/100;
innerheight=height*SQUELCHHEIGHT/100;
Squelch->setGeometry(xpos,ypos,innerwidth,innerheight);
ypos=ypos+innerheight;
innerheight=height*BUTTONHEIGHT/100;
Activate->setGeometry(xpos,ypos,innerwidth,innerheight);
innerwidth=width*BUTTONWIDTH/100;
xpos=(width-innerwidth)/2;
ypos=ypos+innerheight;
ActivateText->setGeometry(xpos,ypos,innerwidth,innerheight);

this->setFrameRect(QRect(0,0,width,height));
}


void CSquelch::setSquelchLevel(int level)
{
Squelch->setSquelchLevel(level);
repaint();

}
int CSquelch::getThreshold()
{
return Squelch->getThreshold();
}
bool CSquelch::getSquelchState()
{
return Activate->isOn();
}
void CSquelch::setSquelchState(bool state)
{
Activate->setChecked(state);
}
void CSquelch::setThreshold(int Threshold)
{
Squelch->setValue(100-Threshold);
}
