/*
 * Line6 Linux USB driver - 0.7.3
 *
 * Copyright (C) 2005-2008 Markus Grabner (grabner@icg.tugraz.at)
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation, version 2.
 *
 */

#ifndef USBDEFS_H
#define USBDEFS_H


#include <linux/version.h>


#define LINE6_VENDOR_ID  0x0e41

#define USB_INTERVAL_UNIT 0.001

/*
	Device ids.
*/
#define LINE6_DEVID_BASSPODXT     0x4250
#define LINE6_DEVID_BASSPODXTLIVE 0x4642
#define LINE6_DEVID_BASSPODXTPRO  0x4252
#define LINE6_DEVID_PODXT         0x5044
#define LINE6_DEVID_PODXTLIVE     0x4650
#define LINE6_DEVID_PODXTPRO      0x5050
#define LINE6_DEVID_POCKETPOD     0x5051
#define LINE6_DEVID_TONEPORT_UX1  0x4141
#define LINE6_DEVID_TONEPORT_UX2  0x4142
#define LINE6_DEVID_VARIAX        0x534d

#define LINE6_BIT_BASSPODXT       (1 << 0)
#define LINE6_BIT_BASSPODXTLIVE   (1 << 1)
#define LINE6_BIT_BASSPODXTPRO    (1 << 2)
#define LINE6_BIT_PODXT           (1 << 3)
#define LINE6_BIT_PODXTLIVE       (1 << 4)
#define LINE6_BIT_PODXTPRO        (1 << 5)
#define LINE6_BIT_POCKETPOD       (1 << 6)
#define LINE6_BIT_VARIAX          (1 << 7)
#define LINE6_BIT_TONEPORT_UX1    (1 << 8)
#define LINE6_BIT_TONEPORT_UX2    (1 << 9)

#define LINE6_BITS_PRO            (LINE6_BIT_BASSPODXTPRO | LINE6_BIT_PODXTPRO)
#define LINE6_BITS_LIVE           (LINE6_BIT_BASSPODXTLIVE | LINE6_BIT_PODXTLIVE)
#define LINE6_BITS_PODXTALL       (LINE6_BIT_PODXT | LINE6_BIT_PODXTLIVE | LINE6_BIT_PODXTPRO)
#define LINE6_BITS_BASSPODXTALL   (LINE6_BIT_BASSPODXT | LINE6_BIT_BASSPODXTLIVE | LINE6_BIT_BASSPODXTPRO)

#define LINE6_FALLBACK_INTERVAL 10
#define LINE6_FALLBACK_MAXPACKETSIZE 16


#if LINUX_VERSION_CODE < KERNEL_VERSION(2, 6, 18)
#define usb_interrupt_msg(usb_dev, pipe, data, len, actual_length, timeout) \
usb_bulk_msg(usb_dev, pipe, data, len, actual_length, timeout)
#endif


#endif
