/***********************************************************************************

	Copyright (C) 2007-2010 Ahmet Öztürk (aoz_2@yahoo.com)

	This file is part of Lifeograph.

	Lifeograph is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Lifeograph is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_ENTRY_HEADER
#define LIFEOGRAPH_ENTRY_HEADER


#include "diarydata.hpp"


namespace LIFEO
{

class Entry : virtual public DiaryElement
{
	public:
		struct Shower
		{
			virtual void show( Entry& ) = 0;
			virtual void prepare_for_hiding( Entry& ) = 0;
		};

	typedef sigc::signal< void, Entry* >
								Signal_void_Entry;

								Entry( const Date&, const Glib::ustring&, bool = false );
								Entry( const Date&, bool = false );
		virtual					~Entry() {}

		void					show( void );
		void					prepare_for_hiding( void );

		const Glib::ustring&	get_text() const { return m_text; }
		Glib::ustring&			get_text() { return m_text; }
		void					set_text( const Glib::ustring &text )
		{ m_text = text; }

		Date					get_date( void ) const { return m_date; }
		Glib::ustring			get_date_created_str( void ) const;
		Glib::ustring			get_date_changed_str( void ) const;
		void					set_date( Date date )
		{ m_date = date; }

		int						get_size( void ) const
		{ return m_text.size(); }
		Type					get_type( void ) const
		{ return IT_ENTRY; }
		Glib::RefPtr< Gdk::Pixbuf >&
								get_icon( void ) const;

		Glib::ustring			get_title( void ) const;

		Glib::ustring			get_1st_str( void ) const
		{ return m_date.format_string(); }
		Glib::ustring			get_2nd_str( void ) const;

		bool					get_filtered_out( void );
		void					set_filtered_out( bool filteredout = true )
		{ m_flag_filteredout = filteredout; }

		bool					is_favored( void ) const { return m_option_favored; }
		void					set_favored( bool favored ) { m_option_favored = favored; }

		bool					get_spellcheck( void ) const
		{ return m_option_spellcheck; }
		void					set_spellcheck( bool opt_spell )
		{ m_option_spellcheck = opt_spell; }

		void					set_tags( const Tagset& );
		const Tagset&			get_tags( void ) const;
		Tagset&					get_tags( void );
		bool					add_tag( Tag* );
		bool					remove_tag( Tag* );

		// BEWARE: theme may be NULL indicating default Diary theme
		const Theme*			get_theme( void ) const
		{ return m_ptr2theme; }
		void					set_theme( const Theme *theme )
		{ m_ptr2theme = theme; }

	protected:
		Date					m_date;
		time_t					m_date_created;
		time_t					m_date_changed;
		Glib::ustring			m_text;
		Tagset					m_tags;
		const Theme				*m_ptr2theme;

		bool					m_option_favored;
		bool					m_option_spellcheck;	// TODO: per entry spellcheck
		bool					m_flag_filteredout;

		// GUI data
		static Shower			*shower;

	friend class Diary;	// TODO: remove this friendship too??
	friend class DiaryView;	// TODO: remove this friendship too??
	friend class EntryView;
};

// ENTRY SET ===================================================================
class PoolEntries : public std::map< Date::date_t, Entry*, FuncCompareDates >
{
	public:
									PoolEntries( void )
		:	std::map< Date::date_t, Entry*, FuncCompareDates >( compare_dates ) {}
									~PoolEntries();

		void						clear( void );
};

} // end of namespace LIFEO

#endif

