/***********************************************************************************

	Copyright (C) 2009 Ahmet Öztürk (aoz_2@yahoo.com)

	This file is part of Lifeograph.

	Lifeograph is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Lifeograph is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_DIALOG_CHAPTEREDITOR_HEADER
#define LIFEOGRAPH_DIALOG_CHAPTEREDITOR_HEADER


#include <gtkmm/dialog.h>
#include <gtkmm/treeview.h>
#include <gtkmm/liststore.h>
#include <gtkmm/button.h>
#include <gtkmm/stock.h>

#include "lifeobase.hpp"
#include "diary.hpp"


namespace LIFEO
{
	namespace STRING
	{
		const char NOT_SET_ITALIC[] = N_("<i>not set</i>");
	}

class CellrendererTextEditable : public Gtk::CellRendererText
{
	public:
};

class ColrecSetChapters : public Gtk::TreeModel::ColumnRecord
{
	public:
		ColrecSetChapters()
		{
			add( m_name );
			add( m_ptr2set );
		}

		// COLUMNS
		Gtk::TreeModelColumn< Glib::ustring >		m_name;
		Gtk::TreeModelColumn< CategoryChapters* >	m_ptr2set;
};

class ColrecChapter : public Gtk::TreeModel::ColumnRecord
{
	public:
		ColrecChapter()
		{
			add( m_name );
			add( m_date );
			add( m_ptr2chapter );
		}

		// COLUMNS
		Gtk::TreeModelColumn< Glib::ustring >		m_name;
		Gtk::TreeModelColumn< Glib::ustring >		m_date;
		Gtk::TreeModelColumn< Chapter* >			m_ptr2chapter;
};


class DialogChaptereditor : public DialogEvent
{
	public:
		explicit						DialogChaptereditor( Diary* );

		void							populate_sets( void );
		void							populate_chapters( const CategoryChapters* );

		bool							is_sets_changed( void )
		{ return m_flag_sets_changed; }

		void							handle_sets_selection_changed( void );
		void							handle_chapters_selection_changed( void );

		void							handle_editing_setname(
												Gtk::CellEditable*,
												const Glib::ustring& );
		void							handle_editing_chaptername(
												Gtk::CellEditable*,
												const Glib::ustring& );
		void							handle_editing_chapterdate(
												Gtk::CellEditable*,
												const Glib::ustring& );

		void							handle_edited_setname(
												const Glib::ustring&,
												const Glib::ustring& );
		void							handle_edited_chaptername(
												const Glib::ustring&,
												const Glib::ustring& );
		void							handle_edited_chapterdate(
												const Glib::ustring&,
												const Glib::ustring& );

		void							handle_celldata_setname(
												Gtk::CellRenderer*,
												const Gtk::TreeModel::iterator& );
		void							handle_celldata_chaptername(
												Gtk::CellRenderer*,
												const Gtk::TreeModel::iterator& );
		void							handle_celldata_chapterdate(
												Gtk::CellRenderer*,
												const Gtk::TreeModel::iterator& );

		void							add_set( void );
		void							add_chapter( void );
		void							remove_set( void );
		void							remove_chapter( void );

	protected:
		Gtk::TreeView					*m_treeview_sets;
		Gtk::TreeView					*m_treeview_chapters;
		CellrendererTextEditable		*m_cellrenderertext_setname;
		CellrendererTextEditable		*m_cellrenderertext_chaptername;
		CellrendererTextEditable		*m_cellrenderertext_chapterdate;
		Gtk::TreeViewColumn				*m_treecolumn_setname;
		Gtk::TreeViewColumn				*m_treecolumn_chaptername;
		Gtk::TreeViewColumn				*m_treecolumn_chapterdate;
		Gtk::Entry						*m_entry_tagname;
		Gtk::Button						*m_button_set_add;
		Gtk::Button						*m_button_set_remove;
		Gtk::Button						*m_button_chapter_add;
		Gtk::Button						*m_button_chapter_remove;
		Glib::RefPtr< Gtk::ListStore >	m_liststore_sets;
		Glib::RefPtr< Gtk::ListStore >	m_liststore_chapters;
		ColrecSetChapters				m_colrec_sets;
		ColrecChapter					m_colrec_chapters;

		Diary							*m_ptr2diary;
		CategoryChapters				*m_ptr2set;
		bool							m_flag_sets_changed;
};

} // end of namespace LIFEO

#endif

