/***********************************************************************************

	Copyright (C) 2009 Ahmet Öztürk (aoz_2@yahoo.com)

	This file is part of Lifeograph.

	Lifeograph is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Lifeograph is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_DIALOG_EXPORT_HEADER
#define LIFEOGRAPH_DIALOG_EXPORT_HEADER


#include <gtkmm/dialog.h>
#include <gtkmm/stock.h>

#include "database.hpp"


namespace LIFEO
{

// SAVERS & EXPORTERS
class Databasesaver
{
	public:
	typedef sigc::signal< void, bool >
									Signal_void_bool;

		virtual Gtk::Widget*		draw_options( void ) = 0;
		virtual bool				is_ready( void ) = 0;
		virtual Result				save( const std::string& ) = 0;

		Glib::ustring				get_name( void )
		{ return m_name; }

		Signal_void_bool			signal_updated( void )
		{ return m_signal_updated; }

	protected:
									Databasesaver( const Glib::ustring&, Database* );

		Glib::ustring				m_name;
		Database					*m_ptr2database;

		Signal_void_bool			m_signal_updated;
};

class SaverEncrypted : public Databasesaver
{
	public:
		explicit					SaverEncrypted( Database* );
		Gtk::Widget*				draw_options( void );
		bool						is_ready( void );
		Result						save( const std::string& );

		void						handle_passphrase_changed( void );

	private:
		Gtk::Entry					*m_entry_passphrase;
		Gtk::Entry					*m_entry_confirm;
		std::string					m_passphrase;
};

class SaverUnencrypted : public Databasesaver
{
	public:
		explicit					SaverUnencrypted( Database* );
		Gtk::Widget*				draw_options( void )
		{ return NULL; }

		bool						is_ready( void )
		{ return true; }

		Result						save( const std::string& );
};

class ExporterText : public Databasesaver
{
	public:
		explicit					ExporterText( Database* );
		Gtk::Widget*				draw_options( void )
		{ return NULL; }

		bool						is_ready( void )
		{ return true; }

		Result						save( const std::string& );
};

// FILE SELECTION DIALOG
class DialogSaveDiary : public Gtk::FileChooserDialog
{
	public:
									DialogSaveDiary();

};

// EXPORT DIALOG
class DialogExport : public Gtk::Dialog
{
	public:
		explicit					DialogExport( Database* );

		void						add_saver( Databasesaver* );

	protected:
		virtual void				on_response( int );

		void						handle_savetype_changed( void );
		void						handle_saver_updated( bool );
		void						handle_path_changed( void );
		void						handle_overwrite_toggled( void );
		void						handle_browse(	Gtk::EntryIconPosition,
													const GdkEventButton* );

		Gtk::Widget*				draw_options_encrypted( void );

		bool						is_ready( void );

		Gtk::Entry					m_entry_path;
		Gtk::CheckButton			m_checkbutton_overwrite;
		Gtk::ComboBoxText			m_combobox;
		Gtk::Table					m_table;
		Gtk::Button					*m_button_save;
		Gtk::Widget					*m_ptr2widget_options;

		std::vector< Databasesaver* >
									m_savers;

		Database					*m_ptr2database;

		bool						m_flag_fileready;
		bool						m_flag_saverready;

	private:

};

} // end of namespace LIFEO

#endif

