/* -*- mode: c++ -*-

  This file is part of the Life library

  Author(s): Christophe Prud'homme <christophe.prudhomme@ujf-grenoble.fr>
       Date: 2009-04-30

  Copyright (C) 2009 Universit Joseph Fourier (Grenoble I)

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3.0 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
/**
   \file basisgen.hpp
   \author Christophe Prud'homme <christophe.prudhomme@ujf-grenoble.fr>
   \date 2009-04-30
 */
#ifndef __basisgen_H
#define __basisgen_H 1

#include <boost/tokenizer.hpp>
#include <boost/token_functions.hpp>
#include <boost/algorithm/string/split.hpp>
#include <boost/algorithm/string/classification.hpp>

#include <life/lifecore/life.hpp>
#include <life/lifecore/factory.hpp>
#include <life/lifecore/singleton.hpp>

#include "polyvis.hpp"

namespace Life
{
namespace detail
{

# define DIMS                                               \
    BOOST_PP_TUPLE_TO_LIST(                                 \
                           3,                               \
                           (                                \
                            1,2,3                           \
                                                            )   \
                                                            )
# define CONVEX                                 \
    BOOST_PP_TUPLE_TO_LIST(                                 \
                           2,                               \
                           (                                \
                            Simplex,SimplexProduct              \
                                                            )   \
                                                            )
#
# define SIMPLEX BOOST_PP_TUPLE_TO_LIST(1, (Simplex))
#
# define SIMPLEX_PRODUCT BOOST_PP_TUPLE_TO_LIST(1, (SimplexProduct))
#
# define DIM1 BOOST_PP_TUPLE_TO_LIST(1, (1))
# define DIM2 BOOST_PP_TUPLE_TO_LIST(1, (2))
# define DIM3 BOOST_PP_TUPLE_TO_LIST(1, (3))
#
#if 1
# define ORDER0 BOOST_PP_TUPLE_TO_LIST(1,(0))
# define ORDER1 BOOST_PP_TUPLE_TO_LIST(1,(1))

# define ORDERS                                             \
    BOOST_PP_TUPLE_TO_LIST(                                 \
                           10,                              \
                           (                                \
                            1,2,3,4,5,6,7,8,9,10            \
                                                            )   \
                                                            )
#else
# define ORDERS BOOST_PP_TUPLE_TO_LIST(3,(1,2,3))
#endif
} // detail
} // Life
#endif /* __basisgen_H */
