/*
 *  Copyright 1994-2012 Olivier Girondel
 *
 *  This file is part of lebiniou.
 *
 *  lebiniou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  lebiniou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __BINIOU_PICTURES_H
#define __BINIOU_PICTURES_H

#include "picture_8bits.h"


typedef struct Pictures_s {
  Picture8_t **pics;
  uint16_t   size;
} Pictures_t;

extern Pictures_t *pictures;


void Pictures_new(const char *, const char *);
void Pictures_delete();

const char *Pictures_name(const uint32_t);
int32_t Pictures_index(const uint32_t);
int32_t Pictures_find(const char *);
uint32_t Pictures_random_id();
const Picture8_t *Pictures_random();


#endif /* __BINIOU_PICTURES_H */
