/*
 *  Copyright 1994-2012 Olivier Girondel
 *
 *  This file is part of lebiniou.
 *
 *  lebiniou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  lebiniou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.
 */

#include "context.h"


Pixel_t *
export_RGB_buffer(const Context_t *ctx, const u_char screen, const u_char flip)
{
  rgba_t *colors = &ctx->cf->cur->colors[0];
  Buffer8_t *buf = ctx->buffers[screen];
  const Pixel_t *src = NULL;
  Pixel_t *res;
  u_long c, i=0;

  if (flip)
    Buffer8_flip_x(buf);
  src = buf->buffer;

  res = xmalloc(3*BUFFSIZE*sizeof(Pixel_t));

  for (c = 0; c < BUFFSIZE; c++) {
    res[i++] = colors[src[c]].col.r;
    res[i++] = colors[src[c]].col.g;
    res[i++] = colors[src[c]].col.b;
  }

  if (flip)
    Buffer8_flip_x(buf);

  return res;
}


Pixel_t *
export_RGB_active_buffer(const Context_t *ctx, const u_char flip)
{
  return export_RGB_buffer(ctx, ACTIVE_BUFFER, flip);
}
