/*
 *  Copyright 1994-2012 Olivier Girondel
 *
 *  This file is part of lebiniou.
 *
 *  lebiniou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  lebiniou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.
 */

#include "main.h"

static void
usage()
{
  printf("usage: %s [options]\n\n"
	 "\t-b, --basedir <path>\tSet base directory\n"
	 "\t-d, --datadir <path>\tSet data directory\n"
	 "\t-z, --schemes <file>\tSet the schemes file\n"
	 "\t-f, --fullscreen\tSet fullscreen\n"
	 "\t-h, --help\t\tDisplay this help\n"
	 "\t-i, --input <plugin>\tSet input plugin\n"
	 "\t-m, --maxfps <fps>\tSet maximum framerate\n"
	 "\t-o, --output <plugin>\tSet output plugin\n"
	 "\t-r, --random <mode>\tSet auto-random mode\n"
	 "\t-s, --screen <mode>\tSet On Screen Display mode\n"
	 "\t-v, --version\t\tDisplay the version and exit\n"
#ifndef FIXED
	 "\t-x, --width <width>\tSet width\n"
	 "\t-y, --height <height>\tSet height\n"
#endif
	 "\t-p, --pidfile <file>\tSet the PID file\n"
	 "\t-t, --themes <themes>\tComma-separated list of themes to use\n"
	 "\n"
	 "%s was compiled with:\n"
	 "\tInput plugins: %s [default: %s]\n"
	 "\tOutput plugins: %s [default: %s]\n"
	 "\n",
	 PACKAGE_NAME, PACKAGE_STRING,
	 INPUT_PLUGINS, DEFAULT_INPUT_PLUGIN,
	 OUTPUT_PLUGINS, DEFAULT_OUTPUT_PLUGIN);

  /* TODO print default values for all options */
  exit(0);
}


void
getargs(int argc, char **argv)
{
  int ch;

#if HAVE_GETOPT_LONG
  static struct option long_opt[] =
	  {
		  {"basedir", required_argument, NULL, 'b'},
		  {"datadir", required_argument, NULL, 'd'},
		  {"schemes", required_argument, NULL, 'z'},
		  {"fullscreen", no_argument, NULL, 'f'},
		  {"help", no_argument, NULL, 'h'},
		  {"input", required_argument, NULL, 'i'},
		  {"maxfps", required_argument, NULL, 'm'},
		  {"output", required_argument, NULL, 'o'},
		  {"random", required_argument, NULL, 'r'},
		  {"screen", required_argument, NULL, 's'},
#ifndef FIXED
		  {"width", required_argument, NULL, 'x'},
		  {"height", required_argument, NULL, 'y'},
#endif
		  {"version", no_argument, NULL, 'v'},
		  {"pidfile", required_argument, NULL, 'p'},
		  {"themes", required_argument, NULL, 't'},
		  {0, 0, 0, 0}
	  };

  
  /* Get command line arguments */
#ifdef FIXED
  while ((ch = getopt_long(argc, argv, "b:d:fhi:m:o:p:r:s:t:v", long_opt, NULL)) != -1)
#else
  while ((ch = getopt_long(argc, argv, "b:d:fhi:m:o:p:r:s:t:x:y:v", long_opt, NULL)) != -1)
#endif
#else
#ifdef FIXED
  while ((ch = getopt(argc, argv, "b:d:fhi:m:o:p:r:s:t:v")) != -1)
#else
  while ((ch = getopt(argc, argv, "b:d:fhi:m:o:p:r:s:t:x:y:v")) != -1)
#endif
#endif
    switch (ch) {
    case 'b':
      if (base_dir == NULL)
	base_dir = optarg;
      break;
			
    case 'd':
      if (data_dir == NULL)
	data_dir = optarg;
      break;
				
    case 'z':
      if (schemes_file == NULL)
	schemes_file = optarg;
      break;
				
    case 'f':
      fullscreen = 1;
      break;
			
    case 'h':
      usage();
      break;

    case 'i':
      if (NULL != input_plugin)
	xfree(input_plugin);
      input_plugin = strdup(optarg);
      printf("[c] Setting input plugin: %s\n", input_plugin);
      break;

    case 'o':
      if (NULL != output_plugin)
	xfree(output_plugin);
      output_plugin = strdup(optarg);
      printf("[c] Setting output plugin: %s\n", output_plugin);
      break;

    case 'm':
      max_fps = xatol(optarg);
      if (max_fps > 0)
	printf("[c] Maximum fps set to %li\n", max_fps);
      else
	xerror("Invalid max_fps (%li)\n", max_fps);
      break;

    case 'r':
      random_mode = (enum RandomMode)xatol(optarg);
      if (random_mode > BR_BOTH)
	xerror("Invalid random_mode (%d)\n", random_mode);
      else
	printf("[c] Random mode set to %d\n", random_mode);
      break;

    case 's':
      osd_mode = (enum OSDMode)xatol(optarg);
      if (osd_mode > OSD_FULL_BG)
	xerror("Invalid osd_mode (%d)\n", osd_mode);
      else
	printf("[c] OSD mode set to %d\n", osd_mode);
      break;

    case 't':
      if (NULL != themes)
	xfree(themes);
      themes = strdup(optarg);
      printf("[c] Using themes: %s\n", themes);
      break;

    case 'v':
      printf("Le Biniou version %s\n", PACKAGE_VERSION);
      exit(0);
      break;

#ifndef FIXED
    case 'x':
      width = xatol(optarg);
      printf("[c] Width set to %i\n", width);
      break;

    case 'y':
      height = xatol(optarg);
      printf("[c] Height set to %i\n", height);
      break;
#endif
		  
    case 'p':
      if (pid_file == NULL)
	pid_file = optarg;
      break;

    default:
      usage();
      break;
    }
	
  if (NULL == base_dir)
    base_dir = DEFAULT_BASEDIR;

  if (NULL == data_dir)
    data_dir = DEFAULT_DATADIR;
  
  if (NULL == schemes_file)
    schemes_file = DEFAULT_SCHEMES_FILE;
  
  if (NULL == input_plugin)
    input_plugin = strdup(DEFAULT_INPUT_PLUGIN);
  else if (!strcmp(input_plugin, "NULL"))
    input_plugin = NULL;
	
  if (NULL == output_plugin)
    output_plugin = strdup(DEFAULT_OUTPUT_PLUGIN);
  else if (!strcmp(output_plugin, "NULL"))
    output_plugin = NULL;

  if (NULL == themes)
    themes = strdup("biniou");
} 
