/* post_processors.c generated by valac 0.12.1, the Vala compiler
 * generated from post_processors.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define TYPE_POST_PROCESSOR (post_processor_get_type ())
#define POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_POST_PROCESSOR, PostProcessor))
#define POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_POST_PROCESSOR, PostProcessorClass))
#define IS_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_POST_PROCESSOR))
#define IS_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_POST_PROCESSOR))
#define POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_POST_PROCESSOR, PostProcessorClass))

typedef struct _PostProcessor PostProcessor;
typedef struct _PostProcessorClass PostProcessorClass;
typedef struct _PostProcessorPrivate PostProcessorPrivate;

#define TYPE_BUILD_MSG (build_msg_get_type ())

#define TYPE_BUILD_MSG_TYPE (build_msg_type_get_type ())
typedef struct _BuildMsg BuildMsg;
#define __g_node_destroy__build_msg_free0_0(var) ((var == NULL) ? NULL : (var = (_g_node_destroy__build_msg_free0_ (var), NULL)))

#define TYPE_NO_OUTPUT_POST_PROCESSOR (no_output_post_processor_get_type ())
#define NO_OUTPUT_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NO_OUTPUT_POST_PROCESSOR, NoOutputPostProcessor))
#define NO_OUTPUT_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NO_OUTPUT_POST_PROCESSOR, NoOutputPostProcessorClass))
#define IS_NO_OUTPUT_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NO_OUTPUT_POST_PROCESSOR))
#define IS_NO_OUTPUT_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NO_OUTPUT_POST_PROCESSOR))
#define NO_OUTPUT_POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NO_OUTPUT_POST_PROCESSOR, NoOutputPostProcessorClass))

typedef struct _NoOutputPostProcessor NoOutputPostProcessor;
typedef struct _NoOutputPostProcessorClass NoOutputPostProcessorClass;
typedef struct _NoOutputPostProcessorPrivate NoOutputPostProcessorPrivate;

#define TYPE_ALL_OUTPUT_POST_PROCESSOR (all_output_post_processor_get_type ())
#define ALL_OUTPUT_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALL_OUTPUT_POST_PROCESSOR, AllOutputPostProcessor))
#define ALL_OUTPUT_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALL_OUTPUT_POST_PROCESSOR, AllOutputPostProcessorClass))
#define IS_ALL_OUTPUT_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALL_OUTPUT_POST_PROCESSOR))
#define IS_ALL_OUTPUT_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALL_OUTPUT_POST_PROCESSOR))
#define ALL_OUTPUT_POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALL_OUTPUT_POST_PROCESSOR, AllOutputPostProcessorClass))

typedef struct _AllOutputPostProcessor AllOutputPostProcessor;
typedef struct _AllOutputPostProcessorClass AllOutputPostProcessorClass;
typedef struct _AllOutputPostProcessorPrivate AllOutputPostProcessorPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_RUBBER_POST_PROCESSOR (rubber_post_processor_get_type ())
#define RUBBER_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RUBBER_POST_PROCESSOR, RubberPostProcessor))
#define RUBBER_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RUBBER_POST_PROCESSOR, RubberPostProcessorClass))
#define IS_RUBBER_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RUBBER_POST_PROCESSOR))
#define IS_RUBBER_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RUBBER_POST_PROCESSOR))
#define RUBBER_POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RUBBER_POST_PROCESSOR, RubberPostProcessorClass))

typedef struct _RubberPostProcessor RubberPostProcessor;
typedef struct _RubberPostProcessorClass RubberPostProcessorClass;
typedef struct _RubberPostProcessorPrivate RubberPostProcessorPrivate;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_match_info_free0(var) ((var == NULL) ? NULL : (var = (g_match_info_free (var), NULL)))

#define TYPE_LATEXMK_POST_PROCESSOR (latexmk_post_processor_get_type ())
#define LATEXMK_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LATEXMK_POST_PROCESSOR, LatexmkPostProcessor))
#define LATEXMK_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LATEXMK_POST_PROCESSOR, LatexmkPostProcessorClass))
#define IS_LATEXMK_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LATEXMK_POST_PROCESSOR))
#define IS_LATEXMK_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LATEXMK_POST_PROCESSOR))
#define LATEXMK_POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LATEXMK_POST_PROCESSOR, LatexmkPostProcessorClass))

typedef struct _LatexmkPostProcessor LatexmkPostProcessor;
typedef struct _LatexmkPostProcessorClass LatexmkPostProcessorClass;
typedef struct _LatexmkPostProcessorPrivate LatexmkPostProcessorPrivate;
#define _build_msg_free0(var) ((var == NULL) ? NULL : (var = (build_msg_free (var), NULL)))

#define TYPE_LATEX_POST_PROCESSOR (latex_post_processor_get_type ())
#define LATEX_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LATEX_POST_PROCESSOR, LatexPostProcessor))
#define LATEX_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LATEX_POST_PROCESSOR, LatexPostProcessorClass))
#define IS_LATEX_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LATEX_POST_PROCESSOR))
#define IS_LATEX_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LATEX_POST_PROCESSOR))
#define LATEX_POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LATEX_POST_PROCESSOR, LatexPostProcessorClass))

typedef struct _LatexPostProcessor LatexPostProcessor;
typedef struct _LatexPostProcessorClass LatexPostProcessorClass;

typedef enum  {
	BUILD_MSG_TYPE_ERROR,
	BUILD_MSG_TYPE_WARNING,
	BUILD_MSG_TYPE_BADBOX,
	BUILD_MSG_TYPE_OTHER
} BuildMsgType;

struct _BuildMsg {
	gchar* text;
	BuildMsgType type;
	gchar* filename;
	gboolean lines_set;
	gint start_line;
	gint end_line;
	gboolean expand;
};

struct _PostProcessor {
	GObject parent_instance;
	PostProcessorPrivate * priv;
	GNode* _all_messages;
};

struct _PostProcessorClass {
	GObjectClass parent_class;
	void (*process) (PostProcessor* self, GFile* file, const gchar* output);
};

struct _PostProcessorPrivate {
	GNode* _prev_message;
	gboolean _successful;
};

struct _NoOutputPostProcessor {
	PostProcessor parent_instance;
	NoOutputPostProcessorPrivate * priv;
};

struct _NoOutputPostProcessorClass {
	PostProcessorClass parent_class;
};

struct _AllOutputPostProcessor {
	PostProcessor parent_instance;
	AllOutputPostProcessorPrivate * priv;
};

struct _AllOutputPostProcessorClass {
	PostProcessorClass parent_class;
};

struct _RubberPostProcessor {
	PostProcessor parent_instance;
	RubberPostProcessorPrivate * priv;
};

struct _RubberPostProcessorClass {
	PostProcessorClass parent_class;
};

struct _LatexmkPostProcessor {
	PostProcessor parent_instance;
	LatexmkPostProcessorPrivate * priv;
};

struct _LatexmkPostProcessorClass {
	PostProcessorClass parent_class;
};

struct _LatexmkPostProcessorPrivate {
	gboolean _force_show_all;
};


static gpointer post_processor_parent_class = NULL;
static gpointer no_output_post_processor_parent_class = NULL;
static gpointer all_output_post_processor_parent_class = NULL;
static gpointer rubber_post_processor_parent_class = NULL;
static GRegex* rubber_post_processor__pattern;
static GRegex* rubber_post_processor__pattern = NULL;
static gpointer latexmk_post_processor_parent_class = NULL;
static GRegex* latexmk_post_processor__reg_rule;
static GRegex* latexmk_post_processor__reg_rule = NULL;
static GRegex* latexmk_post_processor__reg_no_rule;
static GRegex* latexmk_post_processor__reg_no_rule = NULL;

GType post_processor_get_type (void) G_GNUC_CONST;
GType build_msg_get_type (void) G_GNUC_CONST;
GType build_msg_type_get_type (void) G_GNUC_CONST;
BuildMsg* build_msg_dup (const BuildMsg* self);
void build_msg_free (BuildMsg* self);
void build_msg_copy (const BuildMsg* self, BuildMsg* dest);
void build_msg_destroy (BuildMsg* self);
#define POST_PROCESSOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_POST_PROCESSOR, PostProcessorPrivate))
enum  {
	POST_PROCESSOR_DUMMY_PROPERTY,
	POST_PROCESSOR_SUCCESSFUL
};
static void _build_msg_free0_ (gpointer var);
static void _g_node_destroy__build_msg_free0_ (GNode* self);
static void _g_node_destroy__build_msg_free0_ (GNode* self);
GNode* post_processor_get_messages (PostProcessor* self);
GNode* post_processor_append_message (PostProcessor* self, BuildMsg* message);
void post_processor_set_status (PostProcessor* self, gint status);
void post_processor_set_successful (PostProcessor* self, gboolean value);
void post_processor_process (PostProcessor* self, GFile* file, const gchar* output);
static void post_processor_real_process (PostProcessor* self, GFile* file, const gchar* output);
PostProcessor* post_processor_construct (GType object_type);
gboolean post_processor_get_successful (PostProcessor* self);
static void post_processor_finalize (GObject* obj);
static void _vala_post_processor_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_post_processor_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType no_output_post_processor_get_type (void) G_GNUC_CONST;
enum  {
	NO_OUTPUT_POST_PROCESSOR_DUMMY_PROPERTY
};
static void no_output_post_processor_real_process (PostProcessor* base, GFile* file, const gchar* output);
NoOutputPostProcessor* no_output_post_processor_new (void);
NoOutputPostProcessor* no_output_post_processor_construct (GType object_type);
GType all_output_post_processor_get_type (void) G_GNUC_CONST;
enum  {
	ALL_OUTPUT_POST_PROCESSOR_DUMMY_PROPERTY
};
static void all_output_post_processor_real_process (PostProcessor* base, GFile* file, const gchar* output);
AllOutputPostProcessor* all_output_post_processor_new (void);
AllOutputPostProcessor* all_output_post_processor_construct (GType object_type);
GType rubber_post_processor_get_type (void) G_GNUC_CONST;
enum  {
	RUBBER_POST_PROCESSOR_DUMMY_PROPERTY
};
RubberPostProcessor* rubber_post_processor_new (void);
RubberPostProcessor* rubber_post_processor_construct (GType object_type);
static void rubber_post_processor_real_process (PostProcessor* base, GFile* file, const gchar* output);
static void rubber_post_processor_finalize (GObject* obj);
GType latexmk_post_processor_get_type (void) G_GNUC_CONST;
#define LATEXMK_POST_PROCESSOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LATEXMK_POST_PROCESSOR, LatexmkPostProcessorPrivate))
enum  {
	LATEXMK_POST_PROCESSOR_DUMMY_PROPERTY
};
LatexmkPostProcessor* latexmk_post_processor_new (gboolean force_show_all);
LatexmkPostProcessor* latexmk_post_processor_construct (GType object_type, gboolean force_show_all);
static void latexmk_post_processor_real_process (PostProcessor* base, GFile* file, const gchar* output);
LatexPostProcessor* latex_post_processor_new (void);
LatexPostProcessor* latex_post_processor_construct (GType object_type);
GType latex_post_processor_get_type (void) G_GNUC_CONST;
static void latexmk_post_processor_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _build_msg_dup0 (gpointer self) {
	return self ? build_msg_dup (self) : NULL;
}


static void _build_msg_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (build_msg_free (var), NULL));
}


static gboolean _g_node_destroy__build_msg_free0__node (GNode* node, gpointer unused) {
	_build_msg_free0_ (node->data);
	return FALSE;
}


static void _g_node_destroy__build_msg_free0_ (GNode* self) {
	g_node_traverse (self, G_POST_ORDER, G_TRAVERSE_ALL, -1, _g_node_destroy__build_msg_free0__node, NULL);
	g_node_destroy (self);
}


GNode* post_processor_get_messages (PostProcessor* self) {
	GNode* result = NULL;
	GNode* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->_all_messages;
	self->_all_messages = NULL;
	result = _tmp0_;
	return result;
}


GNode* post_processor_append_message (PostProcessor* self, BuildMsg* message) {
	GNode* result = NULL;
	GNode* new_message = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean prev_msg_is_invalid;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_prev_message != NULL) {
		_tmp0_ = self->priv->_prev_message->next != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	prev_msg_is_invalid = _tmp0_;
	if (self->priv->_prev_message == NULL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = prev_msg_is_invalid;
	}
	if (_tmp1_) {
		BuildMsg* _tmp2_;
		GNode* _tmp3_ = NULL;
		_tmp2_ = _build_msg_dup0 (message);
		_tmp3_ = g_node_append_data (self->_all_messages, _tmp2_);
		new_message = _tmp3_;
	} else {
		BuildMsg* _tmp4_;
		GNode* _tmp5_ = NULL;
		GNode* _tmp6_ = NULL;
		_tmp4_ = _build_msg_dup0 (message);
		_tmp5_ = g_node_new (_tmp4_);
		_tmp6_ = g_node_insert_after (self->_all_messages, self->priv->_prev_message, _tmp5_);
		new_message = _tmp6_;
	}
	self->priv->_prev_message = new_message;
	result = new_message;
	return result;
}


void post_processor_set_status (PostProcessor* self, gint status) {
	g_return_if_fail (self != NULL);
	post_processor_set_successful (self, status == 0);
}


static void post_processor_real_process (PostProcessor* self, GFile* file, const gchar* output) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `post_processor_process'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void post_processor_process (PostProcessor* self, GFile* file, const gchar* output) {
	POST_PROCESSOR_GET_CLASS (self)->process (self, file, output);
}


PostProcessor* post_processor_construct (GType object_type) {
	PostProcessor * self = NULL;
	self = (PostProcessor*) g_object_new (object_type, NULL);
	return self;
}


gboolean post_processor_get_successful (PostProcessor* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_successful;
	return result;
}


void post_processor_set_successful (PostProcessor* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_successful = value;
	g_object_notify ((GObject *) self, "successful");
}


static void post_processor_class_init (PostProcessorClass * klass) {
	post_processor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PostProcessorPrivate));
	POST_PROCESSOR_CLASS (klass)->process = post_processor_real_process;
	G_OBJECT_CLASS (klass)->get_property = _vala_post_processor_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_post_processor_set_property;
	G_OBJECT_CLASS (klass)->finalize = post_processor_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), POST_PROCESSOR_SUCCESSFUL, g_param_spec_boolean ("successful", "successful", "successful", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void post_processor_instance_init (PostProcessor * self) {
	BuildMsg _tmp0_ = {0};
	BuildMsg _tmp1_ = {0};
	BuildMsg _tmp2_;
	BuildMsg* _tmp3_;
	GNode* _tmp4_ = NULL;
	self->priv = POST_PROCESSOR_GET_PRIVATE (self);
	memset (&_tmp0_, 0, sizeof (BuildMsg));
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = _build_msg_dup0 (&_tmp2_);
	_tmp4_ = g_node_new (_tmp3_);
	self->_all_messages = _tmp4_;
	build_msg_destroy (&_tmp2_);
	self->priv->_prev_message = NULL;
}


static void post_processor_finalize (GObject* obj) {
	PostProcessor * self;
	self = POST_PROCESSOR (obj);
	__g_node_destroy__build_msg_free0_0 (self->_all_messages);
	G_OBJECT_CLASS (post_processor_parent_class)->finalize (obj);
}


GType post_processor_get_type (void) {
	static volatile gsize post_processor_type_id__volatile = 0;
	if (g_once_init_enter (&post_processor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PostProcessorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) post_processor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PostProcessor), 0, (GInstanceInitFunc) post_processor_instance_init, NULL };
		GType post_processor_type_id;
		post_processor_type_id = g_type_register_static (G_TYPE_OBJECT, "PostProcessor", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&post_processor_type_id__volatile, post_processor_type_id);
	}
	return post_processor_type_id__volatile;
}


static void _vala_post_processor_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	PostProcessor * self;
	self = POST_PROCESSOR (object);
	switch (property_id) {
		case POST_PROCESSOR_SUCCESSFUL:
		g_value_set_boolean (value, post_processor_get_successful (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_post_processor_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	PostProcessor * self;
	self = POST_PROCESSOR (object);
	switch (property_id) {
		case POST_PROCESSOR_SUCCESSFUL:
		post_processor_set_successful (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void no_output_post_processor_real_process (PostProcessor* base, GFile* file, const gchar* output) {
	NoOutputPostProcessor * self;
	self = (NoOutputPostProcessor*) base;
	g_return_if_fail (file != NULL);
	g_return_if_fail (output != NULL);
}


NoOutputPostProcessor* no_output_post_processor_construct (GType object_type) {
	NoOutputPostProcessor * self = NULL;
	self = (NoOutputPostProcessor*) post_processor_construct (object_type);
	return self;
}


NoOutputPostProcessor* no_output_post_processor_new (void) {
	return no_output_post_processor_construct (TYPE_NO_OUTPUT_POST_PROCESSOR);
}


static void no_output_post_processor_class_init (NoOutputPostProcessorClass * klass) {
	no_output_post_processor_parent_class = g_type_class_peek_parent (klass);
	POST_PROCESSOR_CLASS (klass)->process = no_output_post_processor_real_process;
}


static void no_output_post_processor_instance_init (NoOutputPostProcessor * self) {
}


GType no_output_post_processor_get_type (void) {
	static volatile gsize no_output_post_processor_type_id__volatile = 0;
	if (g_once_init_enter (&no_output_post_processor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NoOutputPostProcessorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) no_output_post_processor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NoOutputPostProcessor), 0, (GInstanceInitFunc) no_output_post_processor_instance_init, NULL };
		GType no_output_post_processor_type_id;
		no_output_post_processor_type_id = g_type_register_static (TYPE_POST_PROCESSOR, "NoOutputPostProcessor", &g_define_type_info, 0);
		g_once_init_leave (&no_output_post_processor_type_id__volatile, no_output_post_processor_type_id);
	}
	return no_output_post_processor_type_id__volatile;
}


static void all_output_post_processor_real_process (PostProcessor* base, GFile* file, const gchar* output) {
	AllOutputPostProcessor * self;
	gint _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** lines;
	gint lines_length1;
	gint _lines_size_;
	gint nb_lines;
	gint _tmp3_;
	BuildMsg message = {0};
	self = (AllOutputPostProcessor*) base;
	g_return_if_fail (file != NULL);
	g_return_if_fail (output != NULL);
	_tmp0_ = strlen (output);
	if (_tmp0_ == 0) {
		return;
	}
	_tmp2_ = _tmp1_ = g_strsplit (output, "\n", 0);
	lines = _tmp2_;
	lines_length1 = _vala_array_length (_tmp1_);
	_lines_size_ = _vala_array_length (_tmp1_);
	nb_lines = lines_length1;
	g_return_if_fail (nb_lines > 0);
	_tmp3_ = strlen (lines[nb_lines - 1]);
	if (_tmp3_ == 0) {
		nb_lines--;
	}
	memset (&message, 0, sizeof (BuildMsg));
	message.type = BUILD_MSG_TYPE_OTHER;
	_g_free0 (message.filename);
	message.filename = NULL;
	message.lines_set = FALSE;
	{
		gint line_num;
		line_num = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gchar* _tmp5_;
				if (!_tmp4_) {
					line_num++;
				}
				_tmp4_ = FALSE;
				if (!(line_num < nb_lines)) {
					break;
				}
				_tmp5_ = g_strdup (lines[line_num]);
				_g_free0 (message.text);
				message.text = _tmp5_;
				post_processor_append_message ((PostProcessor*) self, &message);
			}
		}
	}
	build_msg_destroy (&message);
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
}


AllOutputPostProcessor* all_output_post_processor_construct (GType object_type) {
	AllOutputPostProcessor * self = NULL;
	self = (AllOutputPostProcessor*) post_processor_construct (object_type);
	return self;
}


AllOutputPostProcessor* all_output_post_processor_new (void) {
	return all_output_post_processor_construct (TYPE_ALL_OUTPUT_POST_PROCESSOR);
}


static void all_output_post_processor_class_init (AllOutputPostProcessorClass * klass) {
	all_output_post_processor_parent_class = g_type_class_peek_parent (klass);
	POST_PROCESSOR_CLASS (klass)->process = all_output_post_processor_real_process;
}


static void all_output_post_processor_instance_init (AllOutputPostProcessor * self) {
}


GType all_output_post_processor_get_type (void) {
	static volatile gsize all_output_post_processor_type_id__volatile = 0;
	if (g_once_init_enter (&all_output_post_processor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AllOutputPostProcessorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) all_output_post_processor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AllOutputPostProcessor), 0, (GInstanceInitFunc) all_output_post_processor_instance_init, NULL };
		GType all_output_post_processor_type_id;
		all_output_post_processor_type_id = g_type_register_static (TYPE_POST_PROCESSOR, "AllOutputPostProcessor", &g_define_type_info, 0);
		g_once_init_leave (&all_output_post_processor_type_id__volatile, all_output_post_processor_type_id);
	}
	return all_output_post_processor_type_id__volatile;
}


RubberPostProcessor* rubber_post_processor_construct (GType object_type) {
	RubberPostProcessor * self = NULL;
	GRegex* _tmp0_ = NULL;
	GRegex* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RubberPostProcessor*) post_processor_construct (object_type);
	if (rubber_post_processor__pattern != NULL) {
		return self;
	}
	_tmp0_ = g_regex_new ("(?P<file>[^:\n]+)(:(?P<line>[\\d\\-]+))?:(?P<text>.+)$", G_REGEX_MULTILINE | G_REGEX_OPTIMIZE, 0, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch43_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_regex_unref0 (rubber_post_processor__pattern);
	rubber_post_processor__pattern = _tmp1_;
	goto __finally43;
	__catch43_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("post_processors.vala:115: RubberPostProcessor: %s", e->message);
		_g_error_free0 (e);
	}
	__finally43:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


RubberPostProcessor* rubber_post_processor_new (void) {
	return rubber_post_processor_construct (TYPE_RUBBER_POST_PROCESSOR);
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


static void rubber_post_processor_real_process (PostProcessor* base, GFile* file, const gchar* output) {
	RubberPostProcessor * self;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* parent_path;
	GMatchInfo* match_info = NULL;
	GMatchInfo* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RubberPostProcessor*) base;
	g_return_if_fail (file != NULL);
	g_return_if_fail (output != NULL);
	g_return_if_fail (rubber_post_processor__pattern != NULL);
	_tmp0_ = g_file_get_parent (file);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_get_parse_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	parent_path = _tmp3_;
	g_regex_match (rubber_post_processor__pattern, output, 0, &_tmp4_);
	_g_match_info_free0 (match_info);
	match_info = _tmp4_;
	while (TRUE) {
		gboolean _tmp5_;
		BuildMsg message = {0};
		gchar* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_;
		gchar* _tmp10_ = NULL;
		gchar* line;
		gboolean _tmp11_ = FALSE;
		gchar* _tmp20_ = NULL;
		gchar _tmp21_;
		_tmp5_ = g_match_info_matches (match_info);
		if (!_tmp5_) {
			break;
		}
		memset (&message, 0, sizeof (BuildMsg));
		_tmp6_ = g_match_info_fetch_named (match_info, "text");
		_g_free0 (message.text);
		message.text = _tmp6_;
		message.type = BUILD_MSG_TYPE_ERROR;
		_tmp8_ = string_contains (message.text, "Underfull");
		if (_tmp8_) {
			_tmp7_ = TRUE;
		} else {
			gboolean _tmp9_;
			_tmp9_ = string_contains (message.text, "Overfull");
			_tmp7_ = _tmp9_;
		}
		if (_tmp7_) {
			message.type = BUILD_MSG_TYPE_BADBOX;
		}
		message.lines_set = FALSE;
		_tmp10_ = g_match_info_fetch_named (match_info, "line");
		line = _tmp10_;
		if (line != NULL) {
			gint _tmp12_;
			_tmp12_ = strlen (line);
			_tmp11_ = 0 < _tmp12_;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			gchar** _tmp13_;
			gchar** _tmp14_ = NULL;
			gchar** parts;
			gint parts_length1;
			gint _parts_size_;
			gint _tmp15_;
			gboolean _tmp16_ = FALSE;
			gboolean _tmp17_ = FALSE;
			message.lines_set = TRUE;
			_tmp14_ = _tmp13_ = g_strsplit (line, "-", 0);
			parts = _tmp14_;
			parts_length1 = _vala_array_length (_tmp13_);
			_parts_size_ = _vala_array_length (_tmp13_);
			_tmp15_ = atoi (parts[0]);
			message.start_line = _tmp15_;
			if (1 < parts_length1) {
				_tmp17_ = parts[1] != NULL;
			} else {
				_tmp17_ = FALSE;
			}
			if (_tmp17_) {
				gint _tmp18_;
				_tmp18_ = strlen (parts[1]);
				_tmp16_ = 0 < _tmp18_;
			} else {
				_tmp16_ = FALSE;
			}
			if (_tmp16_) {
				gint _tmp19_;
				_tmp19_ = atoi (parts[1]);
				message.end_line = _tmp19_;
			} else {
				message.end_line = -1;
			}
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp20_ = g_match_info_fetch_named (match_info, "file");
		_g_free0 (message.filename);
		message.filename = _tmp20_;
		_tmp21_ = string_get (message.filename, (glong) 0);
		if (_tmp21_ != '/') {
			gchar* _tmp22_ = NULL;
			_tmp22_ = g_strdup_printf ("%s/%s", parent_path, message.filename);
			_g_free0 (message.filename);
			message.filename = _tmp22_;
		}
		post_processor_append_message ((PostProcessor*) self, &message);
		g_match_info_next (match_info, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch44_g_regex_error;
			}
			_g_free0 (line);
			build_msg_destroy (&message);
			_g_match_info_free0 (match_info);
			_g_free0 (parent_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		goto __finally44;
		__catch44_g_regex_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			g_warning ("post_processors.vala:164: RubberPostProcessor: %s", e->message);
			_g_error_free0 (e);
			_g_free0 (line);
			build_msg_destroy (&message);
			break;
		}
		__finally44:
		if (_inner_error_ != NULL) {
			_g_free0 (line);
			build_msg_destroy (&message);
			_g_match_info_free0 (match_info);
			_g_free0 (parent_path);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (line);
		build_msg_destroy (&message);
	}
	_g_match_info_free0 (match_info);
	_g_free0 (parent_path);
}


static void rubber_post_processor_class_init (RubberPostProcessorClass * klass) {
	rubber_post_processor_parent_class = g_type_class_peek_parent (klass);
	POST_PROCESSOR_CLASS (klass)->process = rubber_post_processor_real_process;
	G_OBJECT_CLASS (klass)->finalize = rubber_post_processor_finalize;
}


static void rubber_post_processor_instance_init (RubberPostProcessor * self) {
}


static void rubber_post_processor_finalize (GObject* obj) {
	RubberPostProcessor * self;
	self = RUBBER_POST_PROCESSOR (obj);
	G_OBJECT_CLASS (rubber_post_processor_parent_class)->finalize (obj);
}


GType rubber_post_processor_get_type (void) {
	static volatile gsize rubber_post_processor_type_id__volatile = 0;
	if (g_once_init_enter (&rubber_post_processor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RubberPostProcessorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rubber_post_processor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RubberPostProcessor), 0, (GInstanceInitFunc) rubber_post_processor_instance_init, NULL };
		GType rubber_post_processor_type_id;
		rubber_post_processor_type_id = g_type_register_static (TYPE_POST_PROCESSOR, "RubberPostProcessor", &g_define_type_info, 0);
		g_once_init_leave (&rubber_post_processor_type_id__volatile, rubber_post_processor_type_id);
	}
	return rubber_post_processor_type_id__volatile;
}


LatexmkPostProcessor* latexmk_post_processor_construct (GType object_type, gboolean force_show_all) {
	LatexmkPostProcessor * self = NULL;
	gchar* _tmp0_;
	gchar* ungreedy_lines;
	gchar* _tmp1_;
	gchar* reg_rule_str;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GRegex* _tmp19_ = NULL;
	GRegex* _tmp20_;
	gchar* _tmp21_;
	gchar* reg_no_rule_str;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GRegex* _tmp24_ = NULL;
	GRegex* _tmp25_;
	GError * _inner_error_ = NULL;
	self = (LatexmkPostProcessor*) post_processor_construct (object_type);
	self->priv->_force_show_all = force_show_all;
	if (latexmk_post_processor__reg_rule != NULL) {
		return self;
	}
	_tmp0_ = g_strdup ("((?U)(.*\\R)*)");
	ungreedy_lines = _tmp0_;
	_tmp1_ = g_strdup ("(?P<title>Run number \\d+ of rule '(?P<rule>.*)')\\R");
	reg_rule_str = _tmp1_;
	_tmp2_ = g_strconcat (reg_rule_str, "(-{12}\\R){2}", NULL);
	_g_free0 (reg_rule_str);
	reg_rule_str = _tmp2_;
	_tmp3_ = g_strconcat (reg_rule_str, "Running '(?P<cmd>.*)'\\R", NULL);
	_g_free0 (reg_rule_str);
	reg_rule_str = _tmp3_;
	_tmp4_ = g_strconcat (reg_rule_str, "-{12}\\R", NULL);
	_g_free0 (reg_rule_str);
	reg_rule_str = _tmp4_;
	_tmp5_ = g_strconcat (reg_rule_str, ungreedy_lines, NULL);
	_g_free0 (reg_rule_str);
	reg_rule_str = _tmp5_;
	_tmp6_ = g_strconcat (reg_rule_str, "(Latexmk: applying rule .*\\R)+", NULL);
	_g_free0 (reg_rule_str);
	reg_rule_str = _tmp6_;
	_tmp7_ = g_strconcat (reg_rule_str, "(For rule '.*', running .*\\R)?", NULL);
	_g_free0 (reg_rule_str);
	reg_rule_str = _tmp7_;
	_tmp8_ = g_strconcat ("(?P<output>", ungreedy_lines, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, ")", NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat (reg_rule_str, _tmp11_, NULL);
	_g_free0 (reg_rule_str);
	reg_rule_str = _tmp12_;
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_tmp13_ = g_strconcat ("(?P<latexmk>(Latexmk:|Rule '.*':)", ungreedy_lines, NULL);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strconcat (_tmp14_, ")", NULL);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strconcat (reg_rule_str, _tmp16_, NULL);
	_g_free0 (reg_rule_str);
	reg_rule_str = _tmp17_;
	_g_free0 (_tmp16_);
	_g_free0 (_tmp14_);
	_tmp18_ = g_strconcat (reg_rule_str, "(-{12}\\R|$)", NULL);
	_g_free0 (reg_rule_str);
	reg_rule_str = _tmp18_;
	_tmp19_ = g_regex_new (reg_rule_str, G_REGEX_OPTIMIZE, 0, &_inner_error_);
	_tmp20_ = _tmp19_;
	if (_inner_error_ != NULL) {
		_g_free0 (reg_rule_str);
		_g_free0 (ungreedy_lines);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch45_g_regex_error;
		}
		_g_free0 (reg_rule_str);
		_g_free0 (ungreedy_lines);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_regex_unref0 (latexmk_post_processor__reg_rule);
	latexmk_post_processor__reg_rule = _tmp20_;
	_tmp21_ = g_strdup ("(Latexmk: This is Latexmk.*\\R)?");
	reg_no_rule_str = _tmp21_;
	_tmp22_ = g_strconcat (reg_no_rule_str, "(\\*{4} Report bugs.*\\R)?", NULL);
	_g_free0 (reg_no_rule_str);
	reg_no_rule_str = _tmp22_;
	_tmp23_ = g_strconcat (reg_no_rule_str, "(?P<output>(.*\\R)*)", NULL);
	_g_free0 (reg_no_rule_str);
	reg_no_rule_str = _tmp23_;
	_tmp24_ = g_regex_new (reg_no_rule_str, 0, 0, &_inner_error_);
	_tmp25_ = _tmp24_;
	if (_inner_error_ != NULL) {
		_g_free0 (reg_no_rule_str);
		_g_free0 (reg_rule_str);
		_g_free0 (ungreedy_lines);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch45_g_regex_error;
		}
		_g_free0 (reg_no_rule_str);
		_g_free0 (reg_rule_str);
		_g_free0 (ungreedy_lines);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_regex_unref0 (latexmk_post_processor__reg_no_rule);
	latexmk_post_processor__reg_no_rule = _tmp25_;
	_g_free0 (reg_no_rule_str);
	_g_free0 (reg_rule_str);
	_g_free0 (ungreedy_lines);
	goto __finally45;
	__catch45_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("post_processors.vala:209: LatexmkPostProcessor: %s", e->message);
		_g_error_free0 (e);
	}
	__finally45:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


LatexmkPostProcessor* latexmk_post_processor_new (gboolean force_show_all) {
	return latexmk_post_processor_construct (TYPE_LATEXMK_POST_PROCESSOR, force_show_all);
}


static GNode* g_node_unlink_vala (GNode* self) {
	GNode* result = NULL;
	void* ptr;
	void* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	ptr = self;
	g_node_unlink (self);
	_tmp0_ = ptr;
	ptr = NULL;
	result = (GNode*) _tmp0_;
	return result;
}


static void latexmk_post_processor_real_process (PostProcessor* base, GFile* file, const gchar* output) {
	LatexmkPostProcessor * self;
	gboolean _tmp0_ = FALSE;
	gchar* last_latex_output;
	GNode* last_latex_node;
	GMatchInfo* match_info = NULL;
	GMatchInfo* _tmp1_ = NULL;
	AllOutputPostProcessor* _tmp45_ = NULL;
	PostProcessor* all_output_pp;
	GMatchInfo* _tmp46_ = NULL;
	gboolean _tmp47_;
	GNode* _tmp49_ = NULL;
	GError * _inner_error_ = NULL;
	self = (LatexmkPostProcessor*) base;
	g_return_if_fail (file != NULL);
	g_return_if_fail (output != NULL);
	if (latexmk_post_processor__reg_rule != NULL) {
		_tmp0_ = latexmk_post_processor__reg_no_rule != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	g_return_if_fail (_tmp0_);
	last_latex_output = NULL;
	last_latex_node = NULL;
	g_regex_match (latexmk_post_processor__reg_rule, output, 0, &_tmp1_);
	_g_match_info_free0 (match_info);
	match_info = _tmp1_;
	while (TRUE) {
		gboolean _tmp2_;
		GNode* cmd_messages;
		gchar* _tmp3_ = NULL;
		gchar* rule;
		gboolean _tmp4_ = FALSE;
		gboolean is_latex_cmd;
		BuildMsg title_msg = {0};
		gchar* _tmp14_ = NULL;
		BuildMsg* _tmp15_;
		BuildMsg cmd_line_msg = {0};
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		gchar* _tmp18_;
		BuildMsg* _tmp19_;
		gchar* _tmp23_ = NULL;
		gchar* latexmk_output;
		AllOutputPostProcessor* _tmp24_ = NULL;
		PostProcessor* all_output_pp;
		GNode* _tmp25_ = NULL;
		GNode* latexmk_messages;
		const gchar* _tmp26_ = NULL;
		gchar* _tmp27_;
		BuildMsg* _tmp28_;
		GNode* _tmp29_;
		_tmp2_ = g_match_info_matches (match_info);
		if (!_tmp2_) {
			break;
		}
		cmd_messages = NULL;
		_tmp3_ = g_match_info_fetch_named (match_info, "rule");
		rule = _tmp3_;
		if (g_strcmp0 (rule, "latex") == 0) {
			_tmp4_ = TRUE;
		} else {
			_tmp4_ = g_strcmp0 (rule, "pdflatex") == 0;
		}
		is_latex_cmd = _tmp4_;
		if (is_latex_cmd) {
			gchar* _tmp5_ = NULL;
			BuildMsg _tmp6_ = {0};
			BuildMsg _tmp7_ = {0};
			BuildMsg _tmp8_;
			BuildMsg* _tmp9_;
			GNode* _tmp10_ = NULL;
			_tmp5_ = g_match_info_fetch_named (match_info, "output");
			_g_free0 (last_latex_output);
			last_latex_output = _tmp5_;
			memset (&_tmp6_, 0, sizeof (BuildMsg));
			_tmp7_ = _tmp6_;
			_tmp8_ = _tmp7_;
			_tmp9_ = _build_msg_dup0 (&_tmp8_);
			_tmp10_ = g_node_new (_tmp9_);
			__g_node_destroy__build_msg_free0_0 (cmd_messages);
			cmd_messages = _tmp10_;
			build_msg_destroy (&_tmp8_);
		} else {
			gchar* _tmp11_ = NULL;
			gchar* cmd_output;
			AllOutputPostProcessor* _tmp12_ = NULL;
			PostProcessor* all_output_pp;
			GNode* _tmp13_ = NULL;
			_tmp11_ = g_match_info_fetch_named (match_info, "output");
			cmd_output = _tmp11_;
			_tmp12_ = all_output_post_processor_new ();
			all_output_pp = (PostProcessor*) _tmp12_;
			post_processor_process (all_output_pp, file, cmd_output);
			_tmp13_ = post_processor_get_messages (all_output_pp);
			__g_node_destroy__build_msg_free0_0 (cmd_messages);
			cmd_messages = _tmp13_;
			_g_object_unref0 (all_output_pp);
			_g_free0 (cmd_output);
		}
		memset (&title_msg, 0, sizeof (BuildMsg));
		title_msg.type = BUILD_MSG_TYPE_OTHER;
		title_msg.lines_set = FALSE;
		_tmp14_ = g_match_info_fetch_named (match_info, "title");
		_g_free0 (title_msg.text);
		title_msg.text = _tmp14_;
		title_msg.expand = FALSE;
		_tmp15_ = _build_msg_dup0 (&title_msg);
		_build_msg_free0 (cmd_messages->data);
		cmd_messages->data = _tmp15_;
		memset (&cmd_line_msg, 0, sizeof (BuildMsg));
		cmd_line_msg.type = BUILD_MSG_TYPE_OTHER;
		cmd_line_msg.lines_set = FALSE;
		_tmp16_ = g_match_info_fetch_named (match_info, "cmd");
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strconcat ("$ ", _tmp17_, NULL);
		_g_free0 (cmd_line_msg.text);
		cmd_line_msg.text = _tmp18_;
		_g_free0 (_tmp17_);
		_tmp19_ = _build_msg_dup0 (&cmd_line_msg);
		g_node_insert_data (cmd_messages, 0, _tmp19_);
		if (is_latex_cmd) {
			GNode* _tmp20_;
			GNode* _tmp21_ = NULL;
			_tmp20_ = cmd_messages;
			cmd_messages = NULL;
			_tmp21_ = g_node_append (((PostProcessor*) self)->_all_messages, _tmp20_);
			last_latex_node = _tmp21_;
		} else {
			GNode* _tmp22_;
			_tmp22_ = cmd_messages;
			cmd_messages = NULL;
			g_node_append (((PostProcessor*) self)->_all_messages, _tmp22_);
		}
		_tmp23_ = g_match_info_fetch_named (match_info, "latexmk");
		latexmk_output = _tmp23_;
		_tmp24_ = all_output_post_processor_new ();
		all_output_pp = (PostProcessor*) _tmp24_;
		post_processor_process (all_output_pp, file, latexmk_output);
		_tmp25_ = post_processor_get_messages (all_output_pp);
		latexmk_messages = _tmp25_;
		_tmp26_ = _ ("Latexmk messages");
		_tmp27_ = g_strdup (_tmp26_);
		_g_free0 (title_msg.text);
		title_msg.text = _tmp27_;
		_tmp28_ = _build_msg_dup0 (&title_msg);
		_build_msg_free0 (latexmk_messages->data);
		latexmk_messages->data = _tmp28_;
		_tmp29_ = latexmk_messages;
		latexmk_messages = NULL;
		g_node_append (((PostProcessor*) self)->_all_messages, _tmp29_);
		g_match_info_next (match_info, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch46_g_regex_error;
			}
			__g_node_destroy__build_msg_free0_0 (latexmk_messages);
			_g_object_unref0 (all_output_pp);
			_g_free0 (latexmk_output);
			build_msg_destroy (&cmd_line_msg);
			build_msg_destroy (&title_msg);
			_g_free0 (rule);
			__g_node_destroy__build_msg_free0_0 (cmd_messages);
			_g_match_info_free0 (match_info);
			_g_free0 (last_latex_output);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		goto __finally46;
		__catch46_g_regex_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			g_warning ("post_processors.vala:287: LatexmkPostProcessor: %s", e->message);
			_g_error_free0 (e);
			__g_node_destroy__build_msg_free0_0 (latexmk_messages);
			_g_object_unref0 (all_output_pp);
			_g_free0 (latexmk_output);
			build_msg_destroy (&cmd_line_msg);
			build_msg_destroy (&title_msg);
			_g_free0 (rule);
			__g_node_destroy__build_msg_free0_0 (cmd_messages);
			break;
		}
		__finally46:
		if (_inner_error_ != NULL) {
			__g_node_destroy__build_msg_free0_0 (latexmk_messages);
			_g_object_unref0 (all_output_pp);
			_g_free0 (latexmk_output);
			build_msg_destroy (&cmd_line_msg);
			build_msg_destroy (&title_msg);
			_g_free0 (rule);
			__g_node_destroy__build_msg_free0_0 (cmd_messages);
			_g_match_info_free0 (match_info);
			_g_free0 (last_latex_output);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		__g_node_destroy__build_msg_free0_0 (latexmk_messages);
		_g_object_unref0 (all_output_pp);
		_g_free0 (latexmk_output);
		build_msg_destroy (&cmd_line_msg);
		build_msg_destroy (&title_msg);
		_g_free0 (rule);
		__g_node_destroy__build_msg_free0_0 (cmd_messages);
	}
	if (last_latex_output != NULL) {
		LatexPostProcessor* _tmp30_ = NULL;
		PostProcessor* latex_pp;
		GNode* _tmp31_ = NULL;
		GNode* latex_messages;
		GNode* _tmp32_ = NULL;
		GNode* _tmp33_ = NULL;
		gboolean last_cmd_is_latex_cmd;
		gboolean _tmp34_ = FALSE;
		_tmp30_ = latex_post_processor_new ();
		latex_pp = (PostProcessor*) _tmp30_;
		post_processor_process (latex_pp, file, last_latex_output);
		_tmp31_ = post_processor_get_messages (latex_pp);
		latex_messages = _tmp31_;
		_tmp32_ = g_node_last_child (((PostProcessor*) self)->_all_messages);
		_tmp33_ = g_node_prev_sibling (_tmp32_);
		last_cmd_is_latex_cmd = _tmp33_ == last_latex_node;
		if (!self->priv->_force_show_all) {
			gboolean _tmp35_ = FALSE;
			gboolean _tmp36_;
			_tmp36_ = post_processor_get_successful ((PostProcessor*) self);
			if (_tmp36_) {
				_tmp35_ = TRUE;
			} else {
				_tmp35_ = last_cmd_is_latex_cmd;
			}
			_tmp34_ = _tmp35_;
		} else {
			_tmp34_ = FALSE;
		}
		if (_tmp34_) {
			GNode* _tmp37_;
			_tmp37_ = latex_messages;
			latex_messages = NULL;
			__g_node_destroy__build_msg_free0_0 (((PostProcessor*) self)->_all_messages);
			((PostProcessor*) self)->_all_messages = _tmp37_;
		} else {
			BuildMsg* _tmp38_;
			GNode* _tmp39_ = NULL;
			GNode* _tmp40_ = NULL;
			gint _tmp41_;
			gint pos;
			GNode* _tmp42_ = NULL;
			GNode* _tmp43_;
			GNode* _tmp44_;
			_tmp38_ = _build_msg_dup0 ((BuildMsg*) last_latex_node->data);
			_build_msg_free0 (latex_messages->data);
			latex_messages->data = _tmp38_;
			(*((BuildMsg*) latex_messages->data)).expand = TRUE;
			_tmp39_ = g_node_first_child (last_latex_node);
			_tmp40_ = g_node_unlink_vala (_tmp39_);
			g_node_insert (latex_messages, 0, _tmp40_);
			_tmp41_ = g_node_child_position (((PostProcessor*) self)->_all_messages, last_latex_node);
			pos = _tmp41_;
			_tmp42_ = g_node_unlink_vala (last_latex_node);
			_tmp43_ = _tmp42_;
			__g_node_destroy__build_msg_free0_0 (_tmp43_);
			_tmp44_ = latex_messages;
			latex_messages = NULL;
			g_node_insert (((PostProcessor*) self)->_all_messages, pos, _tmp44_);
		}
		__g_node_destroy__build_msg_free0_0 (latex_messages);
		_g_object_unref0 (latex_pp);
	}
	if (((PostProcessor*) self)->_all_messages->children != NULL) {
		_g_match_info_free0 (match_info);
		_g_free0 (last_latex_output);
		return;
	}
	_tmp45_ = all_output_post_processor_new ();
	all_output_pp = (PostProcessor*) _tmp45_;
	_tmp47_ = g_regex_match (latexmk_post_processor__reg_no_rule, output, 0, &_tmp46_);
	_g_match_info_free0 (match_info);
	match_info = _tmp46_;
	if (_tmp47_) {
		gchar* _tmp48_ = NULL;
		gchar* all_output;
		_tmp48_ = g_match_info_fetch_named (match_info, "output");
		all_output = _tmp48_;
		post_processor_process (all_output_pp, file, all_output);
		_g_free0 (all_output);
	} else {
		post_processor_process (all_output_pp, file, output);
	}
	_tmp49_ = post_processor_get_messages (all_output_pp);
	__g_node_destroy__build_msg_free0_0 (((PostProcessor*) self)->_all_messages);
	((PostProcessor*) self)->_all_messages = _tmp49_;
	_g_object_unref0 (all_output_pp);
	_g_match_info_free0 (match_info);
	_g_free0 (last_latex_output);
}


static void latexmk_post_processor_class_init (LatexmkPostProcessorClass * klass) {
	latexmk_post_processor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (LatexmkPostProcessorPrivate));
	POST_PROCESSOR_CLASS (klass)->process = latexmk_post_processor_real_process;
	G_OBJECT_CLASS (klass)->finalize = latexmk_post_processor_finalize;
}


static void latexmk_post_processor_instance_init (LatexmkPostProcessor * self) {
	self->priv = LATEXMK_POST_PROCESSOR_GET_PRIVATE (self);
}


static void latexmk_post_processor_finalize (GObject* obj) {
	LatexmkPostProcessor * self;
	self = LATEXMK_POST_PROCESSOR (obj);
	G_OBJECT_CLASS (latexmk_post_processor_parent_class)->finalize (obj);
}


GType latexmk_post_processor_get_type (void) {
	static volatile gsize latexmk_post_processor_type_id__volatile = 0;
	if (g_once_init_enter (&latexmk_post_processor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LatexmkPostProcessorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) latexmk_post_processor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LatexmkPostProcessor), 0, (GInstanceInitFunc) latexmk_post_processor_instance_init, NULL };
		GType latexmk_post_processor_type_id;
		latexmk_post_processor_type_id = g_type_register_static (TYPE_POST_PROCESSOR, "LatexmkPostProcessor", &g_define_type_info, 0);
		g_once_init_leave (&latexmk_post_processor_type_id__volatile, latexmk_post_processor_type_id);
	}
	return latexmk_post_processor_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



