/* latex_post_processor.c generated by valac 0.12.1, the Vala compiler
 * generated from latex_post_processor.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>


#define TYPE_POST_PROCESSOR (post_processor_get_type ())
#define POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_POST_PROCESSOR, PostProcessor))
#define POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_POST_PROCESSOR, PostProcessorClass))
#define IS_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_POST_PROCESSOR))
#define IS_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_POST_PROCESSOR))
#define POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_POST_PROCESSOR, PostProcessorClass))

typedef struct _PostProcessor PostProcessor;
typedef struct _PostProcessorClass PostProcessorClass;
typedef struct _PostProcessorPrivate PostProcessorPrivate;

#define TYPE_BUILD_MSG (build_msg_get_type ())

#define TYPE_BUILD_MSG_TYPE (build_msg_type_get_type ())
typedef struct _BuildMsg BuildMsg;

#define TYPE_LATEX_POST_PROCESSOR (latex_post_processor_get_type ())
#define LATEX_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LATEX_POST_PROCESSOR, LatexPostProcessor))
#define LATEX_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LATEX_POST_PROCESSOR, LatexPostProcessorClass))
#define IS_LATEX_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LATEX_POST_PROCESSOR))
#define IS_LATEX_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LATEX_POST_PROCESSOR))
#define LATEX_POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LATEX_POST_PROCESSOR, LatexPostProcessorClass))

typedef struct _LatexPostProcessor LatexPostProcessor;
typedef struct _LatexPostProcessorClass LatexPostProcessorClass;
typedef struct _LatexPostProcessorPrivate LatexPostProcessorPrivate;

#define LATEX_POST_PROCESSOR_TYPE_FILTER_STATUS (latex_post_processor_filter_status_get_type ())

#define LATEX_POST_PROCESSOR_TYPE_FILE_IN_STACK (latex_post_processor_file_in_stack_get_type ())
typedef struct _LatexPostProcessorFileInStack LatexPostProcessorFileInStack;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_slist_free__latex_post_processor_file_in_stack_free0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__latex_post_processor_file_in_stack_free0_ (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_match_info_free0(var) ((var == NULL) ? NULL : (var = (g_match_info_free (var), NULL)))

typedef enum  {
	BUILD_MSG_TYPE_ERROR,
	BUILD_MSG_TYPE_WARNING,
	BUILD_MSG_TYPE_BADBOX,
	BUILD_MSG_TYPE_OTHER
} BuildMsgType;

struct _BuildMsg {
	gchar* text;
	BuildMsgType type;
	gchar* filename;
	gboolean lines_set;
	gint start_line;
	gint end_line;
	gboolean expand;
};

struct _PostProcessor {
	GObject parent_instance;
	PostProcessorPrivate * priv;
	GNode* _all_messages;
};

struct _PostProcessorClass {
	GObjectClass parent_class;
	void (*process) (PostProcessor* self, GFile* file, const gchar* output);
};

struct _LatexPostProcessor {
	PostProcessor parent_instance;
	LatexPostProcessorPrivate * priv;
};

struct _LatexPostProcessorClass {
	PostProcessorClass parent_class;
};

typedef enum  {
	LATEX_POST_PROCESSOR_FILTER_STATUS_START,
	LATEX_POST_PROCESSOR_FILTER_STATUS_BADBOX,
	LATEX_POST_PROCESSOR_FILTER_STATUS_WARNING,
	LATEX_POST_PROCESSOR_FILTER_STATUS_ERROR,
	LATEX_POST_PROCESSOR_FILTER_STATUS_ERROR_SEARCH_LINE,
	LATEX_POST_PROCESSOR_FILTER_STATUS_FILENAME,
	LATEX_POST_PROCESSOR_FILTER_STATUS_FILENAME_HEURISTIC
} LatexPostProcessorFilterStatus;

struct _LatexPostProcessorFileInStack {
	gchar* filename;
	gboolean reliable;
	gboolean exists;
};

struct _LatexPostProcessorPrivate {
	BuildMsg msg;
	LatexPostProcessorFilterStatus status;
	gchar* line_buf;
	gint nb_lines;
	gchar* filename_buf;
	GSList* stack_files;
	gchar* directory_path;
	gint nb_badboxes;
	gint nb_warnings;
	gint nb_errors;
};


static gpointer latex_post_processor_parent_class = NULL;
static GRegex* latex_post_processor_reg_badbox;
static GRegex* latex_post_processor_reg_badbox = NULL;
static GRegex* latex_post_processor_reg_badbox_lines;
static GRegex* latex_post_processor_reg_badbox_lines = NULL;
static GRegex* latex_post_processor_reg_badbox_line;
static GRegex* latex_post_processor_reg_badbox_line = NULL;
static GRegex* latex_post_processor_reg_badbox_output;
static GRegex* latex_post_processor_reg_badbox_output = NULL;
static GRegex* latex_post_processor_reg_warning;
static GRegex* latex_post_processor_reg_warning = NULL;
static GRegex* latex_post_processor_reg_warning_no_file;
static GRegex* latex_post_processor_reg_warning_no_file = NULL;
static GRegex* latex_post_processor_reg_warning_line;
static GRegex* latex_post_processor_reg_warning_line = NULL;
static GRegex* latex_post_processor_reg_warning_international_line;
static GRegex* latex_post_processor_reg_warning_international_line = NULL;
static GRegex* latex_post_processor_reg_latex_error;
static GRegex* latex_post_processor_reg_latex_error = NULL;
static GRegex* latex_post_processor_reg_pdflatex_error;
static GRegex* latex_post_processor_reg_pdflatex_error = NULL;
static GRegex* latex_post_processor_reg_tex_error;
static GRegex* latex_post_processor_reg_tex_error = NULL;
static GRegex* latex_post_processor_reg_error_line;
static GRegex* latex_post_processor_reg_error_line = NULL;
static GRegex* latex_post_processor_reg_file_pop;
static GRegex* latex_post_processor_reg_file_pop = NULL;
static GRegex* latex_post_processor_reg_other_bytes;
static GRegex* latex_post_processor_reg_other_bytes = NULL;
static GRegex* latex_post_processor_reg_spaces;
static GRegex* latex_post_processor_reg_spaces = NULL;

GType post_processor_get_type (void) G_GNUC_CONST;
GType build_msg_get_type (void) G_GNUC_CONST;
GType build_msg_type_get_type (void) G_GNUC_CONST;
BuildMsg* build_msg_dup (const BuildMsg* self);
void build_msg_free (BuildMsg* self);
void build_msg_copy (const BuildMsg* self, BuildMsg* dest);
void build_msg_destroy (BuildMsg* self);
GType latex_post_processor_get_type (void) G_GNUC_CONST;
static GType latex_post_processor_filter_status_get_type (void) G_GNUC_UNUSED;
static GType latex_post_processor_file_in_stack_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static LatexPostProcessorFileInStack* latex_post_processor_file_in_stack_dup (const LatexPostProcessorFileInStack* self);
static void latex_post_processor_file_in_stack_free (LatexPostProcessorFileInStack* self);
static void latex_post_processor_file_in_stack_copy (const LatexPostProcessorFileInStack* self, LatexPostProcessorFileInStack* dest);
static void latex_post_processor_file_in_stack_destroy (LatexPostProcessorFileInStack* self);
#define LATEX_POST_PROCESSOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LATEX_POST_PROCESSOR, LatexPostProcessorPrivate))
enum  {
	LATEX_POST_PROCESSOR_DUMMY_PROPERTY
};
static void _latex_post_processor_file_in_stack_free0_ (gpointer var);
static void _g_slist_free__latex_post_processor_file_in_stack_free0_ (GSList* self);
#define LATEX_POST_PROCESSOR_NO_LINE (-1)
LatexPostProcessor* latex_post_processor_new (void);
LatexPostProcessor* latex_post_processor_construct (GType object_type);
PostProcessor* post_processor_construct (GType object_type);
static void latex_post_processor_reset_msg (LatexPostProcessor* self);
static void latex_post_processor_real_process (PostProcessor* base, GFile* file, const gchar* output);
static void latex_post_processor_latex_output_filter (LatexPostProcessor* self, const gchar* line);
static void latex_post_processor_add_msg (LatexPostProcessor* self, gboolean set_filename);
static gboolean latex_post_processor_detect_badbox (LatexPostProcessor* self, const gchar* line);
static gboolean latex_post_processor_detect_warning (LatexPostProcessor* self, const gchar* line);
static gboolean latex_post_processor_detect_error (LatexPostProcessor* self, const gchar* line);
static gboolean latex_post_processor_detect_other (LatexPostProcessor* self, const gchar* line);
static void latex_post_processor_update_stack_file (LatexPostProcessor* self, const gchar* line);
static gboolean latex_post_processor_detect_badbox_line (LatexPostProcessor* self, const gchar* badbox, gboolean current_line_is_empty);
static gboolean latex_post_processor_detect_warning_line (LatexPostProcessor* self, const gchar* warning, gboolean current_line_is_empty);
static void latex_post_processor_pop_file_from_stack (LatexPostProcessor* self);
static void latex_post_processor_update_stack_file_heuristic (LatexPostProcessor* self, const gchar* line);
static void latex_post_processor_push_file_on_stack (LatexPostProcessor* self, const gchar* filename, gboolean reliable);
static gboolean latex_post_processor_file_exists (LatexPostProcessor* self, const gchar* filename);
static gboolean latex_post_processor_top_file_on_stack_is_reliable (LatexPostProcessor* self);
static gchar* latex_post_processor_get_path_if_file_exists (LatexPostProcessor* self, const gchar* filename);
static gchar* latex_post_processor_get_current_filename (LatexPostProcessor* self);
GNode* post_processor_append_message (PostProcessor* self, BuildMsg* message);
static void latex_post_processor_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static GType latex_post_processor_filter_status_get_type (void) {
	static volatile gsize latex_post_processor_filter_status_type_id__volatile = 0;
	if (g_once_init_enter (&latex_post_processor_filter_status_type_id__volatile)) {
		static const GEnumValue values[] = {{LATEX_POST_PROCESSOR_FILTER_STATUS_START, "LATEX_POST_PROCESSOR_FILTER_STATUS_START", "start"}, {LATEX_POST_PROCESSOR_FILTER_STATUS_BADBOX, "LATEX_POST_PROCESSOR_FILTER_STATUS_BADBOX", "badbox"}, {LATEX_POST_PROCESSOR_FILTER_STATUS_WARNING, "LATEX_POST_PROCESSOR_FILTER_STATUS_WARNING", "warning"}, {LATEX_POST_PROCESSOR_FILTER_STATUS_ERROR, "LATEX_POST_PROCESSOR_FILTER_STATUS_ERROR", "error"}, {LATEX_POST_PROCESSOR_FILTER_STATUS_ERROR_SEARCH_LINE, "LATEX_POST_PROCESSOR_FILTER_STATUS_ERROR_SEARCH_LINE", "error-search-line"}, {LATEX_POST_PROCESSOR_FILTER_STATUS_FILENAME, "LATEX_POST_PROCESSOR_FILTER_STATUS_FILENAME", "filename"}, {LATEX_POST_PROCESSOR_FILTER_STATUS_FILENAME_HEURISTIC, "LATEX_POST_PROCESSOR_FILTER_STATUS_FILENAME_HEURISTIC", "filename-heuristic"}, {0, NULL, NULL}};
		GType latex_post_processor_filter_status_type_id;
		latex_post_processor_filter_status_type_id = g_enum_register_static ("LatexPostProcessorFilterStatus", values);
		g_once_init_leave (&latex_post_processor_filter_status_type_id__volatile, latex_post_processor_filter_status_type_id);
	}
	return latex_post_processor_filter_status_type_id__volatile;
}


static void _latex_post_processor_file_in_stack_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (latex_post_processor_file_in_stack_free (var), NULL));
}


static void _g_slist_free__latex_post_processor_file_in_stack_free0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _latex_post_processor_file_in_stack_free0_, NULL);
	g_slist_free (self);
}


LatexPostProcessor* latex_post_processor_construct (GType object_type) {
	LatexPostProcessor * self = NULL;
	GRegex* _tmp0_ = NULL;
	GRegex* _tmp1_;
	GRegex* _tmp2_ = NULL;
	GRegex* _tmp3_;
	GRegex* _tmp4_ = NULL;
	GRegex* _tmp5_;
	GRegex* _tmp6_ = NULL;
	GRegex* _tmp7_;
	gchar* _tmp8_;
	gchar* warning_str;
	gchar* _tmp9_;
	GRegex* _tmp10_ = NULL;
	GRegex* _tmp11_;
	GRegex* _tmp12_ = NULL;
	GRegex* _tmp13_;
	GRegex* _tmp14_ = NULL;
	GRegex* _tmp15_;
	GRegex* _tmp16_ = NULL;
	GRegex* _tmp17_;
	GRegex* _tmp18_ = NULL;
	GRegex* _tmp19_;
	GRegex* _tmp20_ = NULL;
	GRegex* _tmp21_;
	GRegex* _tmp22_ = NULL;
	GRegex* _tmp23_;
	GRegex* _tmp24_ = NULL;
	GRegex* _tmp25_;
	GRegex* _tmp26_ = NULL;
	GRegex* _tmp27_;
	GRegex* _tmp28_ = NULL;
	GRegex* _tmp29_;
	GRegex* _tmp30_ = NULL;
	GRegex* _tmp31_;
	GError * _inner_error_ = NULL;
	self = (LatexPostProcessor*) post_processor_construct (object_type);
	latex_post_processor_reset_msg (self);
	if (latex_post_processor_reg_badbox != NULL) {
		return self;
	}
	_tmp0_ = g_regex_new ("^(Over|Under)full \\\\[hv]box", 0, 0, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch25_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_regex_unref0 (latex_post_processor_reg_badbox);
	latex_post_processor_reg_badbox = _tmp1_;
	_tmp2_ = g_regex_new ("(.*) at lines (\\d+)--(\\d+)", 0, 0, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch25_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_regex_unref0 (latex_post_processor_reg_badbox_lines);
	latex_post_processor_reg_badbox_lines = _tmp3_;
	_tmp4_ = g_regex_new ("(.*) at line (\\d+)", 0, 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch25_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_regex_unref0 (latex_post_processor_reg_badbox_line);
	latex_post_processor_reg_badbox_line = _tmp5_;
	_tmp6_ = g_regex_new ("(.*)has occurred while \\output is active", 0, 0, &_inner_error_);
	_tmp7_ = _tmp6_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch25_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_regex_unref0 (latex_post_processor_reg_badbox_output);
	latex_post_processor_reg_badbox_output = _tmp7_;
	_tmp8_ = g_strdup ("^(((! )?(La|pdf)TeX)|Package|Class)");
	warning_str = _tmp8_;
	_tmp9_ = g_strconcat (warning_str, "(?P<name>.*) Warning[^:]*:\\s*(?P<contents>.*)", NULL);
	_g_free0 (warning_str);
	warning_str = _tmp9_;
	_tmp10_ = g_regex_new (warning_str, G_REGEX_CASELESS | G_REGEX_OPTIMIZE, 0, &_inner_error_);
	_tmp11_ = _tmp10_;
	if (_inner_error_ != NULL) {
		_g_free0 (warning_str);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch25_g_regex_error;
		}
		_g_free0 (warning_str);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_regex_unref0 (latex_post_processor_reg_warning);
	latex_post_processor_reg_warning = _tmp11_;
	_tmp12_ = g_regex_new ("(No file .*)", 0, 0, &_inner_error_);
	_tmp13_ = _tmp12_;
	if (_inner_error_ != NULL) {
		_g_free0 (warning_str);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch25_g_regex_error;
		}
		_g_free0 (warning_str);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_regex_unref0 (latex_post_processor_reg_warning_no_file);
	latex_post_processor_reg_warning_no_file = _tmp13_;
	_tmp14_ = g_regex_new ("(.*) on input line (\\d+)\\.$", 0, 0, &_inner_error_);
	_tmp15_ = _tmp14_;
	if (_inner_error_ != NULL) {
		_g_free0 (warning_str);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch25_g_regex_error;
		}
		_g_free0 (warning_str);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_regex_unref0 (latex_post_processor_reg_warning_line);
	latex_post_processor_reg_warning_line = _tmp15_;
	_tmp16_ = g_regex_new ("(.*)(\\d+)\\.$", 0, 0, &_inner_error_);
	_tmp17_ = _tmp16_;
	if (_inner_error_ != NULL) {
		_g_free0 (warning_str);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch25_g_regex_error;
		}
		_g_free0 (warning_str);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_regex_unref0 (latex_post_processor_reg_warning_international_line);
	latex_post_processor_reg_warning_international_line = _tmp17_;
	_tmp18_ = g_regex_new ("^! LaTeX Error: (.*)$", 0, 0, &_inner_error_);
	_tmp19_ = _tmp18_;
	if (_inner_error_ != NULL) {
		_g_free0 (warning_str);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch25_g_regex_error;
		}
		_g_free0 (warning_str);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_regex_unref0 (latex_post_processor_reg_latex_error);
	latex_post_processor_reg_latex_error = _tmp19_;
	_tmp20_ = g_regex_new ("^Error: pdflatex (.*)$", 0, 0, &_inner_error_);
	_tmp21_ = _tmp20_;
	if (_inner_error_ != NULL) {
		_g_free0 (warning_str);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch25_g_regex_error;
		}
		_g_free0 (warning_str);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_regex_unref0 (latex_post_processor_reg_pdflatex_error);
	latex_post_processor_reg_pdflatex_error = _tmp21_;
	_tmp22_ = g_regex_new ("^! (.*)\\.$", 0, 0, &_inner_error_);
	_tmp23_ = _tmp22_;
	if (_inner_error_ != NULL) {
		_g_free0 (warning_str);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch25_g_regex_error;
		}
		_g_free0 (warning_str);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_regex_unref0 (latex_post_processor_reg_tex_error);
	latex_post_processor_reg_tex_error = _tmp23_;
	_tmp24_ = g_regex_new ("^l\\.(\\d+)(.*)", 0, 0, &_inner_error_);
	_tmp25_ = _tmp24_;
	if (_inner_error_ != NULL) {
		_g_free0 (warning_str);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch25_g_regex_error;
		}
		_g_free0 (warning_str);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_regex_unref0 (latex_post_processor_reg_error_line);
	latex_post_processor_reg_error_line = _tmp25_;
	_tmp26_ = g_regex_new ("(\\) )?:<-$", 0, 0, &_inner_error_);
	_tmp27_ = _tmp26_;
	if (_inner_error_ != NULL) {
		_g_free0 (warning_str);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch25_g_regex_error;
		}
		_g_free0 (warning_str);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_regex_unref0 (latex_post_processor_reg_file_pop);
	latex_post_processor_reg_file_pop = _tmp27_;
	_tmp28_ = g_regex_new ("(?P<nb>\\d+) bytes", 0, 0, &_inner_error_);
	_tmp29_ = _tmp28_;
	if (_inner_error_ != NULL) {
		_g_free0 (warning_str);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch25_g_regex_error;
		}
		_g_free0 (warning_str);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_regex_unref0 (latex_post_processor_reg_other_bytes);
	latex_post_processor_reg_other_bytes = _tmp29_;
	_tmp30_ = g_regex_new ("\\s{2,}", 0, 0, &_inner_error_);
	_tmp31_ = _tmp30_;
	if (_inner_error_ != NULL) {
		_g_free0 (warning_str);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch25_g_regex_error;
		}
		_g_free0 (warning_str);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_regex_unref0 (latex_post_processor_reg_spaces);
	latex_post_processor_reg_spaces = _tmp31_;
	_g_free0 (warning_str);
	goto __finally25;
	__catch25_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("latex_post_processor.vala:128: LatexPostProcessor: %s", e->message);
		_g_error_free0 (e);
	}
	__finally25:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


LatexPostProcessor* latex_post_processor_new (void) {
	return latex_post_processor_construct (TYPE_LATEX_POST_PROCESSOR);
}


static void latex_post_processor_real_process (PostProcessor* base, GFile* file, const gchar* output) {
	LatexPostProcessor * self;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar** _tmp3_;
	gchar** _tmp4_ = NULL;
	gchar** lines;
	gint lines_length1;
	gint _lines_size_;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	self = (LatexPostProcessor*) base;
	g_return_if_fail (file != NULL);
	g_return_if_fail (output != NULL);
	_tmp0_ = g_file_get_parent (file);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_get_parse_name (_tmp1_);
	_g_free0 (self->priv->directory_path);
	self->priv->directory_path = _tmp2_;
	_g_object_unref0 (_tmp1_);
	_tmp4_ = _tmp3_ = g_strsplit (output, "\n", 0);
	lines = _tmp4_;
	lines_length1 = _vala_array_length (_tmp3_);
	_lines_size_ = _vala_array_length (_tmp3_);
	{
		gchar** line_collection;
		int line_collection_length1;
		int line_it;
		line_collection = lines;
		line_collection_length1 = lines_length1;
		for (line_it = 0; line_it < lines_length1; line_it = line_it + 1) {
			gchar* _tmp5_;
			gchar* line;
			_tmp5_ = g_strdup (line_collection[line_it]);
			line = _tmp5_;
			{
				latex_post_processor_latex_output_filter (self, line);
				_g_free0 (line);
			}
		}
	}
	if (self->priv->nb_errors == 1) {
		_tmp6_ = "error";
	} else {
		_tmp6_ = "errors";
	}
	if (self->priv->nb_warnings == 1) {
		_tmp7_ = "warning";
	} else {
		_tmp7_ = "warnings";
	}
	if (self->priv->nb_badboxes == 1) {
		_tmp8_ = "badbox";
	} else {
		_tmp8_ = "badboxes";
	}
	_tmp9_ = g_strdup_printf ("%d %s, %d %s, %d %s", self->priv->nb_errors, _tmp6_, self->priv->nb_warnings, _tmp7_, self->priv->nb_badboxes, _tmp8_);
	_g_free0 (self->priv->msg.text);
	self->priv->msg.text = _tmp9_;
	self->priv->msg.type = BUILD_MSG_TYPE_OTHER;
	latex_post_processor_add_msg (self, FALSE);
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
}


static void latex_post_processor_latex_output_filter (LatexPostProcessor* self, const gchar* line) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (line != NULL);
	switch (self->priv->status) {
		case LATEX_POST_PROCESSOR_FILTER_STATUS_START:
		{
			gint _tmp0_;
			gboolean _tmp1_ = FALSE;
			gboolean _tmp2_ = FALSE;
			gboolean _tmp3_ = FALSE;
			gboolean _tmp4_;
			_tmp0_ = strlen (line);
			if (_tmp0_ == 0) {
				return;
			}
			_tmp4_ = latex_post_processor_detect_badbox (self, line);
			if (_tmp4_) {
				_tmp3_ = TRUE;
			} else {
				gboolean _tmp5_;
				_tmp5_ = latex_post_processor_detect_warning (self, line);
				_tmp3_ = _tmp5_;
			}
			if (_tmp3_) {
				_tmp2_ = TRUE;
			} else {
				gboolean _tmp6_;
				_tmp6_ = latex_post_processor_detect_error (self, line);
				_tmp2_ = _tmp6_;
			}
			if (_tmp2_) {
				_tmp1_ = TRUE;
			} else {
				gboolean _tmp7_;
				_tmp7_ = latex_post_processor_detect_other (self, line);
				_tmp1_ = _tmp7_;
			}
			if (!_tmp1_) {
				latex_post_processor_update_stack_file (self, line);
			}
			break;
		}
		case LATEX_POST_PROCESSOR_FILTER_STATUS_BADBOX:
		{
			latex_post_processor_detect_badbox (self, line);
			break;
		}
		case LATEX_POST_PROCESSOR_FILTER_STATUS_WARNING:
		{
			latex_post_processor_detect_warning (self, line);
			break;
		}
		case LATEX_POST_PROCESSOR_FILTER_STATUS_ERROR:
		case LATEX_POST_PROCESSOR_FILTER_STATUS_ERROR_SEARCH_LINE:
		{
			latex_post_processor_detect_error (self, line);
			break;
		}
		case LATEX_POST_PROCESSOR_FILTER_STATUS_FILENAME:
		case LATEX_POST_PROCESSOR_FILTER_STATUS_FILENAME_HEURISTIC:
		{
			latex_post_processor_update_stack_file (self, line);
			break;
		}
		default:
		{
			self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
			break;
		}
	}
}


static gboolean latex_post_processor_detect_badbox (LatexPostProcessor* self, const gchar* line) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	switch (self->priv->status) {
		case LATEX_POST_PROCESSOR_FILTER_STATUS_START:
		{
			gboolean _tmp0_;
			gboolean _tmp1_;
			_tmp0_ = g_regex_match (latex_post_processor_reg_badbox, line, 0, NULL);
			if (!_tmp0_) {
				result = FALSE;
				return result;
			}
			self->priv->msg.type = BUILD_MSG_TYPE_BADBOX;
			_tmp1_ = latex_post_processor_detect_badbox_line (self, line, FALSE);
			if (_tmp1_) {
				latex_post_processor_add_msg (self, TRUE);
			} else {
				gchar* _tmp2_;
				_tmp2_ = g_strdup (line);
				_g_free0 (self->priv->line_buf);
				self->priv->line_buf = _tmp2_;
				self->priv->nb_lines++;
			}
			result = TRUE;
			return result;
		}
		case LATEX_POST_PROCESSOR_FILTER_STATUS_BADBOX:
		{
			gchar* _tmp3_;
			gint _tmp4_;
			gboolean _tmp5_;
			_tmp3_ = g_strconcat (self->priv->line_buf, line, NULL);
			_g_free0 (self->priv->line_buf);
			self->priv->line_buf = _tmp3_;
			self->priv->nb_lines++;
			_tmp4_ = strlen (line);
			_tmp5_ = latex_post_processor_detect_badbox_line (self, self->priv->line_buf, _tmp4_ == 0);
			if (_tmp5_) {
				latex_post_processor_add_msg (self, TRUE);
				self->priv->nb_lines = 0;
			}
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}


static gboolean latex_post_processor_detect_badbox_line (LatexPostProcessor* self, const gchar* badbox, gboolean current_line_is_empty) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (badbox != NULL, FALSE);
	_tmp0_ = g_regex_match (latex_post_processor_reg_badbox_lines, badbox, 0, NULL);
	if (_tmp0_) {
		gchar** _tmp1_;
		gchar** _tmp2_ = NULL;
		gchar** strings;
		gint strings_length1;
		gint _strings_size_;
		gchar* _tmp3_;
		gint _tmp4_;
		gint n1;
		gint _tmp5_;
		gint n2;
		self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
		_tmp2_ = _tmp1_ = g_regex_split (latex_post_processor_reg_badbox_lines, badbox, 0);
		strings = _tmp2_;
		strings_length1 = _vala_array_length (_tmp1_);
		_strings_size_ = _vala_array_length (_tmp1_);
		_tmp3_ = g_strdup (strings[1]);
		_g_free0 (self->priv->msg.text);
		self->priv->msg.text = _tmp3_;
		_tmp4_ = atoi (strings[2]);
		n1 = _tmp4_;
		_tmp5_ = atoi (strings[3]);
		n2 = _tmp5_;
		if (n1 <= n2) {
			self->priv->msg.start_line = n1;
			self->priv->msg.end_line = n2;
		} else {
			self->priv->msg.start_line = n2;
			self->priv->msg.end_line = n1;
		}
		result = TRUE;
		strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
		return result;
	} else {
		gboolean _tmp6_;
		_tmp6_ = g_regex_match (latex_post_processor_reg_badbox_line, badbox, 0, NULL);
		if (_tmp6_) {
			gchar** _tmp7_;
			gchar** _tmp8_ = NULL;
			gchar** strings;
			gint strings_length1;
			gint _strings_size_;
			gchar* _tmp9_;
			gint _tmp10_;
			self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
			_tmp8_ = _tmp7_ = g_regex_split (latex_post_processor_reg_badbox_line, badbox, 0);
			strings = _tmp8_;
			strings_length1 = _vala_array_length (_tmp7_);
			_strings_size_ = _vala_array_length (_tmp7_);
			_tmp9_ = g_strdup (strings[1]);
			_g_free0 (self->priv->msg.text);
			self->priv->msg.text = _tmp9_;
			_tmp10_ = atoi (strings[2]);
			self->priv->msg.start_line = _tmp10_;
			result = TRUE;
			strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
			return result;
		} else {
			gboolean _tmp11_;
			_tmp11_ = g_regex_match (latex_post_processor_reg_badbox_output, badbox, 0, NULL);
			if (_tmp11_) {
				gchar** _tmp12_;
				gchar** _tmp13_ = NULL;
				gchar** strings;
				gint strings_length1;
				gint _strings_size_;
				gchar* _tmp14_;
				self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
				_tmp13_ = _tmp12_ = g_regex_split (latex_post_processor_reg_badbox_output, badbox, 0);
				strings = _tmp13_;
				strings_length1 = _vala_array_length (_tmp12_);
				_strings_size_ = _vala_array_length (_tmp12_);
				_tmp14_ = g_strdup (strings[1]);
				_g_free0 (self->priv->msg.text);
				self->priv->msg.text = _tmp14_;
				self->priv->msg.start_line = LATEX_POST_PROCESSOR_NO_LINE;
				result = TRUE;
				strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
				return result;
			} else {
				gboolean _tmp15_ = FALSE;
				if (self->priv->nb_lines > 4) {
					_tmp15_ = TRUE;
				} else {
					_tmp15_ = current_line_is_empty;
				}
				if (_tmp15_) {
					gchar* _tmp16_;
					self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
					_tmp16_ = g_strdup (badbox);
					_g_free0 (self->priv->msg.text);
					self->priv->msg.text = _tmp16_;
					self->priv->msg.start_line = LATEX_POST_PROCESSOR_NO_LINE;
					result = TRUE;
					return result;
				}
			}
		}
	}
	self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_BADBOX;
	result = FALSE;
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gboolean latex_post_processor_detect_warning (LatexPostProcessor* self, const gchar* line) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	switch (self->priv->status) {
		case LATEX_POST_PROCESSOR_FILTER_STATUS_START:
		{
			GMatchInfo* match_info = NULL;
			GMatchInfo* _tmp0_ = NULL;
			gboolean _tmp1_;
			_tmp1_ = g_regex_match (latex_post_processor_reg_warning, line, 0, &_tmp0_);
			_g_match_info_free0 (match_info);
			match_info = _tmp0_;
			if (_tmp1_) {
				gchar* _tmp2_ = NULL;
				gchar* contents;
				gchar* _tmp3_ = NULL;
				gchar* _tmp4_;
				gchar* _tmp5_ = NULL;
				gchar* _tmp6_;
				gchar* name;
				gboolean _tmp10_;
				self->priv->msg.type = BUILD_MSG_TYPE_WARNING;
				_tmp2_ = g_match_info_fetch_named (match_info, "contents");
				contents = _tmp2_;
				_tmp3_ = g_match_info_fetch_named (match_info, "name");
				_tmp4_ = _tmp3_;
				_tmp5_ = string_strip (_tmp4_);
				_tmp6_ = _tmp5_;
				_g_free0 (_tmp4_);
				name = _tmp6_;
				if (g_strcmp0 (name, "") != 0) {
					const gchar* _tmp7_ = NULL;
					const gchar* _tmp8_ = NULL;
					gchar* _tmp9_ = NULL;
					_tmp7_ = string_to_string (name);
					_tmp8_ = string_to_string (contents);
					_tmp9_ = g_strconcat (_tmp7_, ": ", _tmp8_, NULL);
					_g_free0 (contents);
					contents = _tmp9_;
				}
				_tmp10_ = latex_post_processor_detect_warning_line (self, contents, FALSE);
				if (_tmp10_) {
					latex_post_processor_add_msg (self, TRUE);
				} else {
					gchar* _tmp11_;
					_tmp11_ = g_strdup (contents);
					_g_free0 (self->priv->line_buf);
					self->priv->line_buf = _tmp11_;
					self->priv->nb_lines++;
				}
				result = TRUE;
				_g_free0 (name);
				_g_free0 (contents);
				_g_match_info_free0 (match_info);
				return result;
			} else {
				gboolean _tmp12_;
				_tmp12_ = g_regex_match (latex_post_processor_reg_warning_no_file, line, 0, NULL);
				if (_tmp12_) {
					gchar** _tmp13_;
					gchar** _tmp14_ = NULL;
					gchar** strings;
					gint strings_length1;
					gint _strings_size_;
					gchar* _tmp15_;
					self->priv->msg.type = BUILD_MSG_TYPE_WARNING;
					_tmp14_ = _tmp13_ = g_regex_split (latex_post_processor_reg_warning_no_file, line, 0);
					strings = _tmp14_;
					strings_length1 = _vala_array_length (_tmp13_);
					_strings_size_ = _vala_array_length (_tmp13_);
					_tmp15_ = g_strdup (strings[1]);
					_g_free0 (self->priv->msg.text);
					self->priv->msg.text = _tmp15_;
					self->priv->msg.start_line = LATEX_POST_PROCESSOR_NO_LINE;
					latex_post_processor_add_msg (self, TRUE);
					result = TRUE;
					strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
					_g_match_info_free0 (match_info);
					return result;
				}
			}
			result = FALSE;
			_g_match_info_free0 (match_info);
			return result;
		}
		case LATEX_POST_PROCESSOR_FILTER_STATUS_WARNING:
		{
			gchar* _tmp16_;
			gint _tmp17_;
			gboolean _tmp18_;
			_tmp16_ = g_strconcat (self->priv->line_buf, line, NULL);
			_g_free0 (self->priv->line_buf);
			self->priv->line_buf = _tmp16_;
			self->priv->nb_lines++;
			_tmp17_ = strlen (line);
			_tmp18_ = latex_post_processor_detect_warning_line (self, self->priv->line_buf, _tmp17_ == 0);
			if (_tmp18_) {
				latex_post_processor_add_msg (self, TRUE);
				self->priv->nb_lines = 0;
			}
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


static gboolean latex_post_processor_detect_warning_line (LatexPostProcessor* self, const gchar* warning, gboolean current_line_is_empty) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (warning != NULL, FALSE);
	_tmp0_ = g_regex_match (latex_post_processor_reg_warning_line, warning, 0, NULL);
	if (_tmp0_) {
		gchar** _tmp1_;
		gchar** _tmp2_ = NULL;
		gchar** strings;
		gint strings_length1;
		gint _strings_size_;
		gchar* _tmp3_;
		gint _tmp4_;
		self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
		_tmp2_ = _tmp1_ = g_regex_split (latex_post_processor_reg_warning_line, warning, 0);
		strings = _tmp2_;
		strings_length1 = _vala_array_length (_tmp1_);
		_strings_size_ = _vala_array_length (_tmp1_);
		_tmp3_ = g_strdup (strings[1]);
		_g_free0 (self->priv->msg.text);
		self->priv->msg.text = _tmp3_;
		_tmp4_ = atoi (strings[2]);
		self->priv->msg.start_line = _tmp4_;
		result = TRUE;
		strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
		return result;
	} else {
		gboolean _tmp5_;
		_tmp5_ = g_regex_match (latex_post_processor_reg_warning_international_line, warning, 0, NULL);
		if (_tmp5_) {
			gchar** _tmp6_;
			gchar** _tmp7_ = NULL;
			gchar** strings;
			gint strings_length1;
			gint _strings_size_;
			gchar* _tmp8_;
			gint _tmp9_;
			self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
			_tmp7_ = _tmp6_ = g_regex_split (latex_post_processor_reg_warning_international_line, warning, 0);
			strings = _tmp7_;
			strings_length1 = _vala_array_length (_tmp6_);
			_strings_size_ = _vala_array_length (_tmp6_);
			_tmp8_ = g_strdup (strings[1]);
			_g_free0 (self->priv->msg.text);
			self->priv->msg.text = _tmp8_;
			_tmp9_ = atoi (strings[2]);
			self->priv->msg.start_line = _tmp9_;
			result = TRUE;
			strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
			return result;
		} else {
			gint _tmp10_;
			gchar _tmp11_;
			_tmp10_ = strlen (warning);
			_tmp11_ = string_get (warning, (glong) (_tmp10_ - 1));
			if (_tmp11_ == '.') {
				gchar* _tmp12_;
				self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
				_tmp12_ = g_strdup (warning);
				_g_free0 (self->priv->msg.text);
				self->priv->msg.text = _tmp12_;
				self->priv->msg.start_line = LATEX_POST_PROCESSOR_NO_LINE;
				result = TRUE;
				return result;
			} else {
				gboolean _tmp13_ = FALSE;
				if (self->priv->nb_lines > 5) {
					_tmp13_ = TRUE;
				} else {
					_tmp13_ = current_line_is_empty;
				}
				if (_tmp13_) {
					gchar* _tmp14_;
					self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
					_tmp14_ = g_strdup (warning);
					_g_free0 (self->priv->msg.text);
					self->priv->msg.text = _tmp14_;
					self->priv->msg.start_line = LATEX_POST_PROCESSOR_NO_LINE;
					result = TRUE;
					return result;
				}
			}
		}
	}
	self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_WARNING;
	result = FALSE;
	return result;
}


static gboolean latex_post_processor_detect_error (LatexPostProcessor* self, const gchar* line) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	switch (self->priv->status) {
		case LATEX_POST_PROCESSOR_FILTER_STATUS_START:
		{
			gboolean found;
			gchar* tmp;
			gboolean _tmp0_;
			found = TRUE;
			tmp = NULL;
			_tmp0_ = g_regex_match (latex_post_processor_reg_latex_error, line, 0, NULL);
			if (_tmp0_) {
				gchar** _tmp1_;
				gchar** _tmp2_ = NULL;
				gchar** strings;
				gint strings_length1;
				gint _strings_size_;
				gchar* _tmp3_;
				_tmp2_ = _tmp1_ = g_regex_split (latex_post_processor_reg_latex_error, line, 0);
				strings = _tmp2_;
				strings_length1 = _vala_array_length (_tmp1_);
				_strings_size_ = _vala_array_length (_tmp1_);
				_tmp3_ = g_strdup (strings[1]);
				_g_free0 (tmp);
				tmp = _tmp3_;
				strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
			} else {
				gboolean _tmp4_;
				_tmp4_ = g_regex_match (latex_post_processor_reg_pdflatex_error, line, 0, NULL);
				if (_tmp4_) {
					gchar** _tmp5_;
					gchar** _tmp6_ = NULL;
					gchar** strings;
					gint strings_length1;
					gint _strings_size_;
					gchar* _tmp7_;
					_tmp6_ = _tmp5_ = g_regex_split (latex_post_processor_reg_pdflatex_error, line, 0);
					strings = _tmp6_;
					strings_length1 = _vala_array_length (_tmp5_);
					_strings_size_ = _vala_array_length (_tmp5_);
					_tmp7_ = g_strdup (strings[1]);
					_g_free0 (tmp);
					tmp = _tmp7_;
					strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
				} else {
					gboolean _tmp8_;
					_tmp8_ = g_regex_match (latex_post_processor_reg_tex_error, line, 0, NULL);
					if (_tmp8_) {
						gchar** _tmp9_;
						gchar** _tmp10_ = NULL;
						gchar** strings;
						gint strings_length1;
						gint _strings_size_;
						gchar* _tmp11_;
						_tmp10_ = _tmp9_ = g_regex_split (latex_post_processor_reg_tex_error, line, 0);
						strings = _tmp10_;
						strings_length1 = _vala_array_length (_tmp9_);
						_strings_size_ = _vala_array_length (_tmp9_);
						_tmp11_ = g_strdup (strings[1]);
						_g_free0 (tmp);
						tmp = _tmp11_;
						strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
					} else {
						found = FALSE;
					}
				}
			}
			if (found) {
				gint _tmp12_;
				gchar _tmp13_;
				self->priv->nb_lines++;
				self->priv->msg.type = BUILD_MSG_TYPE_ERROR;
				_tmp12_ = strlen (line);
				_tmp13_ = string_get (line, (glong) (_tmp12_ - 1));
				if (_tmp13_ == '.') {
					gchar* _tmp14_;
					_tmp14_ = g_strdup (tmp);
					_g_free0 (self->priv->msg.text);
					self->priv->msg.text = _tmp14_;
					self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_ERROR_SEARCH_LINE;
				} else {
					gchar* _tmp15_;
					_tmp15_ = g_strdup (tmp);
					_g_free0 (self->priv->line_buf);
					self->priv->line_buf = _tmp15_;
					self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_ERROR;
				}
				result = TRUE;
				_g_free0 (tmp);
				return result;
			}
			result = FALSE;
			_g_free0 (tmp);
			return result;
		}
		case LATEX_POST_PROCESSOR_FILTER_STATUS_ERROR:
		{
			gchar* _tmp16_;
			gint _tmp17_;
			gchar _tmp18_;
			_tmp16_ = g_strconcat (self->priv->line_buf, line, NULL);
			_g_free0 (self->priv->line_buf);
			self->priv->line_buf = _tmp16_;
			self->priv->nb_lines++;
			_tmp17_ = strlen (line);
			_tmp18_ = string_get (line, (glong) (_tmp17_ - 1));
			if (_tmp18_ == '.') {
				gchar* _tmp19_;
				_tmp19_ = g_strdup (self->priv->line_buf);
				_g_free0 (self->priv->msg.text);
				self->priv->msg.text = _tmp19_;
				self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_ERROR_SEARCH_LINE;
			} else {
				if (self->priv->nb_lines > 4) {
					gchar* _tmp20_;
					_tmp20_ = g_strdup (self->priv->line_buf);
					_g_free0 (self->priv->msg.text);
					self->priv->msg.text = _tmp20_;
					self->priv->msg.start_line = LATEX_POST_PROCESSOR_NO_LINE;
					latex_post_processor_add_msg (self, TRUE);
					self->priv->nb_lines = 0;
					self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
				}
			}
			result = TRUE;
			return result;
		}
		case LATEX_POST_PROCESSOR_FILTER_STATUS_ERROR_SEARCH_LINE:
		{
			gboolean _tmp21_;
			self->priv->nb_lines++;
			_tmp21_ = g_regex_match (latex_post_processor_reg_error_line, line, 0, NULL);
			if (_tmp21_) {
				gchar** _tmp22_;
				gchar** _tmp23_ = NULL;
				gchar** strings;
				gint strings_length1;
				gint _strings_size_;
				gint _tmp24_;
				_tmp23_ = _tmp22_ = g_regex_split (latex_post_processor_reg_error_line, line, 0);
				strings = _tmp23_;
				strings_length1 = _vala_array_length (_tmp22_);
				_strings_size_ = _vala_array_length (_tmp22_);
				_tmp24_ = atoi (strings[1]);
				self->priv->msg.start_line = _tmp24_;
				latex_post_processor_add_msg (self, TRUE);
				self->priv->nb_lines = 0;
				self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
				result = TRUE;
				strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
				return result;
			} else {
				if (self->priv->nb_lines > 11) {
					self->priv->msg.start_line = LATEX_POST_PROCESSOR_NO_LINE;
					latex_post_processor_add_msg (self, TRUE);
					self->priv->nb_lines = 0;
					self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
					result = TRUE;
					return result;
				}
			}
			break;
		}
		default:
		{
			break;
		}
	}
	result = FALSE;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}


static gint64 int64_parse (const gchar* str) {
	gint64 result = 0LL;
	gint64 _tmp0_;
	g_return_val_if_fail (str != NULL, 0LL);
	_tmp0_ = g_ascii_strtoll (str, NULL, (guint) 0);
	result = _tmp0_;
	return result;
}


static gboolean latex_post_processor_detect_other (LatexPostProcessor* self, const gchar* line) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	GMatchInfo* match_info = NULL;
	GMatchInfo* _tmp1_ = NULL;
	gboolean _tmp2_;
	gchar* _tmp4_ = NULL;
	gchar* nb_bytes_str;
	gint64 _tmp5_;
	gint64 nb_bytes;
	gchar* _tmp6_ = NULL;
	gchar* human_size;
	gchar* _tmp7_ = NULL;
	gchar* new_line;
	gchar* _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	_tmp0_ = string_contains (line, "Output written on");
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	self->priv->msg.start_line = LATEX_POST_PROCESSOR_NO_LINE;
	self->priv->msg.type = BUILD_MSG_TYPE_OTHER;
	_tmp2_ = g_regex_match (latex_post_processor_reg_other_bytes, line, 0, &_tmp1_);
	_g_match_info_free0 (match_info);
	match_info = _tmp1_;
	if (!_tmp2_) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup (line);
		_g_free0 (self->priv->msg.text);
		self->priv->msg.text = _tmp3_;
		latex_post_processor_add_msg (self, FALSE);
		result = TRUE;
		_g_match_info_free0 (match_info);
		return result;
	}
	_tmp4_ = g_match_info_fetch_named (match_info, "nb");
	nb_bytes_str = _tmp4_;
	g_return_val_if_fail (nb_bytes_str != NULL, FALSE);
	_tmp5_ = int64_parse (nb_bytes_str);
	nb_bytes = _tmp5_;
	_tmp6_ = g_format_size_for_display (nb_bytes);
	human_size = _tmp6_;
	_tmp7_ = g_regex_replace_literal (latex_post_processor_reg_other_bytes, line, (gssize) (-1), 0, human_size, 0, &_inner_error_);
	new_line = _tmp7_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch26_g_regex_error;
		}
		_g_free0 (human_size);
		_g_free0 (nb_bytes_str);
		_g_match_info_free0 (match_info);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp8_ = g_strdup (new_line);
	_g_free0 (self->priv->msg.text);
	self->priv->msg.text = _tmp8_;
	_g_free0 (new_line);
	goto __finally26;
	__catch26_g_regex_error:
	{
		GError * e;
		gchar* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("latex_post_processor.vala:511: LaTeX post processor: %s", e->message);
		_tmp9_ = g_strdup (line);
		_g_free0 (self->priv->msg.text);
		self->priv->msg.text = _tmp9_;
		_g_error_free0 (e);
	}
	__finally26:
	if (_inner_error_ != NULL) {
		_g_free0 (human_size);
		_g_free0 (nb_bytes_str);
		_g_match_info_free0 (match_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	latex_post_processor_add_msg (self, FALSE);
	result = TRUE;
	_g_free0 (human_size);
	_g_free0 (nb_bytes_str);
	_g_match_info_free0 (match_info);
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_ = NULL;
	gchar* end;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	if (end == NULL) {
		result = maxlen;
		return result;
	} else {
		result = (glong) (end - str);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= 0) {
		_tmp0_ = len >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp1_;
		_tmp1_ = string_strnlen ((gchar*) self, offset + len);
		string_length = _tmp1_;
	} else {
		gint _tmp2_;
		_tmp2_ = strlen (self);
		string_length = (glong) _tmp2_;
	}
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}


static void latex_post_processor_update_stack_file (LatexPostProcessor* self, const gchar* line) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (line != NULL);
	switch (self->priv->status) {
		case LATEX_POST_PROCESSOR_FILTER_STATUS_START:
		case LATEX_POST_PROCESSOR_FILTER_STATUS_FILENAME_HEURISTIC:
		{
			gboolean _tmp0_;
			_tmp0_ = g_str_has_prefix (line, ":<+ ");
			if (_tmp0_) {
				gchar* _tmp1_ = NULL;
				gchar* _tmp2_;
				gchar* _tmp3_ = NULL;
				_tmp1_ = string_substring (line, (glong) 4, (glong) (-1));
				_tmp2_ = _tmp1_;
				_tmp3_ = string_strip (_tmp2_);
				_g_free0 (self->priv->filename_buf);
				self->priv->filename_buf = _tmp3_;
				_g_free0 (_tmp2_);
				self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_FILENAME;
			} else {
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_;
				_tmp5_ = g_regex_match (latex_post_processor_reg_file_pop, line, 0, NULL);
				if (_tmp5_) {
					_tmp4_ = TRUE;
				} else {
					gboolean _tmp6_;
					_tmp6_ = g_str_has_prefix (line, ":<-");
					_tmp4_ = _tmp6_;
				}
				if (_tmp4_) {
					latex_post_processor_pop_file_from_stack (self);
				} else {
					latex_post_processor_update_stack_file_heuristic (self, line);
				}
			}
			break;
		}
		case LATEX_POST_PROCESSOR_FILTER_STATUS_FILENAME:
		{
			gboolean _tmp7_ = FALSE;
			gchar _tmp8_;
			_tmp8_ = string_get (line, (glong) 0);
			if (_tmp8_ == '(') {
				_tmp7_ = TRUE;
			} else {
				gboolean _tmp9_;
				_tmp9_ = g_str_has_prefix (line, "\\openout");
				_tmp7_ = _tmp9_;
			}
			if (_tmp7_) {
				latex_post_processor_push_file_on_stack (self, self->priv->filename_buf, TRUE);
				self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
			} else {
				gchar _tmp10_;
				_tmp10_ = string_get (line, (glong) 0);
				if (_tmp10_ == '!') {
					self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
					latex_post_processor_detect_error (self, line);
				} else {
					gboolean _tmp11_;
					_tmp11_ = g_str_has_prefix (line, "No file");
					if (_tmp11_) {
						self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
						latex_post_processor_detect_warning (self, line);
					} else {
						gchar* _tmp12_ = NULL;
						gchar* _tmp13_;
						gchar* _tmp14_;
						_tmp12_ = string_strip (line);
						_tmp13_ = _tmp12_;
						_tmp14_ = g_strconcat (self->priv->filename_buf, _tmp13_, NULL);
						_g_free0 (self->priv->filename_buf);
						self->priv->filename_buf = _tmp14_;
						_g_free0 (_tmp13_);
					}
				}
			}
			break;
		}
		default:
		{
			break;
		}
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	glong string_length;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	string_length = (glong) _tmp0_;
	if (start < 0) {
		start = string_length + start;
	}
	if (end < 0) {
		end = string_length + end;
	}
	if (start >= 0) {
		_tmp1_ = start <= string_length;
	} else {
		_tmp1_ = FALSE;
	}
	g_return_val_if_fail (_tmp1_, NULL);
	if (end >= 0) {
		_tmp2_ = end <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp3_;
	return result;
}


static void latex_post_processor_update_stack_file_heuristic (LatexPostProcessor* self, const gchar* line) {
	gboolean expect_filename;
	gint index;
	gint _tmp0_;
	glong length;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (line != NULL);
	expect_filename = self->priv->status == LATEX_POST_PROCESSOR_FILTER_STATUS_FILENAME_HEURISTIC;
	index = 0;
	_tmp0_ = strlen (line);
	length = (glong) _tmp0_;
	if (expect_filename) {
		_tmp2_ = length > 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gchar _tmp3_;
		_tmp3_ = string_get (line, (glong) 0);
		_tmp1_ = _tmp3_ == ')';
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		latex_post_processor_push_file_on_stack (self, self->priv->filename_buf, FALSE);
		expect_filename = FALSE;
		self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean is_last_char;
				gboolean next_is_terminator;
				gboolean _tmp10_ = FALSE;
				if (!_tmp4_) {
					i++;
				}
				_tmp4_ = FALSE;
				if (!(i < length)) {
					break;
				}
				is_last_char = FALSE;
				next_is_terminator = FALSE;
				if (expect_filename) {
					gboolean _tmp5_ = FALSE;
					is_last_char = (i + 1) == length;
					if (is_last_char) {
						_tmp5_ = FALSE;
					} else {
						gboolean _tmp6_ = FALSE;
						gchar _tmp7_;
						gboolean _tmp8_;
						_tmp7_ = string_get (line, (glong) (i + 1));
						_tmp8_ = g_ascii_isspace (_tmp7_);
						if (_tmp8_) {
							_tmp6_ = TRUE;
						} else {
							gchar _tmp9_;
							_tmp9_ = string_get (line, (glong) (i + 1));
							_tmp6_ = _tmp9_ == ')';
						}
						_tmp5_ = _tmp6_;
					}
					next_is_terminator = _tmp5_;
				}
				if (is_last_char) {
					_tmp10_ = TRUE;
				} else {
					_tmp10_ = next_is_terminator;
				}
				if (_tmp10_) {
					gchar* _tmp11_ = NULL;
					gchar* _tmp12_;
					gchar* _tmp13_;
					gint _tmp14_;
					gboolean _tmp15_ = FALSE;
					gboolean _tmp16_ = FALSE;
					gboolean _tmp17_ = FALSE;
					_tmp11_ = string_slice (line, (glong) index, (glong) (i + 1));
					_tmp12_ = _tmp11_;
					_tmp13_ = g_strconcat (self->priv->filename_buf, _tmp12_, NULL);
					_g_free0 (self->priv->filename_buf);
					self->priv->filename_buf = _tmp13_;
					_g_free0 (_tmp12_);
					_tmp14_ = strlen (self->priv->filename_buf);
					if (_tmp14_ == 0) {
						continue;
					}
					if (is_last_char) {
						_tmp17_ = i < 78;
					} else {
						_tmp17_ = FALSE;
					}
					if (_tmp17_) {
						_tmp16_ = TRUE;
					} else {
						_tmp16_ = next_is_terminator;
					}
					if (_tmp16_) {
						_tmp15_ = TRUE;
					} else {
						gboolean _tmp18_;
						_tmp18_ = latex_post_processor_file_exists (self, self->priv->filename_buf);
						_tmp15_ = _tmp18_;
					}
					if (_tmp15_) {
						latex_post_processor_push_file_on_stack (self, self->priv->filename_buf, FALSE);
						expect_filename = FALSE;
						self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
					} else {
						if (is_last_char) {
							gboolean _tmp19_;
							_tmp19_ = latex_post_processor_file_exists (self, self->priv->filename_buf);
							if (_tmp19_) {
								latex_post_processor_push_file_on_stack (self, self->priv->filename_buf, FALSE);
								expect_filename = FALSE;
								self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
							} else {
								self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_FILENAME_HEURISTIC;
							}
						} else {
							gchar* _tmp20_;
							self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
							_tmp20_ = g_strdup ("");
							_g_free0 (self->priv->filename_buf);
							self->priv->filename_buf = _tmp20_;
							expect_filename = FALSE;
						}
					}
				} else {
					gchar _tmp21_;
					_tmp21_ = string_get (line, (glong) i);
					if (_tmp21_ == '(') {
						gchar* _tmp22_;
						self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
						_tmp22_ = g_strdup ("");
						_g_free0 (self->priv->filename_buf);
						self->priv->filename_buf = _tmp22_;
						expect_filename = TRUE;
						index = i + 1;
					} else {
						gboolean _tmp23_ = FALSE;
						gboolean _tmp24_ = FALSE;
						gchar _tmp25_;
						_tmp25_ = string_get (line, (glong) i);
						if (_tmp25_ == ')') {
							guint _tmp26_;
							_tmp26_ = g_slist_length (self->priv->stack_files);
							_tmp24_ = _tmp26_ > 0;
						} else {
							_tmp24_ = FALSE;
						}
						if (_tmp24_) {
							gboolean _tmp27_;
							_tmp27_ = latex_post_processor_top_file_on_stack_is_reliable (self);
							_tmp23_ = !_tmp27_;
						} else {
							_tmp23_ = FALSE;
						}
						if (_tmp23_) {
							latex_post_processor_pop_file_from_stack (self);
						}
					}
				}
			}
		}
	}
}


static gboolean latex_post_processor_file_exists (LatexPostProcessor* self, const gchar* filename) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (filename != NULL, FALSE);
	_tmp0_ = latex_post_processor_get_path_if_file_exists (self, filename);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_g_free0 (_tmp1_);
	result = _tmp2_;
	return result;
}


static gchar* latex_post_processor_get_path_if_file_exists (LatexPostProcessor* self, const gchar* filename) {
	gchar* result = NULL;
	gboolean _tmp0_;
	gchar* full_path = NULL;
	gboolean _tmp3_;
	gboolean _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar** _tmp14_ = NULL;
	gchar** extensions;
	gint extensions_length1;
	gint _extensions_size_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	_tmp0_ = g_path_is_absolute (filename);
	if (_tmp0_) {
		gboolean _tmp1_;
		_tmp1_ = g_file_test (filename, G_FILE_TEST_IS_REGULAR);
		if (_tmp1_) {
			gchar* _tmp2_;
			_tmp2_ = g_strdup (filename);
			result = _tmp2_;
			return result;
		} else {
			result = NULL;
			return result;
		}
	}
	_tmp3_ = g_str_has_prefix (filename, "./");
	if (_tmp3_) {
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_ = NULL;
		_tmp4_ = string_substring (filename, (glong) 2, (glong) (-1));
		_tmp5_ = _tmp4_;
		_tmp6_ = g_build_filename (self->priv->directory_path, _tmp5_, NULL, NULL);
		_g_free0 (full_path);
		full_path = _tmp6_;
		_g_free0 (_tmp5_);
	} else {
		gchar* _tmp7_ = NULL;
		_tmp7_ = g_build_filename (self->priv->directory_path, filename, NULL, NULL);
		_g_free0 (full_path);
		full_path = _tmp7_;
	}
	_tmp8_ = g_file_test (full_path, G_FILE_TEST_IS_REGULAR);
	if (_tmp8_) {
		result = full_path;
		return result;
	}
	_tmp9_ = g_strdup (".tex");
	_tmp10_ = g_strdup (".ltx");
	_tmp11_ = g_strdup (".latex");
	_tmp12_ = g_strdup (".dtx");
	_tmp13_ = g_strdup (".ins");
	_tmp14_ = g_new0 (gchar*, 5 + 1);
	_tmp14_[0] = _tmp9_;
	_tmp14_[1] = _tmp10_;
	_tmp14_[2] = _tmp11_;
	_tmp14_[3] = _tmp12_;
	_tmp14_[4] = _tmp13_;
	extensions = _tmp14_;
	extensions_length1 = 5;
	_extensions_size_ = 5;
	{
		gchar** ext_collection;
		int ext_collection_length1;
		int ext_it;
		ext_collection = extensions;
		ext_collection_length1 = extensions_length1;
		for (ext_it = 0; ext_it < extensions_length1; ext_it = ext_it + 1) {
			gchar* _tmp15_;
			gchar* ext;
			_tmp15_ = g_strdup (ext_collection[ext_it]);
			ext = _tmp15_;
			{
				gchar* _tmp16_;
				gchar* path_with_ext;
				gboolean _tmp17_;
				_tmp16_ = g_strconcat (full_path, ext, NULL);
				path_with_ext = _tmp16_;
				_tmp17_ = g_file_test (path_with_ext, G_FILE_TEST_IS_REGULAR);
				if (_tmp17_) {
					result = path_with_ext;
					_g_free0 (ext);
					extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (full_path);
					return result;
				}
				_g_free0 (path_with_ext);
				_g_free0 (ext);
			}
		}
	}
	result = NULL;
	extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (full_path);
	return result;
}


static gchar* latex_post_processor_get_current_filename (LatexPostProcessor* self) {
	gchar* result = NULL;
	GSList* stack_file;
	g_return_val_if_fail (self != NULL, NULL);
	stack_file = self->priv->stack_files;
	while (TRUE) {
		LatexPostProcessorFileInStack _tmp0_;
		LatexPostProcessorFileInStack _tmp1_ = {0};
		LatexPostProcessorFileInStack file;
		if (!(stack_file != NULL)) {
			break;
		}
		latex_post_processor_file_in_stack_copy ((LatexPostProcessorFileInStack*) stack_file->data, &_tmp1_);
		_tmp0_ = _tmp1_;
		file = _tmp0_;
		if (file.exists) {
			gchar* _tmp2_;
			_tmp2_ = g_strdup (file.filename);
			result = _tmp2_;
			latex_post_processor_file_in_stack_destroy (&file);
			return result;
		}
		stack_file = stack_file->next;
		latex_post_processor_file_in_stack_destroy (&file);
	}
	result = NULL;
	return result;
}


static gpointer _latex_post_processor_file_in_stack_dup0 (gpointer self) {
	return self ? latex_post_processor_file_in_stack_dup (self) : NULL;
}


static void latex_post_processor_push_file_on_stack (LatexPostProcessor* self, const gchar* filename, gboolean reliable) {
	LatexPostProcessorFileInStack file = {0};
	gchar* clean_filename = NULL;
	gchar* _tmp0_;
	gchar* bad_suffix;
	gboolean _tmp1_;
	gchar* _tmp5_ = NULL;
	gchar* path;
	LatexPostProcessorFileInStack* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	memset (&file, 0, sizeof (LatexPostProcessorFileInStack));
	file.reliable = reliable;
	_tmp0_ = g_strdup ("pdfTeX");
	bad_suffix = _tmp0_;
	_tmp1_ = g_str_has_suffix (filename, bad_suffix);
	if (_tmp1_) {
		gint _tmp2_;
		gchar* _tmp3_ = NULL;
		_tmp2_ = strlen (bad_suffix);
		_tmp3_ = string_slice (filename, (glong) 0, (glong) (-_tmp2_));
		_g_free0 (clean_filename);
		clean_filename = _tmp3_;
	} else {
		gchar* _tmp4_;
		_tmp4_ = g_strdup (filename);
		_g_free0 (clean_filename);
		clean_filename = _tmp4_;
	}
	_tmp5_ = latex_post_processor_get_path_if_file_exists (self, clean_filename);
	path = _tmp5_;
	if (path != NULL) {
		gchar* _tmp6_;
		_tmp6_ = g_strdup (path);
		_g_free0 (file.filename);
		file.filename = _tmp6_;
		file.exists = TRUE;
	} else {
		gchar* _tmp7_;
		_tmp7_ = g_strdup (clean_filename);
		_g_free0 (file.filename);
		file.filename = _tmp7_;
		file.exists = FALSE;
	}
	_tmp8_ = _latex_post_processor_file_in_stack_dup0 (&file);
	self->priv->stack_files = g_slist_prepend (self->priv->stack_files, _tmp8_);
	_g_free0 (path);
	_g_free0 (bad_suffix);
	_g_free0 (clean_filename);
	latex_post_processor_file_in_stack_destroy (&file);
}


static void latex_post_processor_pop_file_from_stack (LatexPostProcessor* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->stack_files == NULL) {
		return;
	}
	self->priv->stack_files = g_slist_remove (self->priv->stack_files, (LatexPostProcessorFileInStack*) self->priv->stack_files->data);
}


static gboolean latex_post_processor_top_file_on_stack_is_reliable (LatexPostProcessor* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (self->priv->stack_files != NULL, TRUE);
	result = (*((LatexPostProcessorFileInStack*) self->priv->stack_files->data)).reliable;
	return result;
}


static void latex_post_processor_add_msg (LatexPostProcessor* self, gboolean set_filename) {
	gboolean _tmp0_ = FALSE;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->msg.type == BUILD_MSG_TYPE_WARNING) {
		_tmp0_ = g_strcmp0 (self->priv->msg.text, "There were undefined references.") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		latex_post_processor_reset_msg (self);
		return;
	}
	if (set_filename) {
		gchar* _tmp1_ = NULL;
		_tmp1_ = latex_post_processor_get_current_filename (self);
		_g_free0 (self->priv->msg.filename);
		self->priv->msg.filename = _tmp1_;
	}
	_tmp2_ = g_regex_replace (latex_post_processor_reg_spaces, self->priv->msg.text, (gssize) (-1), 0, " ", 0, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch27_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (self->priv->msg.text);
	self->priv->msg.text = _tmp3_;
	goto __finally27;
	__catch27_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("latex_post_processor.vala:809: Latex post processor: %s", e->message);
		_g_error_free0 (e);
	}
	__finally27:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	switch (self->priv->msg.type) {
		case BUILD_MSG_TYPE_BADBOX:
		{
			self->priv->nb_badboxes++;
			break;
		}
		case BUILD_MSG_TYPE_WARNING:
		{
			self->priv->nb_warnings++;
			break;
		}
		case BUILD_MSG_TYPE_ERROR:
		{
			self->priv->nb_errors++;
			break;
		}
		default:
		break;
	}
	if (self->priv->msg.start_line != LATEX_POST_PROCESSOR_NO_LINE) {
		self->priv->msg.lines_set = TRUE;
	}
	post_processor_append_message ((PostProcessor*) self, &self->priv->msg);
	latex_post_processor_reset_msg (self);
}


static void latex_post_processor_reset_msg (LatexPostProcessor* self) {
	BuildMsg _tmp0_ = {0};
	BuildMsg _tmp1_ = {0};
	g_return_if_fail (self != NULL);
	memset (&_tmp0_, 0, sizeof (BuildMsg));
	_tmp1_ = _tmp0_;
	build_msg_destroy (&self->priv->msg);
	self->priv->msg = _tmp1_;
	_g_free0 (self->priv->msg.text);
	self->priv->msg.text = NULL;
	self->priv->msg.type = BUILD_MSG_TYPE_OTHER;
	_g_free0 (self->priv->msg.filename);
	self->priv->msg.filename = NULL;
	self->priv->msg.start_line = LATEX_POST_PROCESSOR_NO_LINE;
	self->priv->msg.end_line = LATEX_POST_PROCESSOR_NO_LINE;
	self->priv->msg.lines_set = FALSE;
}


static void latex_post_processor_file_in_stack_copy (const LatexPostProcessorFileInStack* self, LatexPostProcessorFileInStack* dest) {
	dest->filename = g_strdup (self->filename);
	dest->reliable = self->reliable;
	dest->exists = self->exists;
}


static void latex_post_processor_file_in_stack_destroy (LatexPostProcessorFileInStack* self) {
	_g_free0 ((*self).filename);
}


static LatexPostProcessorFileInStack* latex_post_processor_file_in_stack_dup (const LatexPostProcessorFileInStack* self) {
	LatexPostProcessorFileInStack* dup;
	dup = g_new0 (LatexPostProcessorFileInStack, 1);
	latex_post_processor_file_in_stack_copy (self, dup);
	return dup;
}


static void latex_post_processor_file_in_stack_free (LatexPostProcessorFileInStack* self) {
	latex_post_processor_file_in_stack_destroy (self);
	g_free (self);
}


static GType latex_post_processor_file_in_stack_get_type (void) {
	static volatile gsize latex_post_processor_file_in_stack_type_id__volatile = 0;
	if (g_once_init_enter (&latex_post_processor_file_in_stack_type_id__volatile)) {
		GType latex_post_processor_file_in_stack_type_id;
		latex_post_processor_file_in_stack_type_id = g_boxed_type_register_static ("LatexPostProcessorFileInStack", (GBoxedCopyFunc) latex_post_processor_file_in_stack_dup, (GBoxedFreeFunc) latex_post_processor_file_in_stack_free);
		g_once_init_leave (&latex_post_processor_file_in_stack_type_id__volatile, latex_post_processor_file_in_stack_type_id);
	}
	return latex_post_processor_file_in_stack_type_id__volatile;
}


static void latex_post_processor_class_init (LatexPostProcessorClass * klass) {
	latex_post_processor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (LatexPostProcessorPrivate));
	POST_PROCESSOR_CLASS (klass)->process = latex_post_processor_real_process;
	G_OBJECT_CLASS (klass)->finalize = latex_post_processor_finalize;
}


static void latex_post_processor_instance_init (LatexPostProcessor * self) {
	self->priv = LATEX_POST_PROCESSOR_GET_PRIVATE (self);
	self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
	self->priv->nb_lines = 0;
	self->priv->stack_files = NULL;
	self->priv->directory_path = NULL;
	self->priv->nb_badboxes = 0;
	self->priv->nb_warnings = 0;
	self->priv->nb_errors = 0;
}


static void latex_post_processor_finalize (GObject* obj) {
	LatexPostProcessor * self;
	self = LATEX_POST_PROCESSOR (obj);
	build_msg_destroy (&self->priv->msg);
	_g_free0 (self->priv->line_buf);
	_g_free0 (self->priv->filename_buf);
	__g_slist_free__latex_post_processor_file_in_stack_free0_0 (self->priv->stack_files);
	_g_free0 (self->priv->directory_path);
	G_OBJECT_CLASS (latex_post_processor_parent_class)->finalize (obj);
}


GType latex_post_processor_get_type (void) {
	static volatile gsize latex_post_processor_type_id__volatile = 0;
	if (g_once_init_enter (&latex_post_processor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LatexPostProcessorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) latex_post_processor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LatexPostProcessor), 0, (GInstanceInitFunc) latex_post_processor_instance_init, NULL };
		GType latex_post_processor_type_id;
		latex_post_processor_type_id = g_type_register_static (TYPE_POST_PROCESSOR, "LatexPostProcessor", &g_define_type_info, 0);
		g_once_init_leave (&latex_post_processor_type_id__volatile, latex_post_processor_type_id);
	}
	return latex_post_processor_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



