package latexDraw.figures.properties;

import java.awt.Graphics2D;

import latexDraw.figures.LaTeXDrawRectangle;
import latexDraw.util.LaTeXDrawException;

/**
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 01/01/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public interface Drawable
{
	/**
	 * Allows to draw the figure.
	 * @param g The graphic
	 * @param antiAlias The antialiasing value
	 * @param rendering The rendering value
	 * @param alphaInter The alphainterpolation value
	 * @param colorRendering The colour rendering value
	 * @throws LaTeXDrawException
	 */
	public void draw(Graphics2D g, Object antiAlias, Object rendering, Object alphaInter, 
					Object colorRendering) throws Exception;
	
	
	/**
	 * @return The borders of the drawn figure.
	 */
	public LaTeXDrawRectangle getBorders();
}
