package junit.test.svg;

import junit.framework.TestCase;
import latexDraw.parsers.svg.SVGDocument;
import latexDraw.parsers.svg.SVGText;

import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Node;

/** 
 * This class contains tests for the SVGText class.<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 03/30/08<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public class TestSVGText extends TestCase
{
	protected SVGDocument doc;
	
	
	@Override
	@Before
	public void setUp()
	{
		doc = new SVGDocument();
	}
	
	
	@Test
	public void testConstructors()
	{
		SVGText txt;
		
		try
		{
			txt = createSVGText(null, null);
			fail();
		}
		catch(IllegalArgumentException e) { /* ok */ }
		
		try
		{
			txt = createSVGText(null, doc);
			fail();
		}
		catch(IllegalArgumentException e) { /* ok */ }
		
		txt = createSVGText("a", null);
		assertEquals("a", txt.getData());
		assertNull(txt.getOwnerDocument());
		
		txt = createSVGText("test", doc);
		assertEquals("test", txt.getData());
		assertEquals(txt.getOwnerDocument(), doc);
	}
	
	
	@Test
	public void testGetNodeValue()
	{
		SVGText txt = createSVGText("test", doc);
		assertEquals("test", txt.getNodeValue());
		txt = createSVGText("", doc);
		assertEquals("", txt.getNodeValue());
	}
	
	
	@Test
	public void testAppendData()
	{
		SVGText txt = createSVGText("test", doc);
		txt.appendData(null);
		assertEquals("test", txt.getData());
		txt.appendData("coucou");
		assertEquals("testcoucou", txt.getData());
		txt.appendData("");
		assertEquals("testcoucou", txt.getData());
	}
	
	
	@Test
	public void testGetData()
	{
		SVGText txt = createSVGText("test", doc);
		assertEquals("test", txt.getData());
		txt = createSVGText("", doc);
		assertEquals("", txt.getData());
	}
	
	
	@Test
	public void testGetLength()
	{
		SVGText txt = createSVGText("test", doc);
		assertEquals("text".length(), txt.getLength());
		txt = createSVGText("", doc);
		assertEquals("".length(), txt.getLength());
	}
	
	
	@Test
	public void testGetNodeType()
	{
		SVGText txt = createSVGText("test", doc);
		assertEquals(Node.TEXT_NODE, txt.getNodeType());
	}
	
	
	@Test
	public void testSetData()
	{
		SVGText txt = createSVGText("test", doc);
		txt.setData("");
		assertEquals(txt.getData(), "");
		txt.setData("coucou");
		assertEquals(txt.getData(), "coucou");
	}
	
	
	protected SVGText createSVGText(String txt, SVGDocument document) throws IllegalArgumentException
	{
		return new SVGText(txt, document);
	}
}

