/* -*-C-*-

$Id: mktone.c,v 1.2 2003/01/20 20:48:43 cph Exp $

Copyright 2000,2001 Massachusetts Institute of Technology

This file is part of laptop-net.

Laptop-net is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

Laptop-net is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with laptop-net; if not, write to the Free Software Foundation,
Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/kd.h>

static void
usage (const char * program)
{
  fprintf (stderr, "Usage: %s <duration> <period>\n", program);
  fprintf (stderr, "  <duration> is 0-65535 milliseconds\n");
  fprintf (stderr, "  <period> is 0-65535 cycles of a 1,193,180 Hz clock \n");
  exit (1);
}

int
main (int argc, const char ** argv)
{
  unsigned long duration;
  unsigned long period;
  char * p;
  int fd;

  if (argc != 3)
    usage (argv[0]);

  duration = (strtoul ((argv[1]), (&p), 10));
  if (! ((p > (argv[1])) && ((*p) == '\0') && (duration < 0x10000)))
    usage (argv[0]);

  period = (strtoul ((argv[2]), (&p), 10));
  if (! ((p > (argv[2])) && ((*p) == '\0') && (period < 0x10000)))
    usage (argv[0]);

  fd = (open ("/dev/console", O_RDWR));
  if (fd < 0)
    {
      perror ("/dev/console");
      return (1);
    }
  ioctl (fd, KDMKTONE, ((duration << 16) | period));
  close (fd);
  usleep (duration * 1000);
  return (0);
}
