.TH  DLARRF 1 "April 2011" " LAPACK auxiliary routine (version 3.2.2) " " LAPACK auxiliary routine (version 3.2.2) " 
.SH NAME
LAPACK-3 - the initial representation L D L^T and its cluster of close eigenvalues (in a relative measure), W( CLSTRT ), W( CLSTRT+1 ), ..
.SH SYNOPSIS
.TP 19
SUBROUTINE DLARRF(
N, D, L, LD, CLSTRT, CLEND,
W, WGAP, WERR,
SPDIAM, CLGAPL, CLGAPR, PIVMIN, SIGMA,
DPLUS, LPLUS, WORK, INFO )
.TP 19
.ti +4
INTEGER
CLSTRT, CLEND, INFO, N
.TP 19
.ti +4
DOUBLE
PRECISION CLGAPL, CLGAPR, PIVMIN, SIGMA, SPDIAM
.TP 19
.ti +4
DOUBLE
PRECISION D( * ), DPLUS( * ), L( * ), LD( * ),
LPLUS( * ), W( * ), WGAP( * ), WERR( * ), WORK( * )
.SH PURPOSE
Given the initial representation L D L^T and its cluster of close
eigenvalues (in a relative measure), W( CLSTRT ), W( CLSTRT+1 ), ...
 W( CLEND ), DLARRF finds a new relatively robust representation
 L D L^T - SIGMA I = L(+) D(+) L(+)^T such that at least one of the
 eigenvalues of L(+) D(+) L(+)^T is relatively isolated.
.br
.SH ARGUMENTS
.TP 8
 N       (input) INTEGER
 The order of the matrix (subblock, if the matrix splitted).
.TP 8
 D       (input) DOUBLE PRECISION array, dimension (N)
 The N diagonal elements of the diagonal matrix D.
.TP 8
 L       (input) DOUBLE PRECISION array, dimension (N-1)
 The (N-1) subdiagonal elements of the unit bidiagonal
 matrix L.
.TP 8
 LD      (input) DOUBLE PRECISION array, dimension (N-1)
 The (N-1) elements L(i)*D(i).
.TP 8
 CLSTRT  (input) INTEGER
 The index of the first eigenvalue in the cluster.
.TP 8
 CLEND   (input) INTEGER
 The index of the last eigenvalue in the cluster.
.TP 8
 W       (input) DOUBLE PRECISION array, dimension
 dimension is >=  (CLEND-CLSTRT+1)
 The eigenvalue APPROXIMATIONS of L D L^T in ascending order.
 W( CLSTRT ) through W( CLEND ) form the cluster of relatively
 close eigenalues.
.TP 8
 WGAP    (input/output) DOUBLE PRECISION array, dimension
 dimension is >=  (CLEND-CLSTRT+1)
 The separation from the right neighbor eigenvalue in W.
.TP 8
 WERR    (input) DOUBLE PRECISION array, dimension
 dimension is  >=  (CLEND-CLSTRT+1)
 WERR contain the semiwidth of the uncertainty
 interval of the corresponding eigenvalue APPROXIMATION in W
.TP 8
 SPDIAM  (input) DOUBLE PRECISION
 estimate of the spectral diameter obtained from the
 Gerschgorin intervals
.TP 8
 CLGAPL  (input) DOUBLE PRECISION
.TP 8
 CLGAPR  (input) DOUBLE PRECISION
 absolute gap on each end of the cluster.
 Set by the calling routine to protect against shifts too close
 to eigenvalues outside the cluster.
.TP 8
 PIVMIN  (input) DOUBLE PRECISION
 The minimum pivot allowed in the Sturm sequence.
.TP 8
 SIGMA   (output) DOUBLE PRECISION
 The shift used to form L(+) D(+) L(+)^T.
.TP 8
 DPLUS   (output) DOUBLE PRECISION array, dimension (N)
 The N diagonal elements of the diagonal matrix D(+).
.TP 8
 LPLUS   (output) DOUBLE PRECISION array, dimension (N-1)
 The first (N-1) elements of LPLUS contain the subdiagonal
 elements of the unit bidiagonal matrix L(+).
.TP 8
 WORK    (workspace) DOUBLE PRECISION array, dimension (2*N)
 Workspace.
.TP 8
 INFO    (output) INTEGER
 Signals processing OK (=0) or failure (=1)
.SH FURTHER DETAILS
 Based on contributions by
.br
    Beresford Parlett, University of California, Berkeley, USA
    Jim Demmel, University of California, Berkeley, USA
.br
    Inderjit Dhillon, University of Texas, Austin, USA
.br
    Osni Marques, LBNL/NERSC, USA
.br
    Christof Voemel, University of California, Berkeley, USA
